<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* Définition d'une classe d'exception personnalisée
*/
class MysqlException extends Exception
{
	private $m_error;

	// Redéfinissez l'exception ainsi le message n'est pas facultatif
	public function __construct($error) 
	{
		parent::__construct(db_error_name($error['code']), $error['code'], null);

		$this->m_error = $error;
	}
}

/**
 * Liste d'erreurs
 */

DEFINE("ER_ERROR_FIRST", 1000);
DEFINE("ER_HASHCHK", 1000);
DEFINE("ER_NISAMCHK", 1001);
DEFINE("ER_NO", 1002);
DEFINE("ER_YES", 1003);
DEFINE("ER_CANT_CREATE_FILE", 1004);
DEFINE("ER_CANT_CREATE_TABLE", 1005);
DEFINE("ER_CANT_CREATE_DB", 1006);
DEFINE("ER_DB_CREATE_EXISTS", 1007);
DEFINE("ER_DB_DROP_EXISTS", 1008);
DEFINE("ER_DB_DROP_DELETE", 1009);
DEFINE("ER_DB_DROP_RMDIR", 1010);
DEFINE("ER_CANT_DELETE_FILE", 1011);
DEFINE("ER_CANT_FIND_SYSTEM_REC", 1012);
DEFINE("ER_CANT_GET_STAT", 1013);
DEFINE("ER_CANT_GET_WD", 1014);
DEFINE("ER_CANT_LOCK", 1015);
DEFINE("ER_CANT_OPEN_FILE", 1016);
DEFINE("ER_FILE_NOT_FOUND", 1017);
DEFINE("ER_CANT_READ_DIR", 1018);
DEFINE("ER_CANT_SET_WD", 1019);
DEFINE("ER_CHECKREAD", 1020);
DEFINE("ER_DISK_FULL", 1021);
DEFINE("ER_DUP_KEY", 1022);
DEFINE("ER_ERROR_ON_CLOSE", 1023);
DEFINE("ER_ERROR_ON_READ", 1024);
DEFINE("ER_ERROR_ON_RENAME", 1025);
DEFINE("ER_ERROR_ON_WRITE", 1026);
DEFINE("ER_FILE_USED", 1027);
DEFINE("ER_FILSORT_ABORT", 1028);
DEFINE("ER_FORM_NOT_FOUND", 1029);
DEFINE("ER_GET_ERRNO", 1030);
DEFINE("ER_ILLEGAL_HA", 1031);
DEFINE("ER_KEY_NOT_FOUND", 1032);
DEFINE("ER_NOT_FORM_FILE", 1033);
DEFINE("ER_NOT_KEYFILE", 1034);
DEFINE("ER_OLD_KEYFILE", 1035);
DEFINE("ER_OPEN_AS_READONLY", 1036);
DEFINE("ER_OUTOFMEMORY", 1037);
DEFINE("ER_OUT_OF_SORTMEMORY", 1038);
DEFINE("ER_UNEXPECTED_EOF", 1039);
DEFINE("ER_CON_COUNT_ERROR", 1040);
DEFINE("ER_OUT_OF_RESOURCES", 1041);
DEFINE("ER_BAD_HOST_ERROR", 1042);
DEFINE("ER_HANDSHAKE_ERROR", 1043);
DEFINE("ER_DBACCESS_DENIED_ERROR", 1044);
DEFINE("ER_ACCESS_DENIED_ERROR", 1045);
DEFINE("ER_NO_DB_ERROR", 1046);
DEFINE("ER_UNKNOWN_COM_ERROR", 1047);
DEFINE("ER_BAD_NULL_ERROR", 1048);
DEFINE("ER_BAD_DB_ERROR", 1049);
DEFINE("ER_TABLE_EXISTS_ERROR", 1050);
DEFINE("ER_BAD_TABLE_ERROR", 1051);
DEFINE("ER_NON_UNIQ_ERROR", 1052);
DEFINE("ER_SERVER_SHUTDOWN", 1053);
DEFINE("ER_BAD_FIELD_ERROR", 1054);
DEFINE("ER_WRONG_FIELD_WITH_GROUP", 1055);
DEFINE("ER_WRONG_GROUP_FIELD", 1056);
DEFINE("ER_WRONG_SUM_SELECT", 1057);
DEFINE("ER_WRONG_VALUE_COUNT", 1058);
DEFINE("ER_TOO_LONG_IDENT", 1059);
DEFINE("ER_DUP_FIELDNAME", 1060);
DEFINE("ER_DUP_KEYNAME", 1061);
DEFINE("ER_DUP_ENTRY", 1062);
DEFINE("ER_WRONG_FIELD_SPEC", 1063);
DEFINE("ER_PARSE_ERROR", 1064);
DEFINE("ER_EMPTY_QUERY", 1065);
DEFINE("ER_NONUNIQ_TABLE", 1066);
DEFINE("ER_INVALID_DEFAULT", 1067);
DEFINE("ER_MULTIPLE_PRI_KEY", 1068);
DEFINE("ER_TOO_MANY_KEYS", 1069);
DEFINE("ER_TOO_MANY_KEY_PARTS", 1070);
DEFINE("ER_TOO_LONG_KEY", 1071);
DEFINE("ER_KEY_COLUMN_DOES_NOT_EXITS", 1072);
DEFINE("ER_BLOB_USED_AS_KEY", 1073);
DEFINE("ER_TOO_BIG_FIELDLENGTH", 1074);
DEFINE("ER_WRONG_AUTO_KEY", 1075);
DEFINE("ER_READY", 1076);
DEFINE("ER_NORMAL_SHUTDOWN", 1077);
DEFINE("ER_GOT_SIGNAL", 1078);
DEFINE("ER_SHUTDOWN_COMPLETE", 1079);
DEFINE("ER_FORCING_CLOSE", 1080);
DEFINE("ER_IPSOCK_ERROR", 1081);
DEFINE("ER_NO_SUCH_INDEX", 1082);
DEFINE("ER_WRONG_FIELD_TERMINATORS", 1083);
DEFINE("ER_BLOBS_AND_NO_TERMINATED", 1084);
DEFINE("ER_TEXTFILE_NOT_READABLE", 1085);
DEFINE("ER_FILE_EXISTS_ERROR", 1086);
DEFINE("ER_LOAD_INFO", 1087);
DEFINE("ER_ALTER_INFO", 1088);
DEFINE("ER_WRONG_SUB_KEY", 1089);
DEFINE("ER_CANT_REMOVE_ALL_FIELDS", 1090);
DEFINE("ER_CANT_DROP_FIELD_OR_KEY", 1091);
DEFINE("ER_INSERT_INFO", 1092);
DEFINE("ER_UPDATE_TABLE_USED", 1093);
DEFINE("ER_NO_SUCH_THREAD", 1094);
DEFINE("ER_KILL_DENIED_ERROR", 1095);
DEFINE("ER_NO_TABLES_USED", 1096);
DEFINE("ER_TOO_BIG_SET", 1097);
DEFINE("ER_NO_UNIQUE_LOGFILE", 1098);
DEFINE("ER_TABLE_NOT_LOCKED_FOR_WRITE", 1099);
DEFINE("ER_TABLE_NOT_LOCKED", 1100);
DEFINE("ER_BLOB_CANT_HAVE_DEFAULT", 1101);
DEFINE("ER_WRONG_DB_NAME", 1102);
DEFINE("ER_WRONG_TABLE_NAME", 1103);
DEFINE("ER_TOO_BIG_SELECT", 1104);
DEFINE("ER_UNKNOWN_ERROR", 1105);
DEFINE("ER_UNKNOWN_PROCEDURE", 1106);
DEFINE("ER_WRONG_PARAMCOUNT_TO_PROCEDURE", 1107);
DEFINE("ER_WRONG_PARAMETERS_TO_PROCEDURE", 1108);
DEFINE("ER_UNKNOWN_TABLE", 1109);
DEFINE("ER_FIELD_SPECIFIED_TWICE", 1110);
DEFINE("ER_INVALID_GROUP_FUNC_USE", 1111);
DEFINE("ER_UNSUPPORTED_EXTENSION", 1112);
DEFINE("ER_TABLE_MUST_HAVE_COLUMNS", 1113);
DEFINE("ER_RECORD_FILE_FULL", 1114);
DEFINE("ER_UNKNOWN_CHARACTER_SET", 1115);
DEFINE("ER_TOO_MANY_TABLES", 1116);
DEFINE("ER_TOO_MANY_FIELDS", 1117);
DEFINE("ER_TOO_BIG_ROWSIZE", 1118);
DEFINE("ER_STACK_OVERRUN", 1119);
DEFINE("ER_WRONG_OUTER_JOIN", 1120);
DEFINE("ER_NULL_COLUMN_IN_INDEX", 1121);
DEFINE("ER_CANT_FIND_UDF", 1122);
DEFINE("ER_CANT_INITIALIZE_UDF", 1123);
DEFINE("ER_UDF_NO_PATHS", 1124);
DEFINE("ER_UDF_EXISTS", 1125);
DEFINE("ER_CANT_OPEN_LIBRARY", 1126);
DEFINE("ER_CANT_FIND_DL_ENTRY", 1127);
DEFINE("ER_FUNCTION_NOT_DEFINED", 1128);
DEFINE("ER_HOST_IS_BLOCKED", 1129);
DEFINE("ER_HOST_NOT_PRIVILEGED", 1130);
DEFINE("ER_PASSWORD_ANONYMOUS_USER", 1131);
DEFINE("ER_PASSWORD_NOT_ALLOWED", 1132);
DEFINE("ER_PASSWORD_NO_MATCH", 1133);
DEFINE("ER_UPDATE_INFO", 1134);
DEFINE("ER_CANT_CREATE_THREAD", 1135);
DEFINE("ER_WRONG_VALUE_COUNT_ON_ROW", 1136);
DEFINE("ER_CANT_REOPEN_TABLE", 1137);
DEFINE("ER_INVALID_USE_OF_NULL", 1138);
DEFINE("ER_REGEXP_ERROR", 1139);
DEFINE("ER_MIX_OF_GROUP_FUNC_AND_FIELDS", 1140);
DEFINE("ER_NONEXISTING_GRANT", 1141);
DEFINE("ER_TABLEACCESS_DENIED_ERROR", 1142);
DEFINE("ER_COLUMNACCESS_DENIED_ERROR", 1143);
DEFINE("ER_ILLEGAL_GRANT_FOR_TABLE", 1144);
DEFINE("ER_GRANT_WRONG_HOST_OR_USER", 1145);
DEFINE("ER_NO_SUCH_TABLE", 1146);
DEFINE("ER_NONEXISTING_TABLE_GRANT", 1147);
DEFINE("ER_NOT_ALLOWED_COMMAND", 1148);
DEFINE("ER_SYNTAX_ERROR", 1149);
DEFINE("ER_DELAYED_CANT_CHANGE_LOCK", 1150);
DEFINE("ER_TOO_MANY_DELAYED_THREADS", 1151);
DEFINE("ER_ABORTING_CONNECTION", 1152);
DEFINE("ER_NET_PACKET_TOO_LARGE", 1153);
DEFINE("ER_NET_READ_ERROR_FROM_PIPE", 1154);
DEFINE("ER_NET_FCNTL_ERROR", 1155);
DEFINE("ER_NET_PACKETS_OUT_OF_ORDER", 1156);
DEFINE("ER_NET_UNCOMPRESS_ERROR", 1157);
DEFINE("ER_NET_READ_ERROR", 1158);
DEFINE("ER_NET_READ_INTERRUPTED", 1159);
DEFINE("ER_NET_ERROR_ON_WRITE", 1160);
DEFINE("ER_NET_WRITE_INTERRUPTED", 1161);
DEFINE("ER_TOO_LONG_STRING", 1162);
DEFINE("ER_TABLE_CANT_HANDLE_BLOB", 1163);
DEFINE("ER_TABLE_CANT_HANDLE_AUTO_INCREMENT", 1164);
DEFINE("ER_DELAYED_INSERT_TABLE_LOCKED", 1165);
DEFINE("ER_WRONG_COLUMN_NAME", 1166);
DEFINE("ER_WRONG_KEY_COLUMN", 1167);
DEFINE("ER_WRONG_MRG_TABLE", 1168);
DEFINE("ER_DUP_UNIQUE", 1169);
DEFINE("ER_BLOB_KEY_WITHOUT_LENGTH", 1170);
DEFINE("ER_PRIMARY_CANT_HAVE_NULL", 1171);
DEFINE("ER_TOO_MANY_ROWS", 1172);
DEFINE("ER_REQUIRES_PRIMARY_KEY", 1173);
DEFINE("ER_NO_RAID_COMPILED", 1174);
DEFINE("ER_UPDATE_WITHOUT_KEY_IN_SAFE_MODE", 1175);
DEFINE("ER_KEY_DOES_NOT_EXITS", 1176);
DEFINE("ER_CHECK_NO_SUCH_TABLE", 1177);
DEFINE("ER_CHECK_NOT_IMPLEMENTED", 1178);
DEFINE("ER_CANT_DO_THIS_DURING_AN_TRANSACTION", 1179);
DEFINE("ER_ERROR_DURING_COMMIT", 1180);
DEFINE("ER_ERROR_DURING_ROLLBACK", 1181);
DEFINE("ER_ERROR_DURING_FLUSH_LOGS", 1182);
DEFINE("ER_ERROR_DURING_CHECKPOINT", 1183);
DEFINE("ER_NEW_ABORTING_CONNECTION", 1184);
DEFINE("ER_DUMP_NOT_IMPLEMENTED", 1185);
DEFINE("ER_FLUSH_MASTER_BINLOG_CLOSED", 1186);
DEFINE("ER_INDEX_REBUILD", 1187);
DEFINE("ER_MASTER", 1188);
DEFINE("ER_MASTER_NET_READ", 1189);
DEFINE("ER_MASTER_NET_WRITE", 1190);
DEFINE("ER_FT_MATCHING_KEY_NOT_FOUND", 1191);
DEFINE("ER_LOCK_OR_ACTIVE_TRANSACTION", 1192);
DEFINE("ER_UNKNOWN_SYSTEM_VARIABLE", 1193);
DEFINE("ER_CRASHED_ON_USAGE", 1194);
DEFINE("ER_CRASHED_ON_REPAIR", 1195);
DEFINE("ER_WARNING_NOT_COMPLETE_ROLLBACK", 1196);
DEFINE("ER_TRANS_CACHE_FULL", 1197);
DEFINE("ER_SLAVE_MUST_STOP", 1198);
DEFINE("ER_SLAVE_NOT_RUNNING", 1199);
DEFINE("ER_BAD_SLAVE", 1200);
DEFINE("ER_MASTER_INFO", 1201);
DEFINE("ER_SLAVE_THREAD", 1202);
DEFINE("ER_TOO_MANY_USER_CONNECTIONS", 1203);
DEFINE("ER_SET_CONSTANTS_ONLY", 1204);
DEFINE("ER_LOCK_WAIT_TIMEOUT", 1205);
DEFINE("ER_LOCK_TABLE_FULL", 1206);
DEFINE("ER_READ_ONLY_TRANSACTION", 1207);
DEFINE("ER_DROP_DB_WITH_READ_LOCK", 1208);
DEFINE("ER_CREATE_DB_WITH_READ_LOCK", 1209);
DEFINE("ER_WRONG_ARGUMENTS", 1210);
DEFINE("ER_NO_PERMISSION_TO_CREATE_USER", 1211);
DEFINE("ER_UNION_TABLES_IN_DIFFERENT_DIR", 1212);
DEFINE("ER_LOCK_DEADLOCK", 1213);
DEFINE("ER_TABLE_CANT_HANDLE_FT", 1214);
DEFINE("ER_CANNOT_ADD_FOREIGN", 1215);
DEFINE("ER_NO_REFERENCED_ROW", 1216);
DEFINE("ER_ROW_IS_REFERENCED", 1217);
DEFINE("ER_CONNECT_TO_MASTER", 1218);
DEFINE("ER_QUERY_ON_MASTER", 1219);
DEFINE("ER_ERROR_WHEN_EXECUTING_COMMAND", 1220);
DEFINE("ER_WRONG_USAGE", 1221);
DEFINE("ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT", 1222);
DEFINE("ER_CANT_UPDATE_WITH_READLOCK", 1223);
DEFINE("ER_MIXING_NOT_ALLOWED", 1224);
DEFINE("ER_DUP_ARGUMENT", 1225);
DEFINE("ER_USER_LIMIT_REACHED", 1226);
DEFINE("ER_SPECIFIC_ACCESS_DENIED_ERROR", 1227);
DEFINE("ER_LOCAL_VARIABLE", 1228);
DEFINE("ER_GLOBAL_VARIABLE", 1229);
DEFINE("ER_NO_DEFAULT", 1230);
DEFINE("ER_WRONG_VALUE_FOR_VAR", 1231);
DEFINE("ER_WRONG_TYPE_FOR_VAR", 1232);
DEFINE("ER_VAR_CANT_BE_READ", 1233);
DEFINE("ER_CANT_USE_OPTION_HERE", 1234);
DEFINE("ER_NOT_SUPPORTED_YET", 1235);
DEFINE("ER_MASTER_FATAL_ERROR_READING_BINLOG", 1236);
DEFINE("ER_SLAVE_IGNORED_TABLE", 1237);
DEFINE("ER_INCORRECT_GLOBAL_LOCAL_VAR", 1238);
DEFINE("ER_WRONG_FK_DEF", 1239);
DEFINE("ER_KEY_REF_DO_NOT_MATCH_TABLE_REF", 1240);
DEFINE("ER_OPERAND_COLUMNS", 1241);
DEFINE("ER_SUBQUERY_NO_1_ROW", 1242);
DEFINE("ER_UNKNOWN_STMT_HANDLER", 1243);
DEFINE("ER_CORRUPT_HELP_DB", 1244);
DEFINE("ER_CYCLIC_REFERENCE", 1245);
DEFINE("ER_AUTO_CONVERT", 1246);
DEFINE("ER_ILLEGAL_REFERENCE", 1247);
DEFINE("ER_DERIVED_MUST_HAVE_ALIAS", 1248);
DEFINE("ER_SELECT_REDUCED", 1249);
DEFINE("ER_TABLENAME_NOT_ALLOWED_HERE", 1250);
DEFINE("ER_NOT_SUPPORTED_AUTH_MODE", 1251);
DEFINE("ER_SPATIAL_CANT_HAVE_NULL", 1252);
DEFINE("ER_COLLATION_CHARSET_MISMATCH", 1253);
DEFINE("ER_SLAVE_WAS_RUNNING", 1254);
DEFINE("ER_SLAVE_WAS_NOT_RUNNING", 1255);
DEFINE("ER_TOO_BIG_FOR_UNCOMPRESS", 1256);
DEFINE("ER_ZLIB_Z_MEM_ERROR", 1257);
DEFINE("ER_ZLIB_Z_BUF_ERROR", 1258);
DEFINE("ER_ZLIB_Z_DATA_ERROR", 1259);
DEFINE("ER_CUT_VALUE_GROUP_CONCAT", 1260);
DEFINE("ER_WARN_TOO_FEW_RECORDS", 1261);
DEFINE("ER_WARN_TOO_MANY_RECORDS", 1262);
DEFINE("ER_WARN_NULL_TO_NOTNULL", 1263);
DEFINE("ER_WARN_DATA_OUT_OF_RANGE", 1264);
DEFINE("WARN_DATA_TRUNCATED", 1265);
DEFINE("ER_WARN_USING_OTHER_HANDLER", 1266);
DEFINE("ER_CANT_AGGREGATE_2COLLATIONS", 1267);
DEFINE("ER_DROP_USER", 1268);
DEFINE("ER_REVOKE_GRANTS", 1269);
DEFINE("ER_CANT_AGGREGATE_3COLLATIONS", 1270);
DEFINE("ER_CANT_AGGREGATE_NCOLLATIONS", 1271);
DEFINE("ER_VARIABLE_IS_NOT_STRUCT", 1272);
DEFINE("ER_UNKNOWN_COLLATION", 1273);
DEFINE("ER_SLAVE_IGNORED_SSL_PARAMS", 1274);
DEFINE("ER_SERVER_IS_IN_SECURE_AUTH_MODE", 1275);
DEFINE("ER_WARN_FIELD_RESOLVED", 1276);
DEFINE("ER_BAD_SLAVE_UNTIL_COND", 1277);
DEFINE("ER_MISSING_SKIP_SLAVE", 1278);
DEFINE("ER_UNTIL_COND_IGNORED", 1279);
DEFINE("ER_WRONG_NAME_FOR_INDEX", 1280);
DEFINE("ER_WRONG_NAME_FOR_CATALOG", 1281);
DEFINE("ER_WARN_QC_RESIZE", 1282);
DEFINE("ER_BAD_FT_COLUMN", 1283);
DEFINE("ER_UNKNOWN_KEY_CACHE", 1284);
DEFINE("ER_WARN_HOSTNAME_WONT_WORK", 1285);
DEFINE("ER_UNKNOWN_STORAGE_ENGINE", 1286);
DEFINE("ER_WARN_DEPRECATED_SYNTAX", 1287);
DEFINE("ER_NON_UPDATABLE_TABLE", 1288);
DEFINE("ER_FEATURE_DISABLED", 1289);
DEFINE("ER_OPTION_PREVENTS_STATEMENT", 1290);
DEFINE("ER_DUPLICATED_VALUE_IN_TYPE", 1291);
DEFINE("ER_TRUNCATED_WRONG_VALUE", 1292);
DEFINE("ER_TOO_MUCH_AUTO_TIMESTAMP_COLS", 1293);
DEFINE("ER_INVALID_ON_UPDATE", 1294);
DEFINE("ER_UNSUPPORTED_PS", 1295);
DEFINE("ER_GET_ERRMSG", 1296);
DEFINE("ER_GET_TEMPORARY_ERRMSG", 1297);
DEFINE("ER_UNKNOWN_TIME_ZONE", 1298);
DEFINE("ER_WARN_INVALID_TIMESTAMP", 1299);
DEFINE("ER_INVALID_CHARACTER_STRING", 1300);
DEFINE("ER_WARN_ALLOWED_PACKET_OVERFLOWED", 1301);
DEFINE("ER_CONFLICTING_DECLARATIONS", 1302);
DEFINE("ER_SP_NO_RECURSIVE_CREATE", 1303);
DEFINE("ER_SP_ALREADY_EXISTS", 1304);
DEFINE("ER_SP_DOES_NOT_EXIST", 1305);
DEFINE("ER_SP_DROP_FAILED", 1306);
DEFINE("ER_SP_STORE_FAILED", 1307);
DEFINE("ER_SP_LILABEL_MISMATCH", 1308);
DEFINE("ER_SP_LABEL_REDEFINE", 1309);
DEFINE("ER_SP_LABEL_MISMATCH", 1310);
DEFINE("ER_SP_UNINIT_VAR", 1311);
DEFINE("ER_SP_BADSELECT", 1312);
DEFINE("ER_SP_BADRETURN", 1313);
DEFINE("ER_SP_BADSTATEMENT", 1314);
DEFINE("ER_UPDATE_LOG_DEPRECATED_IGNORED", 1315);
DEFINE("ER_UPDATE_LOG_DEPRECATED_TRANSLATED", 1316);
DEFINE("ER_QUERY_INTERRUPTED", 1317);
DEFINE("ER_SP_WRONG_NO_OF_ARGS", 1318);
DEFINE("ER_SP_COND_MISMATCH", 1319);
DEFINE("ER_SP_NORETURN", 1320);
DEFINE("ER_SP_NORETURNEND", 1321);
DEFINE("ER_SP_BAD_CURSOR_QUERY", 1322);
DEFINE("ER_SP_BAD_CURSOR_SELECT", 1323);
DEFINE("ER_SP_CURSOR_MISMATCH", 1324);
DEFINE("ER_SP_CURSOR_ALREADY_OPEN", 1325);
DEFINE("ER_SP_CURSOR_NOT_OPEN", 1326);
DEFINE("ER_SP_UNDECLARED_VAR", 1327);
DEFINE("ER_SP_WRONG_NO_OF_FETCH_ARGS", 1328);
DEFINE("ER_SP_FETCH_NO_DATA", 1329);
DEFINE("ER_SP_DUP_PARAM", 1330);
DEFINE("ER_SP_DUP_VAR", 1331);
DEFINE("ER_SP_DUP_COND", 1332);
DEFINE("ER_SP_DUP_CURS", 1333);
DEFINE("ER_SP_CANT_ALTER", 1334);
DEFINE("ER_SP_SUBSELECT_NYI", 1335);
DEFINE("ER_STMT_NOT_ALLOWED_IN_SF_OR_TRG", 1336);
DEFINE("ER_SP_VARCOND_AFTER_CURSHNDLR", 1337);
DEFINE("ER_SP_CURSOR_AFTER_HANDLER", 1338);
DEFINE("ER_SP_CASE_NOT_FOUND", 1339);
DEFINE("ER_FPARSER_TOO_BIG_FILE", 1340);
DEFINE("ER_FPARSER_BAD_HEADER", 1341);
DEFINE("ER_FPARSER_EOF_IN_COMMENT", 1342);
DEFINE("ER_FPARSER_ERROR_IN_PARAMETER", 1343);
DEFINE("ER_FPARSER_EOF_IN_UNKNOWN_PARAMETER", 1344);
DEFINE("ER_VIEW_NO_EXPLAIN", 1345);
DEFINE("ER_FRM_UNKNOWN_TYPE", 1346);
DEFINE("ER_WRONG_OBJECT", 1347);
DEFINE("ER_NONUPDATEABLE_COLUMN", 1348);
DEFINE("ER_VIEW_SELECT_DERIVED", 1349);
DEFINE("ER_VIEW_SELECT_CLAUSE", 1350);
DEFINE("ER_VIEW_SELECT_VARIABLE", 1351);
DEFINE("ER_VIEW_SELECT_TMPTABLE", 1352);
DEFINE("ER_VIEW_WRONG_LIST", 1353);
DEFINE("ER_WARN_VIEW_MERGE", 1354);
DEFINE("ER_WARN_VIEW_WITHOUT_KEY", 1355);
DEFINE("ER_VIEW_INVALID", 1356);
DEFINE("ER_SP_NO_DROP_SP", 1357);
DEFINE("ER_SP_GOTO_IN_HNDLR", 1358);
DEFINE("ER_TRG_ALREADY_EXISTS", 1359);
DEFINE("ER_TRG_DOES_NOT_EXIST", 1360);
DEFINE("ER_TRG_ON_VIEW_OR_TEMP_TABLE", 1361);
DEFINE("ER_TRG_CANT_CHANGE_ROW", 1362);
DEFINE("ER_TRG_NO_SUCH_ROW_IN_TRG", 1363);
DEFINE("ER_NO_DEFAULT_FOR_FIELD", 1364);
DEFINE("ER_DIVISION_BY_ZERO", 1365);
DEFINE("ER_TRUNCATED_WRONG_VALUE_FOR_FIELD", 1366);
DEFINE("ER_ILLEGAL_VALUE_FOR_TYPE", 1367);
DEFINE("ER_VIEW_NONUPD_CHECK", 1368);
DEFINE("ER_VIEW_CHECK_FAILED", 1369);
DEFINE("ER_PROCACCESS_DENIED_ERROR", 1370);
DEFINE("ER_RELAY_LOG_FAIL", 1371);
DEFINE("ER_PASSWD_LENGTH", 1372);
DEFINE("ER_UNKNOWN_TARGET_BINLOG", 1373);
DEFINE("ER_IO_ERR_LOG_INDEX_READ", 1374);
DEFINE("ER_BINLOG_PURGE_PROHIBITED", 1375);
DEFINE("ER_FSEEK_FAIL", 1376);
DEFINE("ER_BINLOG_PURGE_FATAL_ERR", 1377);
DEFINE("ER_LOG_IN_USE", 1378);
DEFINE("ER_LOG_PURGE_UNKNOWN_ERR", 1379);
DEFINE("ER_RELAY_LOG_INIT", 1380);
DEFINE("ER_NO_BINARY_LOGGING", 1381);
DEFINE("ER_RESERVED_SYNTAX", 1382);
DEFINE("ER_WSAS_FAILED", 1383);
DEFINE("ER_DIFF_GROUPS_PROC", 1384);
DEFINE("ER_NO_GROUP_FOR_PROC", 1385);
DEFINE("ER_ORDER_WITH_PROC", 1386);
DEFINE("ER_LOGGING_PROHIBIT_CHANGING_OF", 1387);
DEFINE("ER_NO_FILE_MAPPING", 1388);
DEFINE("ER_WRONG_MAGIC", 1389);
DEFINE("ER_PS_MANY_PARAM", 1390);
DEFINE("ER_KEY_PART_0", 1391);
DEFINE("ER_VIEW_CHECKSUM", 1392);
DEFINE("ER_VIEW_MULTIUPDATE", 1393);
DEFINE("ER_VIEW_NO_INSERT_FIELD_LIST", 1394);
DEFINE("ER_VIEW_DELETE_MERGE_VIEW", 1395);
DEFINE("ER_CANNOT_USER", 1396);
DEFINE("ER_XAER_NOTA", 1397);
DEFINE("ER_XAER_INVAL", 1398);
DEFINE("ER_XAER_RMFAIL", 1399);
DEFINE("ER_XAER_OUTSIDE", 1400);
DEFINE("ER_XAER_RMERR", 1401);
DEFINE("ER_XA_RBROLLBACK", 1402);
DEFINE("ER_NONEXISTING_PROC_GRANT", 1403);
DEFINE("ER_PROC_AUTO_GRANT_FAIL", 1404);
DEFINE("ER_PROC_AUTO_REVOKE_FAIL", 1405);
DEFINE("ER_DATA_TOO_LONG", 1406);
DEFINE("ER_SP_BAD_SQLSTATE", 1407);
DEFINE("ER_STARTUP", 1408);
DEFINE("ER_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR", 1409);
DEFINE("ER_CANT_CREATE_USER_WITH_GRANT", 1410);
DEFINE("ER_WRONG_VALUE_FOR_TYPE", 1411);
DEFINE("ER_TABLE_DEF_CHANGED", 1412);
DEFINE("ER_SP_DUP_HANDLER", 1413);
DEFINE("ER_SP_NOT_VAR_ARG", 1414);
DEFINE("ER_SP_NO_RETSET", 1415);
DEFINE("ER_CANT_CREATE_GEOMETRY_OBJECT", 1416);
DEFINE("ER_FAILED_ROUTINE_BREAK_BINLOG", 1417);
DEFINE("ER_BINLOG_UNSAFE_ROUTINE", 1418);
DEFINE("ER_BINLOG_CREATE_ROUTINE_NEED_SUPER", 1419);
DEFINE("ER_EXEC_STMT_WITH_OPEN_CURSOR", 1420);
DEFINE("ER_STMT_HAS_NO_OPEN_CURSOR", 1421);
DEFINE("ER_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG", 1422);
DEFINE("ER_NO_DEFAULT_FOR_VIEW_FIELD", 1423);
DEFINE("ER_SP_NO_RECURSION", 1424);
DEFINE("ER_TOO_BIG_SCALE", 1425);
DEFINE("ER_TOO_BIG_PRECISION", 1426);
DEFINE("ER_M_BIGGER_THAN_D", 1427);
DEFINE("ER_WRONG_LOCK_OF_SYSTEM_TABLE", 1428);
DEFINE("ER_CONNECT_TO_FOREIGN_DATA_SOURCE", 1429);
DEFINE("ER_QUERY_ON_FOREIGN_DATA_SOURCE", 1430);
DEFINE("ER_FOREIGN_DATA_SOURCE_DOESNT_EXIST", 1431);
DEFINE("ER_FOREIGN_DATA_STRING_INVALID_CANT_CREATE", 1432);
DEFINE("ER_FOREIGN_DATA_STRING_INVALID", 1433);
DEFINE("ER_CANT_CREATE_FEDERATED_TABLE", 1434);
DEFINE("ER_TRG_IN_WRONG_SCHEMA", 1435);
DEFINE("ER_STACK_OVERRUN_NEED_MORE", 1436);
DEFINE("ER_TOO_LONG_BODY", 1437);
DEFINE("ER_WARN_CANT_DROP_DEFAULT_KEYCACHE", 1438);
DEFINE("ER_TOO_BIG_DISPLAYWIDTH", 1439);
DEFINE("ER_XAER_DUPID", 1440);
DEFINE("ER_DATETIME_FUNCTION_OVERFLOW", 1441);
DEFINE("ER_CANT_UPDATE_USED_TABLE_IN_SF_OR_TRG", 1442);
DEFINE("ER_VIEW_PREVENT_UPDATE", 1443);
DEFINE("ER_PS_NO_RECURSION", 1444);
DEFINE("ER_SP_CANT_SET_AUTOCOMMIT", 1445);
DEFINE("ER_MALFORMED_DEFINER", 1446);
DEFINE("ER_VIEW_FRM_NO_USER", 1447);
DEFINE("ER_VIEW_OTHER_USER", 1448);
DEFINE("ER_NO_SUCH_USER", 1449);
DEFINE("ER_FORBID_SCHEMA_CHANGE", 1450);
DEFINE("ER_ROW_IS_REFERENCED_2", 1451);
DEFINE("ER_NO_REFERENCED_ROW_2", 1452);
DEFINE("ER_SP_BAD_VAR_SHADOW", 1453);
DEFINE("ER_TRG_NO_DEFINER", 1454);
DEFINE("ER_OLD_FILE_FORMAT", 1455);
DEFINE("ER_SP_RECURSION_LIMIT", 1456);
DEFINE("ER_SP_PROC_TABLE_CORRUPT", 1457);
DEFINE("ER_SP_WRONG_NAME", 1458);
DEFINE("ER_TABLE_NEEDS_UPGRADE", 1459);
DEFINE("ER_SP_NO_AGGREGATE", 1460);
DEFINE("ER_MAX_PREPARED_STMT_COUNT_REACHED", 1461);
DEFINE("ER_VIEW_RECURSIVE", 1462);
DEFINE("ER_NON_GROUPING_FIELD_USED", 1463);
DEFINE("ER_TABLE_CANT_HANDLE_SPKEYS", 1464);
DEFINE("ER_NO_TRIGGERS_ON_SYSTEM_SCHEMA", 1465);
DEFINE("ER_REMOVED_SPACES", 1466);
DEFINE("ER_AUTOINC_READ_FAILED", 1467);
DEFINE("ER_USERNAME", 1468);
DEFINE("ER_HOSTNAME", 1469);
DEFINE("ER_WRONG_STRING_LENGTH", 1470);
DEFINE("ER_NON_INSERTABLE_TABLE", 1471);
DEFINE("ER_ADMIN_WRONG_MRG_TABLE", 1472);
DEFINE("ER_TOO_HIGH_LEVEL_OF_NESTING_FOR_SELECT", 1473);
DEFINE("ER_NAME_BECOMES_EMPTY", 1474);
DEFINE("ER_AMBIGUOUS_FIELD_TERM", 1475);
DEFINE("ER_FOREIGN_SERVER_EXISTS", 1476);
DEFINE("ER_FOREIGN_SERVER_DOESNT_EXIST", 1477);
DEFINE("ER_ILLEGAL_HA_CREATE_OPTION", 1478);
DEFINE("ER_PARTITION_REQUIRES_VALUES_ERROR", 1479);
DEFINE("ER_PARTITION_WRONG_VALUES_ERROR", 1480);
DEFINE("ER_PARTITION_MAXVALUE_ERROR", 1481);
DEFINE("ER_PARTITION_SUBPARTITION_ERROR", 1482);
DEFINE("ER_PARTITION_SUBPART_MIX_ERROR", 1483);
DEFINE("ER_PARTITION_WRONG_NO_PART_ERROR", 1484);
DEFINE("ER_PARTITION_WRONG_NO_SUBPART_ERROR", 1485);
DEFINE("ER_WRONG_EXPR_IN_PARTITION_FUNC_ERROR", 1486);
DEFINE("ER_NO_CONST_EXPR_IN_RANGE_OR_LIST_ERROR", 1487);
DEFINE("ER_FIELD_NOT_FOUND_PART_ERROR", 1488);
DEFINE("ER_LIST_OF_FIELDS_ONLY_IN_HASH_ERROR", 1489);
DEFINE("ER_INCONSISTENT_PARTITION_INFO_ERROR", 1490);
DEFINE("ER_PARTITION_FUNC_NOT_ALLOWED_ERROR", 1491);
DEFINE("ER_PARTITIONS_MUST_BE_DEFINED_ERROR", 1492);
DEFINE("ER_RANGE_NOT_INCREASING_ERROR", 1493);
DEFINE("ER_INCONSISTENT_TYPE_OF_FUNCTIONS_ERROR", 1494);
DEFINE("ER_MULTIPLE_DEF_CONST_IN_LIST_PART_ERROR", 1495);
DEFINE("ER_PARTITION_ENTRY_ERROR", 1496);
DEFINE("ER_MIX_HANDLER_ERROR", 1497);
DEFINE("ER_PARTITION_NOT_DEFINED_ERROR", 1498);
DEFINE("ER_TOO_MANY_PARTITIONS_ERROR", 1499);
DEFINE("ER_SUBPARTITION_ERROR", 1500);
DEFINE("ER_CANT_CREATE_HANDLER_FILE", 1501);
DEFINE("ER_BLOB_FIELD_IN_PART_FUNC_ERROR", 1502);
DEFINE("ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF", 1503);
DEFINE("ER_NO_PARTS_ERROR", 1504);
DEFINE("ER_PARTITION_MGMT_ON_NONPARTITIONED", 1505);
DEFINE("ER_FOREIGN_KEY_ON_PARTITIONED", 1506);
DEFINE("ER_DROP_PARTITION_NON_EXISTENT", 1507);
DEFINE("ER_DROP_LAST_PARTITION", 1508);
DEFINE("ER_COALESCE_ONLY_ON_HASH_PARTITION", 1509);
DEFINE("ER_REORG_HASH_ONLY_ON_SAME_NO", 1510);
DEFINE("ER_REORG_NO_PARAM_ERROR", 1511);
DEFINE("ER_ONLY_ON_RANGE_LIST_PARTITION", 1512);
DEFINE("ER_ADD_PARTITION_SUBPART_ERROR", 1513);
DEFINE("ER_ADD_PARTITION_NO_NEW_PARTITION", 1514);
DEFINE("ER_COALESCE_PARTITION_NO_PARTITION", 1515);
DEFINE("ER_REORG_PARTITION_NOT_EXIST", 1516);
DEFINE("ER_SAME_NAME_PARTITION", 1517);
DEFINE("ER_NO_BINLOG_ERROR", 1518);
DEFINE("ER_CONSECUTIVE_REORG_PARTITIONS", 1519);
DEFINE("ER_REORG_OUTSIDE_RANGE", 1520);
DEFINE("ER_PARTITION_FUNCTION_FAILURE", 1521);
DEFINE("ER_PART_STATE_ERROR", 1522);
DEFINE("ER_LIMITED_PART_RANGE", 1523);
DEFINE("ER_PLUGIN_IS_NOT_LOADED", 1524);
DEFINE("ER_WRONG_VALUE", 1525);
DEFINE("ER_NO_PARTITION_FOR_GIVEN_VALUE", 1526);
DEFINE("ER_FILEGROUP_OPTION_ONLY_ONCE", 1527);
DEFINE("ER_CREATE_FILEGROUP_FAILED", 1528);
DEFINE("ER_DROP_FILEGROUP_FAILED", 1529);
DEFINE("ER_TABLESPACE_AUTO_EXTEND_ERROR", 1530);
DEFINE("ER_WRONG_SIZE_NUMBER", 1531);
DEFINE("ER_SIZE_OVERFLOW_ERROR", 1532);
DEFINE("ER_ALTER_FILEGROUP_FAILED", 1533);
DEFINE("ER_BINLOG_ROW_LOGGING_FAILED", 1534);
DEFINE("ER_BINLOG_ROW_WRONG_TABLE_DEF", 1535);
DEFINE("ER_BINLOG_ROW_RBR_TO_SBR", 1536);
DEFINE("ER_EVENT_ALREADY_EXISTS", 1537);
DEFINE("ER_EVENT_STORE_FAILED", 1538);
DEFINE("ER_EVENT_DOES_NOT_EXIST", 1539);
DEFINE("ER_EVENT_CANT_ALTER", 1540);
DEFINE("ER_EVENT_DROP_FAILED", 1541);
DEFINE("ER_EVENT_INTERVAL_NOT_POSITIVE_OR_TOO_BIG", 1542);
DEFINE("ER_EVENT_ENDS_BEFORE_STARTS", 1543);
DEFINE("ER_EVENT_EXEC_TIME_IN_THE_PAST", 1544);
DEFINE("ER_EVENT_OPEN_TABLE_FAILED", 1545);
DEFINE("ER_EVENT_NEITHER_M_EXPR_NOR_M_AT", 1546);
DEFINE("ER_OBSOLETE_COL_COUNT_DOESNT_MATCH_CORRUPTED", 1547);
DEFINE("ER_OBSOLETE_CANNOT_LOAD_FROM_TABLE", 1548);
DEFINE("ER_EVENT_CANNOT_DELETE", 1549);
DEFINE("ER_EVENT_COMPILE_ERROR", 1550);
DEFINE("ER_EVENT_SAME_NAME", 1551);
DEFINE("ER_EVENT_DATA_TOO_LONG", 1552);
DEFINE("ER_DROP_INDEX_FK", 1553);
DEFINE("ER_WARN_DEPRECATED_SYNTAX_WITH_VER", 1554);
DEFINE("ER_CANT_WRITE_LOCK_LOG_TABLE", 1555);
DEFINE("ER_CANT_LOCK_LOG_TABLE", 1556);
DEFINE("ER_FOREIGN_DUPLICATE_KEY_OLD_UNUSED", 1557);
DEFINE("ER_COL_COUNT_DOESNT_MATCH_PLEASE_UPDATE", 1558);
DEFINE("ER_TEMP_TABLE_PREVENTS_SWITCH_OUT_OF_RBR", 1559);
DEFINE("ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_FORMAT", 1560);
DEFINE("ER_NDB_CANT_SWITCH_BINLOG_FORMAT", 1561);
DEFINE("ER_PARTITION_NO_TEMPORARY", 1562);
DEFINE("ER_PARTITION_CONST_DOMAIN_ERROR", 1563);
DEFINE("ER_PARTITION_FUNCTION_IS_NOT_ALLOWED", 1564);
DEFINE("ER_DDL_LOG_ERROR", 1565);
DEFINE("ER_NULL_IN_VALUES_LESS_THAN", 1566);
DEFINE("ER_WRONG_PARTITION_NAME", 1567);
DEFINE("ER_CANT_CHANGE_TX_CHARACTERISTICS", 1568);
DEFINE("ER_DUP_ENTRY_AUTOINCREMENT_CASE", 1569);
DEFINE("ER_EVENT_MODIFY_QUEUE_ERROR", 1570);
DEFINE("ER_EVENT_SET_VAR_ERROR", 1571);
DEFINE("ER_PARTITION_MERGE_ERROR", 1572);
DEFINE("ER_CANT_ACTIVATE_LOG", 1573);
DEFINE("ER_RBR_NOT_AVAILABLE", 1574);
DEFINE("ER_BASE64_DECODE_ERROR", 1575);
DEFINE("ER_EVENT_RECURSION_FORBIDDEN", 1576);
DEFINE("ER_EVENTS_DB_ERROR", 1577);
DEFINE("ER_ONLY_INTEGERS_ALLOWED", 1578);
DEFINE("ER_UNSUPORTED_LOG_ENGINE", 1579);
DEFINE("ER_BAD_LOG_STATEMENT", 1580);
DEFINE("ER_CANT_RENAME_LOG_TABLE", 1581);
DEFINE("ER_WRONG_PARAMCOUNT_TO_NATIVE_FCT", 1582);
DEFINE("ER_WRONG_PARAMETERS_TO_NATIVE_FCT", 1583);
DEFINE("ER_WRONG_PARAMETERS_TO_STORED_FCT", 1584);
DEFINE("ER_NATIVE_FCT_NAME_COLLISION", 1585);
DEFINE("ER_DUP_ENTRY_WITH_KEY_NAME", 1586);
DEFINE("ER_BINLOG_PURGE_EMFILE", 1587);
DEFINE("ER_EVENT_CANNOT_CREATE_IN_THE_PAST", 1588);
DEFINE("ER_EVENT_CANNOT_ALTER_IN_THE_PAST", 1589);
DEFINE("ER_SLAVE_INCIDENT", 1590);
DEFINE("ER_NO_PARTITION_FOR_GIVEN_VALUE_SILENT", 1591);
DEFINE("ER_BINLOG_UNSAFE_STATEMENT", 1592);
DEFINE("ER_SLAVE_FATAL_ERROR", 1593);
DEFINE("ER_SLAVE_RELAY_LOG_READ_FAILURE", 1594);
DEFINE("ER_SLAVE_RELAY_LOG_WRITE_FAILURE", 1595);
DEFINE("ER_SLAVE_CREATE_EVENT_FAILURE", 1596);
DEFINE("ER_SLAVE_MASTER_COM_FAILURE", 1597);
DEFINE("ER_BINLOG_LOGGING_IMPOSSIBLE", 1598);
DEFINE("ER_VIEW_NO_CREATION_CTX", 1599);
DEFINE("ER_VIEW_INVALID_CREATION_CTX", 1600);
DEFINE("ER_SR_INVALID_CREATION_CTX", 1601);
DEFINE("ER_TRG_CORRUPTED_FILE", 1602);
DEFINE("ER_TRG_NO_CREATION_CTX", 1603);
DEFINE("ER_TRG_INVALID_CREATION_CTX", 1604);
DEFINE("ER_EVENT_INVALID_CREATION_CTX", 1605);
DEFINE("ER_TRG_CANT_OPEN_TABLE", 1606);
DEFINE("ER_CANT_CREATE_SROUTINE", 1607);
DEFINE("ER_NEVER_USED", 1608);
DEFINE("ER_NO_FORMAT_DESCRIPTION_EVENT_BEFORE_BINLOG_STATEMENT", 1609);
DEFINE("ER_SLAVE_CORRUPT_EVENT", 1610);
DEFINE("ER_LOAD_DATA_INVALID_COLUMN", 1611);
DEFINE("ER_LOG_PURGE_NO_FILE", 1612);
DEFINE("ER_XA_RBTIMEOUT", 1613);
DEFINE("ER_XA_RBDEADLOCK", 1614);
DEFINE("ER_NEED_REPREPARE", 1615);
DEFINE("ER_DELAYED_NOT_SUPPORTED", 1616);
DEFINE("WARN_NO_MASTER_INFO", 1617);
DEFINE("WARN_OPTION_IGNORED", 1618);
DEFINE("WARN_PLUGIN_DELETE_BUILTIN", 1619);
DEFINE("WARN_PLUGIN_BUSY", 1620);
DEFINE("ER_VARIABLE_IS_READONLY", 1621);
DEFINE("ER_WARN_ENGINE_TRANSACTION_ROLLBACK", 1622);
DEFINE("ER_SLAVE_HEARTBEAT_FAILURE", 1623);
DEFINE("ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE", 1624);
DEFINE("ER_NDB_REPLICATION_SCHEMA_ERROR", 1625);
DEFINE("ER_CONFLICT_FN_PARSE_ERROR", 1626);
DEFINE("ER_EXCEPTIONS_WRITE_ERROR", 1627);
DEFINE("ER_TOO_LONG_TABLE_COMMENT", 1628);
DEFINE("ER_TOO_LONG_FIELD_COMMENT", 1629);
DEFINE("ER_FUNC_INEXISTENT_NAME_COLLISION", 1630);
DEFINE("ER_DATABASE_NAME", 1631);
DEFINE("ER_TABLE_NAME", 1632);
DEFINE("ER_PARTITION_NAME", 1633);
DEFINE("ER_SUBPARTITION_NAME", 1634);
DEFINE("ER_TEMPORARY_NAME", 1635);
DEFINE("ER_RENAMED_NAME", 1636);
DEFINE("ER_TOO_MANY_CONCURRENT_TRXS", 1637);
DEFINE("WARN_NON_ASCII_SEPARATOR_NOT_IMPLEMENTED", 1638);
DEFINE("ER_DEBUG_SYNC_TIMEOUT", 1639);
DEFINE("ER_DEBUG_SYNC_HIT_LIMIT", 1640);
DEFINE("ER_DUP_SIGNAL_SET", 1641);
DEFINE("ER_SIGNAL_WARN", 1642);
DEFINE("ER_SIGNAL_NOT_FOUND", 1643);
DEFINE("ER_SIGNAL_EXCEPTION", 1644);
DEFINE("ER_RESIGNAL_WITHOUT_ACTIVE_HANDLER", 1645);
DEFINE("ER_SIGNAL_BAD_CONDITION_TYPE", 1646);
DEFINE("WARN_COND_ITEM_TRUNCATED", 1647);
DEFINE("ER_COND_ITEM_TOO_LONG", 1648);
DEFINE("ER_UNKNOWN_LOCALE", 1649);
DEFINE("ER_SLAVE_IGNORE_SERVER_IDS", 1650);
DEFINE("ER_QUERY_CACHE_DISABLED", 1651);
DEFINE("ER_SAME_NAME_PARTITION_FIELD", 1652);
DEFINE("ER_PARTITION_COLUMN_LIST_ERROR", 1653);
DEFINE("ER_WRONG_TYPE_COLUMN_VALUE_ERROR", 1654);
DEFINE("ER_TOO_MANY_PARTITION_FUNC_FIELDS_ERROR", 1655);
DEFINE("ER_MAXVALUE_IN_VALUES_IN", 1656);
DEFINE("ER_TOO_MANY_VALUES_ERROR", 1657);
DEFINE("ER_ROW_SINGLE_PARTITION_FIELD_ERROR", 1658);
DEFINE("ER_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD", 1659);
DEFINE("ER_PARTITION_FIELDS_TOO_LONG", 1660);
DEFINE("ER_BINLOG_ROW_ENGINE_AND_STMT_ENGINE", 1661);
DEFINE("ER_BINLOG_ROW_MODE_AND_STMT_ENGINE", 1662);
DEFINE("ER_BINLOG_UNSAFE_AND_STMT_ENGINE", 1663);
DEFINE("ER_BINLOG_ROW_INJECTION_AND_STMT_ENGINE", 1664);
DEFINE("ER_BINLOG_STMT_MODE_AND_ROW_ENGINE", 1665);
DEFINE("ER_BINLOG_ROW_INJECTION_AND_STMT_MODE", 1666);
DEFINE("ER_BINLOG_MULTIPLE_ENGINES_AND_SELF_LOGGING_ENGINE", 1667);
DEFINE("ER_BINLOG_UNSAFE_LIMIT", 1668);
DEFINE("ER_BINLOG_UNSAFE_INSERT_DELAYED", 1669);
DEFINE("ER_BINLOG_UNSAFE_SYSTEM_TABLE", 1670);
DEFINE("ER_BINLOG_UNSAFE_AUTOINC_COLUMNS", 1671);
DEFINE("ER_BINLOG_UNSAFE_UDF", 1672);
DEFINE("ER_BINLOG_UNSAFE_SYSTEM_VARIABLE", 1673);
DEFINE("ER_BINLOG_UNSAFE_SYSTEM_FUNCTION", 1674);
DEFINE("ER_BINLOG_UNSAFE_NONTRANS_AFTER_TRANS", 1675);
DEFINE("ER_MESSAGE_AND_STATEMENT", 1676);
DEFINE("ER_SLAVE_CONVERSION_FAILED", 1677);
DEFINE("ER_SLAVE_CANT_CREATE_CONVERSION", 1678);
DEFINE("ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_BINLOG_FORMAT", 1679);
DEFINE("ER_PATH_LENGTH", 1680);
DEFINE("ER_WARN_DEPRECATED_SYNTAX_NO_REPLACEMENT", 1681);
DEFINE("ER_WRONG_NATIVE_TABLE_STRUCTURE", 1682);
DEFINE("ER_WRONG_PERFSCHEMA_USAGE", 1683);
DEFINE("ER_WARN_I_S_SKIPPED_TABLE", 1684);
DEFINE("ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_BINLOG_DIRECT", 1685);
DEFINE("ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_DIRECT", 1686);
DEFINE("ER_SPATIAL_MUST_HAVE_GEOM_COL", 1687);
DEFINE("ER_TOO_LONG_INDEX_COMMENT", 1688);
DEFINE("ER_LOCK_ABORTED", 1689);
DEFINE("ER_DATA_OUT_OF_RANGE", 1690);
DEFINE("ER_WRONG_SPVAR_TYPE_IN_LIMIT", 1691);
DEFINE("ER_BINLOG_UNSAFE_MULTIPLE_ENGINES_AND_SELF_LOGGING_ENGINE", 1692);
DEFINE("ER_BINLOG_UNSAFE_MIXED_STATEMENT", 1693);
DEFINE("ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_SQL_LOG_BIN", 1694);
DEFINE("ER_STORED_FUNCTION_PREVENTS_SWITCH_SQL_LOG_BIN", 1695);
DEFINE("ER_FAILED_READ_FROM_PAR_FILE", 1696);
DEFINE("ER_VALUES_IS_NOT_INT_TYPE_ERROR", 1697);
DEFINE("ER_ACCESS_DENIED_NO_PASSWORD_ERROR", 1698);
DEFINE("ER_SET_PASSWORD_AUTH_PLUGIN", 1699);
DEFINE("ER_GRANT_PLUGIN_USER_EXISTS", 1700);
DEFINE("ER_TRUNCATE_ILLEGAL_FK", 1701);
DEFINE("ER_PLUGIN_IS_PERMANENT", 1702);
DEFINE("ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE_MIN", 1703);
DEFINE("ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE_MAX", 1704);
DEFINE("ER_STMT_CACHE_FULL", 1705);
DEFINE("ER_MULTI_UPDATE_KEY_CONFLICT", 1706);
DEFINE("ER_TABLE_NEEDS_REBUILD", 1707);
DEFINE("WARN_OPTION_BELOW_LIMIT", 1708);
DEFINE("ER_INDEX_COLUMN_TOO_LONG", 1709);
DEFINE("ER_ERROR_IN_TRIGGER_BODY", 1710);
DEFINE("ER_ERROR_IN_UNKNOWN_TRIGGER_BODY", 1711);
DEFINE("ER_INDEX_CORRUPT", 1712);
DEFINE("ER_UNDO_RECORD_TOO_BIG", 1713);
DEFINE("ER_BINLOG_UNSAFE_INSERT_IGNORE_SELECT", 1714);
DEFINE("ER_BINLOG_UNSAFE_INSERT_SELECT_UPDATE", 1715);
DEFINE("ER_BINLOG_UNSAFE_REPLACE_SELECT", 1716);
DEFINE("ER_BINLOG_UNSAFE_CREATE_IGNORE_SELECT", 1717);
DEFINE("ER_BINLOG_UNSAFE_CREATE_REPLACE_SELECT", 1718);
DEFINE("ER_BINLOG_UNSAFE_UPDATE_IGNORE", 1719);
DEFINE("ER_PLUGIN_NO_UNINSTALL", 1720);
DEFINE("ER_PLUGIN_NO_INSTALL", 1721);
DEFINE("ER_BINLOG_UNSAFE_WRITE_AUTOINC_SELECT", 1722);
DEFINE("ER_BINLOG_UNSAFE_CREATE_SELECT_AUTOINC", 1723);
DEFINE("ER_BINLOG_UNSAFE_INSERT_TWO_KEYS", 1724);
DEFINE("ER_TABLE_IN_FK_CHECK", 1725);
DEFINE("ER_UNSUPPORTED_ENGINE", 1726);
DEFINE("ER_BINLOG_UNSAFE_AUTOINC_NOT_FIRST", 1727);
DEFINE("ER_CANNOT_LOAD_FROM_TABLE_V2", 1728);
DEFINE("ER_MASTER_DELAY_VALUE_OUT_OF_RANGE", 1729);
DEFINE("ER_ONLY_FD_AND_RBR_EVENTS_ALLOWED_IN_BINLOG_STATEMENT", 1730);
DEFINE("ER_PARTITION_EXCHANGE_DIFFERENT_OPTION", 1731);
DEFINE("ER_PARTITION_EXCHANGE_PART_TABLE", 1732);
DEFINE("ER_PARTITION_EXCHANGE_TEMP_TABLE", 1733);
DEFINE("ER_PARTITION_INSTEAD_OF_SUBPARTITION", 1734);
DEFINE("ER_UNKNOWN_PARTITION", 1735);
DEFINE("ER_TABLES_DIFFERENT_METADATA", 1736);
DEFINE("ER_ROW_DOES_NOT_MATCH_PARTITION", 1737);
DEFINE("ER_BINLOG_CACHE_SIZE_GREATER_THAN_MAX", 1738);
DEFINE("ER_WARN_INDEX_NOT_APPLICABLE", 1739);
DEFINE("ER_PARTITION_EXCHANGE_FOREIGN_KEY", 1740);
DEFINE("ER_NO_SUCH_KEY_VALUE", 1741);
DEFINE("ER_RPL_INFO_DATA_TOO_LONG", 1742);
DEFINE("ER_NETWORK_READ_EVENT_CHECKSUM_FAILURE", 1743);
DEFINE("ER_BINLOG_READ_EVENT_CHECKSUM_FAILURE", 1744);
DEFINE("ER_BINLOG_STMT_CACHE_SIZE_GREATER_THAN_MAX", 1745);
DEFINE("ER_CANT_UPDATE_TABLE_IN_CREATE_TABLE_SELECT", 1746);
DEFINE("ER_PARTITION_CLAUSE_ON_NONPARTITIONED", 1747);
DEFINE("ER_ROW_DOES_NOT_MATCH_GIVEN_PARTITION_SET", 1748);
DEFINE("ER_NO_SUCH_PARTITION__UNUSED", 1749);
DEFINE("ER_CHANGE_RPL_INFO_REPOSITORY_FAILURE", 1750);
DEFINE("ER_WARNING_NOT_COMPLETE_ROLLBACK_WITH_CREATED_TEMP_TABLE", 1751);
DEFINE("ER_WARNING_NOT_COMPLETE_ROLLBACK_WITH_DROPPED_TEMP_TABLE", 1752);
DEFINE("ER_MTS_FEATURE_IS_NOT_SUPPORTED", 1753);
DEFINE("ER_MTS_UPDATED_DBS_GREATER_MAX", 1754);
DEFINE("ER_MTS_CANT_PARALLEL", 1755);
DEFINE("ER_FULLTEXT_NOT_SUPPORTED_WITH_PARTITIONING", 1757);
DEFINE("ER_DA_INVALID_CONDITION_NUMBER", 1758);
DEFINE("ER_INSECURE_PLAIN_TEXT", 1759);
DEFINE("ER_INSECURE_CHANGE_MASTER", 1760);
DEFINE("ER_FOREIGN_DUPLICATE_KEY_WITH_CHILD_INFO", 1761);
DEFINE("ER_FOREIGN_DUPLICATE_KEY_WITHOUT_CHILD_INFO", 1762);
DEFINE("ER_SQLTHREAD_WITH_SECURE_SLAVE", 1763);
DEFINE("ER_TABLE_HAS_NO_FT", 1764);
DEFINE("ER_VARIABLE_NOT_SETTABLE_IN_SF_OR_TRIGGER", 1765);
DEFINE("ER_VARIABLE_NOT_SETTABLE_IN_TRANSACTION", 1766);
DEFINE("ER_GTID_NEXT_IS_NOT_IN_GTID_NEXT_LIST", 1767);
DEFINE("ER_CANT_CHANGE_GTID_NEXT_IN_TRANSACTION_WHEN_GTID_NEXT_LIST_IS_NULL", 1768);
DEFINE("ER_SET_STATEMENT_CANNOT_INVOKE_FUNCTION", 1769);
DEFINE("ER_GTID_NEXT_CANT_BE_AUTOMATIC_IF_GTID_NEXT_LIST_IS_NON_NULL", 1770);
DEFINE("ER_SKIPPING_LOGGED_TRANSACTION", 1771);
DEFINE("ER_MALFORMED_GTID_SET_SPECIFICATION", 1772);
DEFINE("ER_MALFORMED_GTID_SET_ENCODING", 1773);
DEFINE("ER_MALFORMED_GTID_SPECIFICATION", 1774);
DEFINE("ER_GNO_EXHAUSTED", 1775);
DEFINE("ER_BAD_SLAVE_AUTO_POSITION", 1776);
DEFINE("ER_AUTO_POSITION_REQUIRES_GTID_MODE_ON", 1777);
DEFINE("ER_CANT_DO_IMPLICIT_COMMIT_IN_TRX_WHEN_GTID_NEXT_IS_SET", 1778);
DEFINE("ER_GTID_MODE_2_OR_3_REQUIRES_ENFORCE_GTID_CONSISTENCY_ON", 1779);
DEFINE("ER_GTID_MODE_REQUIRES_BINLOG", 1780);
DEFINE("ER_CANT_SET_GTID_NEXT_TO_GTID_WHEN_GTID_MODE_IS_OFF", 1781);
DEFINE("ER_CANT_SET_GTID_NEXT_TO_ANONYMOUS_WHEN_GTID_MODE_IS_ON", 1782);
DEFINE("ER_CANT_SET_GTID_NEXT_LIST_TO_NON_NULL_WHEN_GTID_MODE_IS_OFF", 1783);
DEFINE("ER_FOUND_GTID_EVENT_WHEN_GTID_MODE_IS_OFF", 1784);
DEFINE("ER_GTID_UNSAFE_NON_TRANSACTIONAL_TABLE", 1785);
DEFINE("ER_GTID_UNSAFE_CREATE_SELECT", 1786);
DEFINE("ER_GTID_UNSAFE_CREATE_DROP_TEMPORARY_TABLE_IN_TRANSACTION", 1787);
DEFINE("ER_GTID_MODE_CAN_ONLY_CHANGE_ONE_STEP_AT_A_TIME", 1788);
DEFINE("ER_MASTER_HAS_PURGED_REQUIRED_GTIDS", 1789);
DEFINE("ER_CANT_SET_GTID_NEXT_WHEN_OWNING_GTID", 1790);
DEFINE("ER_UNKNOWN_EXPLAIN_FORMAT", 1791);
DEFINE("ER_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION", 1792);
DEFINE("ER_TOO_LONG_TABLE_PARTITION_COMMENT", 1793);
DEFINE("ER_SLAVE_CONFIGURATION", 1794);
DEFINE("ER_INNODB_FT_LIMIT", 1795);
DEFINE("ER_INNODB_NO_FT_TEMP_TABLE", 1796);
DEFINE("ER_INNODB_FT_WRONG_DOCID_COLUMN", 1797);
DEFINE("ER_INNODB_FT_WRONG_DOCID_INDEX", 1798);
DEFINE("ER_INNODB_ONLINE_LOG_TOO_BIG", 1799);
DEFINE("ER_UNKNOWN_ALTER_ALGORITHM", 1800);
DEFINE("ER_UNKNOWN_ALTER_LOCK", 1801);
DEFINE("ER_MTS_CHANGE_MASTER_CANT_RUN_WITH_GAPS", 1802);
DEFINE("ER_MTS_RECOVERY_FAILURE", 1803);
DEFINE("ER_MTS_RESET_WORKERS", 1804);
DEFINE("ER_COL_COUNT_DOESNT_MATCH_CORRUPTED_V2", 1805);
DEFINE("ER_SLAVE_SILENT_RETRY_TRANSACTION", 1806);
DEFINE("ER_DISCARD_FK_CHECKS_RUNNING", 1807);
DEFINE("ER_TABLE_SCHEMA_MISMATCH", 1808);
DEFINE("ER_TABLE_IN_SYSTEM_TABLESPACE", 1809);
DEFINE("ER_IO_READ_ERROR", 1810);
DEFINE("ER_IO_WRITE_ERROR", 1811);
DEFINE("ER_TABLESPACE_MISSING", 1812);
DEFINE("ER_TABLESPACE_EXISTS", 1813);
DEFINE("ER_TABLESPACE_DISCARDED", 1814);
DEFINE("ER_INTERNAL_ERROR", 1815);
DEFINE("ER_INNODB_IMPORT_ERROR", 1816);
DEFINE("ER_INNODB_INDEX_CORRUPT", 1817);
DEFINE("ER_INVALID_YEAR_COLUMN_LENGTH", 1818);
DEFINE("ER_NOT_VALID_PASSWORD", 1819);
DEFINE("ER_MUST_CHANGE_PASSWORD", 1820);
DEFINE("ER_FK_NO_INDEX_CHILD", 1821);
DEFINE("ER_FK_NO_INDEX_PARENT", 1822);
DEFINE("ER_FK_FAIL_ADD_SYSTEM", 1823);
DEFINE("ER_FK_CANNOT_OPEN_PARENT", 1824);
DEFINE("ER_FK_INCORRECT_OPTION", 1825);
DEFINE("ER_FK_DUP_NAME", 1826);
DEFINE("ER_PASSWORD_FORMAT", 1827);
DEFINE("ER_FK_COLUMN_CANNOT_DROP", 1828);
DEFINE("ER_FK_COLUMN_CANNOT_DROP_CHILD", 1829);
DEFINE("ER_FK_COLUMN_NOT_NULL", 1830);
DEFINE("ER_DUP_INDEX", 1831);
DEFINE("ER_FK_COLUMN_CANNOT_CHANGE", 1832);
DEFINE("ER_FK_COLUMN_CANNOT_CHANGE_CHILD", 1833);
DEFINE("ER_FK_CANNOT_DELETE_PARENT", 1834);
DEFINE("ER_MALFORMED_PACKET", 1835);
DEFINE("ER_READ_ONLY_MODE", 1836);
DEFINE("ER_GTID_NEXT_TYPE_UNDEFINED_GROUP", 1837);
DEFINE("ER_VARIABLE_NOT_SETTABLE_IN_SP", 1838);
DEFINE("ER_CANT_SET_GTID_PURGED_WHEN_GTID_MODE_IS_OFF", 1839);
DEFINE("ER_CANT_SET_GTID_PURGED_WHEN_GTID_EXECUTED_IS_NOT_EMPTY", 1840);
DEFINE("ER_CANT_SET_GTID_PURGED_WHEN_OWNED_GTIDS_IS_NOT_EMPTY", 1841);
DEFINE("ER_GTID_PURGED_WAS_CHANGED", 1842);
DEFINE("ER_GTID_EXECUTED_WAS_CHANGED", 1843);
DEFINE("ER_BINLOG_STMT_MODE_AND_NO_REPL_TABLES", 1844);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED", 1845);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED_REASON", 1846);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_COPY", 1847);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_PARTITION", 1848);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FK_RENAME", 1849);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_COLUMN_TYPE", 1850);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FK_CHECK", 1851);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_IGNORE", 1852);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_NOPK", 1853);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_AUTOINC", 1854);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_HIDDEN_FTS", 1855);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_CHANGE_FTS", 1856);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FTS", 1857);
DEFINE("ER_SQL_SLAVE_SKIP_COUNTER_NOT_SETTABLE_IN_GTID_MODE", 1858);
DEFINE("ER_DUP_UNKNOWN_IN_INDEX", 1859);
DEFINE("ER_IDENT_CAUSES_TOO_LONG_PATH", 1860);
DEFINE("ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_NOT_NULL", 1861);
DEFINE("ER_MUST_CHANGE_PASSWORD_LOGIN", 1862);
DEFINE("ER_ROW_IN_WRONG_PARTITION", 1863);
DEFINE("ER_MTS_EVENT_BIGGER_PENDING_JOBS_SIZE_MAX", 1864);
DEFINE("ER_INNODB_NO_FT_USES_PARSER", 1865);
DEFINE("ER_BINLOG_LOGICAL_CORRUPTION", 1866);
DEFINE("ER_WARN_PURGE_LOG_IN_USE", 1867);
DEFINE("ER_WARN_PURGE_LOG_IS_ACTIVE", 1868);
DEFINE("ER_AUTO_INCREMENT_CONFLICT", 1869);
DEFINE("WARN_ON_BLOCKHOLE_IN_RBR", 1870);
DEFINE("ER_SLAVE_MI_INIT_REPOSITORY", 1871);
DEFINE("ER_SLAVE_RLI_INIT_REPOSITORY", 1872);
DEFINE("ER_ACCESS_DENIED_CHANGE_USER_ERROR", 1873);
DEFINE("ER_INNODB_READ_ONLY", 1874);
DEFINE("ER_STOP_SLAVE_SQL_THREAD_TIMEOUT", 1875);
DEFINE("ER_STOP_SLAVE_IO_THREAD_TIMEOUT", 1876);
DEFINE("ER_TABLE_CORRUPT", 1877);
DEFINE("ER_TEMP_FILE_WRITE_FAILURE", 1878);
DEFINE("ER_INNODB_FT_AUX_NOT_HEX_ID", 1879);
DEFINE("ER_OLD_TEMPORALS_UPGRADED", 1880);
DEFINE("ER_INNODB_FORCED_RECOVERY", 1881);
DEFINE("ER_AES_INVALID_IV", 1882);

function db_error_name($err_code){

	$arrayDefine = get_defined_constants();
	$defineSearched = '';
	foreach($arrayDefine as $define=>$value){
		if($err_code == $value){
			$defineSearched = $define;
		}
	}
	
	$ci =& get_instance();
	
	switch($defineSearched)
	{
		case "ER_ERROR_FIRST" : return $ci->lang->line('ER_ERROR_FIRST');
		case "ER_HASHCHK" : return $ci->lang->line('ER_HASHCHK');
		case "ER_NISAMCHK" : return $ci->lang->line('ER_NISAMCHK');
		case "ER_NO" : return $ci->lang->line('ER_NO');
		case "ER_YES" : return $ci->lang->line('ER_YES');
		case "ER_CANT_CREATE_FILE" : return $ci->lang->line('ER_CANT_CREATE_FILE');
		case "ER_CANT_CREATE_TABLE" : return $ci->lang->line('ER_CANT_CREATE_TABLE');
		case "ER_CANT_CREATE_DB" : return $ci->lang->line('ER_CANT_CREATE_DB');
		case "ER_DB_CREATE_EXISTS" : return $ci->lang->line('ER_DB_CREATE_EXISTS');
		case "ER_DB_DROP_EXISTS" : return $ci->lang->line('ER_DB_DROP_EXISTS');
		case "ER_DB_DROP_DELETE" : return $ci->lang->line('ER_DB_DROP_DELETE');
		case "ER_DB_DROP_RMDIR" : return $ci->lang->line('ER_DB_DROP_RMDIR');
		case "ER_CANT_DELETE_FILE" : return $ci->lang->line('ER_CANT_DELETE_FILE');
		case "ER_CANT_FIND_SYSTEM_REC" : return $ci->lang->line('ER_CANT_FIND_SYSTEM_REC');
		case "ER_CANT_GET_STAT" : return $ci->lang->line('ER_CANT_GET_STAT');
		case "ER_CANT_GET_WD" : return $ci->lang->line('ER_CANT_GET_WD');
		case "ER_CANT_LOCK" : return $ci->lang->line('ER_CANT_LOCK');
		case "ER_CANT_OPEN_FILE" : return $ci->lang->line('ER_CANT_OPEN_FILE');
		case "ER_FILE_NOT_FOUND" : return $ci->lang->line('ER_FILE_NOT_FOUND');
		case "ER_CANT_READ_DIR" : return $ci->lang->line('ER_CANT_READ_DIR');
		case "ER_CANT_SET_WD" : return $ci->lang->line('ER_CANT_SET_WD');
		case "ER_CHECKREAD" : return $ci->lang->line('ER_CHECKREAD');
		case "ER_DISK_FULL" : return $ci->lang->line('ER_DISK_FULL');
		case "ER_DUP_KEY" : return $ci->lang->line('ER_DUP_KEY');
		case "ER_ERROR_ON_CLOSE" : return $ci->lang->line('ER_ERROR_ON_CLOSE');
		case "ER_ERROR_ON_READ" : return $ci->lang->line('ER_ERROR_ON_READ');
		case "ER_ERROR_ON_RENAME" : return $ci->lang->line('ER_ERROR_ON_RENAME');
		case "ER_ERROR_ON_WRITE" : return $ci->lang->line('ER_ERROR_ON_WRITE');
		case "ER_FILE_USED" : return $ci->lang->line('ER_FILE_USED');
		case "ER_FILSORT_ABORT" : return $ci->lang->line('ER_FILSORT_ABORT');
		case "ER_FORM_NOT_FOUND" : return $ci->lang->line('ER_FORM_NOT_FOUND');
		case "ER_GET_ERRNO" : return $ci->lang->line('ER_GET_ERRNO');
		case "ER_ILLEGAL_HA" : return $ci->lang->line('ER_ILLEGAL_HA');
		case "ER_KEY_NOT_FOUND" : return $ci->lang->line('ER_KEY_NOT_FOUND');
		case "ER_NOT_FORM_FILE" : return $ci->lang->line('ER_NOT_FORM_FILE');
		case "ER_NOT_KEYFILE" : return $ci->lang->line('ER_NOT_KEYFILE');
		case "ER_OLD_KEYFILE" : return $ci->lang->line('ER_OLD_KEYFILE');
		case "ER_OPEN_AS_READONLY" : return $ci->lang->line('ER_OPEN_AS_READONLY');
		case "ER_OUTOFMEMORY" : return $ci->lang->line('ER_OUTOFMEMORY');
		case "ER_OUT_OF_SORTMEMORY" : return $ci->lang->line('ER_OUT_OF_SORTMEMORY');
		case "ER_UNEXPECTED_EOF" : return $ci->lang->line('ER_UNEXPECTED_EOF');
		case "ER_CON_COUNT_ERROR" : return $ci->lang->line('ER_CON_COUNT_ERROR');
		case "ER_OUT_OF_RESOURCES" : return $ci->lang->line('ER_OUT_OF_RESOURCES');
		case "ER_BAD_HOST_ERROR" : return $ci->lang->line('ER_BAD_HOST_ERROR');
		case "ER_HANDSHAKE_ERROR" : return $ci->lang->line('ER_HANDSHAKE_ERROR');
		case "ER_DBACCESS_DENIED_ERROR" : return $ci->lang->line('ER_DBACCESS_DENIED_ERROR');
		case "ER_ACCESS_DENIED_ERROR" : return $ci->lang->line('ER_ACCESS_DENIED_ERROR');
		case "ER_NO_DB_ERROR" : return $ci->lang->line('ER_NO_DB_ERROR');
		case "ER_UNKNOWN_COM_ERROR" : return $ci->lang->line('ER_UNKNOWN_COM_ERROR');
		case "ER_BAD_NULL_ERROR" : return $ci->lang->line('ER_BAD_NULL_ERROR');
		case "ER_BAD_DB_ERROR" : return $ci->lang->line('ER_BAD_DB_ERROR');
		case "ER_TABLE_EXISTS_ERROR" : return $ci->lang->line('ER_TABLE_EXISTS_ERROR');
		case "ER_BAD_TABLE_ERROR" : return $ci->lang->line('ER_BAD_TABLE_ERROR');
		case "ER_NON_UNIQ_ERROR" : return $ci->lang->line('ER_NON_UNIQ_ERROR');
		case "ER_SERVER_SHUTDOWN" : return $ci->lang->line('ER_SERVER_SHUTDOWN');
		case "ER_BAD_FIELD_ERROR" : return $ci->lang->line('ER_BAD_FIELD_ERROR');
		case "ER_WRONG_FIELD_WITH_GROUP" : return $ci->lang->line('ER_WRONG_FIELD_WITH_GROUP');
		case "ER_WRONG_GROUP_FIELD" : return $ci->lang->line('ER_WRONG_GROUP_FIELD');
		case "ER_WRONG_SUM_SELECT" : return $ci->lang->line('ER_WRONG_SUM_SELECT');
		case "ER_WRONG_VALUE_COUNT" : return $ci->lang->line('ER_WRONG_VALUE_COUNT');
		case "ER_TOO_LONG_IDENT" : return $ci->lang->line('ER_TOO_LONG_IDENT');
		case "ER_DUP_FIELDNAME" : return $ci->lang->line('ER_DUP_FIELDNAME');
		case "ER_DUP_KEYNAME" : return $ci->lang->line('ER_DUP_KEYNAME');
		case "ER_DUP_ENTRY" : return $ci->lang->line('ER_DUP_ENTRY');
		case "ER_WRONG_FIELD_SPEC" : return $ci->lang->line('ER_WRONG_FIELD_SPEC');
		case "ER_PARSE_ERROR" : return $ci->lang->line('ER_PARSE_ERROR');
		case "ER_EMPTY_QUERY" : return $ci->lang->line('ER_EMPTY_QUERY');
		case "ER_NONUNIQ_TABLE" : return $ci->lang->line('ER_NONUNIQ_TABLE');
		case "ER_INVALID_DEFAULT" : return $ci->lang->line('ER_INVALID_DEFAULT');
		case "ER_MULTIPLE_PRI_KEY" : return $ci->lang->line('ER_MULTIPLE_PRI_KEY');
		case "ER_TOO_MANY_KEYS" : return $ci->lang->line('ER_TOO_MANY_KEYS');
		case "ER_TOO_MANY_KEY_PARTS" : return $ci->lang->line('ER_TOO_MANY_KEY_PARTS');
		case "ER_TOO_LONG_KEY" : return $ci->lang->line('ER_TOO_LONG_KEY');
		case "ER_KEY_COLUMN_DOES_NOT_EXITS" : return $ci->lang->line('ER_KEY_COLUMN_DOES_NOT_EXITS');
		case "ER_BLOB_USED_AS_KEY" : return $ci->lang->line('ER_BLOB_USED_AS_KEY');
		case "ER_TOO_BIG_FIELDLENGTH" : return $ci->lang->line('ER_TOO_BIG_FIELDLENGTH');
		case "ER_WRONG_AUTO_KEY" : return $ci->lang->line('ER_WRONG_AUTO_KEY');
		case "ER_READY" : return $ci->lang->line('ER_READY');
		case "ER_NORMAL_SHUTDOWN" : return $ci->lang->line('ER_NORMAL_SHUTDOWN');
		case "ER_GOT_SIGNAL" : return $ci->lang->line('ER_GOT_SIGNAL');
		case "ER_SHUTDOWN_COMPLETE" : return $ci->lang->line('ER_SHUTDOWN_COMPLETE');
		case "ER_FORCING_CLOSE" : return $ci->lang->line('ER_FORCING_CLOSE');
		case "ER_IPSOCK_ERROR" : return $ci->lang->line('ER_IPSOCK_ERROR');
		case "ER_NO_SUCH_INDEX" : return $ci->lang->line('ER_NO_SUCH_INDEX');
		case "ER_WRONG_FIELD_TERMINATORS" : return $ci->lang->line('ER_WRONG_FIELD_TERMINATORS');
		case "ER_BLOBS_AND_NO_TERMINATED" : return $ci->lang->line('ER_BLOBS_AND_NO_TERMINATED');
		case "ER_TEXTFILE_NOT_READABLE" : return $ci->lang->line('ER_TEXTFILE_NOT_READABLE');
		case "ER_FILE_EXISTS_ERROR" : return $ci->lang->line('ER_FILE_EXISTS_ERROR');
		case "ER_LOAD_INFO" : return $ci->lang->line('ER_LOAD_INFO');
		case "ER_ALTER_INFO" : return $ci->lang->line('ER_ALTER_INFO');
		case "ER_WRONG_SUB_KEY" : return $ci->lang->line('ER_WRONG_SUB_KEY');
		case "ER_CANT_REMOVE_ALL_FIELDS" : return $ci->lang->line('ER_CANT_REMOVE_ALL_FIELDS');
		case "ER_CANT_DROP_FIELD_OR_KEY" : return $ci->lang->line('ER_CANT_DROP_FIELD_OR_KEY');
		case "ER_INSERT_INFO" : return $ci->lang->line('ER_INSERT_INFO');
		case "ER_UPDATE_TABLE_USED" : return $ci->lang->line('ER_UPDATE_TABLE_USED');
		case "ER_NO_SUCH_THREAD" : return $ci->lang->line('ER_NO_SUCH_THREAD');
		case "ER_KILL_DENIED_ERROR" : return $ci->lang->line('ER_KILL_DENIED_ERROR');
		case "ER_NO_TABLES_USED" : return $ci->lang->line('ER_NO_TABLES_USED');
		case "ER_TOO_BIG_SET" : return $ci->lang->line('ER_TOO_BIG_SET');
		case "ER_NO_UNIQUE_LOGFILE" : return $ci->lang->line('ER_NO_UNIQUE_LOGFILE');
		case "ER_TABLE_NOT_LOCKED_FOR_WRITE" : return $ci->lang->line('ER_TABLE_NOT_LOCKED_FOR_WRITE');
		case "ER_TABLE_NOT_LOCKED" : return $ci->lang->line('ER_TABLE_NOT_LOCKED');
		case "ER_BLOB_CANT_HAVE_DEFAULT" : return $ci->lang->line('ER_BLOB_CANT_HAVE_DEFAULT');
		case "ER_WRONG_DB_NAME" : return $ci->lang->line('ER_WRONG_DB_NAME');
		case "ER_WRONG_TABLE_NAME" : return $ci->lang->line('ER_WRONG_TABLE_NAME');
		case "ER_TOO_BIG_SELECT" : return $ci->lang->line('ER_TOO_BIG_SELECT');
		case "ER_UNKNOWN_ERROR" : return $ci->lang->line('ER_UNKNOWN_ERROR');
		case "ER_UNKNOWN_PROCEDURE" : return $ci->lang->line('ER_UNKNOWN_PROCEDURE');
		case "ER_WRONG_PARAMCOUNT_TO_PROCEDURE" : return $ci->lang->line('ER_WRONG_PARAMCOUNT_TO_PROCEDURE');
		case "ER_WRONG_PARAMETERS_TO_PROCEDURE" : return $ci->lang->line('ER_WRONG_PARAMETERS_TO_PROCEDURE');
		case "ER_UNKNOWN_TABLE" : return $ci->lang->line('ER_UNKNOWN_TABLE');
		case "ER_FIELD_SPECIFIED_TWICE" : return $ci->lang->line('ER_FIELD_SPECIFIED_TWICE');
		case "ER_INVALID_GROUP_FUNC_USE" : return $ci->lang->line('ER_INVALID_GROUP_FUNC_USE');
		case "ER_UNSUPPORTED_EXTENSION" : return $ci->lang->line('ER_UNSUPPORTED_EXTENSION');
		case "ER_TABLE_MUST_HAVE_COLUMNS" : return $ci->lang->line('ER_TABLE_MUST_HAVE_COLUMNS');
		case "ER_RECORD_FILE_FULL" : return $ci->lang->line('ER_RECORD_FILE_FULL');
		case "ER_UNKNOWN_CHARACTER_SET" : return $ci->lang->line('ER_UNKNOWN_CHARACTER_SET');
		case "ER_TOO_MANY_TABLES" : return $ci->lang->line('ER_TOO_MANY_TABLES');
		case "ER_TOO_MANY_FIELDS" : return $ci->lang->line('ER_TOO_MANY_FIELDS');
		case "ER_TOO_BIG_ROWSIZE" : return $ci->lang->line('ER_TOO_BIG_ROWSIZE');
		case "ER_STACK_OVERRUN" : return $ci->lang->line('ER_STACK_OVERRUN');
		case "ER_WRONG_OUTER_JOIN" : return $ci->lang->line('ER_WRONG_OUTER_JOIN');
		case "ER_NULL_COLUMN_IN_INDEX" : return $ci->lang->line('ER_NULL_COLUMN_IN_INDEX');
		case "ER_CANT_FIND_UDF" : return $ci->lang->line('ER_CANT_FIND_UDF');
		case "ER_CANT_INITIALIZE_UDF" : return $ci->lang->line('ER_CANT_INITIALIZE_UDF');
		case "ER_UDF_NO_PATHS" : return $ci->lang->line('ER_UDF_NO_PATHS');
		case "ER_UDF_EXISTS" : return $ci->lang->line('ER_UDF_EXISTS');
		case "ER_CANT_OPEN_LIBRARY" : return $ci->lang->line('ER_CANT_OPEN_LIBRARY');
		case "ER_CANT_FIND_DL_ENTRY" : return $ci->lang->line('ER_CANT_FIND_DL_ENTRY');
		case "ER_FUNCTION_NOT_DEFINED" : return $ci->lang->line('ER_FUNCTION_NOT_DEFINED');
		case "ER_HOST_IS_BLOCKED" : return $ci->lang->line('ER_HOST_IS_BLOCKED');
		case "ER_HOST_NOT_PRIVILEGED" : return $ci->lang->line('ER_HOST_NOT_PRIVILEGED');
		case "ER_PASSWORD_ANONYMOUS_USER" : return $ci->lang->line('ER_PASSWORD_ANONYMOUS_USER');
		case "ER_PASSWORD_NOT_ALLOWED" : return $ci->lang->line('ER_PASSWORD_NOT_ALLOWED');
		case "ER_PASSWORD_NO_MATCH" : return $ci->lang->line('ER_PASSWORD_NO_MATCH');
		case "ER_UPDATE_INFO" : return $ci->lang->line('ER_UPDATE_INFO');
		case "ER_CANT_CREATE_THREAD" : return $ci->lang->line('ER_CANT_CREATE_THREAD');
		case "ER_WRONG_VALUE_COUNT_ON_ROW" : return $ci->lang->line('ER_WRONG_VALUE_COUNT_ON_ROW');
		case "ER_CANT_REOPEN_TABLE" : return $ci->lang->line('ER_CANT_REOPEN_TABLE');
		case "ER_INVALID_USE_OF_NULL" : return $ci->lang->line('ER_INVALID_USE_OF_NULL');
		case "ER_REGEXP_ERROR" : return $ci->lang->line('ER_REGEXP_ERROR');
		case "ER_MIX_OF_GROUP_FUNC_AND_FIELDS" : return $ci->lang->line('ER_MIX_OF_GROUP_FUNC_AND_FIELDS');
		case "ER_NONEXISTING_GRANT" : return $ci->lang->line('ER_NONEXISTING_GRANT');
		case "ER_TABLEACCESS_DENIED_ERROR" : return $ci->lang->line('ER_TABLEACCESS_DENIED_ERROR');
		case "ER_COLUMNACCESS_DENIED_ERROR" : return $ci->lang->line('ER_COLUMNACCESS_DENIED_ERROR');
		case "ER_ILLEGAL_GRANT_FOR_TABLE" : return $ci->lang->line('ER_ILLEGAL_GRANT_FOR_TABLE');
		case "ER_GRANT_WRONG_HOST_OR_USER" : return $ci->lang->line('ER_GRANT_WRONG_HOST_OR_USER');
		case "ER_NO_SUCH_TABLE" : return $ci->lang->line('ER_NO_SUCH_TABLE');
		case "ER_NONEXISTING_TABLE_GRANT" : return $ci->lang->line('ER_NONEXISTING_TABLE_GRANT');
		case "ER_NOT_ALLOWED_COMMAND" : return $ci->lang->line('ER_NOT_ALLOWED_COMMAND');
		case "ER_SYNTAX_ERROR" : return $ci->lang->line('ER_SYNTAX_ERROR');
		case "ER_DELAYED_CANT_CHANGE_LOCK" : return $ci->lang->line('ER_DELAYED_CANT_CHANGE_LOCK');
		case "ER_TOO_MANY_DELAYED_THREADS" : return $ci->lang->line('ER_TOO_MANY_DELAYED_THREADS');
		case "ER_ABORTING_CONNECTION" : return $ci->lang->line('ER_ABORTING_CONNECTION');
		case "ER_NET_PACKET_TOO_LARGE" : return $ci->lang->line('ER_NET_PACKET_TOO_LARGE');
		case "ER_NET_READ_ERROR_FROM_PIPE" : return $ci->lang->line('ER_NET_READ_ERROR_FROM_PIPE');
		case "ER_NET_FCNTL_ERROR" : return $ci->lang->line('ER_NET_FCNTL_ERROR');
		case "ER_NET_PACKETS_OUT_OF_ORDER" : return $ci->lang->line('ER_NET_PACKETS_OUT_OF_ORDER');
		case "ER_NET_UNCOMPRESS_ERROR" : return $ci->lang->line('ER_NET_UNCOMPRESS_ERROR');
		case "ER_NET_READ_ERROR" : return $ci->lang->line('ER_NET_READ_ERROR');
		case "ER_NET_READ_INTERRUPTED" : return $ci->lang->line('ER_NET_READ_INTERRUPTED');
		case "ER_NET_ERROR_ON_WRITE" : return $ci->lang->line('ER_NET_ERROR_ON_WRITE');
		case "ER_NET_WRITE_INTERRUPTED" : return $ci->lang->line('ER_NET_WRITE_INTERRUPTED');
		case "ER_TOO_LONG_STRING" : return $ci->lang->line('ER_TOO_LONG_STRING');
		case "ER_TABLE_CANT_HANDLE_BLOB" : return $ci->lang->line('ER_TABLE_CANT_HANDLE_BLOB');
		case "ER_TABLE_CANT_HANDLE_AUTO_INCREMENT" : return $ci->lang->line('ER_TABLE_CANT_HANDLE_AUTO_INCREMENT');
		case "ER_DELAYED_INSERT_TABLE_LOCKED" : return $ci->lang->line('ER_DELAYED_INSERT_TABLE_LOCKED');
		case "ER_WRONG_COLUMN_NAME" : return $ci->lang->line('ER_WRONG_COLUMN_NAME');
		case "ER_WRONG_KEY_COLUMN" : return $ci->lang->line('ER_WRONG_KEY_COLUMN');
		case "ER_WRONG_MRG_TABLE" : return $ci->lang->line('ER_WRONG_MRG_TABLE');
		case "ER_DUP_UNIQUE" : return $ci->lang->line('ER_DUP_UNIQUE');
		case "ER_BLOB_KEY_WITHOUT_LENGTH" : return $ci->lang->line('ER_BLOB_KEY_WITHOUT_LENGTH');
		case "ER_PRIMARY_CANT_HAVE_NULL" : return $ci->lang->line('ER_PRIMARY_CANT_HAVE_NULL');
		case "ER_TOO_MANY_ROWS" : return $ci->lang->line('ER_TOO_MANY_ROWS');
		case "ER_REQUIRES_PRIMARY_KEY" : return $ci->lang->line('ER_REQUIRES_PRIMARY_KEY');
		case "ER_NO_RAID_COMPILED" : return $ci->lang->line('ER_NO_RAID_COMPILED');
		case "ER_UPDATE_WITHOUT_KEY_IN_SAFE_MODE" : return $ci->lang->line('ER_UPDATE_WITHOUT_KEY_IN_SAFE_MODE');
		case "ER_KEY_DOES_NOT_EXITS" : return $ci->lang->line('ER_KEY_DOES_NOT_EXITS');
		case "ER_CHECK_NO_SUCH_TABLE" : return $ci->lang->line('ER_CHECK_NO_SUCH_TABLE');
		case "ER_CHECK_NOT_IMPLEMENTED" : return $ci->lang->line('ER_CHECK_NOT_IMPLEMENTED');
		case "ER_CANT_DO_THIS_DURING_AN_TRANSACTION" : return $ci->lang->line('ER_CANT_DO_THIS_DURING_AN_TRANSACTION');
		case "ER_ERROR_DURING_COMMIT" : return $ci->lang->line('ER_ERROR_DURING_COMMIT');
		case "ER_ERROR_DURING_ROLLBACK" : return $ci->lang->line('ER_ERROR_DURING_ROLLBACK');
		case "ER_ERROR_DURING_FLUSH_LOGS" : return $ci->lang->line('ER_ERROR_DURING_FLUSH_LOGS');
		case "ER_ERROR_DURING_CHECKPOINT" : return $ci->lang->line('ER_ERROR_DURING_CHECKPOINT');
		case "ER_NEW_ABORTING_CONNECTION" : return $ci->lang->line('ER_NEW_ABORTING_CONNECTION');
		case "ER_DUMP_NOT_IMPLEMENTED" : return $ci->lang->line('ER_DUMP_NOT_IMPLEMENTED');
		case "ER_FLUSH_MASTER_BINLOG_CLOSED" : return $ci->lang->line('ER_FLUSH_MASTER_BINLOG_CLOSED');
		case "ER_INDEX_REBUILD" : return $ci->lang->line('ER_INDEX_REBUILD');
		case "ER_MASTER" : return $ci->lang->line('ER_MASTER');
		case "ER_MASTER_NET_READ" : return $ci->lang->line('ER_MASTER_NET_READ');
		case "ER_MASTER_NET_WRITE" : return $ci->lang->line('ER_MASTER_NET_WRITE');
		case "ER_FT_MATCHING_KEY_NOT_FOUND" : return $ci->lang->line('ER_FT_MATCHING_KEY_NOT_FOUND');
		case "ER_LOCK_OR_ACTIVE_TRANSACTION" : return $ci->lang->line('ER_LOCK_OR_ACTIVE_TRANSACTION');
		case "ER_UNKNOWN_SYSTEM_VARIABLE" : return $ci->lang->line('ER_UNKNOWN_SYSTEM_VARIABLE');
		case "ER_CRASHED_ON_USAGE" : return $ci->lang->line('ER_CRASHED_ON_USAGE');
		case "ER_CRASHED_ON_REPAIR" : return $ci->lang->line('ER_CRASHED_ON_REPAIR');
		case "ER_WARNING_NOT_COMPLETE_ROLLBACK" : return $ci->lang->line('ER_WARNING_NOT_COMPLETE_ROLLBACK');
		case "ER_TRANS_CACHE_FULL" : return $ci->lang->line('ER_TRANS_CACHE_FULL');
		case "ER_SLAVE_MUST_STOP" : return $ci->lang->line('ER_SLAVE_MUST_STOP');
		case "ER_SLAVE_NOT_RUNNING" : return $ci->lang->line('ER_SLAVE_NOT_RUNNING');
		case "ER_BAD_SLAVE" : return $ci->lang->line('ER_BAD_SLAVE');
		case "ER_MASTER_INFO" : return $ci->lang->line('ER_MASTER_INFO');
		case "ER_SLAVE_THREAD" : return $ci->lang->line('ER_SLAVE_THREAD');
		case "ER_TOO_MANY_USER_CONNECTIONS" : return $ci->lang->line('ER_TOO_MANY_USER_CONNECTIONS');
		case "ER_SET_CONSTANTS_ONLY" : return $ci->lang->line('ER_SET_CONSTANTS_ONLY');
		case "ER_LOCK_WAIT_TIMEOUT" : return $ci->lang->line('ER_LOCK_WAIT_TIMEOUT');
		case "ER_LOCK_TABLE_FULL" : return $ci->lang->line('ER_LOCK_TABLE_FULL');
		case "ER_READ_ONLY_TRANSACTION" : return $ci->lang->line('ER_READ_ONLY_TRANSACTION');
		case "ER_DROP_DB_WITH_READ_LOCK" : return $ci->lang->line('ER_DROP_DB_WITH_READ_LOCK');
		case "ER_CREATE_DB_WITH_READ_LOCK" : return $ci->lang->line('ER_CREATE_DB_WITH_READ_LOCK');
		case "ER_WRONG_ARGUMENTS" : return $ci->lang->line('ER_WRONG_ARGUMENTS');
		case "ER_NO_PERMISSION_TO_CREATE_USER" : return $ci->lang->line('ER_NO_PERMISSION_TO_CREATE_USER');
		case "ER_UNION_TABLES_IN_DIFFERENT_DIR" : return $ci->lang->line('ER_UNION_TABLES_IN_DIFFERENT_DIR');
		case "ER_LOCK_DEADLOCK" : return $ci->lang->line('ER_LOCK_DEADLOCK');
		case "ER_TABLE_CANT_HANDLE_FT" : return $ci->lang->line('ER_TABLE_CANT_HANDLE_FT');
		case "ER_CANNOT_ADD_FOREIGN" : return $ci->lang->line('ER_CANNOT_ADD_FOREIGN');
		case "ER_NO_REFERENCED_ROW" : return $ci->lang->line('ER_NO_REFERENCED_ROW');
		case "ER_ROW_IS_REFERENCED" : return $ci->lang->line('ER_ROW_IS_REFERENCED');
		case "ER_CONNECT_TO_MASTER" : return $ci->lang->line('ER_CONNECT_TO_MASTER');
		case "ER_QUERY_ON_MASTER" : return $ci->lang->line('ER_QUERY_ON_MASTER');
		case "ER_ERROR_WHEN_EXECUTING_COMMAND" : return $ci->lang->line('ER_ERROR_WHEN_EXECUTING_COMMAND');
		case "ER_WRONG_USAGE" : return $ci->lang->line('ER_WRONG_USAGE');
		case "ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT" : return $ci->lang->line('ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT');
		case "ER_CANT_UPDATE_WITH_READLOCK" : return $ci->lang->line('ER_CANT_UPDATE_WITH_READLOCK');
		case "ER_MIXING_NOT_ALLOWED" : return $ci->lang->line('ER_MIXING_NOT_ALLOWED');
		case "ER_DUP_ARGUMENT" : return $ci->lang->line('ER_DUP_ARGUMENT');
		case "ER_USER_LIMIT_REACHED" : return $ci->lang->line('ER_USER_LIMIT_REACHED');
		case "ER_SPECIFIC_ACCESS_DENIED_ERROR" : return $ci->lang->line('ER_SPECIFIC_ACCESS_DENIED_ERROR');
		case "ER_LOCAL_VARIABLE" : return $ci->lang->line('ER_LOCAL_VARIABLE');
		case "ER_GLOBAL_VARIABLE" : return $ci->lang->line('ER_GLOBAL_VARIABLE');
		case "ER_NO_DEFAULT" : return $ci->lang->line('ER_NO_DEFAULT');
		case "ER_WRONG_VALUE_FOR_VAR" : return $ci->lang->line('ER_WRONG_VALUE_FOR_VAR');
		case "ER_WRONG_TYPE_FOR_VAR" : return $ci->lang->line('ER_WRONG_TYPE_FOR_VAR');
		case "ER_VAR_CANT_BE_READ" : return $ci->lang->line('ER_VAR_CANT_BE_READ');
		case "ER_CANT_USE_OPTION_HERE" : return $ci->lang->line('ER_CANT_USE_OPTION_HERE');
		case "ER_NOT_SUPPORTED_YET" : return $ci->lang->line('ER_NOT_SUPPORTED_YET');
		case "ER_MASTER_FATAL_ERROR_READING_BINLOG" : return $ci->lang->line('ER_MASTER_FATAL_ERROR_READING_BINLOG');
		case "ER_SLAVE_IGNORED_TABLE" : return $ci->lang->line('ER_SLAVE_IGNORED_TABLE');
		case "ER_INCORRECT_GLOBAL_LOCAL_VAR" : return $ci->lang->line('ER_INCORRECT_GLOBAL_LOCAL_VAR');
		case "ER_WRONG_FK_DEF" : return $ci->lang->line('ER_WRONG_FK_DEF');
		case "ER_KEY_REF_DO_NOT_MATCH_TABLE_REF" : return $ci->lang->line('ER_KEY_REF_DO_NOT_MATCH_TABLE_REF');
		case "ER_OPERAND_COLUMNS" : return $ci->lang->line('ER_OPERAND_COLUMNS');
		case "ER_SUBQUERY_NO_1_ROW" : return $ci->lang->line('ER_SUBQUERY_NO_1_ROW');
		case "ER_UNKNOWN_STMT_HANDLER" : return $ci->lang->line('ER_UNKNOWN_STMT_HANDLER');
		case "ER_CORRUPT_HELP_DB" : return $ci->lang->line('ER_CORRUPT_HELP_DB');
		case "ER_CYCLIC_REFERENCE" : return $ci->lang->line('ER_CYCLIC_REFERENCE');
		case "ER_AUTO_CONVERT" : return $ci->lang->line('ER_AUTO_CONVERT');
		case "ER_ILLEGAL_REFERENCE" : return $ci->lang->line('ER_ILLEGAL_REFERENCE');
		case "ER_DERIVED_MUST_HAVE_ALIAS" : return $ci->lang->line('ER_DERIVED_MUST_HAVE_ALIAS');
		case "ER_SELECT_REDUCED" : return $ci->lang->line('ER_SELECT_REDUCED');
		case "ER_TABLENAME_NOT_ALLOWED_HERE" : return $ci->lang->line('ER_TABLENAME_NOT_ALLOWED_HERE');
		case "ER_NOT_SUPPORTED_AUTH_MODE" : return $ci->lang->line('ER_NOT_SUPPORTED_AUTH_MODE');
		case "ER_SPATIAL_CANT_HAVE_NULL" : return $ci->lang->line('ER_SPATIAL_CANT_HAVE_NULL');
		case "ER_COLLATION_CHARSET_MISMATCH" : return $ci->lang->line('ER_COLLATION_CHARSET_MISMATCH');
		case "ER_SLAVE_WAS_RUNNING" : return $ci->lang->line('ER_SLAVE_WAS_RUNNING');
		case "ER_SLAVE_WAS_NOT_RUNNING" : return $ci->lang->line('ER_SLAVE_WAS_NOT_RUNNING');
		case "ER_TOO_BIG_FOR_UNCOMPRESS" : return $ci->lang->line('ER_TOO_BIG_FOR_UNCOMPRESS');
		case "ER_ZLIB_Z_MEM_ERROR" : return $ci->lang->line('ER_ZLIB_Z_MEM_ERROR');
		case "ER_ZLIB_Z_BUF_ERROR" : return $ci->lang->line('ER_ZLIB_Z_BUF_ERROR');
		case "ER_ZLIB_Z_DATA_ERROR" : return $ci->lang->line('ER_ZLIB_Z_DATA_ERROR');
		case "ER_CUT_VALUE_GROUP_CONCAT" : return $ci->lang->line('ER_CUT_VALUE_GROUP_CONCAT');
		case "ER_WARN_TOO_FEW_RECORDS" : return $ci->lang->line('ER_WARN_TOO_FEW_RECORDS');
		case "ER_WARN_TOO_MANY_RECORDS" : return $ci->lang->line('ER_WARN_TOO_MANY_RECORDS');
		case "ER_WARN_NULL_TO_NOTNULL" : return $ci->lang->line('ER_WARN_NULL_TO_NOTNULL');
		case "ER_WARN_DATA_OUT_OF_RANGE" : return $ci->lang->line('ER_WARN_DATA_OUT_OF_RANGE');
		case "WARN_DATA_TRUNCATED" : return $ci->lang->line('WARN_DATA_TRUNCATED');
		case "ER_WARN_USING_OTHER_HANDLER" : return $ci->lang->line('ER_WARN_USING_OTHER_HANDLER');
		case "ER_CANT_AGGREGATE_2COLLATIONS" : return $ci->lang->line('ER_CANT_AGGREGATE_2COLLATIONS');
		case "ER_DROP_USER" : return $ci->lang->line('ER_DROP_USER');
		case "ER_REVOKE_GRANTS" : return $ci->lang->line('ER_REVOKE_GRANTS');
		case "ER_CANT_AGGREGATE_3COLLATIONS" : return $ci->lang->line('ER_CANT_AGGREGATE_3COLLATIONS');
		case "ER_CANT_AGGREGATE_NCOLLATIONS" : return $ci->lang->line('ER_CANT_AGGREGATE_NCOLLATIONS');
		case "ER_VARIABLE_IS_NOT_STRUCT" : return $ci->lang->line('ER_VARIABLE_IS_NOT_STRUCT');
		case "ER_UNKNOWN_COLLATION" : return $ci->lang->line('ER_UNKNOWN_COLLATION');
		case "ER_SLAVE_IGNORED_SSL_PARAMS" : return $ci->lang->line('ER_SLAVE_IGNORED_SSL_PARAMS');
		case "ER_SERVER_IS_IN_SECURE_AUTH_MODE" : return $ci->lang->line('ER_SERVER_IS_IN_SECURE_AUTH_MODE');
		case "ER_WARN_FIELD_RESOLVED" : return $ci->lang->line('ER_WARN_FIELD_RESOLVED');
		case "ER_BAD_SLAVE_UNTIL_COND" : return $ci->lang->line('ER_BAD_SLAVE_UNTIL_COND');
		case "ER_MISSING_SKIP_SLAVE" : return $ci->lang->line('ER_MISSING_SKIP_SLAVE');
		case "ER_UNTIL_COND_IGNORED" : return $ci->lang->line('ER_UNTIL_COND_IGNORED');
		case "ER_WRONG_NAME_FOR_INDEX" : return $ci->lang->line('ER_WRONG_NAME_FOR_INDEX');
		case "ER_WRONG_NAME_FOR_CATALOG" : return $ci->lang->line('ER_WRONG_NAME_FOR_CATALOG');
		case "ER_WARN_QC_RESIZE" : return $ci->lang->line('ER_WARN_QC_RESIZE');
		case "ER_BAD_FT_COLUMN" : return $ci->lang->line('ER_BAD_FT_COLUMN');
		case "ER_UNKNOWN_KEY_CACHE" : return $ci->lang->line('ER_UNKNOWN_KEY_CACHE');
		case "ER_WARN_HOSTNAME_WONT_WORK" : return $ci->lang->line('ER_WARN_HOSTNAME_WONT_WORK');
		case "ER_UNKNOWN_STORAGE_ENGINE" : return $ci->lang->line('ER_UNKNOWN_STORAGE_ENGINE');
		case "ER_WARN_DEPRECATED_SYNTAX" : return $ci->lang->line('ER_WARN_DEPRECATED_SYNTAX');
		case "ER_NON_UPDATABLE_TABLE" : return $ci->lang->line('ER_NON_UPDATABLE_TABLE');
		case "ER_FEATURE_DISABLED" : return $ci->lang->line('ER_FEATURE_DISABLED');
		case "ER_OPTION_PREVENTS_STATEMENT" : return $ci->lang->line('ER_OPTION_PREVENTS_STATEMENT');
		case "ER_DUPLICATED_VALUE_IN_TYPE" : return $ci->lang->line('ER_DUPLICATED_VALUE_IN_TYPE');
		case "ER_TRUNCATED_WRONG_VALUE" : return $ci->lang->line('ER_TRUNCATED_WRONG_VALUE');
		case "ER_TOO_MUCH_AUTO_TIMESTAMP_COLS" : return $ci->lang->line('ER_TOO_MUCH_AUTO_TIMESTAMP_COLS');
		case "ER_INVALID_ON_UPDATE" : return $ci->lang->line('ER_INVALID_ON_UPDATE');
		case "ER_UNSUPPORTED_PS" : return $ci->lang->line('ER_UNSUPPORTED_PS');
		case "ER_GET_ERRMSG" : return $ci->lang->line('ER_GET_ERRMSG');
		case "ER_GET_TEMPORARY_ERRMSG" : return $ci->lang->line('ER_GET_TEMPORARY_ERRMSG');
		case "ER_UNKNOWN_TIME_ZONE" : return $ci->lang->line('ER_UNKNOWN_TIME_ZONE');
		case "ER_WARN_INVALID_TIMESTAMP" : return $ci->lang->line('ER_WARN_INVALID_TIMESTAMP');
		case "ER_INVALID_CHARACTER_STRING" : return $ci->lang->line('ER_INVALID_CHARACTER_STRING');
		case "ER_WARN_ALLOWED_PACKET_OVERFLOWED" : return $ci->lang->line('ER_WARN_ALLOWED_PACKET_OVERFLOWED');
		case "ER_CONFLICTING_DECLARATIONS" : return $ci->lang->line('ER_CONFLICTING_DECLARATIONS');
		case "ER_SP_NO_RECURSIVE_CREATE" : return $ci->lang->line('ER_SP_NO_RECURSIVE_CREATE');
		case "ER_SP_ALREADY_EXISTS" : return $ci->lang->line('ER_SP_ALREADY_EXISTS');
		case "ER_SP_DOES_NOT_EXIST" : return $ci->lang->line('ER_SP_DOES_NOT_EXIST');
		case "ER_SP_DROP_FAILED" : return $ci->lang->line('ER_SP_DROP_FAILED');
		case "ER_SP_STORE_FAILED" : return $ci->lang->line('ER_SP_STORE_FAILED');
		case "ER_SP_LILABEL_MISMATCH" : return $ci->lang->line('ER_SP_LILABEL_MISMATCH');
		case "ER_SP_LABEL_REDEFINE" : return $ci->lang->line('ER_SP_LABEL_REDEFINE');
		case "ER_SP_LABEL_MISMATCH" : return $ci->lang->line('ER_SP_LABEL_MISMATCH');
		case "ER_SP_UNINIT_VAR" : return $ci->lang->line('ER_SP_UNINIT_VAR');
		case "ER_SP_BADSELECT" : return $ci->lang->line('ER_SP_BADSELECT');
		case "ER_SP_BADRETURN" : return $ci->lang->line('ER_SP_BADRETURN');
		case "ER_SP_BADSTATEMENT" : return $ci->lang->line('ER_SP_BADSTATEMENT');
		case "ER_UPDATE_LOG_DEPRECATED_IGNORED" : return $ci->lang->line('ER_UPDATE_LOG_DEPRECATED_IGNORED');
		case "ER_UPDATE_LOG_DEPRECATED_TRANSLATED" : return $ci->lang->line('ER_UPDATE_LOG_DEPRECATED_TRANSLATED');
		case "ER_QUERY_INTERRUPTED" : return $ci->lang->line('ER_QUERY_INTERRUPTED');
		case "ER_SP_WRONG_NO_OF_ARGS" : return $ci->lang->line('ER_SP_WRONG_NO_OF_ARGS');
		case "ER_SP_COND_MISMATCH" : return $ci->lang->line('ER_SP_COND_MISMATCH');
		case "ER_SP_NORETURN" : return $ci->lang->line('ER_SP_NORETURN');
		case "ER_SP_NORETURNEND" : return $ci->lang->line('ER_SP_NORETURNEND');
		case "ER_SP_BAD_CURSOR_QUERY" : return $ci->lang->line('ER_SP_BAD_CURSOR_QUERY');
		case "ER_SP_BAD_CURSOR_SELECT" : return $ci->lang->line('ER_SP_BAD_CURSOR_SELECT');
		case "ER_SP_CURSOR_MISMATCH" : return $ci->lang->line('ER_SP_CURSOR_MISMATCH');
		case "ER_SP_CURSOR_ALREADY_OPEN" : return $ci->lang->line('ER_SP_CURSOR_ALREADY_OPEN');
		case "ER_SP_CURSOR_NOT_OPEN" : return $ci->lang->line('ER_SP_CURSOR_NOT_OPEN');
		case "ER_SP_UNDECLARED_VAR" : return $ci->lang->line('ER_SP_UNDECLARED_VAR');
		case "ER_SP_WRONG_NO_OF_FETCH_ARGS" : return $ci->lang->line('ER_SP_WRONG_NO_OF_FETCH_ARGS');
		case "ER_SP_FETCH_NO_DATA" : return $ci->lang->line('ER_SP_FETCH_NO_DATA');
		case "ER_SP_DUP_PARAM" : return $ci->lang->line('ER_SP_DUP_PARAM');
		case "ER_SP_DUP_VAR" : return $ci->lang->line('ER_SP_DUP_VAR');
		case "ER_SP_DUP_COND" : return $ci->lang->line('ER_SP_DUP_COND');
		case "ER_SP_DUP_CURS" : return $ci->lang->line('ER_SP_DUP_CURS');
		case "ER_SP_CANT_ALTER" : return $ci->lang->line('ER_SP_CANT_ALTER');
		case "ER_SP_SUBSELECT_NYI" : return $ci->lang->line('ER_SP_SUBSELECT_NYI');
		case "ER_STMT_NOT_ALLOWED_IN_SF_OR_TRG" : return $ci->lang->line('ER_STMT_NOT_ALLOWED_IN_SF_OR_TRG');
		case "ER_SP_VARCOND_AFTER_CURSHNDLR" : return $ci->lang->line('ER_SP_VARCOND_AFTER_CURSHNDLR');
		case "ER_SP_CURSOR_AFTER_HANDLER" : return $ci->lang->line('ER_SP_CURSOR_AFTER_HANDLER');
		case "ER_SP_CASE_NOT_FOUND" : return $ci->lang->line('ER_SP_CASE_NOT_FOUND');
		case "ER_FPARSER_TOO_BIG_FILE" : return $ci->lang->line('ER_FPARSER_TOO_BIG_FILE');
		case "ER_FPARSER_BAD_HEADER" : return $ci->lang->line('ER_FPARSER_BAD_HEADER');
		case "ER_FPARSER_EOF_IN_COMMENT" : return $ci->lang->line('ER_FPARSER_EOF_IN_COMMENT');
		case "ER_FPARSER_ERROR_IN_PARAMETER" : return $ci->lang->line('ER_FPARSER_ERROR_IN_PARAMETER');
		case "ER_FPARSER_EOF_IN_UNKNOWN_PARAMETER" : return $ci->lang->line('ER_FPARSER_EOF_IN_UNKNOWN_PARAMETER');
		case "ER_VIEW_NO_EXPLAIN" : return $ci->lang->line('ER_VIEW_NO_EXPLAIN');
		case "ER_FRM_UNKNOWN_TYPE" : return $ci->lang->line('ER_FRM_UNKNOWN_TYPE');
		case "ER_WRONG_OBJECT" : return $ci->lang->line('ER_WRONG_OBJECT');
		case "ER_NONUPDATEABLE_COLUMN" : return $ci->lang->line('ER_NONUPDATEABLE_COLUMN');
		case "ER_VIEW_SELECT_DERIVED" : return $ci->lang->line('ER_VIEW_SELECT_DERIVED');
		case "ER_VIEW_SELECT_CLAUSE" : return $ci->lang->line('ER_VIEW_SELECT_CLAUSE');
		case "ER_VIEW_SELECT_VARIABLE" : return $ci->lang->line('ER_VIEW_SELECT_VARIABLE');
		case "ER_VIEW_SELECT_TMPTABLE" : return $ci->lang->line('ER_VIEW_SELECT_TMPTABLE');
		case "ER_VIEW_WRONG_LIST" : return $ci->lang->line('ER_VIEW_WRONG_LIST');
		case "ER_WARN_VIEW_MERGE" : return $ci->lang->line('ER_WARN_VIEW_MERGE');
		case "ER_WARN_VIEW_WITHOUT_KEY" : return $ci->lang->line('ER_WARN_VIEW_WITHOUT_KEY');
		case "ER_VIEW_INVALID" : return $ci->lang->line('ER_VIEW_INVALID');
		case "ER_SP_NO_DROP_SP" : return $ci->lang->line('ER_SP_NO_DROP_SP');
		case "ER_SP_GOTO_IN_HNDLR" : return $ci->lang->line('ER_SP_GOTO_IN_HNDLR');
		case "ER_TRG_ALREADY_EXISTS" : return $ci->lang->line('ER_TRG_ALREADY_EXISTS');
		case "ER_TRG_DOES_NOT_EXIST" : return $ci->lang->line('ER_TRG_DOES_NOT_EXIST');
		case "ER_TRG_ON_VIEW_OR_TEMP_TABLE" : return $ci->lang->line('ER_TRG_ON_VIEW_OR_TEMP_TABLE');
		case "ER_TRG_CANT_CHANGE_ROW" : return $ci->lang->line('ER_TRG_CANT_CHANGE_ROW');
		case "ER_TRG_NO_SUCH_ROW_IN_TRG" : return $ci->lang->line('ER_TRG_NO_SUCH_ROW_IN_TRG');
		case "ER_NO_DEFAULT_FOR_FIELD" : return $ci->lang->line('ER_NO_DEFAULT_FOR_FIELD');
		case "ER_DIVISION_BY_ZERO" : return $ci->lang->line('ER_DIVISION_BY_ZERO');
		case "ER_TRUNCATED_WRONG_VALUE_FOR_FIELD" : return $ci->lang->line('ER_TRUNCATED_WRONG_VALUE_FOR_FIELD');
		case "ER_ILLEGAL_VALUE_FOR_TYPE" : return $ci->lang->line('ER_ILLEGAL_VALUE_FOR_TYPE');
		case "ER_VIEW_NONUPD_CHECK" : return $ci->lang->line('ER_VIEW_NONUPD_CHECK');
		case "ER_VIEW_CHECK_FAILED" : return $ci->lang->line('ER_VIEW_CHECK_FAILED');
		case "ER_PROCACCESS_DENIED_ERROR" : return $ci->lang->line('ER_PROCACCESS_DENIED_ERROR');
		case "ER_RELAY_LOG_FAIL" : return $ci->lang->line('ER_RELAY_LOG_FAIL');
		case "ER_PASSWD_LENGTH" : return $ci->lang->line('ER_PASSWD_LENGTH');
		case "ER_UNKNOWN_TARGET_BINLOG" : return $ci->lang->line('ER_UNKNOWN_TARGET_BINLOG');
		case "ER_IO_ERR_LOG_INDEX_READ" : return $ci->lang->line('ER_IO_ERR_LOG_INDEX_READ');
		case "ER_BINLOG_PURGE_PROHIBITED" : return $ci->lang->line('ER_BINLOG_PURGE_PROHIBITED');
		case "ER_FSEEK_FAIL" : return $ci->lang->line('ER_FSEEK_FAIL');
		case "ER_BINLOG_PURGE_FATAL_ERR" : return $ci->lang->line('ER_BINLOG_PURGE_FATAL_ERR');
		case "ER_LOG_IN_USE" : return $ci->lang->line('ER_LOG_IN_USE');
		case "ER_LOG_PURGE_UNKNOWN_ERR" : return $ci->lang->line('ER_LOG_PURGE_UNKNOWN_ERR');
		case "ER_RELAY_LOG_INIT" : return $ci->lang->line('ER_RELAY_LOG_INIT');
		case "ER_NO_BINARY_LOGGING" : return $ci->lang->line('ER_NO_BINARY_LOGGING');
		case "ER_RESERVED_SYNTAX" : return $ci->lang->line('ER_RESERVED_SYNTAX');
		case "ER_WSAS_FAILED" : return $ci->lang->line('ER_WSAS_FAILED');
		case "ER_DIFF_GROUPS_PROC" : return $ci->lang->line('ER_DIFF_GROUPS_PROC');
		case "ER_NO_GROUP_FOR_PROC" : return $ci->lang->line('ER_NO_GROUP_FOR_PROC');
		case "ER_ORDER_WITH_PROC" : return $ci->lang->line('ER_ORDER_WITH_PROC');
		case "ER_LOGGING_PROHIBIT_CHANGING_OF" : return $ci->lang->line('ER_LOGGING_PROHIBIT_CHANGING_OF');
		case "ER_NO_FILE_MAPPING" : return $ci->lang->line('ER_NO_FILE_MAPPING');
		case "ER_WRONG_MAGIC" : return $ci->lang->line('ER_WRONG_MAGIC');
		case "ER_PS_MANY_PARAM" : return $ci->lang->line('ER_PS_MANY_PARAM');
		case "ER_KEY_PART_0" : return $ci->lang->line('ER_KEY_PART_0');
		case "ER_VIEW_CHECKSUM" : return $ci->lang->line('ER_VIEW_CHECKSUM');
		case "ER_VIEW_MULTIUPDATE" : return $ci->lang->line('ER_VIEW_MULTIUPDATE');
		case "ER_VIEW_NO_INSERT_FIELD_LIST" : return $ci->lang->line('ER_VIEW_NO_INSERT_FIELD_LIST');
		case "ER_VIEW_DELETE_MERGE_VIEW" : return $ci->lang->line('ER_VIEW_DELETE_MERGE_VIEW');
		case "ER_CANNOT_USER" : return $ci->lang->line('ER_CANNOT_USER');
		case "ER_XAER_NOTA" : return $ci->lang->line('ER_XAER_NOTA');
		case "ER_XAER_INVAL" : return $ci->lang->line('ER_XAER_INVAL');
		case "ER_XAER_RMFAIL" : return $ci->lang->line('ER_XAER_RMFAIL');
		case "ER_XAER_OUTSIDE" : return $ci->lang->line('ER_XAER_OUTSIDE');
		case "ER_XAER_RMERR" : return $ci->lang->line('ER_XAER_RMERR');
		case "ER_XA_RBROLLBACK" : return $ci->lang->line('ER_XA_RBROLLBACK');
		case "ER_NONEXISTING_PROC_GRANT" : return $ci->lang->line('ER_NONEXISTING_PROC_GRANT');
		case "ER_PROC_AUTO_GRANT_FAIL" : return $ci->lang->line('ER_PROC_AUTO_GRANT_FAIL');
		case "ER_PROC_AUTO_REVOKE_FAIL" : return $ci->lang->line('ER_PROC_AUTO_REVOKE_FAIL');
		case "ER_DATA_TOO_LONG" : return $ci->lang->line('ER_DATA_TOO_LONG');
		case "ER_SP_BAD_SQLSTATE" : return $ci->lang->line('ER_SP_BAD_SQLSTATE');
		case "ER_STARTUP" : return $ci->lang->line('ER_STARTUP');
		case "ER_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR" : return $ci->lang->line('ER_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR');
		case "ER_CANT_CREATE_USER_WITH_GRANT" : return $ci->lang->line('ER_CANT_CREATE_USER_WITH_GRANT');
		case "ER_WRONG_VALUE_FOR_TYPE" : return $ci->lang->line('ER_WRONG_VALUE_FOR_TYPE');
		case "ER_TABLE_DEF_CHANGED" : return $ci->lang->line('ER_TABLE_DEF_CHANGED');
		case "ER_SP_DUP_HANDLER" : return $ci->lang->line('ER_SP_DUP_HANDLER');
		case "ER_SP_NOT_VAR_ARG" : return $ci->lang->line('ER_SP_NOT_VAR_ARG');
		case "ER_SP_NO_RETSET" : return $ci->lang->line('ER_SP_NO_RETSET');
		case "ER_CANT_CREATE_GEOMETRY_OBJECT" : return $ci->lang->line('ER_CANT_CREATE_GEOMETRY_OBJECT');
		case "ER_FAILED_ROUTINE_BREAK_BINLOG" : return $ci->lang->line('ER_FAILED_ROUTINE_BREAK_BINLOG');
		case "ER_BINLOG_UNSAFE_ROUTINE" : return $ci->lang->line('ER_BINLOG_UNSAFE_ROUTINE');
		case "ER_BINLOG_CREATE_ROUTINE_NEED_SUPER" : return $ci->lang->line('ER_BINLOG_CREATE_ROUTINE_NEED_SUPER');
		case "ER_EXEC_STMT_WITH_OPEN_CURSOR" : return $ci->lang->line('ER_EXEC_STMT_WITH_OPEN_CURSOR');
		case "ER_STMT_HAS_NO_OPEN_CURSOR" : return $ci->lang->line('ER_STMT_HAS_NO_OPEN_CURSOR');
		case "ER_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG" : return $ci->lang->line('ER_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG');
		case "ER_NO_DEFAULT_FOR_VIEW_FIELD" : return $ci->lang->line('ER_NO_DEFAULT_FOR_VIEW_FIELD');
		case "ER_SP_NO_RECURSION" : return $ci->lang->line('ER_SP_NO_RECURSION');
		case "ER_TOO_BIG_SCALE" : return $ci->lang->line('ER_TOO_BIG_SCALE');
		case "ER_TOO_BIG_PRECISION" : return $ci->lang->line('ER_TOO_BIG_PRECISION');
		case "ER_M_BIGGER_THAN_D" : return $ci->lang->line('ER_M_BIGGER_THAN_D');
		case "ER_WRONG_LOCK_OF_SYSTEM_TABLE" : return $ci->lang->line('ER_WRONG_LOCK_OF_SYSTEM_TABLE');
		case "ER_CONNECT_TO_FOREIGN_DATA_SOURCE" : return $ci->lang->line('ER_CONNECT_TO_FOREIGN_DATA_SOURCE');
		case "ER_QUERY_ON_FOREIGN_DATA_SOURCE" : return $ci->lang->line('ER_QUERY_ON_FOREIGN_DATA_SOURCE');
		case "ER_FOREIGN_DATA_SOURCE_DOESNT_EXIST" : return $ci->lang->line('ER_FOREIGN_DATA_SOURCE_DOESNT_EXIST');
		case "ER_FOREIGN_DATA_STRING_INVALID_CANT_CREATE" : return $ci->lang->line('ER_FOREIGN_DATA_STRING_INVALID_CANT_CREATE');
		case "ER_FOREIGN_DATA_STRING_INVALID" : return $ci->lang->line('ER_FOREIGN_DATA_STRING_INVALID');
		case "ER_CANT_CREATE_FEDERATED_TABLE" : return $ci->lang->line('ER_CANT_CREATE_FEDERATED_TABLE');
		case "ER_TRG_IN_WRONG_SCHEMA" : return $ci->lang->line('ER_TRG_IN_WRONG_SCHEMA');
		case "ER_STACK_OVERRUN_NEED_MORE" : return $ci->lang->line('ER_STACK_OVERRUN_NEED_MORE');
		case "ER_TOO_LONG_BODY" : return $ci->lang->line('ER_TOO_LONG_BODY');
		case "ER_WARN_CANT_DROP_DEFAULT_KEYCACHE" : return $ci->lang->line('ER_WARN_CANT_DROP_DEFAULT_KEYCACHE');
		case "ER_TOO_BIG_DISPLAYWIDTH" : return $ci->lang->line('ER_TOO_BIG_DISPLAYWIDTH');
		case "ER_XAER_DUPID" : return $ci->lang->line('ER_XAER_DUPID');
		case "ER_DATETIME_FUNCTION_OVERFLOW" : return $ci->lang->line('ER_DATETIME_FUNCTION_OVERFLOW');
		case "ER_CANT_UPDATE_USED_TABLE_IN_SF_OR_TRG" : return $ci->lang->line('ER_CANT_UPDATE_USED_TABLE_IN_SF_OR_TRG');
		case "ER_VIEW_PREVENT_UPDATE" : return $ci->lang->line('ER_VIEW_PREVENT_UPDATE');
		case "ER_PS_NO_RECURSION" : return $ci->lang->line('ER_PS_NO_RECURSION');
		case "ER_SP_CANT_SET_AUTOCOMMIT" : return $ci->lang->line('ER_SP_CANT_SET_AUTOCOMMIT');
		case "ER_MALFORMED_DEFINER" : return $ci->lang->line('ER_MALFORMED_DEFINER');
		case "ER_VIEW_FRM_NO_USER" : return $ci->lang->line('ER_VIEW_FRM_NO_USER');
		case "ER_VIEW_OTHER_USER" : return $ci->lang->line('ER_VIEW_OTHER_USER');
		case "ER_NO_SUCH_USER" : return $ci->lang->line('ER_NO_SUCH_USER');
		case "ER_FORBID_SCHEMA_CHANGE" : return $ci->lang->line('ER_FORBID_SCHEMA_CHANGE');
		case "ER_ROW_IS_REFERENCED_2" : return $ci->lang->line('ER_ROW_IS_REFERENCED_2');
		case "ER_NO_REFERENCED_ROW_2" : return $ci->lang->line('ER_NO_REFERENCED_ROW_2');
		case "ER_SP_BAD_VAR_SHADOW" : return $ci->lang->line('ER_SP_BAD_VAR_SHADOW');
		case "ER_TRG_NO_DEFINER" : return $ci->lang->line('ER_TRG_NO_DEFINER');
		case "ER_OLD_FILE_FORMAT" : return $ci->lang->line('ER_OLD_FILE_FORMAT');
		case "ER_SP_RECURSION_LIMIT" : return $ci->lang->line('ER_SP_RECURSION_LIMIT');
		case "ER_SP_PROC_TABLE_CORRUPT" : return $ci->lang->line('ER_SP_PROC_TABLE_CORRUPT');
		case "ER_SP_WRONG_NAME" : return $ci->lang->line('ER_SP_WRONG_NAME');
		case "ER_TABLE_NEEDS_UPGRADE" : return $ci->lang->line('ER_TABLE_NEEDS_UPGRADE');
		case "ER_SP_NO_AGGREGATE" : return $ci->lang->line('ER_SP_NO_AGGREGATE');
		case "ER_MAX_PREPARED_STMT_COUNT_REACHED" : return $ci->lang->line('ER_MAX_PREPARED_STMT_COUNT_REACHED');
		case "ER_VIEW_RECURSIVE" : return $ci->lang->line('ER_VIEW_RECURSIVE');
		case "ER_NON_GROUPING_FIELD_USED" : return $ci->lang->line('ER_NON_GROUPING_FIELD_USED');
		case "ER_TABLE_CANT_HANDLE_SPKEYS" : return $ci->lang->line('ER_TABLE_CANT_HANDLE_SPKEYS');
		case "ER_NO_TRIGGERS_ON_SYSTEM_SCHEMA" : return $ci->lang->line('ER_NO_TRIGGERS_ON_SYSTEM_SCHEMA');
		case "ER_REMOVED_SPACES" : return $ci->lang->line('ER_REMOVED_SPACES');
		case "ER_AUTOINC_READ_FAILED" : return $ci->lang->line('ER_AUTOINC_READ_FAILED');
		case "ER_USERNAME" : return $ci->lang->line('ER_USERNAME');
		case "ER_HOSTNAME" : return $ci->lang->line('ER_HOSTNAME');
		case "ER_WRONG_STRING_LENGTH" : return $ci->lang->line('ER_WRONG_STRING_LENGTH');
		case "ER_NON_INSERTABLE_TABLE" : return $ci->lang->line('ER_NON_INSERTABLE_TABLE');
		case "ER_ADMIN_WRONG_MRG_TABLE" : return $ci->lang->line('ER_ADMIN_WRONG_MRG_TABLE');
		case "ER_TOO_HIGH_LEVEL_OF_NESTING_FOR_SELECT" : return $ci->lang->line('ER_TOO_HIGH_LEVEL_OF_NESTING_FOR_SELECT');
		case "ER_NAME_BECOMES_EMPTY" : return $ci->lang->line('ER_NAME_BECOMES_EMPTY');
		case "ER_AMBIGUOUS_FIELD_TERM" : return $ci->lang->line('ER_AMBIGUOUS_FIELD_TERM');
		case "ER_FOREIGN_SERVER_EXISTS" : return $ci->lang->line('ER_FOREIGN_SERVER_EXISTS');
		case "ER_FOREIGN_SERVER_DOESNT_EXIST" : return $ci->lang->line('ER_FOREIGN_SERVER_DOESNT_EXIST');
		case "ER_ILLEGAL_HA_CREATE_OPTION" : return $ci->lang->line('ER_ILLEGAL_HA_CREATE_OPTION');
		case "ER_PARTITION_REQUIRES_VALUES_ERROR" : return $ci->lang->line('ER_PARTITION_REQUIRES_VALUES_ERROR');
		case "ER_PARTITION_WRONG_VALUES_ERROR" : return $ci->lang->line('ER_PARTITION_WRONG_VALUES_ERROR');
		case "ER_PARTITION_MAXVALUE_ERROR" : return $ci->lang->line('ER_PARTITION_MAXVALUE_ERROR');
		case "ER_PARTITION_SUBPARTITION_ERROR" : return $ci->lang->line('ER_PARTITION_SUBPARTITION_ERROR');
		case "ER_PARTITION_SUBPART_MIX_ERROR" : return $ci->lang->line('ER_PARTITION_SUBPART_MIX_ERROR');
		case "ER_PARTITION_WRONG_NO_PART_ERROR" : return $ci->lang->line('ER_PARTITION_WRONG_NO_PART_ERROR');
		case "ER_PARTITION_WRONG_NO_SUBPART_ERROR" : return $ci->lang->line('ER_PARTITION_WRONG_NO_SUBPART_ERROR');
		case "ER_WRONG_EXPR_IN_PARTITION_FUNC_ERROR" : return $ci->lang->line('ER_WRONG_EXPR_IN_PARTITION_FUNC_ERROR');
		case "ER_NO_CONST_EXPR_IN_RANGE_OR_LIST_ERROR" : return $ci->lang->line('ER_NO_CONST_EXPR_IN_RANGE_OR_LIST_ERROR');
		case "ER_FIELD_NOT_FOUND_PART_ERROR" : return $ci->lang->line('ER_FIELD_NOT_FOUND_PART_ERROR');
		case "ER_LIST_OF_FIELDS_ONLY_IN_HASH_ERROR" : return $ci->lang->line('ER_LIST_OF_FIELDS_ONLY_IN_HASH_ERROR');
		case "ER_INCONSISTENT_PARTITION_INFO_ERROR" : return $ci->lang->line('ER_INCONSISTENT_PARTITION_INFO_ERROR');
		case "ER_PARTITION_FUNC_NOT_ALLOWED_ERROR" : return $ci->lang->line('ER_PARTITION_FUNC_NOT_ALLOWED_ERROR');
		case "ER_PARTITIONS_MUST_BE_DEFINED_ERROR" : return $ci->lang->line('ER_PARTITIONS_MUST_BE_DEFINED_ERROR');
		case "ER_RANGE_NOT_INCREASING_ERROR" : return $ci->lang->line('ER_RANGE_NOT_INCREASING_ERROR');
		case "ER_INCONSISTENT_TYPE_OF_FUNCTIONS_ERROR" : return $ci->lang->line('ER_INCONSISTENT_TYPE_OF_FUNCTIONS_ERROR');
		case "ER_MULTIPLE_DEF_CONST_IN_LIST_PART_ERROR" : return $ci->lang->line('ER_MULTIPLE_DEF_CONST_IN_LIST_PART_ERROR');
		case "ER_PARTITION_ENTRY_ERROR" : return $ci->lang->line('ER_PARTITION_ENTRY_ERROR');
		case "ER_MIX_HANDLER_ERROR" : return $ci->lang->line('ER_MIX_HANDLER_ERROR');
		case "ER_PARTITION_NOT_DEFINED_ERROR" : return $ci->lang->line('ER_PARTITION_NOT_DEFINED_ERROR');
		case "ER_TOO_MANY_PARTITIONS_ERROR" : return $ci->lang->line('ER_TOO_MANY_PARTITIONS_ERROR');
		case "ER_SUBPARTITION_ERROR" : return $ci->lang->line('ER_SUBPARTITION_ERROR');
		case "ER_CANT_CREATE_HANDLER_FILE" : return $ci->lang->line('ER_CANT_CREATE_HANDLER_FILE');
		case "ER_BLOB_FIELD_IN_PART_FUNC_ERROR" : return $ci->lang->line('ER_BLOB_FIELD_IN_PART_FUNC_ERROR');
		case "ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF" : return $ci->lang->line('ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF');
		case "ER_NO_PARTS_ERROR" : return $ci->lang->line('ER_NO_PARTS_ERROR');
		case "ER_PARTITION_MGMT_ON_NONPARTITIONED" : return $ci->lang->line('ER_PARTITION_MGMT_ON_NONPARTITIONED');
		case "ER_FOREIGN_KEY_ON_PARTITIONED" : return $ci->lang->line('ER_FOREIGN_KEY_ON_PARTITIONED');
		case "ER_DROP_PARTITION_NON_EXISTENT" : return $ci->lang->line('ER_DROP_PARTITION_NON_EXISTENT');
		case "ER_DROP_LAST_PARTITION" : return $ci->lang->line('ER_DROP_LAST_PARTITION');
		case "ER_COALESCE_ONLY_ON_HASH_PARTITION" : return $ci->lang->line('ER_COALESCE_ONLY_ON_HASH_PARTITION');
		case "ER_REORG_HASH_ONLY_ON_SAME_NO" : return $ci->lang->line('ER_REORG_HASH_ONLY_ON_SAME_NO');
		case "ER_REORG_NO_PARAM_ERROR" : return $ci->lang->line('ER_REORG_NO_PARAM_ERROR');
		case "ER_ONLY_ON_RANGE_LIST_PARTITION" : return $ci->lang->line('ER_ONLY_ON_RANGE_LIST_PARTITION');
		case "ER_ADD_PARTITION_SUBPART_ERROR" : return $ci->lang->line('ER_ADD_PARTITION_SUBPART_ERROR');
		case "ER_ADD_PARTITION_NO_NEW_PARTITION" : return $ci->lang->line('ER_ADD_PARTITION_NO_NEW_PARTITION');
		case "ER_COALESCE_PARTITION_NO_PARTITION" : return $ci->lang->line('ER_COALESCE_PARTITION_NO_PARTITION');
		case "ER_REORG_PARTITION_NOT_EXIST" : return $ci->lang->line('ER_REORG_PARTITION_NOT_EXIST');
		case "ER_SAME_NAME_PARTITION" : return $ci->lang->line('ER_SAME_NAME_PARTITION');
		case "ER_NO_BINLOG_ERROR" : return $ci->lang->line('ER_NO_BINLOG_ERROR');
		case "ER_CONSECUTIVE_REORG_PARTITIONS" : return $ci->lang->line('ER_CONSECUTIVE_REORG_PARTITIONS');
		case "ER_REORG_OUTSIDE_RANGE" : return $ci->lang->line('ER_REORG_OUTSIDE_RANGE');
		case "ER_PARTITION_FUNCTION_FAILURE" : return $ci->lang->line('ER_PARTITION_FUNCTION_FAILURE');
		case "ER_PART_STATE_ERROR" : return $ci->lang->line('ER_PART_STATE_ERROR');
		case "ER_LIMITED_PART_RANGE" : return $ci->lang->line('ER_LIMITED_PART_RANGE');
		case "ER_PLUGIN_IS_NOT_LOADED" : return $ci->lang->line('ER_PLUGIN_IS_NOT_LOADED');
		case "ER_WRONG_VALUE" : return $ci->lang->line('ER_WRONG_VALUE');
		case "ER_NO_PARTITION_FOR_GIVEN_VALUE" : return $ci->lang->line('ER_NO_PARTITION_FOR_GIVEN_VALUE');
		case "ER_FILEGROUP_OPTION_ONLY_ONCE" : return $ci->lang->line('ER_FILEGROUP_OPTION_ONLY_ONCE');
		case "ER_CREATE_FILEGROUP_FAILED" : return $ci->lang->line('ER_CREATE_FILEGROUP_FAILED');
		case "ER_DROP_FILEGROUP_FAILED" : return $ci->lang->line('ER_DROP_FILEGROUP_FAILED');
		case "ER_TABLESPACE_AUTO_EXTEND_ERROR" : return $ci->lang->line('ER_TABLESPACE_AUTO_EXTEND_ERROR');
		case "ER_WRONG_SIZE_NUMBER" : return $ci->lang->line('ER_WRONG_SIZE_NUMBER');
		case "ER_SIZE_OVERFLOW_ERROR" : return $ci->lang->line('ER_SIZE_OVERFLOW_ERROR');
		case "ER_ALTER_FILEGROUP_FAILED" : return $ci->lang->line('ER_ALTER_FILEGROUP_FAILED');
		case "ER_BINLOG_ROW_LOGGING_FAILED" : return $ci->lang->line('ER_BINLOG_ROW_LOGGING_FAILED');
		case "ER_BINLOG_ROW_WRONG_TABLE_DEF" : return $ci->lang->line('ER_BINLOG_ROW_WRONG_TABLE_DEF');
		case "ER_BINLOG_ROW_RBR_TO_SBR" : return $ci->lang->line('ER_BINLOG_ROW_RBR_TO_SBR');
		case "ER_EVENT_ALREADY_EXISTS" : return $ci->lang->line('ER_EVENT_ALREADY_EXISTS');
		case "ER_EVENT_STORE_FAILED" : return $ci->lang->line('ER_EVENT_STORE_FAILED');
		case "ER_EVENT_DOES_NOT_EXIST" : return $ci->lang->line('ER_EVENT_DOES_NOT_EXIST');
		case "ER_EVENT_CANT_ALTER" : return $ci->lang->line('ER_EVENT_CANT_ALTER');
		case "ER_EVENT_DROP_FAILED" : return $ci->lang->line('ER_EVENT_DROP_FAILED');
		case "ER_EVENT_INTERVAL_NOT_POSITIVE_OR_TOO_BIG" : return $ci->lang->line('ER_EVENT_INTERVAL_NOT_POSITIVE_OR_TOO_BIG');
		case "ER_EVENT_ENDS_BEFORE_STARTS" : return $ci->lang->line('ER_EVENT_ENDS_BEFORE_STARTS');
		case "ER_EVENT_EXEC_TIME_IN_THE_PAST" : return $ci->lang->line('ER_EVENT_EXEC_TIME_IN_THE_PAST');
		case "ER_EVENT_OPEN_TABLE_FAILED" : return $ci->lang->line('ER_EVENT_OPEN_TABLE_FAILED');
		case "ER_EVENT_NEITHER_M_EXPR_NOR_M_AT" : return $ci->lang->line('ER_EVENT_NEITHER_M_EXPR_NOR_M_AT');
		case "ER_OBSOLETE_COL_COUNT_DOESNT_MATCH_CORRUPTED" : return $ci->lang->line('ER_OBSOLETE_COL_COUNT_DOESNT_MATCH_CORRUPTED');
		case "ER_OBSOLETE_CANNOT_LOAD_FROM_TABLE" : return $ci->lang->line('ER_OBSOLETE_CANNOT_LOAD_FROM_TABLE');
		case "ER_EVENT_CANNOT_DELETE" : return $ci->lang->line('ER_EVENT_CANNOT_DELETE');
		case "ER_EVENT_COMPILE_ERROR" : return $ci->lang->line('ER_EVENT_COMPILE_ERROR');
		case "ER_EVENT_SAME_NAME" : return $ci->lang->line('ER_EVENT_SAME_NAME');
		case "ER_EVENT_DATA_TOO_LONG" : return $ci->lang->line('ER_EVENT_DATA_TOO_LONG');
		case "ER_DROP_INDEX_FK" : return $ci->lang->line('ER_DROP_INDEX_FK');
		case "ER_WARN_DEPRECATED_SYNTAX_WITH_VER" : return $ci->lang->line('ER_WARN_DEPRECATED_SYNTAX_WITH_VER');
		case "ER_CANT_WRITE_LOCK_LOG_TABLE" : return $ci->lang->line('ER_CANT_WRITE_LOCK_LOG_TABLE');
		case "ER_CANT_LOCK_LOG_TABLE" : return $ci->lang->line('ER_CANT_LOCK_LOG_TABLE');
		case "ER_FOREIGN_DUPLICATE_KEY_OLD_UNUSED" : return $ci->lang->line('ER_FOREIGN_DUPLICATE_KEY_OLD_UNUSED');
		case "ER_COL_COUNT_DOESNT_MATCH_PLEASE_UPDATE" : return $ci->lang->line('ER_COL_COUNT_DOESNT_MATCH_PLEASE_UPDATE');
		case "ER_TEMP_TABLE_PREVENTS_SWITCH_OUT_OF_RBR" : return $ci->lang->line('ER_TEMP_TABLE_PREVENTS_SWITCH_OUT_OF_RBR');
		case "ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_FORMAT" : return $ci->lang->line('ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_FORMAT');
		case "ER_NDB_CANT_SWITCH_BINLOG_FORMAT" : return $ci->lang->line('ER_NDB_CANT_SWITCH_BINLOG_FORMAT');
		case "ER_PARTITION_NO_TEMPORARY" : return $ci->lang->line('ER_PARTITION_NO_TEMPORARY');
		case "ER_PARTITION_CONST_DOMAIN_ERROR" : return $ci->lang->line('ER_PARTITION_CONST_DOMAIN_ERROR');
		case "ER_PARTITION_FUNCTION_IS_NOT_ALLOWED" : return $ci->lang->line('ER_PARTITION_FUNCTION_IS_NOT_ALLOWED');
		case "ER_DDL_LOG_ERROR" : return $ci->lang->line('ER_DDL_LOG_ERROR');
		case "ER_NULL_IN_VALUES_LESS_THAN" : return $ci->lang->line('ER_NULL_IN_VALUES_LESS_THAN');
		case "ER_WRONG_PARTITION_NAME" : return $ci->lang->line('ER_WRONG_PARTITION_NAME');
		case "ER_CANT_CHANGE_TX_CHARACTERISTICS" : return $ci->lang->line('ER_CANT_CHANGE_TX_CHARACTERISTICS');
		case "ER_DUP_ENTRY_AUTOINCREMENT_CASE" : return $ci->lang->line('ER_DUP_ENTRY_AUTOINCREMENT_CASE');
		case "ER_EVENT_MODIFY_QUEUE_ERROR" : return $ci->lang->line('ER_EVENT_MODIFY_QUEUE_ERROR');
		case "ER_EVENT_SET_VAR_ERROR" : return $ci->lang->line('ER_EVENT_SET_VAR_ERROR');
		case "ER_PARTITION_MERGE_ERROR" : return $ci->lang->line('ER_PARTITION_MERGE_ERROR');
		case "ER_CANT_ACTIVATE_LOG" : return $ci->lang->line('ER_CANT_ACTIVATE_LOG');
		case "ER_RBR_NOT_AVAILABLE" : return $ci->lang->line('ER_RBR_NOT_AVAILABLE');
		case "ER_BASE64_DECODE_ERROR" : return $ci->lang->line('ER_BASE64_DECODE_ERROR');
		case "ER_EVENT_RECURSION_FORBIDDEN" : return $ci->lang->line('ER_EVENT_RECURSION_FORBIDDEN');
		case "ER_EVENTS_DB_ERROR" : return $ci->lang->line('ER_EVENTS_DB_ERROR');
		case "ER_ONLY_INTEGERS_ALLOWED" : return $ci->lang->line('ER_ONLY_INTEGERS_ALLOWED');
		case "ER_UNSUPORTED_LOG_ENGINE" : return $ci->lang->line('ER_UNSUPORTED_LOG_ENGINE');
		case "ER_BAD_LOG_STATEMENT" : return $ci->lang->line('ER_BAD_LOG_STATEMENT');
		case "ER_CANT_RENAME_LOG_TABLE" : return $ci->lang->line('ER_CANT_RENAME_LOG_TABLE');
		case "ER_WRONG_PARAMCOUNT_TO_NATIVE_FCT" : return $ci->lang->line('ER_WRONG_PARAMCOUNT_TO_NATIVE_FCT');
		case "ER_WRONG_PARAMETERS_TO_NATIVE_FCT" : return $ci->lang->line('ER_WRONG_PARAMETERS_TO_NATIVE_FCT');
		case "ER_WRONG_PARAMETERS_TO_STORED_FCT" : return $ci->lang->line('ER_WRONG_PARAMETERS_TO_STORED_FCT');
		case "ER_NATIVE_FCT_NAME_COLLISION" : return $ci->lang->line('ER_NATIVE_FCT_NAME_COLLISION');
		case "ER_DUP_ENTRY_WITH_KEY_NAME" : return $ci->lang->line('ER_DUP_ENTRY_WITH_KEY_NAME');
		case "ER_BINLOG_PURGE_EMFILE" : return $ci->lang->line('ER_BINLOG_PURGE_EMFILE');
		case "ER_EVENT_CANNOT_CREATE_IN_THE_PAST" : return $ci->lang->line('ER_EVENT_CANNOT_CREATE_IN_THE_PAST');
		case "ER_EVENT_CANNOT_ALTER_IN_THE_PAST" : return $ci->lang->line('ER_EVENT_CANNOT_ALTER_IN_THE_PAST');
		case "ER_SLAVE_INCIDENT" : return $ci->lang->line('ER_SLAVE_INCIDENT');
		case "ER_NO_PARTITION_FOR_GIVEN_VALUE_SILENT" : return $ci->lang->line('ER_NO_PARTITION_FOR_GIVEN_VALUE_SILENT');
		case "ER_BINLOG_UNSAFE_STATEMENT" : return $ci->lang->line('ER_BINLOG_UNSAFE_STATEMENT');
		case "ER_SLAVE_FATAL_ERROR" : return $ci->lang->line('ER_SLAVE_FATAL_ERROR');
		case "ER_SLAVE_RELAY_LOG_READ_FAILURE" : return $ci->lang->line('ER_SLAVE_RELAY_LOG_READ_FAILURE');
		case "ER_SLAVE_RELAY_LOG_WRITE_FAILURE" : return $ci->lang->line('ER_SLAVE_RELAY_LOG_WRITE_FAILURE');
		case "ER_SLAVE_CREATE_EVENT_FAILURE" : return $ci->lang->line('ER_SLAVE_CREATE_EVENT_FAILURE');
		case "ER_SLAVE_MASTER_COM_FAILURE" : return $ci->lang->line('ER_SLAVE_MASTER_COM_FAILURE');
		case "ER_BINLOG_LOGGING_IMPOSSIBLE" : return $ci->lang->line('ER_BINLOG_LOGGING_IMPOSSIBLE');
		case "ER_VIEW_NO_CREATION_CTX" : return $ci->lang->line('ER_VIEW_NO_CREATION_CTX');
		case "ER_VIEW_INVALID_CREATION_CTX" : return $ci->lang->line('ER_VIEW_INVALID_CREATION_CTX');
		case "ER_SR_INVALID_CREATION_CTX" : return $ci->lang->line('ER_SR_INVALID_CREATION_CTX');
		case "ER_TRG_CORRUPTED_FILE" : return $ci->lang->line('ER_TRG_CORRUPTED_FILE');
		case "ER_TRG_NO_CREATION_CTX" : return $ci->lang->line('ER_TRG_NO_CREATION_CTX');
		case "ER_TRG_INVALID_CREATION_CTX" : return $ci->lang->line('ER_TRG_INVALID_CREATION_CTX');
		case "ER_EVENT_INVALID_CREATION_CTX" : return $ci->lang->line('ER_EVENT_INVALID_CREATION_CTX');
		case "ER_TRG_CANT_OPEN_TABLE" : return $ci->lang->line('ER_TRG_CANT_OPEN_TABLE');
		case "ER_CANT_CREATE_SROUTINE" : return $ci->lang->line('ER_CANT_CREATE_SROUTINE');
		case "ER_NEVER_USED" : return $ci->lang->line('ER_NEVER_USED');
		case "ER_NO_FORMAT_DESCRIPTION_EVENT_BEFORE_BINLOG_STATEMENT" : return $ci->lang->line('ER_NO_FORMAT_DESCRIPTION_EVENT_BEFORE_BINLOG_STATEMENT');
		case "ER_SLAVE_CORRUPT_EVENT" : return $ci->lang->line('ER_SLAVE_CORRUPT_EVENT');
		case "ER_LOAD_DATA_INVALID_COLUMN" : return $ci->lang->line('ER_LOAD_DATA_INVALID_COLUMN');
		case "ER_LOG_PURGE_NO_FILE" : return $ci->lang->line('ER_LOG_PURGE_NO_FILE');
		case "ER_XA_RBTIMEOUT" : return $ci->lang->line('ER_XA_RBTIMEOUT');
		case "ER_XA_RBDEADLOCK" : return $ci->lang->line('ER_XA_RBDEADLOCK');
		case "ER_NEED_REPREPARE" : return $ci->lang->line('ER_NEED_REPREPARE');
		case "ER_DELAYED_NOT_SUPPORTED" : return $ci->lang->line('ER_DELAYED_NOT_SUPPORTED');
		case "WARN_NO_MASTER_INFO" : return $ci->lang->line('WARN_NO_MASTER_INFO');
		case "WARN_OPTION_IGNORED" : return $ci->lang->line('WARN_OPTION_IGNORED');
		case "WARN_PLUGIN_DELETE_BUILTIN" : return $ci->lang->line('WARN_PLUGIN_DELETE_BUILTIN');
		case "WARN_PLUGIN_BUSY" : return $ci->lang->line('WARN_PLUGIN_BUSY');
		case "ER_VARIABLE_IS_READONLY" : return $ci->lang->line('ER_VARIABLE_IS_READONLY');
		case "ER_WARN_ENGINE_TRANSACTION_ROLLBACK" : return $ci->lang->line('ER_WARN_ENGINE_TRANSACTION_ROLLBACK');
		case "ER_SLAVE_HEARTBEAT_FAILURE" : return $ci->lang->line('ER_SLAVE_HEARTBEAT_FAILURE');
		case "ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE" : return $ci->lang->line('ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE');
		case "ER_NDB_REPLICATION_SCHEMA_ERROR" : return $ci->lang->line('ER_NDB_REPLICATION_SCHEMA_ERROR');
		case "ER_CONFLICT_FN_PARSE_ERROR" : return $ci->lang->line('ER_CONFLICT_FN_PARSE_ERROR');
		case "ER_EXCEPTIONS_WRITE_ERROR" : return $ci->lang->line('ER_EXCEPTIONS_WRITE_ERROR');
		case "ER_TOO_LONG_TABLE_COMMENT" : return $ci->lang->line('ER_TOO_LONG_TABLE_COMMENT');
		case "ER_TOO_LONG_FIELD_COMMENT" : return $ci->lang->line('ER_TOO_LONG_FIELD_COMMENT');
		case "ER_FUNC_INEXISTENT_NAME_COLLISION" : return $ci->lang->line('ER_FUNC_INEXISTENT_NAME_COLLISION');
		case "ER_DATABASE_NAME" : return $ci->lang->line('ER_DATABASE_NAME');
		case "ER_TABLE_NAME" : return $ci->lang->line('ER_TABLE_NAME');
		case "ER_PARTITION_NAME" : return $ci->lang->line('ER_PARTITION_NAME');
		case "ER_SUBPARTITION_NAME" : return $ci->lang->line('ER_SUBPARTITION_NAME');
		case "ER_TEMPORARY_NAME" : return $ci->lang->line('ER_TEMPORARY_NAME');
		case "ER_RENAMED_NAME" : return $ci->lang->line('ER_RENAMED_NAME');
		case "ER_TOO_MANY_CONCURRENT_TRXS" : return $ci->lang->line('ER_TOO_MANY_CONCURRENT_TRXS');
		case "WARN_NON_ASCII_SEPARATOR_NOT_IMPLEMENTED" : return $ci->lang->line('WARN_NON_ASCII_SEPARATOR_NOT_IMPLEMENTED');
		case "ER_DEBUG_SYNC_TIMEOUT" : return $ci->lang->line('ER_DEBUG_SYNC_TIMEOUT');
		case "ER_DEBUG_SYNC_HIT_LIMIT" : return $ci->lang->line('ER_DEBUG_SYNC_HIT_LIMIT');
		case "ER_DUP_SIGNAL_SET" : return $ci->lang->line('ER_DUP_SIGNAL_SET');
		case "ER_SIGNAL_WARN" : return $ci->lang->line('ER_SIGNAL_WARN');
		case "ER_SIGNAL_NOT_FOUND" : return $ci->lang->line('ER_SIGNAL_NOT_FOUND');
		case "ER_SIGNAL_EXCEPTION" : return $ci->lang->line('ER_SIGNAL_EXCEPTION');
		case "ER_RESIGNAL_WITHOUT_ACTIVE_HANDLER" : return $ci->lang->line('ER_RESIGNAL_WITHOUT_ACTIVE_HANDLER');
		case "ER_SIGNAL_BAD_CONDITION_TYPE" : return $ci->lang->line('ER_SIGNAL_BAD_CONDITION_TYPE');
		case "WARN_COND_ITEM_TRUNCATED" : return $ci->lang->line('WARN_COND_ITEM_TRUNCATED');
		case "ER_COND_ITEM_TOO_LONG" : return $ci->lang->line('ER_COND_ITEM_TOO_LONG');
		case "ER_UNKNOWN_LOCALE" : return $ci->lang->line('ER_UNKNOWN_LOCALE');
		case "ER_SLAVE_IGNORE_SERVER_IDS" : return $ci->lang->line('ER_SLAVE_IGNORE_SERVER_IDS');
		case "ER_QUERY_CACHE_DISABLED" : return $ci->lang->line('ER_QUERY_CACHE_DISABLED');
		case "ER_SAME_NAME_PARTITION_FIELD" : return $ci->lang->line('ER_SAME_NAME_PARTITION_FIELD');
		case "ER_PARTITION_COLUMN_LIST_ERROR" : return $ci->lang->line('ER_PARTITION_COLUMN_LIST_ERROR');
		case "ER_WRONG_TYPE_COLUMN_VALUE_ERROR" : return $ci->lang->line('ER_WRONG_TYPE_COLUMN_VALUE_ERROR');
		case "ER_TOO_MANY_PARTITION_FUNC_FIELDS_ERROR" : return $ci->lang->line('ER_TOO_MANY_PARTITION_FUNC_FIELDS_ERROR');
		case "ER_MAXVALUE_IN_VALUES_IN" : return $ci->lang->line('ER_MAXVALUE_IN_VALUES_IN');
		case "ER_TOO_MANY_VALUES_ERROR" : return $ci->lang->line('ER_TOO_MANY_VALUES_ERROR');
		case "ER_ROW_SINGLE_PARTITION_FIELD_ERROR" : return $ci->lang->line('ER_ROW_SINGLE_PARTITION_FIELD_ERROR');
		case "ER_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD" : return $ci->lang->line('ER_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD');
		case "ER_PARTITION_FIELDS_TOO_LONG" : return $ci->lang->line('ER_PARTITION_FIELDS_TOO_LONG');
		case "ER_BINLOG_ROW_ENGINE_AND_STMT_ENGINE" : return $ci->lang->line('ER_BINLOG_ROW_ENGINE_AND_STMT_ENGINE');
		case "ER_BINLOG_ROW_MODE_AND_STMT_ENGINE" : return $ci->lang->line('ER_BINLOG_ROW_MODE_AND_STMT_ENGINE');
		case "ER_BINLOG_UNSAFE_AND_STMT_ENGINE" : return $ci->lang->line('ER_BINLOG_UNSAFE_AND_STMT_ENGINE');
		case "ER_BINLOG_ROW_INJECTION_AND_STMT_ENGINE" : return $ci->lang->line('ER_BINLOG_ROW_INJECTION_AND_STMT_ENGINE');
		case "ER_BINLOG_STMT_MODE_AND_ROW_ENGINE" : return $ci->lang->line('ER_BINLOG_STMT_MODE_AND_ROW_ENGINE');
		case "ER_BINLOG_ROW_INJECTION_AND_STMT_MODE" : return $ci->lang->line('ER_BINLOG_ROW_INJECTION_AND_STMT_MODE');
		case "ER_BINLOG_MULTIPLE_ENGINES_AND_SELF_LOGGING_ENGINE" : return $ci->lang->line('ER_BINLOG_MULTIPLE_ENGINES_AND_SELF_LOGGING_ENGINE');
		case "ER_BINLOG_UNSAFE_LIMIT" : return $ci->lang->line('ER_BINLOG_UNSAFE_LIMIT');
		case "ER_BINLOG_UNSAFE_INSERT_DELAYED" : return $ci->lang->line('ER_BINLOG_UNSAFE_INSERT_DELAYED');
		case "ER_BINLOG_UNSAFE_SYSTEM_TABLE" : return $ci->lang->line('ER_BINLOG_UNSAFE_SYSTEM_TABLE');
		case "ER_BINLOG_UNSAFE_AUTOINC_COLUMNS" : return $ci->lang->line('ER_BINLOG_UNSAFE_AUTOINC_COLUMNS');
		case "ER_BINLOG_UNSAFE_UDF" : return $ci->lang->line('ER_BINLOG_UNSAFE_UDF');
		case "ER_BINLOG_UNSAFE_SYSTEM_VARIABLE" : return $ci->lang->line('ER_BINLOG_UNSAFE_SYSTEM_VARIABLE');
		case "ER_BINLOG_UNSAFE_SYSTEM_FUNCTION" : return $ci->lang->line('ER_BINLOG_UNSAFE_SYSTEM_FUNCTION');
		case "ER_BINLOG_UNSAFE_NONTRANS_AFTER_TRANS" : return $ci->lang->line('ER_BINLOG_UNSAFE_NONTRANS_AFTER_TRANS');
		case "ER_MESSAGE_AND_STATEMENT" : return $ci->lang->line('ER_MESSAGE_AND_STATEMENT');
		case "ER_SLAVE_CONVERSION_FAILED" : return $ci->lang->line('ER_SLAVE_CONVERSION_FAILED');
		case "ER_SLAVE_CANT_CREATE_CONVERSION" : return $ci->lang->line('ER_SLAVE_CANT_CREATE_CONVERSION');
		case "ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_BINLOG_FORMAT" : return $ci->lang->line('ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_BINLOG_FORMAT');
		case "ER_PATH_LENGTH" : return $ci->lang->line('ER_PATH_LENGTH');
		case "ER_WARN_DEPRECATED_SYNTAX_NO_REPLACEMENT" : return $ci->lang->line('ER_WARN_DEPRECATED_SYNTAX_NO_REPLACEMENT');
		case "ER_WRONG_NATIVE_TABLE_STRUCTURE" : return $ci->lang->line('ER_WRONG_NATIVE_TABLE_STRUCTURE');
		case "ER_WRONG_PERFSCHEMA_USAGE" : return $ci->lang->line('ER_WRONG_PERFSCHEMA_USAGE');
		case "ER_WARN_I_S_SKIPPED_TABLE" : return $ci->lang->line('ER_WARN_I_S_SKIPPED_TABLE');
		case "ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_BINLOG_DIRECT" : return $ci->lang->line('ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_BINLOG_DIRECT');
		case "ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_DIRECT" : return $ci->lang->line('ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_DIRECT');
		case "ER_SPATIAL_MUST_HAVE_GEOM_COL" : return $ci->lang->line('ER_SPATIAL_MUST_HAVE_GEOM_COL');
		case "ER_TOO_LONG_INDEX_COMMENT" : return $ci->lang->line('ER_TOO_LONG_INDEX_COMMENT');
		case "ER_LOCK_ABORTED" : return $ci->lang->line('ER_LOCK_ABORTED');
		case "ER_DATA_OUT_OF_RANGE" : return $ci->lang->line('ER_DATA_OUT_OF_RANGE');
		case "ER_WRONG_SPVAR_TYPE_IN_LIMIT" : return $ci->lang->line('ER_WRONG_SPVAR_TYPE_IN_LIMIT');
		case "ER_BINLOG_UNSAFE_MULTIPLE_ENGINES_AND_SELF_LOGGING_ENGINE" : return $ci->lang->line('ER_BINLOG_UNSAFE_MULTIPLE_ENGINES_AND_SELF_LOGGING_ENGINE');
		case "ER_BINLOG_UNSAFE_MIXED_STATEMENT" : return $ci->lang->line('ER_BINLOG_UNSAFE_MIXED_STATEMENT');
		case "ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_SQL_LOG_BIN" : return $ci->lang->line('ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_SQL_LOG_BIN');
		case "ER_STORED_FUNCTION_PREVENTS_SWITCH_SQL_LOG_BIN" : return $ci->lang->line('ER_STORED_FUNCTION_PREVENTS_SWITCH_SQL_LOG_BIN');
		case "ER_FAILED_READ_FROM_PAR_FILE" : return $ci->lang->line('ER_FAILED_READ_FROM_PAR_FILE');
		case "ER_VALUES_IS_NOT_INT_TYPE_ERROR" : return $ci->lang->line('ER_VALUES_IS_NOT_INT_TYPE_ERROR');
		case "ER_ACCESS_DENIED_NO_PASSWORD_ERROR" : return $ci->lang->line('ER_ACCESS_DENIED_NO_PASSWORD_ERROR');
		case "ER_SET_PASSWORD_AUTH_PLUGIN" : return $ci->lang->line('ER_SET_PASSWORD_AUTH_PLUGIN');
		case "ER_GRANT_PLUGIN_USER_EXISTS" : return $ci->lang->line('ER_GRANT_PLUGIN_USER_EXISTS');
		case "ER_TRUNCATE_ILLEGAL_FK" : return $ci->lang->line('ER_TRUNCATE_ILLEGAL_FK');
		case "ER_PLUGIN_IS_PERMANENT" : return $ci->lang->line('ER_PLUGIN_IS_PERMANENT');
		case "ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE_MIN" : return $ci->lang->line('ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE_MIN');
		case "ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE_MAX" : return $ci->lang->line('ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE_MAX');
		case "ER_STMT_CACHE_FULL" : return $ci->lang->line('ER_STMT_CACHE_FULL');
		case "ER_MULTI_UPDATE_KEY_CONFLICT" : return $ci->lang->line('ER_MULTI_UPDATE_KEY_CONFLICT');
		case "ER_TABLE_NEEDS_REBUILD" : return $ci->lang->line('ER_TABLE_NEEDS_REBUILD');
		case "WARN_OPTION_BELOW_LIMIT" : return $ci->lang->line('WARN_OPTION_BELOW_LIMIT');
		case "ER_INDEX_COLUMN_TOO_LONG" : return $ci->lang->line('ER_INDEX_COLUMN_TOO_LONG');
		case "ER_ERROR_IN_TRIGGER_BODY" : return $ci->lang->line('ER_ERROR_IN_TRIGGER_BODY');
		case "ER_ERROR_IN_UNKNOWN_TRIGGER_BODY" : return $ci->lang->line('ER_ERROR_IN_UNKNOWN_TRIGGER_BODY');
		case "ER_INDEX_CORRUPT" : return $ci->lang->line('ER_INDEX_CORRUPT');
		case "ER_UNDO_RECORD_TOO_BIG" : return $ci->lang->line('ER_UNDO_RECORD_TOO_BIG');
		case "ER_BINLOG_UNSAFE_INSERT_IGNORE_SELECT" : return $ci->lang->line('ER_BINLOG_UNSAFE_INSERT_IGNORE_SELECT');
		case "ER_BINLOG_UNSAFE_INSERT_SELECT_UPDATE" : return $ci->lang->line('ER_BINLOG_UNSAFE_INSERT_SELECT_UPDATE');
		case "ER_BINLOG_UNSAFE_REPLACE_SELECT" : return $ci->lang->line('ER_BINLOG_UNSAFE_REPLACE_SELECT');
		case "ER_BINLOG_UNSAFE_CREATE_IGNORE_SELECT" : return $ci->lang->line('ER_BINLOG_UNSAFE_CREATE_IGNORE_SELECT');
		case "ER_BINLOG_UNSAFE_CREATE_REPLACE_SELECT" : return $ci->lang->line('ER_BINLOG_UNSAFE_CREATE_REPLACE_SELECT');
		case "ER_BINLOG_UNSAFE_UPDATE_IGNORE" : return $ci->lang->line('ER_BINLOG_UNSAFE_UPDATE_IGNORE');
		case "ER_PLUGIN_NO_UNINSTALL" : return $ci->lang->line('ER_PLUGIN_NO_UNINSTALL');
		case "ER_PLUGIN_NO_INSTALL" : return $ci->lang->line('ER_PLUGIN_NO_INSTALL');
		case "ER_BINLOG_UNSAFE_WRITE_AUTOINC_SELECT" : return $ci->lang->line('ER_BINLOG_UNSAFE_WRITE_AUTOINC_SELECT');
		case "ER_BINLOG_UNSAFE_CREATE_SELECT_AUTOINC" : return $ci->lang->line('ER_BINLOG_UNSAFE_CREATE_SELECT_AUTOINC');
		case "ER_BINLOG_UNSAFE_INSERT_TWO_KEYS" : return $ci->lang->line('ER_BINLOG_UNSAFE_INSERT_TWO_KEYS');
		case "ER_TABLE_IN_FK_CHECK" : return $ci->lang->line('ER_TABLE_IN_FK_CHECK');
		case "ER_UNSUPPORTED_ENGINE" : return $ci->lang->line('ER_UNSUPPORTED_ENGINE');
		case "ER_BINLOG_UNSAFE_AUTOINC_NOT_FIRST" : return $ci->lang->line('ER_BINLOG_UNSAFE_AUTOINC_NOT_FIRST');
		case "ER_CANNOT_LOAD_FROM_TABLE_V2" : return $ci->lang->line('ER_CANNOT_LOAD_FROM_TABLE_V2');
		case "ER_MASTER_DELAY_VALUE_OUT_OF_RANGE" : return $ci->lang->line('ER_MASTER_DELAY_VALUE_OUT_OF_RANGE');
		case "ER_ONLY_FD_AND_RBR_EVENTS_ALLOWED_IN_BINLOG_STATEMENT" : return $ci->lang->line('ER_ONLY_FD_AND_RBR_EVENTS_ALLOWED_IN_BINLOG_STATEMENT');
		case "ER_PARTITION_EXCHANGE_DIFFERENT_OPTION" : return $ci->lang->line('ER_PARTITION_EXCHANGE_DIFFERENT_OPTION');
		case "ER_PARTITION_EXCHANGE_PART_TABLE" : return $ci->lang->line('ER_PARTITION_EXCHANGE_PART_TABLE');
		case "ER_PARTITION_EXCHANGE_TEMP_TABLE" : return $ci->lang->line('ER_PARTITION_EXCHANGE_TEMP_TABLE');
		case "ER_PARTITION_INSTEAD_OF_SUBPARTITION" : return $ci->lang->line('ER_PARTITION_INSTEAD_OF_SUBPARTITION');
		case "ER_UNKNOWN_PARTITION" : return $ci->lang->line('ER_UNKNOWN_PARTITION');
		case "ER_TABLES_DIFFERENT_METADATA" : return $ci->lang->line('ER_TABLES_DIFFERENT_METADATA');
		case "ER_ROW_DOES_NOT_MATCH_PARTITION" : return $ci->lang->line('ER_ROW_DOES_NOT_MATCH_PARTITION');
		case "ER_BINLOG_CACHE_SIZE_GREATER_THAN_MAX" : return $ci->lang->line('ER_BINLOG_CACHE_SIZE_GREATER_THAN_MAX');
		case "ER_WARN_INDEX_NOT_APPLICABLE" : return $ci->lang->line('ER_WARN_INDEX_NOT_APPLICABLE');
		case "ER_PARTITION_EXCHANGE_FOREIGN_KEY" : return $ci->lang->line('ER_PARTITION_EXCHANGE_FOREIGN_KEY');
		case "ER_NO_SUCH_KEY_VALUE" : return $ci->lang->line('ER_NO_SUCH_KEY_VALUE');
		case "ER_RPL_INFO_DATA_TOO_LONG" : return $ci->lang->line('ER_RPL_INFO_DATA_TOO_LONG');
		case "ER_NETWORK_READ_EVENT_CHECKSUM_FAILURE" : return $ci->lang->line('ER_NETWORK_READ_EVENT_CHECKSUM_FAILURE');
		case "ER_BINLOG_READ_EVENT_CHECKSUM_FAILURE" : return $ci->lang->line('ER_BINLOG_READ_EVENT_CHECKSUM_FAILURE');
		case "ER_BINLOG_STMT_CACHE_SIZE_GREATER_THAN_MAX" : return $ci->lang->line('ER_BINLOG_STMT_CACHE_SIZE_GREATER_THAN_MAX');
		case "ER_CANT_UPDATE_TABLE_IN_CREATE_TABLE_SELECT" : return $ci->lang->line('ER_CANT_UPDATE_TABLE_IN_CREATE_TABLE_SELECT');
		case "ER_PARTITION_CLAUSE_ON_NONPARTITIONED" : return $ci->lang->line('ER_PARTITION_CLAUSE_ON_NONPARTITIONED');
		case "ER_ROW_DOES_NOT_MATCH_GIVEN_PARTITION_SET" : return $ci->lang->line('ER_ROW_DOES_NOT_MATCH_GIVEN_PARTITION_SET');
		case "ER_NO_SUCH_PARTITION__UNUSED" : return $ci->lang->line('ER_NO_SUCH_PARTITION__UNUSED');
		case "ER_CHANGE_RPL_INFO_REPOSITORY_FAILURE" : return $ci->lang->line('ER_CHANGE_RPL_INFO_REPOSITORY_FAILURE');
		case "ER_WARNING_NOT_COMPLETE_ROLLBACK_WITH_CREATED_TEMP_TABLE" : return $ci->lang->line('ER_WARNING_NOT_COMPLETE_ROLLBACK_WITH_CREATED_TEMP_TABLE');
		case "ER_WARNING_NOT_COMPLETE_ROLLBACK_WITH_DROPPED_TEMP_TABLE" : return $ci->lang->line('ER_WARNING_NOT_COMPLETE_ROLLBACK_WITH_DROPPED_TEMP_TABLE');
		case "ER_MTS_FEATURE_IS_NOT_SUPPORTED" : return $ci->lang->line('ER_MTS_FEATURE_IS_NOT_SUPPORTED');
		case "ER_MTS_UPDATED_DBS_GREATER_MAX" : return $ci->lang->line('ER_MTS_UPDATED_DBS_GREATER_MAX');
		case "ER_MTS_CANT_PARALLEL" : return $ci->lang->line('ER_MTS_CANT_PARALLEL');
		case "ER_FULLTEXT_NOT_SUPPORTED_WITH_PARTITIONING" : return $ci->lang->line('ER_FULLTEXT_NOT_SUPPORTED_WITH_PARTITIONING');
		case "ER_DA_INVALID_CONDITION_NUMBER" : return $ci->lang->line('ER_DA_INVALID_CONDITION_NUMBER');
		case "ER_INSECURE_PLAIN_TEXT" : return $ci->lang->line('ER_INSECURE_PLAIN_TEXT');
		case "ER_INSECURE_CHANGE_MASTER" : return $ci->lang->line('ER_INSECURE_CHANGE_MASTER');
		case "ER_FOREIGN_DUPLICATE_KEY_WITH_CHILD_INFO" : return $ci->lang->line('ER_FOREIGN_DUPLICATE_KEY_WITH_CHILD_INFO');
		case "ER_FOREIGN_DUPLICATE_KEY_WITHOUT_CHILD_INFO" : return $ci->lang->line('ER_FOREIGN_DUPLICATE_KEY_WITHOUT_CHILD_INFO');
		case "ER_SQLTHREAD_WITH_SECURE_SLAVE" : return $ci->lang->line('ER_SQLTHREAD_WITH_SECURE_SLAVE');
		case "ER_TABLE_HAS_NO_FT" : return $ci->lang->line('ER_TABLE_HAS_NO_FT');
		case "ER_VARIABLE_NOT_SETTABLE_IN_SF_OR_TRIGGER" : return $ci->lang->line('ER_VARIABLE_NOT_SETTABLE_IN_SF_OR_TRIGGER');
		case "ER_VARIABLE_NOT_SETTABLE_IN_TRANSACTION" : return $ci->lang->line('ER_VARIABLE_NOT_SETTABLE_IN_TRANSACTION');
		case "ER_GTID_NEXT_IS_NOT_IN_GTID_NEXT_LIST" : return $ci->lang->line('ER_GTID_NEXT_IS_NOT_IN_GTID_NEXT_LIST');
		case "ER_CANT_CHANGE_GTID_NEXT_IN_TRANSACTION_WHEN_GTID_NEXT_LIST_IS_NULL" : return $ci->lang->line('ER_CANT_CHANGE_GTID_NEXT_IN_TRANSACTION_WHEN_GTID_NEXT_LIST_IS_NULL');
		case "ER_SET_STATEMENT_CANNOT_INVOKE_FUNCTION" : return $ci->lang->line('ER_SET_STATEMENT_CANNOT_INVOKE_FUNCTION');
		case "ER_GTID_NEXT_CANT_BE_AUTOMATIC_IF_GTID_NEXT_LIST_IS_NON_NULL" : return $ci->lang->line('ER_GTID_NEXT_CANT_BE_AUTOMATIC_IF_GTID_NEXT_LIST_IS_NON_NULL');
		case "ER_SKIPPING_LOGGED_TRANSACTION" : return $ci->lang->line('ER_SKIPPING_LOGGED_TRANSACTION');
		case "ER_MALFORMED_GTID_SET_SPECIFICATION" : return $ci->lang->line('ER_MALFORMED_GTID_SET_SPECIFICATION');
		case "ER_MALFORMED_GTID_SET_ENCODING" : return $ci->lang->line('ER_MALFORMED_GTID_SET_ENCODING');
		case "ER_MALFORMED_GTID_SPECIFICATION" : return $ci->lang->line('ER_MALFORMED_GTID_SPECIFICATION');
		case "ER_GNO_EXHAUSTED" : return $ci->lang->line('ER_GNO_EXHAUSTED');
		case "ER_BAD_SLAVE_AUTO_POSITION" : return $ci->lang->line('ER_BAD_SLAVE_AUTO_POSITION');
		case "ER_AUTO_POSITION_REQUIRES_GTID_MODE_ON" : return $ci->lang->line('ER_AUTO_POSITION_REQUIRES_GTID_MODE_ON');
		case "ER_CANT_DO_IMPLICIT_COMMIT_IN_TRX_WHEN_GTID_NEXT_IS_SET" : return $ci->lang->line('ER_CANT_DO_IMPLICIT_COMMIT_IN_TRX_WHEN_GTID_NEXT_IS_SET');
		case "ER_GTID_MODE_2_OR_3_REQUIRES_ENFORCE_GTID_CONSISTENCY_ON" : return $ci->lang->line('ER_GTID_MODE_2_OR_3_REQUIRES_ENFORCE_GTID_CONSISTENCY_ON');
		case "ER_GTID_MODE_REQUIRES_BINLOG" : return $ci->lang->line('ER_GTID_MODE_REQUIRES_BINLOG');
		case "ER_CANT_SET_GTID_NEXT_TO_GTID_WHEN_GTID_MODE_IS_OFF" : return $ci->lang->line('ER_CANT_SET_GTID_NEXT_TO_GTID_WHEN_GTID_MODE_IS_OFF');
		case "ER_CANT_SET_GTID_NEXT_TO_ANONYMOUS_WHEN_GTID_MODE_IS_ON" : return $ci->lang->line('ER_CANT_SET_GTID_NEXT_TO_ANONYMOUS_WHEN_GTID_MODE_IS_ON');
		case "ER_CANT_SET_GTID_NEXT_LIST_TO_NON_NULL_WHEN_GTID_MODE_IS_OFF" : return $ci->lang->line('ER_CANT_SET_GTID_NEXT_LIST_TO_NON_NULL_WHEN_GTID_MODE_IS_OFF');
		case "ER_FOUND_GTID_EVENT_WHEN_GTID_MODE_IS_OFF" : return $ci->lang->line('ER_FOUND_GTID_EVENT_WHEN_GTID_MODE_IS_OFF');
		case "ER_GTID_UNSAFE_NON_TRANSACTIONAL_TABLE" : return $ci->lang->line('ER_GTID_UNSAFE_NON_TRANSACTIONAL_TABLE');
		case "ER_GTID_UNSAFE_CREATE_SELECT" : return $ci->lang->line('ER_GTID_UNSAFE_CREATE_SELECT');
		case "ER_GTID_UNSAFE_CREATE_DROP_TEMPORARY_TABLE_IN_TRANSACTION" : return $ci->lang->line('ER_GTID_UNSAFE_CREATE_DROP_TEMPORARY_TABLE_IN_TRANSACTION');
		case "ER_GTID_MODE_CAN_ONLY_CHANGE_ONE_STEP_AT_A_TIME" : return $ci->lang->line('ER_GTID_MODE_CAN_ONLY_CHANGE_ONE_STEP_AT_A_TIME');
		case "ER_MASTER_HAS_PURGED_REQUIRED_GTIDS" : return $ci->lang->line('ER_MASTER_HAS_PURGED_REQUIRED_GTIDS');
		case "ER_CANT_SET_GTID_NEXT_WHEN_OWNING_GTID" : return $ci->lang->line('ER_CANT_SET_GTID_NEXT_WHEN_OWNING_GTID');
		case "ER_UNKNOWN_EXPLAIN_FORMAT" : return $ci->lang->line('ER_UNKNOWN_EXPLAIN_FORMAT');
		case "ER_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION" : return $ci->lang->line('ER_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION');
		case "ER_TOO_LONG_TABLE_PARTITION_COMMENT" : return $ci->lang->line('ER_TOO_LONG_TABLE_PARTITION_COMMENT');
		case "ER_SLAVE_CONFIGURATION" : return $ci->lang->line('ER_SLAVE_CONFIGURATION');
		case "ER_INNODB_FT_LIMIT" : return $ci->lang->line('ER_INNODB_FT_LIMIT');
		case "ER_INNODB_NO_FT_TEMP_TABLE" : return $ci->lang->line('ER_INNODB_NO_FT_TEMP_TABLE');
		case "ER_INNODB_FT_WRONG_DOCID_COLUMN" : return $ci->lang->line('ER_INNODB_FT_WRONG_DOCID_COLUMN');
		case "ER_INNODB_FT_WRONG_DOCID_INDEX" : return $ci->lang->line('ER_INNODB_FT_WRONG_DOCID_INDEX');
		case "ER_INNODB_ONLINE_LOG_TOO_BIG" : return $ci->lang->line('ER_INNODB_ONLINE_LOG_TOO_BIG');
		case "ER_UNKNOWN_ALTER_ALGORITHM" : return $ci->lang->line('ER_UNKNOWN_ALTER_ALGORITHM');
		case "ER_UNKNOWN_ALTER_LOCK" : return $ci->lang->line('ER_UNKNOWN_ALTER_LOCK');
		case "ER_MTS_CHANGE_MASTER_CANT_RUN_WITH_GAPS" : return $ci->lang->line('ER_MTS_CHANGE_MASTER_CANT_RUN_WITH_GAPS');
		case "ER_MTS_RECOVERY_FAILURE" : return $ci->lang->line('ER_MTS_RECOVERY_FAILURE');
		case "ER_MTS_RESET_WORKERS" : return $ci->lang->line('ER_MTS_RESET_WORKERS');
		case "ER_COL_COUNT_DOESNT_MATCH_CORRUPTED_V2" : return $ci->lang->line('ER_COL_COUNT_DOESNT_MATCH_CORRUPTED_V2');
		case "ER_SLAVE_SILENT_RETRY_TRANSACTION" : return $ci->lang->line('ER_SLAVE_SILENT_RETRY_TRANSACTION');
		case "ER_DISCARD_FK_CHECKS_RUNNING" : return $ci->lang->line('ER_DISCARD_FK_CHECKS_RUNNING');
		case "ER_TABLE_SCHEMA_MISMATCH" : return $ci->lang->line('ER_TABLE_SCHEMA_MISMATCH');
		case "ER_TABLE_IN_SYSTEM_TABLESPACE" : return $ci->lang->line('ER_TABLE_IN_SYSTEM_TABLESPACE');
		case "ER_IO_READ_ERROR" : return $ci->lang->line('ER_IO_READ_ERROR');
		case "ER_IO_WRITE_ERROR" : return $ci->lang->line('ER_IO_WRITE_ERROR');
		case "ER_TABLESPACE_MISSING" : return $ci->lang->line('ER_TABLESPACE_MISSING');
		case "ER_TABLESPACE_EXISTS" : return $ci->lang->line('ER_TABLESPACE_EXISTS');
		case "ER_TABLESPACE_DISCARDED" : return $ci->lang->line('ER_TABLESPACE_DISCARDED');
		case "ER_INTERNAL_ERROR" : return $ci->lang->line('ER_INTERNAL_ERROR');
		case "ER_INNODB_IMPORT_ERROR" : return $ci->lang->line('ER_INNODB_IMPORT_ERROR');
		case "ER_INNODB_INDEX_CORRUPT" : return $ci->lang->line('ER_INNODB_INDEX_CORRUPT');
		case "ER_INVALID_YEAR_COLUMN_LENGTH" : return $ci->lang->line('ER_INVALID_YEAR_COLUMN_LENGTH');
		case "ER_NOT_VALID_PASSWORD" : return $ci->lang->line('ER_NOT_VALID_PASSWORD');
		case "ER_MUST_CHANGE_PASSWORD" : return $ci->lang->line('ER_MUST_CHANGE_PASSWORD');
		case "ER_FK_NO_INDEX_CHILD" : return $ci->lang->line('ER_FK_NO_INDEX_CHILD');
		case "ER_FK_NO_INDEX_PARENT" : return $ci->lang->line('ER_FK_NO_INDEX_PARENT');
		case "ER_FK_FAIL_ADD_SYSTEM" : return $ci->lang->line('ER_FK_FAIL_ADD_SYSTEM');
		case "ER_FK_CANNOT_OPEN_PARENT" : return $ci->lang->line('ER_FK_CANNOT_OPEN_PARENT');
		case "ER_FK_INCORRECT_OPTION" : return $ci->lang->line('ER_FK_INCORRECT_OPTION');
		case "ER_FK_DUP_NAME" : return $ci->lang->line('ER_FK_DUP_NAME');
		case "ER_PASSWORD_FORMAT" : return $ci->lang->line('ER_PASSWORD_FORMAT');
		case "ER_FK_COLUMN_CANNOT_DROP" : return $ci->lang->line('ER_FK_COLUMN_CANNOT_DROP');
		case "ER_FK_COLUMN_CANNOT_DROP_CHILD" : return $ci->lang->line('ER_FK_COLUMN_CANNOT_DROP_CHILD');
		case "ER_FK_COLUMN_NOT_NULL" : return $ci->lang->line('ER_FK_COLUMN_NOT_NULL');
		case "ER_DUP_INDEX" : return $ci->lang->line('ER_DUP_INDEX');
		case "ER_FK_COLUMN_CANNOT_CHANGE" : return $ci->lang->line('ER_FK_COLUMN_CANNOT_CHANGE');
		case "ER_FK_COLUMN_CANNOT_CHANGE_CHILD" : return $ci->lang->line('ER_FK_COLUMN_CANNOT_CHANGE_CHILD');
		case "ER_FK_CANNOT_DELETE_PARENT" : return $ci->lang->line('ER_FK_CANNOT_DELETE_PARENT');
		case "ER_MALFORMED_PACKET" : return $ci->lang->line('ER_MALFORMED_PACKET');
		case "ER_READ_ONLY_MODE" : return $ci->lang->line('ER_READ_ONLY_MODE');
		case "ER_GTID_NEXT_TYPE_UNDEFINED_GROUP" : return $ci->lang->line('ER_GTID_NEXT_TYPE_UNDEFINED_GROUP');
		case "ER_VARIABLE_NOT_SETTABLE_IN_SP" : return $ci->lang->line('ER_VARIABLE_NOT_SETTABLE_IN_SP');
		case "ER_CANT_SET_GTID_PURGED_WHEN_GTID_MODE_IS_OFF" : return $ci->lang->line('ER_CANT_SET_GTID_PURGED_WHEN_GTID_MODE_IS_OFF');
		case "ER_CANT_SET_GTID_PURGED_WHEN_GTID_EXECUTED_IS_NOT_EMPTY" : return $ci->lang->line('ER_CANT_SET_GTID_PURGED_WHEN_GTID_EXECUTED_IS_NOT_EMPTY');
		case "ER_CANT_SET_GTID_PURGED_WHEN_OWNED_GTIDS_IS_NOT_EMPTY" : return $ci->lang->line('ER_CANT_SET_GTID_PURGED_WHEN_OWNED_GTIDS_IS_NOT_EMPTY');
		case "ER_GTID_PURGED_WAS_CHANGED" : return $ci->lang->line('ER_GTID_PURGED_WAS_CHANGED');
		case "ER_GTID_EXECUTED_WAS_CHANGED" : return $ci->lang->line('ER_GTID_EXECUTED_WAS_CHANGED');
		case "ER_BINLOG_STMT_MODE_AND_NO_REPL_TABLES" : return $ci->lang->line('ER_BINLOG_STMT_MODE_AND_NO_REPL_TABLES');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED_REASON" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED_REASON');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_COPY" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_COPY');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_PARTITION" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_PARTITION');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FK_RENAME" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FK_RENAME');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_COLUMN_TYPE" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_COLUMN_TYPE');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FK_CHECK" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FK_CHECK');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_IGNORE" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_IGNORE');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_NOPK" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_NOPK');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_AUTOINC" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_AUTOINC');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_HIDDEN_FTS" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_HIDDEN_FTS');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_CHANGE_FTS" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_CHANGE_FTS');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FTS" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FTS');
		case "ER_SQL_SLAVE_SKIP_COUNTER_NOT_SETTABLE_IN_GTID_MODE" : return $ci->lang->line('ER_SQL_SLAVE_SKIP_COUNTER_NOT_SETTABLE_IN_GTID_MODE');
		case "ER_DUP_UNKNOWN_IN_INDEX" : return $ci->lang->line('ER_DUP_UNKNOWN_IN_INDEX');
		case "ER_IDENT_CAUSES_TOO_LONG_PATH" : return $ci->lang->line('ER_IDENT_CAUSES_TOO_LONG_PATH');
		case "ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_NOT_NULL" : return $ci->lang->line('ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_NOT_NULL');
		case "ER_MUST_CHANGE_PASSWORD_LOGIN" : return $ci->lang->line('ER_MUST_CHANGE_PASSWORD_LOGIN');
		case "ER_ROW_IN_WRONG_PARTITION" : return $ci->lang->line('ER_ROW_IN_WRONG_PARTITION');
		case "ER_MTS_EVENT_BIGGER_PENDING_JOBS_SIZE_MAX" : return $ci->lang->line('ER_MTS_EVENT_BIGGER_PENDING_JOBS_SIZE_MAX');
		case "ER_INNODB_NO_FT_USES_PARSER" : return $ci->lang->line('ER_INNODB_NO_FT_USES_PARSER');
		case "ER_BINLOG_LOGICAL_CORRUPTION" : return $ci->lang->line('ER_BINLOG_LOGICAL_CORRUPTION');
		case "ER_WARN_PURGE_LOG_IN_USE" : return $ci->lang->line('ER_WARN_PURGE_LOG_IN_USE');
		case "ER_WARN_PURGE_LOG_IS_ACTIVE" : return $ci->lang->line('ER_WARN_PURGE_LOG_IS_ACTIVE');
		case "ER_AUTO_INCREMENT_CONFLICT" : return $ci->lang->line('ER_AUTO_INCREMENT_CONFLICT');
		case "WARN_ON_BLOCKHOLE_IN_RBR" : return $ci->lang->line('WARN_ON_BLOCKHOLE_IN_RBR');
		case "ER_SLAVE_MI_INIT_REPOSITORY" : return $ci->lang->line('ER_SLAVE_MI_INIT_REPOSITORY');
		case "ER_SLAVE_RLI_INIT_REPOSITORY" : return $ci->lang->line('ER_SLAVE_RLI_INIT_REPOSITORY');
		case "ER_ACCESS_DENIED_CHANGE_USER_ERROR" : return $ci->lang->line('ER_ACCESS_DENIED_CHANGE_USER_ERROR');
		case "ER_INNODB_READ_ONLY" : return $ci->lang->line('ER_INNODB_READ_ONLY');
		case "ER_STOP_SLAVE_SQL_THREAD_TIMEOUT" : return $ci->lang->line('ER_STOP_SLAVE_SQL_THREAD_TIMEOUT');
		case "ER_STOP_SLAVE_IO_THREAD_TIMEOUT" : return $ci->lang->line('ER_STOP_SLAVE_IO_THREAD_TIMEOUT');
		case "ER_TABLE_CORRUPT" : return $ci->lang->line('ER_TABLE_CORRUPT');
		case "ER_TEMP_FILE_WRITE_FAILURE" : return $ci->lang->line('ER_TEMP_FILE_WRITE_FAILURE');
		case "ER_INNODB_FT_AUX_NOT_HEX_ID" : return $ci->lang->line('ER_INNODB_FT_AUX_NOT_HEX_ID');
		case "ER_OLD_TEMPORALS_UPGRADED" : return $ci->lang->line('ER_OLD_TEMPORALS_UPGRADED');
		case "ER_INNODB_FORCED_RECOVERY" : return $ci->lang->line('ER_INNODB_FORCED_RECOVERY');
		case "ER_AES_INVALID_IV" : return $ci->lang->line('ER_AES_INVALID_IV');
	}
}
?>