<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
date_default_timezone_set('Europe/Paris');

define('TAUX_ANNULATION_VOYAGE', "15.14");
define('NOLIMITE_V2_UPDATE_DATE', strtotime("2019-05-14"));

//////////// PAYLINE CONFIGURATION ////////////////
define('NL_PAYLINE_VERSION', 16);
// TEST VERSION
/*
define('NL_PAYLINE_ID', "79598052756314");
define('NL_PAYLINE_KEY', "89THrYBkYygwP4m9fMKj");
define('NL_PAYLINE_ENV', "HOMO");
define("NL_PAYLINE_USEDBY", "demo");
define("NL_PAYLINE_CONTRACTNUM", "1234567");
define('NL_PAYLINE_TOKEN_VARGET', "token");
*/
define('NL_PAYLINE_ID', "57979866931316");
define('NL_PAYLINE_KEY', "E7ArsqNe5WCHUvrQQ1Yh");
define('NL_PAYLINE_ENV', "PROD");
define("NL_PAYLINE_USEDBY", "OPRA");
define("NL_PAYLINE_CONTRACTNUM", "2869228");
define('NL_PAYLINE_TOKEN_VARGET', "paylinetoken");
///////////////////////////////////////////////////

$ismobile = false; 
$istablet = false;
$detect = new Mobile_Detect;
if($detect->isMobile() || $detect->isTablet()) { $ismobile = true; }
if($detect->isTablet()) { $istablet = true; }
define('NOLIMITE_IS_MOBILE', $ismobile);
define('NOLIMITE_IS_TABLET', $istablet);
$isoldbrowser = false;
$userAgent = new phpUserAgent();
if($userAgent->getBrowserName()==='msie') {
    if(version_compare($userAgent->getBrowserVersion(), '9.0', '<')) {
    	$isoldbrowser = true;
    }
}

// PAIEMENT PARAMS
/*
$PAYBOX_ISTEST = false;
define('PAYBOX_SANDBOX', $PAYBOX_ISTEST);
if($PAYBOX_ISTEST)
{
	define('PAYBOX_SITE', "1999888");
	define('PAYBOX_RANG', "32");
	define('PAYBOX_ID', "107904482");
	define('PAYBOX_KEY', '0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF');
}
else
{
	define('PAYBOX_SITE', "7830005");
	define('PAYBOX_RANG', "01");
	define('PAYBOX_ID', "527861086");
	define('PAYBOX_KEY', 'A976B861FC336D5AD05D719571EF0CA71F67BA8FD62636E225451D48339CB73CEF4AF4702E4F0AB4B33E719D2C5C182480F29C0FC8C8FC6C4B61C79D0CEF4935');
}
*/
//

define('NOLIMITE_IS_OLD_BROWSER', $isoldbrowser);
define('NOLIMITE_USER_AGENT', $userAgent->getBrowserName().' - '.$userAgent->getBrowserVersion().' | '.$_SERVER['HTTP_USER_AGENT']);

$isDebugIp = false;
/*if($_SERVER['REMOTE_ADDR'] == "2.4.17.152")
{
	$isDebugIp = true;
}*/
define('IS_DEBUG_IP', $isDebugIp);

function getNiceColumnName($str){
	return strtr(strtolower($str), array("_"=>" ", "partenaire" => ""));
}

function getPartenaireTypeName($str){
	return strtr($str, array("0" => "Courtiers/Agents assurances", "1" => "Associations/clubs sportifs"));
}

function getFullDomain($str)
{
	return "https://".$str.".no-limite.com";
}

function checkIfSuperAdmin($user){
	$res = false;
	if(isset($user) && isset($user['ROLE_PARTENAIRE']) && is_integer($user['ROLE_PARTENAIRE']) && $user['ROLE_PARTENAIRE'] == 1){
		$res=true;
	}
	return $res;
}

function getPartenaireNumeroContrat($partenaire)
{
	return date("Ymd", strtotime($partenaire->DATE_INSCRIPTION_PARTENAIRE)).str_pad($partenaire->ID_PARTENAIRE, 4, '0', STR_PAD_LEFT);
}

setlocale(LC_ALL, 'fr_FR.UTF8');
function toAscii($str, $replace=array(), $delimiter='-') {
	if( !empty($replace) ) {
		$str = str_replace((array)$replace, ' ', $str);
	}

	$clean = iconv('UTF-8', 'ASCII//TRANSLIT', $str);
	$clean = preg_replace("/[^a-zA-Z0-9\/_|+ -]/", '', $clean);
	$clean = strtolower(trim($clean, '-'));
	$clean = preg_replace("/[\/_|+ -]+/", $delimiter, $clean);

	return $clean;
}

function getMainPartenaireEmail()
{
	return "contact@no-limite.com";
}

function getCurrentPartenaireEmail()
{
	$res = getMainPartenaireEmail();
	if(isset($_SESSION['currentPartenaire'])){
		$res = $_SESSION['currentPartenaire']['EMAIL']; 
	}
	return $res;
}

function getCurrentPartenaireUrl()
{
	$res = base_url();
	if(ENVIRONMENT == "testing"):
		$res = "http://nolimite.webpreview.fr";
	else:
		if(isset($_SESSION['currentPartenaire'])) {
			$res = $_SESSION['currentPartenaire']['URL']; 
		}
	endif;
	return $res;
}

function getCurrentPartenaireLogo()
{
	$res = base_url('assets/themes/default/img/logo-nolimite.png');
	if(isset($_SESSION['currentPartenaire']) && isset($_SESSION['currentPartenaire']['LOGO']) && $_SESSION['currentPartenaire']['LOGO'] != ''){
		$res = $_SESSION['currentPartenaire']['LOGO']; 
	}
	return $res;
}

function checkAndGetLogoPartenaire($file)
{
	$res = "";

	$filefolder = 'uploads/';
	$filepath = FCPATH . $filefolder;

	$checkIfFileExists = file_exists($filepath . $file);
	if($checkIfFileExists) {
		$res = base_url() . $filefolder . $file;
	}

	return $res;
}

function getCertificatDateEffetOneMoreDay($dateeffet)
{
	$res = date('Y-m-d', strtotime($dateeffet . ' +1 day'));

	return $res;
}

function getCertificatDateExp($dateeffet, $periode, $version = null)
{
	$ci=&get_instance();
	
	$date_exp = "";
		$jour = (int)date("d", strtotime($dateeffet));
		$mois = (int)date("m", strtotime($dateeffet));
		$annee = (int)date("Y", strtotime($dateeffet));

	if(is_null($version)):
		switch($periode)
		{
			case $ci->lang->line('form_pricing_list_1'):
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois, $jour + 3, $annee));
			break;

			case $ci->lang->line('form_pricing_list_2'):
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois, $jour + 7, $annee));
			break;

			case $ci->lang->line('form_pricing_list_3'):
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois, $jour + 30, $annee));
			break;

			case $ci->lang->line('form_pricing_list_4'):
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois + 2, $jour, $annee));
			break;

			case $ci->lang->line('form_pricing_list_5'):
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois + 3, $jour, $annee));
			break;

			case $ci->lang->line('form_pricing_list_6'):
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois + 4, $jour, $annee));
			break;

			case $ci->lang->line('form_pricing_list_7'):
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois + 5, $jour, $annee));
			break;

			case $ci->lang->line('form_pricing_list_8'):
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois + 6, $jour, $annee));
			break;

			case $ci->lang->line('form_pricing_list_9'):
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois, $jour, $annee + 1));
			break;
		}
	elseif($version == "v2"):
		switch($periode)
		{
			case 1:
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois, $jour + 3, $annee));
			break;

			case 2:
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois, $jour + 7, $annee));
			break;

			case 3:
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois, $jour + 30, $annee));
			break;

			case 4:
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois + 2, $jour, $annee));
			break;

			case 5:
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois + 3, $jour, $annee));
			break;

			case 6:
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois + 4, $jour, $annee));
			break;

			case 7:
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois + 5, $jour, $annee));
			break;

			case 8:
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois + 6, $jour, $annee));
			break;

			case 9:
				$date_exp = date("d/m/Y", mktime(0, 0, 0, $mois, $jour, $annee + 1));
			break;
		}
	endif;

	return $date_exp;
}

function getCurrentSegment($segment){
	$ci=&get_instance();
	$currentSegment = "";

	if($segment) { 
		$currentSegment = $segment;

		if(stripos($currentSegment, $ci->lang->line('page_slug_contact')) !== false){
			$currentSegment = $ci->lang->line('page_slug_contact');
		}
		else if(stripos($currentSegment, $ci->lang->line('page_slug_become_partner')) !== false){
			$currentSegment = $ci->lang->line('page_slug_become_partner');
		}
	}

	return $currentSegment;
}

function getCurrentPageActive($item, $segment) {
	$res = "";
	
	if($item == $segment) {
		$res = ' active';
	}
	return $res;
}

function getCurrentPageTitle($segment, $meta = null) {
	$ci=&get_instance();

	$res = "";

	$is_meta = false;
	if(!is_null($meta) && ($meta == "title" || $meta == "desc")):
		$is_meta = true;
	endif;

	switch($segment){
		case $ci->lang->line('page_slug_learn_more'):
			if($is_meta):
				if($meta == "title"):
					$res = $ci->lang->line('meta_title_home');
				elseif($meta == "desc"):
					$res = $ci->lang->line('meta_desc_home');
				endif;
			else:
				$res = $ci->lang->line('page_title_learn_more');
			endif;
		break;
		case $ci->lang->line('page_slug_pricing'):
			if($is_meta):
				if($meta == "title"):
					$res = $ci->lang->line('meta_title_pricing');
				elseif($meta == "desc"):
					$res = $ci->lang->line('meta_desc_pricing');
				endif;
			else:
				$res = $ci->lang->line('page_title_pricing');
			endif;
		break;
		case $ci->lang->line('page_slug_directory'):
			if($is_meta):
				if($meta == "title"):
					$res = $ci->lang->line('meta_title_directory');
				elseif($meta == "desc"):
					$res = $ci->lang->line('meta_desc_directory');
				endif;
			else:
				$res = $ci->lang->line('page_title_directory');
			endif;
		break;
		case $ci->lang->line('page_slug_contact'):
			if($is_meta):
				if($meta == "title"):
					$res = $ci->lang->line('meta_title_contact');
				elseif($meta == "desc"):
					$res = $ci->lang->line('meta_desc_contact');
				endif;
			else:
				$res = $ci->lang->line('page_title_contact');
			endif;
		break;
		case $ci->lang->line('page_slug_confidentiality'):
			if($is_meta):
				if($meta == "title"):
					$res = $ci->lang->line('meta_title_home');
				elseif($meta == "desc"):
					$res = $ci->lang->line('meta_desc_home');
				endif;
			else:
				$res = $ci->lang->line('page_title_confidentiality');
			endif;
		break;
		case $ci->lang->line('page_slug_associations'):
			if($is_meta):
				if($meta == "title"):
					$res = $ci->lang->line('meta_title_partnership');
				elseif($meta == "desc"):
					$res = $ci->lang->line('meta_desc_partnership');
				endif;
			else:
				$res = $ci->lang->line('page_title_associations');
			endif;
		break;
		case $ci->lang->line('page_slug_brokers'):
			if($is_meta):
				if($meta == "title"):
					$res = $ci->lang->line('meta_title_partnership');
				elseif($meta == "desc"):
					$res = $ci->lang->line('meta_desc_partnership');
				endif;
			else:
				$res = $ci->lang->line('page_title_brokers');
			endif;
		break;
		case $ci->lang->line('page_slug_insurance_borower'):
			if($is_meta):
				if($meta == "title"):
					$res = $ci->lang->line('meta_title_insurance_borower');
				elseif($meta == "desc"):
					$res = $ci->lang->line('meta_desc_insurance_borower');
				endif;
			else:
				$res = $ci->lang->line('page_title_insurance_borower');
			endif;
		break;
		case $ci->lang->line('page_slug_become_partner'):
			if($is_meta):
				if($meta == "title"):
					$res = $ci->lang->line('meta_title_partnership');
				elseif($meta == "desc"):
					$res = $ci->lang->line('meta_desc_partnership');
				endif;
			else:
				$res = $ci->lang->line('page_title_become_partner');
			endif;
		break;
		case $ci->lang->line('page_slug_assursport'):
			if($is_meta):
				if($meta == "title"):
					$res = $ci->lang->line('meta_title_home');
				elseif($meta == "desc"):
					$res = $ci->lang->line('meta_desc_home');
				endif;
			else:
				$res = $ci->lang->line('page_title_assursport');
			endif;
		break;
		case $ci->lang->line('page_slug_assistance_world'):
			if($is_meta):
				if($meta == "title"):
					$res = $ci->lang->line('meta_title_assistance_world');
				elseif($meta == "desc"):
					$res = $ci->lang->line('meta_desc_assistance_world');
				endif;
			else:
				$res = $ci->lang->line('page_title_assistance_world');
			endif;
		break;
		case $ci->lang->line('page_slug_list_sports'):
			if($is_meta):
				if($meta == "title"):
					$res = $ci->lang->line('meta_title_home');
				elseif($meta == "desc"):
					$res = $ci->lang->line('meta_desc_home');
				endif;
			else:
				$res = $ci->lang->line('page_title_list_sports');
			endif;
		break;
		default:
			if($is_meta):
				if($meta == "title"):
					$res = $ci->lang->line('meta_title_home');
				elseif($meta == "desc"):
					$res = $ci->lang->line('meta_desc_home');
				endif;
			else:
				$res = "";
			endif;
		break;
	}

	if($is_meta && $meta == "title"):
		$res .= " | No-Limite";
	endif;

	return $res;
}

function getPourcentageApporteur($isApporteur, $calcul) {
	$res = "";

	$str = trim(strtolower($calcul));
	$str = preg_replace('/\s+/', '', $str);
	$str = str_replace(' ', '', $str);
	$tbl1 = explode("-", $str);

	if($isApporteur) {
		$search = "partapporteur";
	} else {
		$search = "partpartenaireparent";
	}
	foreach($tbl1 as $line){
		if($line != "" && stripos($line, $search) !== false){
			$correctLine = $line;
			break;
		}
	}
	$percent = strtr($correctLine, array($search => "", "(" => "", ")" => ""));
	$res = substr($percent, 0, stripos($percent, "%"));

	return $res;
}

function getUrlFromSubDomain($subdomain)
{
	$res = "https://".$subdomain.".no-limite.com/";
	if($subdomain == ''):
		$res = "https://no-limite.com/";
	endif;
	return $res;
}

function getContratFile($file)
{
	return FCPATH . "contrats/".$file;
}

function sendNewMail($datas) {
	$status = false;
	$debug = false;

	$ci=&get_instance();

	if(IS_DEBUG_IP)
	{
		$debug = false;
	}
	
	// TODO : remove in prod
	$fakeEmail = false;
	if(ENVIRONMENT == "development" || ENVIRONMENT == "testing")
	{
		$fakeEmail = false;
	}

	if($fakeEmail)
	{
		$status = false;
	}
	else
	{
		if(isset($datas['type']) && $datas['type'] != "" && isset($datas['to']) && $datas['to'] != "")
		{
			$config = Array(
			    'protocol' => 'smtp',
			    'smtp_host' => 'mail.gandi.net',
			    //'smtp_host' => 'ssl://s051.panelboxmanager.com',
			    'smtp_timeout' => 5,
			    //'smtp_port' => 465,
			    'smtp_port' => 587,
			    'smtp_user' => 'contact@no-limite.com',
			    'smtp_pass' => 'CNwbk5TqmhQa',
			    'mailtype'  => 'html', 
			    'charset'   => 'utf-8',
			    'newline'   => '\r\n',
			    'crlf'      => '\r\n',
			    'wordwrap'  => true
			);

			//$config['mailpath'] = '/usr/sbin/sendmail';
				/*$config = array();
					$config['protocol'] = 'sendmail';
					$config['charset'] = 'utf-8';
					$config['wordwrap'] = TRUE;
					$config['mailtype'] = 'html'; 
				    $config['newline'] = '\r\n';
				    $config['crlf'] = '\r\n';*/
			$ci->load->library('email');
			$ci->email->initialize($config);

			$main_email = getMainPartenaireEmail();
			$ci->email->from('noreply@no-limite.com', 'No-Limite');

			if(ENVIRONMENT !== 'production' || $debug)
			{
				$datas['bcc'] = 'k@suss.fr';
			}

			if(ENVIRONMENT == 'preprod')
			{
				$ci->email->from('noreply@v3.no-limite.com', 'No-Limite');
			}

			if(ENVIRONMENT != 'preprod' && ENVIRONMENT != "production")
			{
				/*if($debug)
				{
					var_dump("TESTING MODE");
					var_dump("to :".$datas['to']);
					if(isset($datas['bcc']))
					{
						var_dump("bcc : ".$datas['bcc']);
					}
				}
				// testing : erase real values
				$datas['to'] = "kevin@suss.fr";
				$datas['bcc'] = "k@suss.fr";
				$main_email = "kevin@suss.fr";*/
			}
			
			$ci->email->to($datas['to']);
			$m_bcc = array();
			if(isset($datas['bcc']) && $datas['bcc'] != "")
			{
				$m_bcc[] = $datas['bcc'];
				//$ci->email->bcc($datas['bcc']);
			}
			if((isset($datas['bcc']) && $datas['bcc'] != $main_email) && $datas['to'] != $main_email)
			{
				$m_bcc[] = $main_email;
				//$ci->email->bcc($main_email);
			}
			$ci->email->bcc('a.chauvet@signo.fr');
			$mail_bcc = '';
			foreach($m_bcc as $bcc):
				$mail_bcc .= $bcc.",";
			endforeach;
			$ci->email->bcc($mail_bcc);

			$email_nom = '';
			if(isset($datas['nom']) && $datas['nom'] != "")
			{
				$email_nom = ' '.ucfirst($datas['nom']);
			}

			$email_entete = '<p>'.$ci->lang->line('mail_hello').$email_nom.',</p>';
			$email_signature = '<p>'.$ci->lang->line('mail_thankyou_trust').'.</p>
								<p>'.$ci->lang->line('mail_cordially').',<br />
								'.$ci->lang->line('mail_nl_team').'<br />
								<a href=\'https://no-limite.com\'>www.no-limite.com</a><br />
								'.$ci->lang->line('mail_nl_phone').'</p>';

			$subject = "";
			$message = "";
			switch($datas['type'])
			{
				case "certificat_paied":
					$subject = $ci->lang->line('mail_your_certificate')." !";
					$message = $ci->lang->line('mail_click_to_download').' : '.
								'<a href="'.base_url('certificat/'.$datas['PRIVATE_CODE'].'/'.$datas['LANG_SOUSCRIPTEUR']).'">'.$ci->lang->line('mail_click_here_1').'.</a><br />';

					$message .= '<br />(<em>'.$ci->lang->line('mail_if_not_work_url').' :<br /><u>'.base_url('certificat/'.$datas['PRIVATE_CODE'].'/'.$datas['LANG_SOUSCRIPTEUR']).'</u></em>)';

					$message .= '<br /><br />'.$ci->lang->line('mail_find_attachments').' :<br /><br />';
					$message .= '- '.$ci->lang->line('mail_nl_cgv').'<br />';
					/*if(isset($datas['assistancemonde']) && $datas['assistancemonde'] == 1)
					{
						$message .= '- '.$ci->lang->line('mail_special_conventions').'<br />';
					}*/

				break;

				case "contact_new_message_client":
					$subject = $ci->lang->line('mail_contactform_subject');
					$message = $ci->lang->line('mail_contactform_body');
				break;

				case "contact_new_message":
					$subject = "Prise de contact";
					$message = 'Nouveau message depuis le formulaire de contact.<br /><br />';
						$message .= 'De : '.$datas['contact-nom'].'<br />';
						$message .= 'Email : '.$datas['contact-email'].'<br />';
						$message .= 'Tél : '.$datas['contact-tel'].'<br />';
						$message .= 'Sujet : '.$datas['contact-sujet'].'<br />';
						$message .= 'Message : '.$datas['contact-message'].'<br />';
						$message .= 'Langue : '.$ci->session->userdata('site_lang').'<br />';
				break;

				case "new_partner_client":
					$subject = $ci->lang->line('mail_partnership_subject');
					$message = $ci->lang->line('mail_partnership_text_1').', '.$datas['partenaire-nom'].', '.$ci->lang->line('mail_partnership_text_2').'.<br /><br />'.$ci->lang->line('mail_partnership_text_3').'.';

				break;

				case "new_partner_created":
					$subject = $ci->lang->line('mail_partnership_account_subject');
					$message = $ci->lang->line('mail_partnership_account_text_1').', '.$datas['partenaire-nom'].', '.$ci->lang->line('mail_partnership_account_text_2').'.';
				break;

				case "new_partner_validated":
					$subject = $ci->lang->line('mail_partnership_ok_subject');
					$message = $ci->lang->line('mail_partnership_ok_text_1').', '.$datas['partenaire-nom'].', '.$ci->lang->line('mail_partnership_ok_text_2').'.';
				break;

				case "new_devis":
					$subject = $ci->lang->line('mail_quotation_subject');
					$message .= $ci->lang->line('mail_quotation_text_1');
					$message .= '<br /><br />'.$ci->lang->line('mail_quotation_text_2').' <a href="'.base_url($ci->lang->line('page_slug_download_quotation').'/'.$datas['DEVIS_PRIVATE_CODE']).'/">'.$ci->lang->line('mail_click_here_2').'.</a>';

					$message .= '<br />(<em>'.$ci->lang->line('mail_if_not_work_url').' :<br /><u>'.base_url($ci->lang->line('page_slug_download_quotation').'/'.$datas['DEVIS_PRIVATE_CODE']).'</u></em>)';

					$message .= '<br /><br />'.$ci->lang->line('mail_find_attachments').' :<br /><br />';
					$message .= '- '.$ci->lang->line('mail_nl_cgv').'<br />';

					$message .= '<br />'.$ci->lang->line('mail_quotation_continue').' <a href="'.base_url($ci->lang->line('page_slug_offer_continue').'/'.$datas['DEVIS_PRIVATE_CODE']).'/">'.$ci->lang->line('mail_click_here_2').'.</a><br />(<em>'.$ci->lang->line('mail_if_not_work_url_short').' :<br /><u>'.base_url($ci->lang->line('page_slug_offer_continue').'/'.$datas['DEVIS_PRIVATE_CODE']).'</u>)</em>';
				break;
			}

			if($subject != "" && $message != "")
			{
				$message = $email_entete . '<p>'.$message.'</p>' . $email_signature;

				$ci->email->subject($subject);
				$ci->email->message($message);

				if($datas['type'] == "new_devis" || $datas['type'] == "certificat_paied")
				{
					$ci->email->attach(FCPATH . 'conditions_generales_'.getCurrentLang().'.pdf');

					/*if(isset($datas['assistancemonde']) && $datas['assistancemonde'] == 1)
					{
						$ci->email->attach(FCPATH . 'conventions_speciales_nolimite_assistance.pdf');
					}*/
				}

				if(isset($datas['file']) && $datas['file'])
				{
					$ci->email->attach($datas['file']);
					if($debug)
					{
						var_dump("FILE ATTACHED : ", $datas['file']);
					}
				}

				if($debug)
				{
					var_dump("to : ".$datas['to']);
					var_dump("bcc : ".$mail_bcc);
					var_dump("message : ".$message);
				}

				try
				{
					$sendEmail = $ci->email->send();
					$ci->email->clear(true);
				}
				catch(Exception $e)
				{
					$status = false;
					if($debug){
						var_dump("email error :", $e);
					}
				}

				if($sendEmail)
				{
					if($debug){
						var_dump("EMAIL SENT to ".$datas['to']);
					}
					$status = true;
				}
				else
				{
					if($debug){
						var_dump("echec envoi mail", $sendEmail);
						print_r($ci->email->print_debugger(), true);
					}
				}

				if($debug)
				{
					exit();
				}
			}
		}
	}
	return $status;
}

function getCountryList()
{
	$ci=&get_instance();
	//"Andorre",
	//"Monaco",
	//"Suisse", 

	$res = array(
					$ci->lang->line('country_allemagne'),
					$ci->lang->line('country_autriche'),
					$ci->lang->line('country_belgique'),
					$ci->lang->line('country_bulgarie'),
					$ci->lang->line('country_chypre'),
					$ci->lang->line('country_croatie'),
					$ci->lang->line('country_danemark'),
					$ci->lang->line('country_espagne'),
					$ci->lang->line('country_estonie'),
					$ci->lang->line('country_finlande'),
					$ci->lang->line('country_francemetropolitaine'),
					//$ci->lang->line('country_guadeloupe'),
					//$ci->lang->line('country_guyane'),
					$ci->lang->line('country_grece'),
					$ci->lang->line('country_hongrie'),
					//$ci->lang->line('country_irlande'),
					$ci->lang->line('country_islande'),
					$ci->lang->line('country_italie'),
					//$ci->lang->line('country_lareunion'),
					$ci->lang->line('country_lettonie'),
					//$ci->lang->line('country_liechtenstein'),
					$ci->lang->line('country_lituanie'),
					$ci->lang->line('country_luxembourg'),
					$ci->lang->line('country_malte'),
					//$ci->lang->line('country_martinique'),
					//$ci->lang->line('country_mayotte'),
					//$ci->lang->line('country_norvege'),
					$ci->lang->line('country_paysbas'),
					$ci->lang->line('country_pologne'),
					//$ci->lang->line('country_polynesiefrançaise'),
					$ci->lang->line('country_portugal'),
					$ci->lang->line('country_pandorre'),
					$ci->lang->line('country_pmonaco'),
					$ci->lang->line('country_republiquetcheque'),
					$ci->lang->line('country_roumanie'),
					$ci->lang->line('country_royaumeuni'),
					//$ci->lang->line('country_saintbarthelemy'),
					//$ci->lang->line('country_saintmarin'),
					//$ci->lang->line('country_saintmartin'),
					//$ci->lang->line('country_saintpierreetmiquelon'),
					$ci->lang->line('country_slovaquie'),
					$ci->lang->line('country_slovenie'),
					$ci->lang->line('country_suede')
					//$ci->lang->line('country_vatican'),
					//$ci->lang->line('country_wallisetfutuna')
				);

	return $res;
}

function getCountryFlag($country){
	$ci=&get_instance();
	//"Andorre" => "an",
	//"Monaco" => "mo",
	//"Suisse" => "ch", 

	$arr = array(
				$ci->lang->line('country_allemagne') => "de",
				$ci->lang->line('country_autriche') => "au",
				$ci->lang->line('country_belgique') => "be",
				$ci->lang->line('country_danemark') => "dn",
				$ci->lang->line('country_espagne') => "es",
				$ci->lang->line('country_estonie') => "et",
				$ci->lang->line('country_finlande') => "fi",
				$ci->lang->line('country_francemetropolitaine') => "fr",
				$ci->lang->line('country_guadeloupe') => "fr",
				$ci->lang->line('country_guyane') => "fr",
				$ci->lang->line('country_grece') => "gr",
				$ci->lang->line('country_hongrie') => "ho",
				$ci->lang->line('country_irlande') => "ir",
				$ci->lang->line('country_islande') => "is",
				$ci->lang->line('country_italie') => "it",
				$ci->lang->line('country_lareunion') => "fr",
				$ci->lang->line('country_lettonie') => "le",
				$ci->lang->line('country_liechtenstein') => "lc",
				$ci->lang->line('country_lituanie') => "li",
				$ci->lang->line('country_luxembourg') => "lu",
				$ci->lang->line('country_malte') => "ma",
				$ci->lang->line('country_martinique') => "fr",
				$ci->lang->line('country_mayotte') => "fr",
				$ci->lang->line('country_norvege') => "no",
				$ci->lang->line('country_paysbas') => "nl",
				$ci->lang->line('country_pologne') => "po",
				$ci->lang->line('country_polynesiefrançaise') => "fr",
				$ci->lang->line('country_portugal') => "pr",
				$ci->lang->line('country_royaumeuni') => "uk",
				$ci->lang->line('country_saintbarthelemy') => "sb",
				$ci->lang->line('country_saintmarin') => "sm",
				$ci->lang->line('country_saintmartin') => "fr",
				$ci->lang->line('country_saintpierreetmiquelon') => "pm",
				$ci->lang->line('country_slovenie') => "sl",
				$ci->lang->line('country_slovaquie') => "sv",
				$ci->lang->line('country_suede') => "su",
				$ci->lang->line('country_republiquetcheque') => "rt",
				$ci->lang->line('country_vatican') => "va",
				$ci->lang->line('country_wallisetfutuna') => "wf",
				$ci->lang->line('country_bulgarie') => "bg",
				$ci->lang->line('country_chypre') => "cy",
				$ci->lang->line('country_croatie') => "cr",
				$ci->lang->line('country_pandorre') => "an",
				$ci->lang->line('country_pmonaco') => "mo",
				$ci->lang->line('country_roumanie') => "ro"
			);

	return '<img alt="" src="'.base_url().'assets/themes/default/img/flags/'.strtr($country, $arr).'.png">';
}

function getIndicatorsArray()
{
	$ci=&get_instance();

	//"Andorre" => "376",
	//"Monaco" => "377",
	//"Suisse" => "41", 

	return array(
				$ci->lang->line('country_allemagne') => "49",
				$ci->lang->line('country_autriche') => "43", 
				$ci->lang->line('country_belgique') => "32", 
				$ci->lang->line('country_danemark') => "45", 
				$ci->lang->line('country_espagne') => "34", 
				$ci->lang->line('country_estonie') => "372",
				$ci->lang->line('country_finlande') => "358",
				$ci->lang->line('country_francemetropolitaine') => "33",
				$ci->lang->line('country_guadeloupe') => "590",
				$ci->lang->line('country_guyane') => "594",
				$ci->lang->line('country_grece') => "30", 
				$ci->lang->line('country_hongrie') => "36",
				$ci->lang->line('country_irlande') => "353",
				$ci->lang->line('country_islande') => "354",
				$ci->lang->line('country_italie') => "39", 
				$ci->lang->line('country_lareunion') => "262",
				$ci->lang->line('country_lettonie') => "371",
				$ci->lang->line('country_liechtenstein') => "423",
				$ci->lang->line('country_lituanie') => "370",
				$ci->lang->line('country_luxembourg') => "352",
				$ci->lang->line('country_malte') => "356",
				$ci->lang->line('country_martinique') => "596",
				$ci->lang->line('country_mayotte') => "262",
				$ci->lang->line('country_norvege') => "47", 
				$ci->lang->line('country_paysbas') => "31",
				$ci->lang->line('country_pologne') => "48", 
				$ci->lang->line('country_polynesiefrançaise') => "689",
				$ci->lang->line('country_portugal') => "351",
				$ci->lang->line('country_royaumeuni') => "44",
				$ci->lang->line('country_saintbarthelemy') => "590",
				$ci->lang->line('country_saintmarin') => "378",
				$ci->lang->line('country_saintmartin') => "590",
				$ci->lang->line('country_saintpierreetmiquelon') => "508",
				$ci->lang->line('country_slovenie') => "386",
				$ci->lang->line('country_slovaquie') => "421",
				$ci->lang->line('country_suede') => "46", 
				$ci->lang->line('country_republiquetcheque') => "420",
				$ci->lang->line('country_vatican') => "379",
				$ci->lang->line('country_wallisetfutuna') => "681",
				$ci->lang->line('country_bulgarie') => "359",
				$ci->lang->line('country_chypre') => "357",
				$ci->lang->line('country_croatie') => "385",
				$ci->lang->line('country_pandorre') => "376",
				$ci->lang->line('country_pmonaco') => "377",
				$ci->lang->line('country_roumanie') => "40"
			);
}

function getCountryPhoneIndicator($country){
	$arr = getIndicatorsArray();

	return "+".strtr($country, $arr);
}

function getMainSiteUrl()
{
	$res = '';

	if(ENVIRONMENT == 'development')
	{
		$res = 'http://localhost/nolimite/';
	}
	else if(ENVIRONMENT == 'testing')
	{
		$res = 'http://nolimite.suss.fr/';
	}
	else if(ENVIRONMENT == 'preprod')
	{
		$res = 'http://v2.no-limite.com/';
	}
	else if(ENVIRONMENT == 'production')
	{
		$res = 'https://no-limite.com/';
	}

	return $res;
}

function formatPhoneNumber($str)
{
	$res = '';
	$res = substr($str, 0, 3).' '.getPhoneFormatSpaces(substr($str, 3));
	return $res;
}

function getPartenaireSubDomain() {
	$res = "";
	$serverName = strtr($_SERVER['SERVER_NAME'], array("http://" => "", "https://" => "", "www." => "", ".com" => "", ".fr" => ""));
	$tblCheckDomain = explode(".", $serverName);
	$excludeValues = array("no-limite", "nolimite", "v2", "suss", "www", "http://", "https://", "[::1]", "localhost");
	if(isset($tblCheckDomain[0]) && !in_array($tblCheckDomain[0], $excludeValues)):
		// check if subdomain exists
		$res = trim($tblCheckDomain[0]);
	endif;
	return $res;
}

function getPartenaireUrl($format = 0, $domain){
	if($domain == "") {
		$res = base_url();
	} else {
		$res = "http://".$domain.".".strtr(base_url(), array("http://" => "", "www" => "", "https://" => ""));
	}
	$res = strtr($res, array(".." => "."));
	if($format == 1) { $res = strtr($res, array("http://" => "")); }
	return $res;
}

setlocale(LC_TIME, "fr_FR");

function getDateText($date)
{
	$res = date("d", strtotime($date)).' '.getMonthLabel(date("m", strtotime($date))).' '.date("Y", strtotime($date));

	return $res;
}

function getDateFormat($date)
{
	// XX/XX/XXXX to XXXX-XX-XX
	$test = stripos($date, "-");
	if($test !== false && $test !== -1 && $test == 4)
	{
		// already the good format (on mobile with input date)
		return $date;
	}
	else
	{
		return substr($date,-4)."-".substr($date,3,2)."-".substr($date,0,2);
	}
}

function getDateFormatReverse($date)
{
	// XXXX-XX-XX to XX/XX/XXXX
	$test = stripos($date, "-");
	if($test !== false && $test !== -1 && $test == 4)
	{
		return substr($date,-2)."/".substr($date,5,2)."/".substr($date,0,4);
	}
	else
	{
		// No "-" found, assume good format with "/"
		return $date;
	}
}

function getMonthLabel($month){
	$ci=&get_instance();

	return strtr($month, array(
									"01" => $ci->lang->line('form_calendar_month_1'),
									"02" => $ci->lang->line('form_calendar_month_2'),
									"03" => $ci->lang->line('form_calendar_month_3'),
									"04" => $ci->lang->line('form_calendar_month_4'),
									"05" => $ci->lang->line('form_calendar_month_5'),
									"06" => $ci->lang->line('form_calendar_month_6'),
									"07" => $ci->lang->line('form_calendar_month_7'),
									"08" => $ci->lang->line('form_calendar_month_8'),
									"09" => $ci->lang->line('form_calendar_month_9'),
									"10" => $ci->lang->line('form_calendar_month_10'),
									"11" => $ci->lang->line('form_calendar_month_11'),
									"12" => $ci->lang->line('form_calendar_month_12'),
								));
}

function getDateOfDay(){
	$ci=&get_instance();

	$res = strtr(strtolower(date("D")), array(
												"mon" => $ci->lang->line('form_calendar_mon'),
												"tue" => $ci->lang->line('form_calendar_tue'),
												"wed" => $ci->lang->line('form_calendar_wed'),
												"thu" => $ci->lang->line('form_calendar_thu'),
												"fri" => $ci->lang->line('form_calendar_fri'),
												"sat" => $ci->lang->line('form_calendar_sat'),
												"sun" => $ci->lang->line('form_calendar_sun')
											));
	$res .= ' '.date("j");
	$res .= ' '.getMonthLabel(date("m"));
	$res .= ' '.date("Y");

	return $res;
}

function getPhoneFormat($str){
	return strtr($str, array(" " => "", "." => "", "+33" => "0"));
}

function getFederationTypeName($type)
{
	$ci=&get_instance();

	return strtr($type, array(
							"1" => $ci->lang->line('directory_federations_type_1'),
							"2" => $ci->lang->line('directory_federations_type_2'),
							"3" => $ci->lang->line('directory_federations_type_3'),
							"4" => $ci->lang->line('directory_federations_type_4'),
							"5" => $ci->lang->line('directory_federations_type_5')
						));
}

function getTarifEtapeName($i, $typeTarif, $state) {
	$ci=&get_instance();

	$res = "";
	if($i==0){
		$res = $ci->lang->line('form_price_type');
	} else {			
		$res = $ci->lang->line('form_step').' '.$i;
		if($state == "active"){
			switch($i){
				case "1":
					$legend = $ci->lang->line('form_capital_category');
					if($typeTarif == "1")
					{
						$legend .= ', '.$ci->lang->line('form_assistance');
					}
				break;
				case "2":
					$legend = $ci->lang->line('form_duration_premium');
					if($typeTarif != "1")
					{
						$legend .= ', '.$ci->lang->line('form_assistance');
					}
				break;
				case "3":
					$legend = $ci->lang->line('form_contactinfos');
				break;
				case "4":
					$legend = $ci->lang->line('form_recap');
				break;
				case "5":
					$legend = $ci->lang->line('form_paiement');
				break;
				case "6":
					$legend = $ci->lang->line('form_back_paiement');
				break;
			}
			if($legend != '') {
				$res .= '<span class="legend-etape">'.$legend.'</span>';
			}
		}
	}
	return $res;
}

function getCategorieSportText($cat, $format = ''){
	$ci=&get_instance();

	$txt = '';

	if($format == 'short') {
		if($cat == "A") {
			$txt = '- '.$ci->lang->line('pricing_cat_a_listing_1');
			$txt .= '<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- '.$ci->lang->line('pricing_cat_a_listing_2');
			$txt .= '<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- '.$ci->lang->line('pricing_cat_a_listing_3');
			$txt .= '<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- '.$ci->lang->line('pricing_cat_a_listing_4');
		} else if($cat == "B") {
			$txt = $ci->lang->line('pricing_cat_b_listing_1');
		}
	} else if($format == 'pdf') {
		if($cat == "A") {
			$txt = $ci->lang->line('pricing_cat_a_listing_1_pdf');
			$txt .= ', '.$ci->lang->line('pricing_cat_a_listing_2_pdf');
			$txt .= ', '.$ci->lang->line('pricing_cat_a_listing_3_pdf');
			$txt .= ', '.$ci->lang->line('pricing_cat_a_listing_4_pdf');
		} else if($cat == "B") {
			$txt = $ci->lang->line('pricing_cat_b_listing_1_pdf').' :';
			$txt .= ', '.$ci->lang->line('pricing_cat_b_listing_2_pdf');
			$txt .= ', '.$ci->lang->line('pricing_cat_b_listing_3_pdf');
			$txt .= ', '.$ci->lang->line('pricing_cat_b_listing_4_pdf');
			$txt .= ', '.$ci->lang->line('pricing_cat_b_listing_5_pdf');
		}
	} else {
		if($cat == "A") {
			$txt = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- '.$ci->lang->line('pricing_cat_a_listing_1_full');
			$txt .= '<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- '.$ci->lang->line('pricing_cat_a_listing_2_full');
			$txt .= '<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- '.$ci->lang->line('pricing_cat_a_listing_3_full');
			$txt .= '<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- '.$ci->lang->line('pricing_cat_a_listing_4_full');
		} else if($cat == "B") {
			$txt = $ci->lang->line('pricing_cat_b_listing_1_full').' :';
			$txt .= '<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- '.$ci->lang->line('pricing_cat_b_listing_2_full');
			$txt .= '<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- '.$ci->lang->line('pricing_cat_b_listing_3_full');
			$txt .= '<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- '.$ci->lang->line('pricing_cat_b_listing_4_full');
			$txt .= '<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- '.$ci->lang->line('pricing_cat_b_listing_5_full');
		}
	}

	return $txt;
}

function getAssureInfos($data, $p, $format = '', $tarif_data = array()) {
	$ci=&get_instance();
	?>
	<?php if($format == "collectif") { ?>
		<strong class="ttu"><?php echo $data['assure_nom_'.$p]; ?> <?php echo $data['assure_prenom_'.$p]; ?></strong><br />
		<br />
	<?php } else { ?>
		<strong><?= $ci->lang->line('form_lastname') ?> : </strong><?php echo $data['assure_nom_'.$p]; ?><br />
		<strong><?= $ci->lang->line('form_firstname') ?> : </strong><?php echo $data['assure_prenom_'.$p]; ?><br />
	<?php } ?>
	<strong><?= $ci->lang->line('form_birthdate') ?> : </strong><?php echo getDateFormatReverse($data['assure_naissance_'.$p]); ?><br />
	<strong><?= $ci->lang->line('form_address') ?> :<br /></strong>
				<span style="text-transform: uppercase;"><?php
				echo $data['assure_adresse1_'.$p];
				if(isset($data['assure_adresse2_'.$p]) && $data['assure_adresse2_'.$p] != '') {
					echo '<br />'.$data['assure_adresse2_'.$p];
				}
				echo '<br />'.$data['assure_codepostal_'.$p].' '.$data['assure_ville_'.$p].'<br />'.$data['assure_pays_'.$p];
				?></span>
				<br />
	<?php if(isset($data['assure_telephone_'.$p]) && $data['assure_telephone_'.$p] != '') { ?>
		<strong><?= $ci->lang->line('form_phone') ?> : </strong><?php echo $data['assure_telephone_'.$p]; ?><br />
	<?php } ?>
	<strong><?= $ci->lang->line('form_mobile') ?> : 
	<?php if(isset($data['assure_mobile_'.$p]) && $data['assure_mobile_'.$p] != '') { ?>
		</strong><?php echo $data['assure_mobile_'.$p]; ?><br />
	<?php } ?>
	<strong><?= $ci->lang->line('form_mail') ?> : </strong><?php echo $data['assure_email_'.$p]; ?><br />
	<?php if($format == "collectif") { ?>
		<strong><?= $ci->lang->line('form_date_effect') ?> : </strong>
		<?php if($data['assure_typedateeffet_'.$p] == "0") { ?>
			<?= $ci->lang->line('form_immediate_infos') ?>
		<?php } else { ?>
			<?php echo getDateFormatReverse($data['assure_dateeffet_'.$p]).' '.$data['assure_dateeffetheure_'.$p]; ?>
		<?php } ?>
		<br />
	<?php
	}
	?>
	<strong><?= $ci->lang->line('form_beneficiary') ?> : </strong><?php echo $data['assure_beneficiaire_'.$p]; ?>
	<?php if(isset($data['assure_sport_'.$p]) && $data['assure_sport_'.$p] != ""): ?>
		<br /><strong><?= $ci->lang->line('form_sport') ?> : </strong><?php echo $data['assure_sport_'.$p]; ?>
	<?php endif; ?>
	<?php 
	if( ($format == $ci->lang->line('page_slug_pricing_collective') && isset($tarif_data['collectif_personnes_identique']) 
		&& $tarif_data['collectif_personnes_identique'] == "0") || $format == $ci->lang->line('page_slug_pricing_individual') ):
		if(isset($tarif_data['annulation_voyage']) && intval($tarif_data['annulation_voyage']) == 1):
			?>
			<br /><strong><?= $ci->lang->line('form_annulation_field_buy_short') ?> : </strong><?php echo $tarif_data['date_achat_billet_avion']; ?>
			<br /><strong><?= $ci->lang->line('form_annulation_field_departure_short') ?> : </strong><?php echo $tarif_data['date_depart_voyage']; ?>
			<?php
		endif;
	endif;
}

function getAssureEffet($type, $date, $heure) {
	$ci=&get_instance();

	$str = '';

	if($type == "0") {
		$str = $ci->lang->line('form_immediate_infos_2');
	} else if($type == "1") {
		$str = $ci->lang->line('form_date_effect_label')." ".getDateFormatReverse($date).' '.$heure. " ".$ci->lang->line('form_immediate_infos_2b'); // date("d/m/Y", strtotime($date)
	}

	return $str;
}

function getLabelTarifType($str){
	$ci=&get_instance();

	return strtr($str, array("0" => $ci->lang->line('page_slug_pricing_individual'), "1" => $ci->lang->line('page_slug_pricing_collective')));
}

function getTarifType($index, $cat) {
	$type = null;
	$i = $index - 1;
	if($cat == "A") 
	{
		if($i == 0)
		{
			$type = 1;
		}
		else
		{
			$type = 1 + ($i*2); 
		}
	} 
	else if($cat == "B") 
	{
		if($i == 0)
		{
			$type = 2;
		}
		else
		{
			$type = 2 + ($i*2); 
		}
	}
	
	return $type;
}

// FONCTIONS RECUPEREES

	/* **************** */
	/* VERSION SANS IFX */
	/* **************** */

	function getTaux() {
		/*$t['comm'] = 		1.25;
		$t['taxes'] = 		1.09;
		$t['cp'] = 			1.0;
		$t['honoraire'] = 	1.25;*/
		$t['comm'] = 			1.25;
		$t['taxes'] = 			1.09;
		$t['gestion'] = 		3;
		$t['gestion_taxes'] = 	1.09;
		
		return $t;
	}

	/* **************** */
	/* VERSION SANS IFX */
	/* **************** */

	function getFraisFix($mensualite) {
		$ci=&get_instance();

		switch($mensualite) {
			case 'A':
				return 1.0;
			case 'T':
				return 1.04;
			case 'S':
				return 1.02;
			default:
				die($ci->lang->line('error_month'));
		}
	}

	function evalPrimeV2($capital, $cat, $taux_ttc)
	{
		$res = 0;

		$b7 = $capital;
		$b9 = $taux_ttc;

		$c9 = $b7 * $b9 / 1000; // ttc
		$d9 = $c9 / 1.09; // ht
		$e9 = $d9 * 0.2; // comm
		$f9 = $c9 - $e9; // ttc cie
		$g9 = $c9 - $d9; // taxe cie
		$h9 = $d9 * 0.55; // fdg
		$i9 = $h9 * 0.09; // taxe opra
		$j9 = $c9 + $h9 + $i9; // ttc client

		return $j9;
	}

	function evalPrimeV2_prime($capital, $cat, $ttc)
	{
		$res = 0;

		$b9 = $ttc;

		$c9 = $b9 / 1.09; // ht
		$d9 = $c9 * 0.2; // comm
		$e9 = $b9 - $d9; // ttc cie
		$f9 = $b9 - $c9; // taxe cie
		$g9 = $c9 * 0.55; // fdg
		$h9 = $g9 * 0.09; // taxe opra
		$i9 = $b9 + $g9 + $h9; // ttc client

		return $i9;
	}

	/******************************************************************************/
	/*** evalPrime( $montant, $cat, $duree, $mensualite='A' )                   ***/
	/***                                                                        ***/
	/*** input : $capital : montant du capital                                  ***/
	/***         $cat : categorie de sport (char)                               ***/
	/***         $tauxHt : duree du contrat (int)                                ***/
	/***         $mensualite : nombre de mensualite par defaut 1 an             ***/
	/*** output : char $                                                        ***/
	/*** global : none                                                          ***/
	/***                                                                        ***/
	/*** Fonction qui retourne la prime a payer.                                ***/
	/******************************************************************************/

	//$t['comm'] = 		1.20;
	//$t['taxes'] =     1.09;
	//$t['cp'] =        1.0;
	//$t['honoraire'] = 1.25;

	function evalPrime($capital, $cat, $tauxHt, $tauxHTAss = null, $assMonde = 0, $annVoyage = 0) {

		$taux = getTaux();

		$baseTaux = $tauxHt;
		if(!is_null($assMonde) && $assMonde == 1):
			if(!is_null($annVoyage) && $annVoyage == 1):
				$baseTaux = floatval(TAUX_ANNULATION_VOYAGE);
			else:
				$baseTaux = $tauxHTAss;
			endif;
		endif;
		/*
		//
		$TauxDuDossier_B = ($tauxHt/10000);
		$PrimeHT_C = $capital * $TauxDuDossier_B; // Taux HT Inval/Deces /10 000 € (C,D)
		//
		$Commission_D = $PrimeHT_C * ($taux['comm']-1); // Com 20% (F)
		//
		$Honoraires_E = $PrimeHT_C * ($taux['honoraire']-1);
		//
		$CoutDePolice_G = $taux['cp'];
		//
		$Taxes_H = ($PrimeHT_C+$Commission_D+$CoutDePolice_G)*($taux['taxes']-1);
		$PrimeTTC_I = $PrimeHT_C + $Commission_D + $Honoraires_E + $CoutDePolice_G + $Taxes_H;*/

		$TauxDuDossier_B = ($baseTaux/10000);
		$PrimeHT_C = $capital * $TauxDuDossier_B; // Taux HT Inval/Deces /10 000 € (C,D)
		//$PrimeHT_C = round($PrimeHT_C, 2);

		$Commission_D = $PrimeHT_C * ($taux['comm']-1); // Com 20% (F)
		//$Commission_D = round($Commission_D, 2);

		$PrimeHT_D = $PrimeHT_C + $Commission_D;  // Taux HT Inval/Deces /10 000 € avec Com (E)

		$Commission_G = $PrimeHT_D * ($taux['taxes']-1); // Taxes 9% (G)
		//$Commission_G = round($Commission_G, 2);

		$PrimeTTC = $Commission_G + $PrimeHT_D; // Prime inval/deces TTC (H)
		
		$Commission_I = $Commission_D * $taux['gestion']; // Gestion (I)
		$Commission_I_taxes = $Commission_I * ($taux['gestion_taxes']-1); // Taxes gestion 9% (J)
		//$Commission_I_taxes = round($Commission_I_taxes, 2);

		$Commission_Gestion = $Commission_I + $Commission_I_taxes; // Gestion TTC (K)

		$PrimeTTC_I = $PrimeTTC + $Commission_Gestion;

		//var_dump($PrimeTTC_I);
		$PrimeTTC_I = round($PrimeTTC_I, 2);
		//var_dump($PrimeTTC_I);

		return $PrimeTTC_I;

	};

	function errorHandler($errno, $errstr, $errfile, $errline, $errcontext)
	{
		$tab_num = array(E_ERROR => 'E_ERROR',
						E_WARNING => 'E_WARNING',
						E_PARSE => 'E_PARSE',
						E_NOTICE => 'E_NOTICE');
	
		if ($errno != E_NOTICE && $errno != E_STRICT)
		{
			$num = isset($tab_num[$errno]) ? $tab_num[$errno] : $errno;
			/*mail(
				'v.reuss@signo.fr',
				URL_SITE . ' : ' . $num,
				$errno . ' (' . $errfile . ' line ' . $errline . ') : ' . $errstr . "\n" .
				'Context : ' . print_r ($errcontext, true)
			);*/
			// TODO : uncomment
		}
	
	    /* Ne pas exécuter le gestionnaire interne de PHP */
	    return true;
	}

	function password_generator($size){
	    $pass_g = "";
	    $letter = "0aA1bB2cC3dD4eE5fF6gG7hH8iI9jJ0kK1LL2mM3nN4oo5pP6qQ7rR8sS9tT0uU1vV2wW3xX4yY5zZ6789abcdefghjkmnopqrstuvwxyz1234567890";
	    $sizeof_lchar = strlen($letter);
	    if($sizeof_lchar > 0){
	      srand((double)microtime()*date("YmdGis"));
	      for($cnt = 0; $cnt < $size; $cnt++){
	        $char_select = rand(0, $sizeof_lchar - 1);
	        $pass_g .= $letter[$char_select];
	      };
	    };
	    return $pass_g;
	}

	function getDureeDbTarif($duree)
	{
		$ci=&get_instance();

		$array_duree = array(
				$ci->lang->line('form_pricing_list_1') => "1",
				$ci->lang->line('form_pricing_list_2') => "2",
				$ci->lang->line('form_pricing_list_3') => "3",
				$ci->lang->line('form_pricing_list_4') => "42",
				$ci->lang->line('form_pricing_list_5') => "43",
				$ci->lang->line('form_pricing_list_6') => "44",
				$ci->lang->line('form_pricing_list_7') => "45",
				$ci->lang->line('form_pricing_list_8') => "46",
				$ci->lang->line('form_pricing_list_9') => "5"
				,$ci->lang->line('form_pricing_list_10') => "5"
			);

		return strtr($duree, $array_duree);
	}
	  
//

function getPhoneFormatSpaces($phone)
{
	$str = $phone;
	if(strlen($phone) == 10)
	{
		$str = substr($phone, 0, 2).' '.substr($phone, 2, 2).' '.substr($phone, 4, 2).' '.substr($phone, 6, 2).' '.substr($phone, 8, 2);
	}
	else if(strlen($phone) == 9)
	{
		$str = substr($phone, 0, 1).' '.substr($phone, 1, 2).' '.substr($phone, 3, 2).' '.substr($phone, 5, 2).' '.substr($phone, 7, 2);
	}
	else if(strlen($phone) == 8)
	{
		$str = substr($phone, 0, 2).' '.substr($phone, 2, 2).' '.substr($phone, 4, 2).' '.substr($phone, 6, 2);
	}
	return $str;
}

function getCurrentLang()
{
	$ci=&get_instance();
	$res = "";

	if(is_null($ci->session->userdata('site_lang'))):
		$ci->session->set_userdata("site_lang", "french");
	endif;
	$res = $ci->session->userdata('site_lang');

	return $res;
}

function getLanguageFolder($code = "fr")
{
	$ci=&get_instance();

	$array_languages = array(
							"fr" => "french",
							"en" => "english"
						);

	return $array_languages[$code];
	//$ci->session->set_userdata("site_lang", $array_languages[$code]);
	//$ci->lang->load('information', $ci->session->userdata('site_lang'));
}

function getLanguageCode($language = "french")
{
	$ci=&get_instance();

	$array_languages = array(
							"french" => "fr",
							"english" => "uk"
						);

	return $array_languages[$language];
}

function formDisplayFieldError($field = "", $array = array())
{
	if($field != "" && isset($array[$field]) && $array[$field] != ""):
		?>
		<div class="alert alert-danger danger-sm" role="alert">
		 	<i class="fa fa-exclamation-circle"></i> <?= $array[$field]; ?>
		</div>
		<?php
	endif;
}

function formatPriceDb($nb)
{
	return strtr($nb, array(" " => ""));
}

function getOptionsLabel($type, $tarif_data, $p = null)
{
	$ci=&get_instance();

	$options_label = "";
	$option1_label = ""; $option2_label = "";

	$val_o1 = 0; $val_o1o = 0; $val_o2 = 0;
	if($type == "collectif-b"):
		$val_o1 = intval($tarif_data['assistance_monde_'.$p]);
		$val_o1o = intval($tarif_data['assistance_monde_option_'.$p]);
		$val_o2 = intval($tarif_data['annulation_voyage_'.$p]);
	else:
		$val_o1 = intval($tarif_data['assistance_monde']);
		$val_o1o = intval($tarif_data['assistance_monde_option']);
		$val_o2 = intval($tarif_data['annulation_voyage']);
	endif;

	///

	if($val_o1 == 1):
		if($val_o1o == 0):
			$option1_label = $ci->lang->line('form_option').' 1';
		elseif($val_o1o == 1):
			$option1_label = $ci->lang->line('form_option').' 1b';
		endif;
	endif;

	if($val_o2 == 1):
		$option2_label = $ci->lang->line('form_option').' 2';
	endif;

	if($option1_label != "" && $option2_label != ""):
		$options_label = $option1_label.' & '.$option2_label;
	elseif($option1_label != "" && $option2_label == ""):
		$options_label = $option1_label;
	elseif($option2_label != "" && $option1_label == ""):
		$options_label = $option2_label;
	endif;

	if($options_label != ""):
		$options_label = " (".$options_label.")";
	endif;

	return $options_label;
}

function getOptionsLabelQuotation($currentCertificat)
{
	$ci=&get_instance();

	$res = "";

	$val_o1 = intval($currentCertificat->ASSISTANCEMONDE_SOUSCRIPTEUR);
	$val_o1o = intval($currentCertificat->ASSISTANCEMONDE_OPTION_SOUSCRIPTEUR);
	$val_o2 = intval($currentCertificat->ANNULATION_VOYAGE_SOUSCRIPTEUR);

	if($val_o1 == 1):
		if($val_o1o == 0):
			$res .= "          ".$ci->lang->line('quotation_option_1')."<br />";
		elseif($val_o1o == 1):
			$res .= "          ".$ci->lang->line('quotation_option_1b')."<br />";
		endif;
	endif;

	if($val_o2 == 1):
		$res .= "          ".$ci->lang->line('quotation_option_2')."<br />";
	endif;

	return $res;
}

function getTypeTarifOriginal($typeTarif)
{
	$ci=&get_instance();

	$typeTarif = strtr($typeTarif, 
			array(
				$ci->lang->line('page_slug_pricing_individual') => "individuel", 
				$ci->lang->line('page_slug_pricing_collective') => "collectif"
			)
		);

	return $typeTarif;
}

function slugify($text)
{
  // replace non letter or digits by -
  $text = preg_replace('~[^\pL\d]+~u', '-', $text);

  // transliterate
  $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

  // remove unwanted characters
  $text = preg_replace('~[^-\w]+~', '', $text);

  // trim
  $text = trim($text, '-');

  // remove duplicate -
  $text = preg_replace('~-+~', '-', $text);

  // lowercase
  $text = strtolower($text);

  if (empty($text)) {
    return 'n-a';
  }

  return $text;
}

function getSportList($i)
{
	$res = null;

	$array_datas = array(
						array("Base jump", "Deltaplane", "Kitesurf", "Parachutisme", "Parapente", "Saut à l’élastique", "ULM"),
						array("Dragster", "F1- F3 - F4 - Formule Renault", "GP2", "Karting", "Rallycross"),
						array("Ski alpin", "Ski hors-pistes"),
						array("Ski extrême", "Ski de vitesse", "Freestyle", "Freeride", "Snowboard", "Snowler coaster", "Ski trikke", "Snowskate", "Airboard", "Big air", "Ski rider", "Speedel snow", "Snowbike", "Snow kite"),
						array("Enduro", "Motocross", "Supermotard", "Speedway", "Stunt", "Trial", "Motoneige"),
						array("Alpinisme", "Escalade"),
						array("Bateaux à propulsion humaine", "Bateaux à voile (sail-powered boat)", "Bateaux à moteur (Motorboat)"),
						array("Apnée", "Plongée en scaphandre autonome"),
						array("Cliff diving (Plongée en falaise)", "Pool diving (Plongée en piscine), Outdoor diving (Plongée en plein air)")
					);
	if(isset($array_datas[$i-1])):
		$res = $array_datas[$i-1];
	endif;

	return $res;
}

function getSportImage($i)
{
	$res = "";

	$array_datas = array(
							"sports-aeriens.jpg",
							"sports-automobiles.jpg",
							"sports-de-glisse.jpg",
							"sports-de-glisse-extreme.jpg",
							"sports-motos.jpg",
							"sports-de-montagnes.jpg",
							"sports-nautiques-de-navigation.jpg",
							"plongee-sous-marine.jpg",
							"plongeons-de-haut-vol.jpg"
						);

	if(isset($array_datas[$i-1])):
		$res = $array_datas[$i-1];
	endif;

	return $res;
}
?>