<!-- Nav tabs -->
<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<a class="nav-link active" data-toggle="tab" href="#dossiers" role="tab">Dossiers</a>
	</li>
	<li class="nav-item">
		<a class="nav-link" data-toggle="tab" href="#commissions" role="tab">Commissions</a>
	</li>
</ul>

<div class="separator"></div>

<div class="row">
	<div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
	  	<div class="form-group">
	  		<div class="input-group">
			  	<div class="input-group-addon">Filter par mois :</div>
			  	<select id="filter-dossiers" class="form-control filter-calendar-table" name="filter-dossiers">
			  		<?php
			  		$year_prev = '';
			  		$m=0;
			  		foreach($months_list as $month) {
			  			$year = substr($month->month,0,4);
			  			if($year != $year_prev) {
			  				if($m>0){
			  					echo '</optgroup>';
			  				}
			  				echo '<optgroup label="'.substr($month->month,0,4).'">';
			  			}
		  				echo '<option value="'.$month->month.'">'.getMonthLabel(substr($month->month,-2)).' ('.$month->nb.')</option>';
			  			$year_prev = $year;
			  		}
			  		if($m>0){
			  			echo '</optgroup>';
			  		}
			  		?>
			  	</select>
			</div>
	  	</div>
	</div>
</div>

<!-- Tab panes -->
<div class="tab-content">
  <div class="tab-pane active" id="dossiers" role="tabpanel">

  	<a href="<?php echo base_url('intranet/export_data/ventes'); ?>" class="btn btn-success pull-xs-right btn-export-xls btn-export-ventes">Exporter&nbsp;&nbsp;<i class="fa fa-file-excel-o" aria-hidden="true"></i></a>

  	<div class="container-table-content" style="display: none;">
		<table id="table-content" class="table-datatable" data-view="<?php if($isSuperAdmin) { echo "1"; } else { echo "2"; } ?>">
			<thead>
				<th>Date</th>
				<th>Cabinet apporteur</th>
				<?php if($isSuperAdmin) { ?>
					<th>Affilié à</th>
				<?php } ?>
				<th>Souscripteur</th>
				<th>Ville</th>
				<th>Téléphone</th>
				<th>Certificat</th>
				<th>Date d'effet</th>
				<?php if($isSuperAdmin) { ?>
					<th>Prime payée</th>
					<th class="nofilter">&nbsp;</th>
				<?php } else { ?>
					<th>Montant prime</th>
				<?php } ?>
			</thead>
			<tbody>
				<?php
				$datev2_time = NOLIMITE_V2_UPDATE_DATE;
				foreach($current_list as $row)
				{
					$current_time = strtotime($row->DATE_SOUSCRIPTION);
					if($current_time >= $datev2_time):
						$current_periode = $this->lang->line('form_pricing_list_'.$row->PERIODE_SOUSCRIPTEUR.'');
					else:
						$current_periode = $row->PERIODE_SOUSCRIPTEUR;
					endif;

					$class='';
					if($row->ANNULATION_SOUSCRIPTEUR==1):
						$class = 'tr_canceled';
					endif;

					$var_sort = date("Y-m-d", strtotime($row->DATE_SOUSCRIPTION)).' 000000';
					if($row->DATEHEURE_SOUSCRIPTION != ""):
						$var_sort = date("Y-m-d His", strtotime($row->DATEHEURE_SOUSCRIPTION));
					endif;
					?>
					<tr data-certificat="<?= $row->CERTIFICAT_SOUSCRIPTEUR ?>" class="<?php echo $class; ?>" id="tr_<?php echo $row->ID_SOUSCRIPTEUR; ?>">
						<td>
							<span style="display: none;"><?= $var_sort ?></span>
							<?php echo date("d/m/y", strtotime($row->DATE_SOUSCRIPTION)); ?>
						</td>
						<td><?php echo $row->NOM_PARTENAIRE; ?></td>
						<?php if($isSuperAdmin) { ?>
							<td><?php echo $row->NOM_PARENT_PARTENAIRE; ?></td>
						<?php } ?>
						<td>
							<?php
							$dataContent = '';
							if($row->ADRESSE1_SOUSCRIPTEUR != '') {
								$dataContent .= $row->ADRESSE1_SOUSCRIPTEUR;
							}
							if($row->ADRESSE2_SOUSCRIPTEUR != '') {
								$dataContent .= '<br />'.$row->ADRESSE2_SOUSCRIPTEUR;
							}
							if($row->CP_SOUSCRIPTEUR != '') {
								$dataContent .= '<br />'.$row->CP_SOUSCRIPTEUR;
							}
							if($row->VILLE_SOUSCRIPTEUR != '') {
								$dataContent .= ' '.$row->VILLE_SOUSCRIPTEUR;
							}
							if($row->PAYS_SOUSCRIPTEUR != '') {
								$dataContent .= '<br />'.$row->PAYS_SOUSCRIPTEUR;
							}
							if($row->COURRIEL_SOUSCRIPTEUR != '') {
								$dataContent .= '<br />Mail : <a href=\'mailto:'.$row->COURRIEL_SOUSCRIPTEUR.'\'>'.$row->COURRIEL_SOUSCRIPTEUR.'</a>';
							}
							if($row->TEL_SOUSCRIPTEUR != '') {
								$dataContent .= '<br />Tél. : '.$row->TEL_SOUSCRIPTEUR;
							}
							if($row->GSM_SOUSCRIPTEUR != '') {
								$dataContent .= '<br />Mobile : '.$row->GSM_SOUSCRIPTEUR;
							}
							if($row->LANG_SOUSCRIPTEUR != '') {
								$dataContent .= '<br />Langue souscription : '.mb_strtoupper($row->LANG_SOUSCRIPTEUR);
							}
							?>
							<a style="position: relative;" id="link-popover-<?php echo $row->ID_SOUSCRIPTEUR; ?>" tabindex="0" class="link-popover" role="popover" data-toggle="popover" data-placement="right" title="Coordonnées" data-content="<?php echo $dataContent; ?>">
								<?php 
								if($row->NOM_SOUSCRIPTEUR != '') {
									echo $row->NOM_SOUSCRIPTEUR.' '; 
								}
								if($row->PRENOM_SOUSCRIPTEUR != '') {
									echo $row->PRENOM_SOUSCRIPTEUR; 
								}
								?>
							</a>
						</td>
						<td>
							<?php echo $row->VILLE_SOUSCRIPTEUR; ?>
							<?php if($row->CP_SOUSCRIPTEUR!='') { ?>
								<?php echo '('.$row->CP_SOUSCRIPTEUR.')'; ?>
							<?php } ?>
						</td>
						<td><?php echo getPhoneFormat($row->TEL_SOUSCRIPTEUR); ?></td>
						<td class="td_certificat">
							<?php if($row->CERTIFICAT_SOUSCRIPTEUR!='') {

								if($row->ANNULATION_SOUSCRIPTEUR==0):
									$dataContent = '';
									if($row->CAPITAL_SOUSCRIPTEUR != '') {
										$dataContent .= 'Capital : '.$row->CAPITAL_SOUSCRIPTEUR;
									}
									if($row->CATEGORIE_SOUSCRIPTEUR != '') {
										$dataContent .= '<br />Catégorie : '.$row->CATEGORIE_SOUSCRIPTEUR;
									}
									if($row->PERIODE_SOUSCRIPTEUR != '') {
										$dataContent .= '<br />Période : '.$current_periode;
									}
									if($row->BENEFICIAIRE_SOUSCRIPTEUR != '') {
										$dataContent .= '<br />Bénéficiaire : '.$row->BENEFICIAIRE_SOUSCRIPTEUR;
									}
									if($row->ASSISTANCEMONDE_SOUSCRIPTEUR != '') {
										$dataContent .= '<br />Assistance : '.strtr($row->ASSISTANCEMONDE_SOUSCRIPTEUR, array(1 => 'Oui', 0 => 'Non')).'';
										if($row->ASSISTANCEMONDE_SOUSCRIPTEUR == 1):
											$dataContent .= ' (option '.strtr($row->ASSISTANCEMONDE_OPTION_SOUSCRIPTEUR, array(1 => '1B', 0 => '1')).')';
										endif;
									}
									if($row->ANNULATION_VOYAGE_SOUSCRIPTEUR != '') {
										$dataContent .= '<br />Ann. voyage : '.strtr($row->ANNULATION_VOYAGE_SOUSCRIPTEUR, array(1 => 'Oui', 0 => 'Non')).' (option 2)';
										if($row->ANNULATION_VOYAGE_SOUSCRIPTEUR == 1):
											if($row->ANNULATION_VOYAGE_DATE_ACHAT_SOUSCRIPTEUR != "0000-00-00"):
												$dataContent .= '<br />Date achat billet : '.date("d/m/y", strtotime($row->ANNULATION_VOYAGE_DATE_ACHAT_SOUSCRIPTEUR));
											endif;
											if($row->ANNULATION_VOYAGE_DATE_DEPART_SOUSCRIPTEUR != "0000-00-00"):
												$dataContent .= '<br />Date départ : '.date("d/m/y", strtotime($row->ANNULATION_VOYAGE_DATE_DEPART_SOUSCRIPTEUR));
											endif;
										endif;
									}
									if($row->SPORTPRATIQUE_SOUSCRIPTEUR != ""):
										$dataContent .= '<br />Sport pratique : '.$row->SPORTPRATIQUE_SOUSCRIPTEUR;
									endif;
									$dataContent .= '<br /><br /><a title=\'Voir le certificat FR\' target=\'_blank\' href=\''.base_url('certificat/'.$row->PRIVATE_CODE.'/french/').'\' class=\'btn btn-info btn-sm\'><i class=\'fa fa-file-pdf-o\'></i> FR</a><br />';
									$dataContent .= '<br /><a title=\'Voir le certificat EN\' target=\'_blank\' href=\''.base_url('certificat/'.$row->PRIVATE_CODE.'/english/').'\' class=\'btn btn-info btn-sm\'><i class=\'fa fa-file-pdf-o\'></i> EN</a>';
									?>
									<a tabindex="0" class="link-popover" role="button" data-toggle="popover" data-trigger="hover" data-placement="left" title="Certificat" data-content="<?php echo $dataContent; ?>">
										<?php echo $row->CERTIFICAT_SOUSCRIPTEUR; ?>
									</a>
								<?php 
								else:
									echo $row->CERTIFICAT_SOUSCRIPTEUR;
								endif;
							}
							?>
						</td>
						<td>
							<?php if($row->DATE_EFFET_SOUSCRIPTEUR!=''&&$row->DATE_EFFET_SOUSCRIPTEUR!='0000-00-00'){
								echo date("d/m/y", strtotime($row->DATE_EFFET_SOUSCRIPTEUR));
							} 
							?>
						</td>
						<td class="td_prime">
							<?php
							if($row->ANNULATION_SOUSCRIPTEUR==0):
								if($isSuperAdmin) {
									echo number_format($row->PRIME_SOUSCRIPTEUR, 2, '.', ' ');
								} else {
									echo number_format($row->PART_ASSUREUR, 2, '.', ' ');
								}
							else:
								echo 0;
							endif;
							?>
						</td>
						<?php
						$dataContentCancel = "";
						if($isSuperAdmin): ?>
							<td class="td_cancel" data-id="<?= $row->ID_SOUSCRIPTEUR ?>">
								<?php if($row->ANNULATION_SOUSCRIPTEUR==0):
									$dataContentCancel = "<textarea placeholder='Commentaire' class='form-control input-cancel-text' type='text' name='txt_cancel_".$row->ID_SOUSCRIPTEUR."' id='txt_cancel_".$row->ID_SOUSCRIPTEUR."'></textarea>";
									$dataContentCancel .= "<br /><a data-id='".$row->ID_SOUSCRIPTEUR."' title='Confirmer annulation' class='btn btn-danger btn-sm btn-cancel-certificat'>Annuler certificat</a>";
									?>
									<a tabindex="0" class="link-popover btn-cancel-td" role="button" data-toggle="popover" data-trigger="hover" data-placement="left" title="Annuler certificat" data-content="<?php echo $dataContentCancel; ?>">
										<i class="fa fa-times"></i>
									</a>
								<?php else:
									$dataContentCancel = "Date annulation : ".date("d/m/y", strtotime($row->ANNULATION_DATE_SOUSCRIPTEUR))."<br />";
									if($row->ANNULATION_COMMENTAIRE_SOUSCRIPTEUR!=""):
										$dataContentCancel .= "<p class='comment-info-text'>".$row->ANNULATION_COMMENTAIRE_SOUSCRIPTEUR."</p>";
									endif;
									?>
									<a tabindex="0" class="link-popover btn-cancel-info" role="button" data-toggle="popover" data-trigger="hover" data-placement="left" title="Info annulation" data-content="<?php echo $dataContentCancel; ?>">
										<i class="fa fa-info-circle"></i>
									</a>
								<?php endif; ?>
							</td>
						<?php endif; ?>
					</tr>
				<?php
				}
				?>
			</tbody>
		</table>
		<div class="row">
			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
				<div class="pull-xs-right">
					<br /><br />
					<strong>Total : </strong>
					<span id="dossiers_total"></span> €
				</div>
			</div>
		</div>
	</div>

  </div>
  <div class="tab-pane" id="commissions" role="tabpanel">

    <a href="<?php echo base_url('intranet/export_data/commissions'); ?>" class="btn btn-success pull-xs-right btn-export-xls btn-export-ventes">Exporter&nbsp;&nbsp;<i class="fa fa-file-excel-o" aria-hidden="true"></i></a>

  	<div class="container-table-content" style="display: none;">
		<table id="table-content" class="table-datatable">
			<thead>
				<th>Date</th>
				<th>Certificat</th>
				<?php if($isSuperAdmin) { ?>
					<th>Transaction</th>
					<th>Prime payée</th>
					<th>N</th>
					<th>N+1</th>
					<th>N+2</th>
				<?php } else { ?>
					<th>N° contrat</th>
					<th>Montant prime</th>
					<th>%</th>
					<th>Commission</th>
				<?php } ?>
			</thead>
			<tbody>
				<?php
				foreach($current_list as $row)
				{
					$var_sort = date("Y-m-d", strtotime($row->DATE_SOUSCRIPTION)).' 000000';
					if($row->DATEHEURE_SOUSCRIPTION != ""):
						$var_sort = date("Y-m-d His", strtotime($row->DATEHEURE_SOUSCRIPTION));
					endif;

					if($row->ANNULATION_SOUSCRIPTEUR==0):
					?>
						<tr class="tr_comm_<?= $row->ID_SOUSCRIPTEUR ?>">
							<td>
								<span style="display: none;"><?= $var_sort ?></span>
								<?php echo date("d/m/y", strtotime($row->DATE_SOUSCRIPTION)); ?>
							</td>
							<td>
								<?php if($row->CERTIFICAT_SOUSCRIPTEUR!='') {
									$dataContent = '';
									if($row->CAPITAL_SOUSCRIPTEUR != '') {
										$dataContent .= 'Capital : '.$row->CAPITAL_SOUSCRIPTEUR;
									}
									if($row->CATEGORIE_SOUSCRIPTEUR != '') {
										$dataContent .= '<br />Catégorie : '.$row->CATEGORIE_SOUSCRIPTEUR;
									}
									if($row->PERIODE_SOUSCRIPTEUR != '') {
										$dataContent .= '<br />Période : '.$row->PERIODE_SOUSCRIPTEUR;
									}
									if($row->BENEFICIAIRE_SOUSCRIPTEUR != '') {
										$dataContent .= '<br />Bénéficiaire : '.$row->BENEFICIAIRE_SOUSCRIPTEUR;
									}
									if($row->NOM_PARTENAIRE != '') {
										$dataContent .= '<br />Cabinet apporteur : '.$row->NOM_PARTENAIRE;
									}
									$dataContent .= '<br /><a title=\'Voir le certificat\' target=\'_blank\' href=\''.base_url('certificat/'.$row->PRIVATE_CODE.'/').'\' class=\'btn btn-info btn-sm\'><i class=\'fa fa-file-pdf-o\'></i></a>';
									?>
									<a tabindex="0" class="link-popover" role="button" data-toggle="popover" data-trigger="hover" data-placement="right" title="Certificat" data-content="<?php echo $dataContent; ?>">
										<?php echo $row->CERTIFICAT_SOUSCRIPTEUR; ?>
									</a>
								<?php } ?>
							</td>
							<td><?php echo $row->TRANSACTION_ID; ?></td>
							<?php if($isSuperAdmin) { ?>
								<td>
									<?php
									$splitCalcul = explode("-", $row->CALCUL_ENCAISSEMENT);
									$dataContent = '';
									foreach($splitCalcul as $str){
										if($str != "")
										{
											$dataContent .= $str.'<br />';
										}
									}
									?>
									<a tabindex="0" class="link-popover" role="button" data-toggle="popover" data-trigger="hover" data-placement="left" title="" data-content="<?php echo $dataContent; ?>">
										<?php echo number_format($row->PRIME_SOUSCRIPTEUR, 2, '.', ' '); ?>
									</a>
								</td>
								<?php if($row->VERSION_CALCUL == 0) { ?>
									<td class="td_prime"><?php echo number_format($row->PART_ID1, 2, '.', ' '); ?></td>
									<td class="td_prime_n1"><?php echo number_format($row->PART_ORIGINE, 2, '.', ' '); ?></td>
									<td class="td_prime_n2"><?php echo number_format($row->PART_PARTENAIRE, 2, '.', ' '); ?></td>
								<?php } else { ?>
									<td class="td_prime"><?php echo number_format($row->PART_ASSUREUR, 2, '.', ' '); ?></td>
									<td class="td_prime_n1">
										<?php
										echo number_format($row->PART_APPORTEUR, 2, '.', ' ');
										?>
									</td>
									<td class="td_prime_n2"><?php echo number_format($row->PART_PARENT, 2, '.', ' '); ?></td>
								<?php } ?>
							<?php } else { ?>
								<td><?php echo number_format($row->PART_ASSUREUR, 2, '.', ' '); ?></td>
								<td>
									<?php
									$isApporteur = false; 
									if($user['ID_PARTENAIRE'] == $row->ID_PARTENAIRE) {
										$isApporteur = true;
									}
									echo getPourcentageApporteur($isApporteur, $row->CALCUL_ENCAISSEMENT).'%';
									?>
								</td>
								<td class="td_prime">
									<?php
									if($isApporteur) {
										echo number_format($row->PART_APPORTEUR, 2, '.', ' ');
									} else {
										echo number_format($row->PART_PARENT, 2, '.', ' ');
									}
									?>
								</td>
							<?php } ?>
						</tr>
					<?php endif; ?>
				<?php
				}
				?>
			</tbody>
		</table>
		<div class="row">
			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
				<div class="pull-xs-right" style="text-align: right;">
					<br />
					<?php if($isSuperAdmin) { ?>
						<p>
							<strong>Total N : </strong>
							<span id="commissions_total"></span> €
						</p>
						<p>
							<strong>Total N+1 : </strong>
							<span id="commissions_total_n1"></span> €
						</p>
						<p>
							<strong>Total N+2 : </strong>
							<span id="commissions_total_n2"></span> €
						</p>
					<?php } else { ?>
						<p>
							<strong>Total: </strong>
							<span id="commissions_total"></span> €
						</p>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>

  </div>
</div>