<h2><?= $this->lang->line('form_step_3_col_label_1') ?> :</h2>

<p><?= $this->lang->line('form_step_3_col_label_2') ?>.</p>
<p><?= $this->lang->line('form_step_3_col_label_3') ?>.</p>

<?php
if($tarif_data['collectif_personnes_identique'] == "0") {
	// conditions similaires
	$cat = $tarif_data['categorie_sports'];
	$capital = $tarif_data['capital_montant'];
	?>
	<p>
		<strong><?= $this->lang->line('form_category') ?> :</strong> <?php echo $cat; ?><br />
		<strong><?= $this->lang->line('form_capital') ?> :</strong> <?php echo number_format($capital, 2, '.', ' '); ?> €<br />	
		<strong><?= $this->lang->line('form_duration') ?> :</strong> <?php echo $this->lang->line('form_pricing_list_'.$tarif_data['tarif_duree']); ?><br />
		<?php
		// EDIT 2K17 : Assistance Monde + 2K19 ann voyage
		if(intval($tarif_data['assistance_monde']) == 1 || intval($tarif_data['annulation_voyage']) == 1):
		    echo "<p>";
				echo $this->lang->line('form_step_with_option')." : ";
				if(intval($tarif_data['assistance_monde']) == 1):
					if(intval($tarif_data['assistance_monde_option']) == 0):
						echo "<br /><strong>- ".$this->lang->line('form_option')." 1 : ".$this->lang->line('form_step_1_ind_list_1')."</strong>";
					elseif(intval($tarif_data['assistance_monde_option']) == 1):
						echo "<br /><strong>- ".$this->lang->line('form_option')." 1b : ".$this->lang->line('form_step_1_ind_list_2')."</strong>";
						echo "<br /><strong class='option-1b-recap'>".$this->lang->line('option_1bis_text')."</strong>";
					endif;
				endif;
				if(intval($tarif_data['annulation_voyage']) == 1):
					echo "<br /><strong>- ".$this->lang->line('form_option')." 2 : ".$this->lang->line('form_step_3_col_label_4_3')."</strong><br />";
					echo '<em style="font-style: italic;display: block; margin-left: 40px;">';
						echo $this->lang->line('form_annulation_field_buy_short').' : <span style="font-style: normal; text-decoration: underline;">'.$tarif_data['date_achat_billet_avion'].'</span><br />';
						echo $this->lang->line('form_annulation_field_departure_short').' : <span style="font-style: normal; text-decoration: underline;">'.$tarif_data['date_depart_voyage'].'</span><br />';
					echo '</em>';
				endif;
			echo "</p>";
		endif;
		?>
	</p>
	<div class="separator"></div>
	<?php
	$taux_ttc = $tarifsList->taux_ttc;
	$d = $tarif_data['tarif_duree'];

	$prime = evalPrimeV2($capital, $cat, $taux_ttc);
	$primeDisplay = number_format($prime, 2, '.', ' ');

	$primeDisplay_option1 = "-"; $primeDisplay_option1_val = 0;
	$primeDisplay_option1b = "-"; $primeDisplay_option1b_val = 0;
	$primeDisplay_option2 = "-"; $primeDisplay_option2_val = 0;

	if(intval($tarif_data['assistance_monde']) == 1):
		if(intval($tarif_data['assistance_monde_option']) == 0):
			$ttc_option1 = $tarifsList_option1[$d-1]->ttc;
			$prime_option1 = evalPrimeV2_prime($capital, $cat, $ttc_option1);
			$primeDisplay_option1_val = number_format($prime_option1, 2, '.', ' ');
			$primeDisplay_option1 = $primeDisplay_option1_val.'';
		elseif(intval($tarif_data['assistance_monde_option']) == 1):
			$ttc_option1b = $tarifsList_option1b[$d-1]->ttc;
			$prime_option1b = evalPrimeV2_prime($capital, $cat, $ttc_option1b);
			$primeDisplay_option1b_val = number_format($prime_option1b, 2, '.', ' ');
			$primeDisplay_option1b = $primeDisplay_option1b_val.'';
		endif;
	endif;

	if(intval($tarif_data['annulation_voyage']) == 1):
		$ttc_option2 = $tarifsList_option2[$d-1]->ttc;
		$prime_option2 = evalPrimeV2_prime($capital, $cat, $ttc_option2);
		$primeDisplay_option2_val = number_format($prime_option2, 2, '.', ' ');
		$primeDisplay_option2 = $primeDisplay_option2_val.'';
	endif;

	$total_prime = number_format($prime + $primeDisplay_option1_val + $primeDisplay_option1b_val + $primeDisplay_option2_val, 2, '.', ' ');
	?>

	<?php
	$field = 'tarif_prime';
	$fieldValue = $total_prime;
	?>
	<input readonly="readonly" required type="hidden" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo $fieldValue; ?>">

	<?php
	$field = 'tarif_id';
	$fieldValue = $tarifsList->id;
	if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; }
	formDisplayFieldError($field, $form_errors_array);
	?>
	<input readonly="readonly" required type="hidden" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo $fieldValue; ?>">

	<?php
	$field = 'tarif_tauxindacc';
	$fieldValue = formatPriceDb($tarifsList->taux_ttc);
	?>
	<input readonly="readonly" required type="hidden" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo $fieldValue; ?>">

	<?php
	$field = 'tarif_option1';
	$fieldValue = formatPriceDb($primeDisplay_option1_val);
	?>
	<input readonly="readonly" required type="hidden" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo $fieldValue; ?>">

	<?php
	$field = 'tarif_option1b';
	$fieldValue = formatPriceDb($primeDisplay_option1b_val);
	?>
	<input readonly="readonly" required type="hidden" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo $fieldValue; ?>">

	<?php
	$field = 'tarif_option2';
	$fieldValue = formatPriceDb($primeDisplay_option2_val);
	?>
	<input readonly="readonly" required type="hidden" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo $fieldValue; ?>">

<?php
} 
else if($tarif_data['collectif_personnes_identique'] == "1") 
{
	$prime = 0;
	$primeDisplay_option1_val = "-";
	$primeDisplay_option1b_val = "-";
	$primeDisplay_option2_val = "-";
	$total_prime = 0;
}
?>

<h2><?= $this->lang->line('form_step_3_col_label_1_b') ?> :</h2>

<table class="full-table" id="table-list-assures">
	<thead>
		<tr>
			<th class="th-inscrit-col table-sm-text" width="5%"><?= $this->lang->line('form_registered') ?></th>
			<th class="table-sm-text"><?= $this->lang->line('form_personal_infos') ?></th>
			<th class="th-prime-col table-sm-text" width="10%"><?= $this->lang->line('form_pricing_ind') ?></th>
			<th class="th-prime-col table-sm-text" width="10%"><?= $this->lang->line('form_pricing_option1') ?></th>
			<th class="th-prime-col table-sm-text" width="10%"><?= $this->lang->line('form_pricing_option1b') ?></th>
			<th class="th-prime-col table-sm-text" width="10%"><?= $this->lang->line('form_pricing_option2') ?></th>
			<th class="th-prime-col table-sm-text" width="10%"><?= $this->lang->line('form_pricing_total') ?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		$cumulPrimes = 0;
		for($p=1;$p<=$tarif_data['personnes_nombre'];$p++)
		{
			if($tarif_data['collectif_personnes_identique'] == "1") 
			{
				// pas identique
				$tarif_id = $tarifsList[$p]->id;

				$cat = $tarif_data['categorie_sports_'.$p];
				$capital = $tarif_data['capital_montant_'.$p];

				$taux_ttc = $tarifsList[$p]->taux_ttc;
				$d = $tarif_data['tarif_duree_'.$p];
				$duree = $this->lang->line('form_pricing_list_'.$tarif_data['tarif_duree_'.$p]);

				$prime = evalPrimeV2($capital, $cat, $taux_ttc);
				$primeDisplay = number_format($prime, 2, '.', ' ');

				$primeDisplay_option1 = "-"; $primeDisplay_option1_val = 0;
				$primeDisplay_option1b = "-"; $primeDisplay_option1b_val = 0;
				$primeDisplay_option2 = "-"; $primeDisplay_option2_val = 0;

				if(intval($tarif_data['assistance_monde_option_'.$p]) != 2):
					if(intval($tarif_data['assistance_monde_option_'.$p]) == 0):
						$ttc_option1 = $tarifsList_option1[$p][$d-1]->ttc;
						$prime_option1 = evalPrimeV2_prime($capital, $cat, $ttc_option1);
						$primeDisplay_option1_val = number_format($prime_option1, 2, '.', ' ');
						$primeDisplay_option1 = $primeDisplay_option1_val.'';
					elseif(intval($tarif_data['assistance_monde_option_'.$p]) == 1):
						$ttc_option1b = $tarifsList_option1b[$p][$d-1]->ttc;
						$prime_option1b = evalPrimeV2_prime($capital, $cat, $ttc_option1b);
						$primeDisplay_option1b_val = number_format($prime_option1b, 2, '.', ' ');
						$primeDisplay_option1b = $primeDisplay_option1b_val.'';
					endif;
				endif;

				if(intval($tarif_data['annulation_voyage_'.$p]) == 1):
					$ttc_option2 = $tarifsList_option2[$p][$d-1]->ttc;
					$prime_option2 = evalPrimeV2_prime($capital, $cat, $ttc_option2);
					$primeDisplay_option2_val = number_format($prime_option2, 2, '.', ' ');
					$primeDisplay_option2 = $primeDisplay_option2_val.'';
				endif;

				$total_prime = number_format($prime + $primeDisplay_option1_val + $primeDisplay_option1b_val + $primeDisplay_option2_val, 2, '.', ' ');
			}

			$classIsOk=''; $fieldValue = '';
			$field = 'form_infos_validation_'.$p;
			if(isset($_POST[$field]) && $_POST[$field] != '') { $fieldValue = $_POST[$field]; } else if(isset($tarif_data['infos_assure'][$field])) { $fieldValue = $tarif_data['infos_assure'][$field]; }
			if($fieldValue == "1") { $classIsOk = ' isok'; }
			?>
			<tr>
				<td>
					<strong><span class="lbl-inscrit-row">#<?php echo $p; ?></span></strong>
				</td>
				<td>&nbsp;</td>
				<td class="td-prime-col">
					<?php echo $primeDisplay; ?>
				</td>
				<td class="td-prime-col">
					<?php echo $primeDisplay_option1; ?>
				</td>
				<td class="td-prime-col">
					<?php echo $primeDisplay_option1b; ?>
				</td>
				<td class="td-prime-col">
					<?php echo $primeDisplay_option2; ?>
				</td>
				<td class="td-prime-col" valign="top">
					<?php echo $total_prime.'€'; ?>
				</td>
				<td>&nbsp;</td>
			</tr>
			<tr data-id="<?php echo $p; ?>" class="<?php echo $classIsOk; ?>">
				<td></td>
				<td colspan="5" class="td_form">
					<i id="ico-check-assure-<?php echo $p; ?>" class="fa fa-check ico-check-assure"></i>
					<?php 
					if($tarif_data['collectif_personnes_identique'] == "1") 
					{
						// conditions différentes
						?>
						<span class="infos-assure-text small">
							<strong><?= $this->lang->line('form_category') ?> : </strong> <?php echo $cat; ?><br />
							<strong><?= $this->lang->line('form_capital') ?> : </strong> <?php echo $capital; ?> €<br />
							<strong><?= $this->lang->line('form_duration') ?> : </strong> <?php echo $duree; ?><br />
							<?php
							$texteAssistanceMonde = '';
							$options_label = getOptionsLabel('collectif-b', $tarif_data, $p);

							if(intval($tarif_data['assistance_monde_'.$p]) == 1 && intval($tarif_data['annulation_voyage_'.$p]) == 1):
							    $texteAssistanceMonde = " <strong>".$this->lang->line('form_step_4_options_both').$options_label."</strong>";
							elseif(intval($tarif_data['assistance_monde_'.$p]) == 1):
							    $texteAssistanceMonde = " <strong>".$this->lang->line('form_step_4_options_option1').$options_label."</strong>";
							elseif(intval($tarif_data['annulation_voyage_'.$p]) == 1):
							    $texteAssistanceMonde = " <strong>".$this->lang->line('form_step_4_options_option2').$options_label."</strong>";
							endif;

							if(intval($tarif_data['annulation_voyage_'.$p]) == 1):
								$texteAssistanceMonde .= '<em class="infos-tickets-plane">';
								$texteAssistanceMonde .= $this->lang->line('form_annulation_field_buy_short').' : <span>'.$tarif_data['date_achat_billet_avion_'.$p].'</span><br />';
								$texteAssistanceMonde .= $this->lang->line('form_annulation_field_departure_short').' : <span>'.$tarif_data['date_depart_voyage_'.$p].'</span><br />';
								$texteAssistanceMonde .= '</em>';
							endif;

							echo $texteAssistanceMonde;
							?>
						</span><br /><br />
						<input required readonly="readonly" type="hidden" id="tarif_id_<?php echo $p; ?>" name="tarif_id_<?php echo $p; ?>" value="<?php echo formatPriceDb($tarif_id); ?>">
						<input required readonly="readonly" type="hidden" id="tarif_prime_<?php echo $p; ?>" name="tarif_prime_<?php echo $p; ?>" value="<?php echo formatPriceDb($total_prime); ?>">
						<input required readonly="readonly" type="hidden" id="tarif_tauxindacc_<?php echo $p; ?>" name="tarif_tauxindacc_<?php echo $p; ?>" value="<?php echo formatPriceDb($taux_ttc); ?>">
						<input required readonly="readonly" type="hidden" id="tarif_option1_<?php echo $p; ?>" name="tarif_option1_<?php echo $p; ?>" value="<?php echo formatPriceDb($primeDisplay_option1_val); ?>">
						<input required readonly="readonly" type="hidden" id="tarif_option1b_<?php echo $p; ?>" name="tarif_option1b_<?php echo $p; ?>" value="<?php echo formatPriceDb($primeDisplay_option1b_val); ?>">
						<input required readonly="readonly" type="hidden" id="tarif_option2_<?php echo $p; ?>" name="tarif_option2_<?php echo $p; ?>" value="<?php echo formatPriceDb($primeDisplay_option2_val); ?>">
						<?php
					}
					?>
					<span class="txt-edit-assure" id="txt-edit-assure-<?php echo $p; ?>">
						<a title="<?= $this->lang->line('form_edit_form_access') ?>" href="javascript:void(0);" class="btn-edit-assure btn-edit-assure-text"><?= $this->lang->line('form_to_seize') ?></a>
						<span class="txt-edit-prime-amount"> - <?= $this->lang->line('form_premium') ?> : <?php echo $primeDisplay; ?> €</span>
					</span>
					<span class="txt-edit-name hidden"></span>
					<input readonly="readonly" required type="hidden" name="<?php echo $field; ?>" id="<?php echo $field; ?>" value="<?php echo $fieldValue; ?>">
					<div class="form-infos-assure" id="form-infos-assure-<?php echo $p; ?>">
						<?php include('obtenir-un-tarif-etape-3_form.php'); ?>
					</div>
				</td>
				<td>
					<a href="javascript:void(0);" class="btn btn-warning btn-sm btn-edit-assure"><i class="fa fa-edit"></i></a>
				</td>
			</tr>			
			<?php
			$cumulPrimes += floatVal($total_prime);
		}
		$cumulPrimes = number_format($cumulPrimes, 2, '.', ' ');
		?>
	</tbody>
</table>

<div class="separator"></div>
<h2><?= $this->lang->line('form_total') ?> :</h2>

<p class="total-count-resume">
	<strong><?= $this->lang->line('form_nb_registered_cat_lg') ?> A :</strong> <span id="countCatA"><?php echo $inscritsCountA; ?></span><br />
	<strong><?= $this->lang->line('form_nb_registered_cat_lg') ?> B :</strong> <span id="countCatB"><?php echo $inscritsCountB; ?></span><br />
	<strong><?= $this->lang->line('form_premium_total') ?> :</strong> <span id="cumulPrimes"><?php echo $cumulPrimes; ?></span> €
</p>

<input required readonly="readonly" type="hidden" id="assure_tarif_total" name="assure_tarif_total" value="<?php echo formatPriceDb($cumulPrimes); ?>">
<input required readonly="readonly" type="hidden" id="assure_A_total" name="assure_A_total" value="<?php echo formatPriceDb($inscritsCountA); ?>">
<input required readonly="readonly" type="hidden" id="assure_B_total" name="assure_B_total" value="<?php echo formatPriceDb($inscritsCountB); ?>">

<p>
	<?= $this->lang->line('form_if_edit_goback') ?>,<br /><a class="btn-etape-back" href="<?php echo base_url($this->lang->line('page_slug_pricing').'/'.$typeTarif.'/'.$this->lang->line('pricing_slug_step').'2'); ?>" title="<?= $this->lang->line('form_goback_step') ?>"><?= $this->lang->line('form_goback_step_click') ?></a>.
</p>
<p>
	<strong><?= $this->lang->line('form_must_fill_before') ?>.</strong>
</p>

<div class="separator"></div>
<hr />

<?php
$field = 'assure_conditions'; $fieldValue = '';
if(isset($_POST[$field]) && $_POST[$field] != '') { $fieldValue = $_POST[$field]; } else if(isset($tarif_data['infos_assure'][$field])) { $fieldValue = $tarif_data['infos_assure'][$field]; }
if(isset($tarif_data['is_quotation_step_3']) && $tarif_data['is_quotation_step_3']):
	$fieldValue = "0";
endif;
if($fieldValue == "1") { $selected = ' card-selected'; } else { $selected = ''; }
if(form_error($field)): $class = ' has-error has-feedback'; else: $class = ""; endif;
formDisplayFieldError($field, $form_errors_array);
?>
<input readonly="readonly" required type="hidden" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo $fieldValue; ?>">
<br /><hr /><br />
<div class="row<?php echo $class; ?>">
	<div class="col-lg-12 col-md-12 col-sm-6 col-xs-12">
		<label class="label-cgv"><span><?= $this->lang->line('form_general_conditions') ?> * :&nbsp;&nbsp;&nbsp;</span><a class="btn btn-info btn-sm" href="<?php echo base_url('conditions_generales_'.getCurrentLang().'.pdf'); ?>" target="_blank"><?= $this->lang->line('form_openview') ?> <i class="fa fa-file-pdf-o"></i></a></label>
		<div class="card card-checkbox card-conditions<?php echo $selected; ?>" id="<?php echo $field; ?>-1">
			<i class="fa fa-check-square-o ico-checked"></i>
			<div class="card-block">
				<p class="text-left"><strong><?= $this->lang->line('form_accept_conditions') ?></strong></p>
				<a href="javascript:void(0);" data-nochange="0" data-scrollnext="1" data-checkbox="<?php echo $field; ?>" data-value="1" class="btn btn-primary btn-sm btn-selection-card btn-conditions-gnl"><?= $this->lang->line('form_select') ?> <i class="fa fa-check"></i></a>
			</div>
		</div>
	</div>
</div>