<h2><?= $this->lang->line('form_recap') ?> :</h2>

<p><?= $this->lang->line('form_step_4_col_label_1') ?> :</p>

<div class="recap-collectif-assures">
	<?php
	if($tarif_data['collectif_personnes_identique'] == "0") 
	{
		$cat = $tarif_data['categorie_sports'];
		$capital = $tarif_data['capital_montant'];
		$duree = $this->lang->line('form_pricing_list_'.$tarif_data['tarif_duree']);

		$texteAssistanceMonde = '';
		$options_label = getOptionsLabel('ind', $tarif_data);
		if(intval($tarif_data['assistance_monde']) == 1 && intval($tarif_data['annulation_voyage']) == 1):
		    $texteAssistanceMonde = " <strong>".$this->lang->line('form_step_4_options_both').$options_label."</strong>";
		elseif(intval($tarif_data['assistance_monde']) == 1 && intval($tarif_data['annulation_voyage']) == 0):
		    $texteAssistanceMonde = " <strong>".$this->lang->line('form_step_4_options_option1').$options_label."</strong>";
		elseif(intval($tarif_data['assistance_monde']) == 0 && intval($tarif_data['annulation_voyage']) == 1):
		    $texteAssistanceMonde = " <strong>".$this->lang->line('form_step_4_options_option2').$options_label."</strong>";
		endif;

		if(intval($tarif_data['annulation_voyage']) == 1):
			$texteAssistanceMonde .= '<em class="infos-tickets-plane">';
			$texteAssistanceMonde .= $this->lang->line('form_annulation_field_buy_short').' : <span>'.$tarif_data['date_achat_billet_avion'].'</span><br />';
			$texteAssistanceMonde .= $this->lang->line('form_annulation_field_departure_short').' : <span>'.$tarif_data['date_depart_voyage'].'</span><br />';
			$texteAssistanceMonde .= '</em>';
		endif;

	}

	for($p=1;$p<=$tarif_data['personnes_nombre'];$p++)
	{
		if($tarif_data['collectif_personnes_identique'] == "1") 
		{
			// différents
			$cat = $tarif_data['categorie_sports_'.$p];
			$capital = $tarif_data['capital_montant_'.$p];
			$duree = $this->lang->line('form_pricing_list_'.$tarif_data['tarif_duree_'.$p]);

			$texteAssistanceMonde = '';
			$options_label = getOptionsLabel('collectif-b', $tarif_data, $p);
			if(intval($tarif_data['assistance_monde_'.$p]) == 1 && intval($tarif_data['annulation_voyage_'.$p]) == 1):
			    $texteAssistanceMonde = " <strong>".$this->lang->line('form_step_4_options_both').$options_label."</strong>";
			elseif(intval($tarif_data['assistance_monde_'.$p]) == 1):
			    $texteAssistanceMonde = " <strong>".$this->lang->line('form_step_4_options_option1').$options_label."</strong>";
			elseif(intval($tarif_data['annulation_voyage_'.$p]) == 1):
			    $texteAssistanceMonde = " <strong>".$this->lang->line('form_step_4_options_option2').$options_label."</strong>";
			endif;

			if(intval($tarif_data['annulation_voyage_'.$p]) == 1):
				$texteAssistanceMonde .= '<em class="infos-tickets-plane">';
				$texteAssistanceMonde .= $this->lang->line('form_annulation_field_buy_short').' : <span>'.$tarif_data['date_achat_billet_avion_'.$p].'</span><br />';
				$texteAssistanceMonde .= $this->lang->line('form_annulation_field_departure_short').' : <span>'.$tarif_data['date_depart_voyage_'.$p].'</span><br />';
				$texteAssistanceMonde .= '</em>';
			endif;
		}
		?>
		<div class="row">
			<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3">
				<strong><?= $this->lang->line('form_category') ?> : </strong><?php echo $cat; ?><br />
				<strong><?= $this->lang->line('form_capital_short') ?> : </strong><?php echo $capital; ?> €<br />
				<strong><?= $this->lang->line('form_duration') ?> : </strong><?php echo $duree; ?><br />
				<?php echo $texteAssistanceMonde; ?>
			</div>
			<div class="col-lg-7 col-md-7 col-sm-7 col-xs-6">
				<?php
				getAssureInfos($tarif_data['infos_assure'], $p, 'collectif', $tarif_data);
				?>
			</div>
			<div class="col-lg-2 col-md-2 col-sm-2 col-xs-3">
				<?php
				if($tarif_data['collectif_personnes_identique'] == "1") 
				{
					echo $tarif_data['tarif_prime_'.$p];
				} 
				else if($tarif_data['collectif_personnes_identique'] == "0")
				{
					echo $tarif_data['tarif_prime']; 
				}
				?> €
			</div>
		</div>
		<?php
	}
	?>
</div>

<div class="separator"></div>
<h2><?= $this->lang->line('form_categories_check') ?></h2>

<div class="row">
	<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">

		<div class="card card-category recap">
			<div class="card-block">
				<h4 class="card-title"><?= $this->lang->line('form_category') ?> A</h4>
				<p class="card-text">
					<?php echo getCategorieSportText("A", "short"); ?>
				</p>
			</div>
		</div>

	</div>
	<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">

		<div class="card card-checkbox card-category recap">
			<div class="card-block">
				<h4 class="card-title"><?= $this->lang->line('form_category') ?> B</h4>
				<p class="card-text">
					<?php echo getCategorieSportText("B", "short"); ?>
				</p>
			</div>
		</div>

	</div>

</div>

<div class="separator"></div>
<h2><?= $this->lang->line('form_total') ?></h2>

<p>
	<strong><?= $this->lang->line('form_step_4_col_label_2') ?> A :</strong> <?php echo $tarif_data['inscritsCountA']; ?><br />
	<strong><?= $this->lang->line('form_step_4_col_label_2') ?> B :</strong> <?php echo $tarif_data['inscritsCountB']; ?><br />
	<strong><?= $this->lang->line('form_premium_total_all') ?> :</strong> <?php echo number_format($tarif_data['cumulPrimes'], 2, '.', ' '); ?> €
</p>

<p>
	<?= $this->lang->line('form_step_4_col_label_3') ?>, <a href="<?php echo base_url($this->lang->line('page_slug_pricing').'/'.$this->lang->line('page_slug_pricing_collective').'/'.$this->lang->line('pricing_slug_step').'3'); ?>" title="<?= $this->lang->line('form_goback_step') ?>"><?= $this->lang->line('form_goback_step_click') ?>.</a>
</p>

<br />
<hr />
<h2><i class="fa fa-file-text"></i>&nbsp;&nbsp;<?= $this->lang->line('form_quotation') ?></h2>
<div class="row">
	<?php if(!$etatDevis) { ?>
		<div class="col-sm-10 col-xs-12 text-info-devis">
			<p><?= $this->lang->line('form_quotation_list_1') ?>.</p>
			<p><?= $this->lang->line('form_quotation_list_2') ?>.</p>
			<p><?= $this->lang->line('form_quotation_list_3') ?>.</p>
		</div>
	<?php } ?>
	<div class="col-sm-12 col-xs-12">
		<?php if($etatDevis) { ?>
			<br />
			<div class="alert alert-success">
				<p><?= $this->lang->line('form_quotation_sent') ?> : <u><?php echo $tarif_data['infos_assure']['assure_email_1']; ?></u></p>
				<p><?= $this->lang->line('form_quotation_unreceived') ?> <a href="<?php echo base_url($this->lang->line('page_slug_pricing').'/'.$this->lang->line('page_slug_pricing_collective').'/'.$this->lang->line('pricing_slug_step').'4/'.$this->lang->line('page_slug_quotation').'/'); ?>" title="<?= $this->lang->line('form_download_quotation') ?>"><u><?= $this->lang->line('form_click_send_again') ?></u></a>.</p>
			</div>
		<?php } else { ?>
			<br />
			<a class="btn btn-info pull-right" href="<?php echo base_url($this->lang->line('page_slug_pricing').'/'.$this->lang->line('page_slug_pricing_collective').'/'.$this->lang->line('pricing_slug_step').'4/'.$this->lang->line('page_slug_quotation').'/'); ?>" title="<?= $this->lang->line('form_download_quotation') ?>"> <?= $this->lang->line('form_quotation_by_mail') ?> <i class="fa fa-download"></i></a>
		<?php } ?>
	</div>
</div>

<br />
<hr />
<div class="form-group">
	<div class="checkbox">
		<label for="rgpd"><input required type="checkbox" id="rgpd" name="rgpd" value=""><?= $label_rgpd ?></label>
	</div>
</div>

<input readonly="readonly" required type="hidden" id="assure_recap" name="assure_recap" value="1">