<?php
use Payline\PaylineSDK;

$simulatePaiement = false;
$paiement_TEST = false;
$nl_order_amount = $tarif_data['cumulPrimes'];
?>

<h2><?= $this->lang->line('paiement_form_title') ?> :</h2>
<p><em><?= $this->lang->line('paiement_form_before_btn') ?> :</em></p>
<p>&nbsp;</p><hr /><p>&nbsp;</p>
<div align="center">
	<?php
	if($simulatePaiement):
		?>
		<a title="<?= $this->lang->line('paiement_form_button') ?>" class="btn btn-success" href="<?php echo base_url('call_autoresponse_collectif.php'); ?>"><?= $this->lang->line('paiement_form_button') ?></a>
		<?php
	else:
		// INITIALIZE PAYLINE
		$array = array();
		$payline = new PaylineSDK(NL_PAYLINE_ID, NL_PAYLINE_KEY, "", "", "", "", NL_PAYLINE_ENV, "", null);
		$payline->usedBy(NL_PAYLINE_USEDBY);
		$array['version'] = NL_PAYLINE_VERSION;

		//////////////////////////////////////////
				$p=1; // = personne 1 (individuel)

				$paybox_tarif = $nl_order_amount;
				if($paiement_TEST):
					$paybox_tarif = 1.00;
				endif;

				$varPrime = ($paybox_tarif * 100); // TARIF PAYBOX EN CENTIMES
				$varEmail = $tarif_data['infos_assure']['assure_email_'.$p];

				$paymentAmount = $varPrime;
				$paymentCurrency = 978;

				$orderAmount = $paymentAmount;
				$orderCurrency = $paymentCurrency;
				$orderTaxes = "";
				$deliveryTime = "";
				$deliveryMode = "";
				$deliveryExpectedDate = "";
				$deliveryExpectedDelay = "";
				$orderDetailRef1 = "";
				$orderDetailPrice1 = "";
				$orderDetailQuantity1 = "";
				$orderDetailComment1 = "";
				$orderDetailCategory1 = "";
				$orderDetailBrand1 = "";
				$orderDetailSubcategory1_1 = "";
				$orderDetailSubcategory2_1 = "";
				$orderDetailAdditionalData1 = "";
				$orderDetailTaxRate1 = "";
				$orderDetailRef2 = "";
				$orderDetailPrice2 = "";
				$orderDetailQuantity2 = "";
				$orderDetailComment2 = "";
				$orderDetailCategory2 = "";
				$orderDetailBrand2 = "";
				$orderDetailSubcategory1_2 = "";
				$orderDetailSubcategory2_2 = "";
				$orderDetailAdditionalData2 = "";
				$orderDetailTaxRate2 = "";
				$buyerEmail = $varEmail;
				$shippingAddressTitle = "";
				$shippingAddressName = "";
				$shippingAddressLastName = $tarif_data['infos_assure']['assure_nom_'.$p];
				$shippingAddressFirstName = $tarif_data['infos_assure']['assure_prenom_'.$p];
				$shippingAddressStreet1 = $tarif_data['infos_assure']['assure_adresse1_'.$p];
				$shippingAddressStreet2 = $tarif_data['infos_assure']['assure_adresse2_'.$p];
				$shippingAddressCity = $tarif_data['infos_assure']['assure_ville_'.$p];
				$shippingAddressZipCode = $tarif_data['infos_assure']['assure_codepostal_'.$p];
				$shippingAddressCountry = $tarif_data['infos_assure']['assure_pays_'.$p];
				$shippingAddressPhone = $tarif_data['infos_assure']['assure_telephone_'.$p];
				$shippingAddressState = "";
				$shippingAddressCounty = "";
				$shippingAddressPhoneType = "";
				$billingAddressTitle = "";
				$billingAddressName = "";
				$billingAddressLastName = "";
				$billingAddressFirstName = "";
				$billingAddressStreet1 = "";
				$billingAddressStreet2 = "";
				$billingAddressCity = "";
				$billingAddressZipCode = "";
				$billingAddressCountry = "";
				$billingAddressPhone = "";
				$billingAddressState = "";
				$billingAddressCounty = "";
				$billingAddressPhoneType = "";

				// PAYMENT
				$array['payment']['amount'] = $paymentAmount; // montant
				$array['payment']['currency'] = $paymentCurrency; // euros
				$array['payment']['action'] = 101; // autorisation + validation
				$array['payment']['mode'] = "CPT"; // comptant

				// ORDER
				$array['order']['ref'] = $tarif_data['PRIVATE_CODE']; //'NL-'.time().'-'.substr($shippingAddressLastName, 0, 1).substr($shippingAddressFirstName, 0, 1);
				$array['order']['amount'] = $paymentAmount; // montant 
				$array['order']['currency'] = $paymentCurrency; // euros
				$array['order']['date'] = date('d/m/Y H:i');

				// BUYER
				$array['buyer']['legalStatus'] = "";
				$array['buyer']['title'] = "";
				$array['buyer']['lastName'] = $shippingAddressLastName;
				$array['buyer']['firstName'] = $shippingAddressFirstName;
				$array['buyer']['email'] = $buyerEmail;
				$array['buyer']['mobilePhone'] = $tarif_data['infos_assure']['assure_mobile_'.$p];
				$array['buyer']['customerId'] = "";
				$array['buyer']['accountCreateDate'] = "";
				$array['buyer']['accountAverageAmount'] = "";
				$array['buyer']['accountOrderCount'] = "";
				$array['buyer']['walletId'] = "";
				$array['buyer']['walletDisplayed'] = "";
				$array['buyer']['walletSecured'] = "";
				$array['buyer']['walletCardInd'] = "";
				$array['buyer']['ip'] = $_SERVER['REMOTE_ADDR'];
				$array['buyer']['legalDocument'] = "";
				$array['buyer']['birthDate'] = $tarif_data['infos_assure']['assure_naissance_'.$p];
				$array['buyer']['fingerprintID'] = "";

				// CONTRACT NUMBERS
				$array['payment']['contractNumber'] = NL_PAYLINE_CONTRACTNUM;
				$contracts = explode(";",NL_PAYLINE_CONTRACTNUM);
				$array['contracts'] = $contracts;
				$secondContracts = "";
				$array['secondContracts'] = $secondContracts;
				$walletContracts = "";
				$array['walletContracts'] = $walletContracts;

				// URLS
				$urlRetour = base_url('call_autoresponse_collectif.php');
				$array['notificationURL'] = $urlRetour;
				$array['returnURL'] = $urlRetour;
				$array['cancelURL'] = $urlRetour;

				// options
				$array['customPaymentPageCode'] = "";
				$array['customPaymentTemplateURL'] = "";
				$array['languageCode'] = "fr";
		//////////////////////////////////////////

		// Create session and init widget
		$response = $payline->doWebPayment($array);
		if(isset($response) && $response['result']['code'] == '00000'):
		    echo "<div class='row'>";
			    echo "<a href=\"".$response['redirectURL']."\" class=\"btn btn-success\">".$this->lang->line('paiement_form_button')."</a>";
		    echo "</div>";	    
		elseif(isset($response)):
		    echo 'doWebPayment ERROR : '.$response['result']['code']. ' '.$response['result']['longMessage'].' <BR/>';
		endif;

		/*
		if(isset($_GET['token']) == "4763b20473acc2582d3d42abe1b69631"): 
		?>

			<p>
				<?= $this->lang->line('paiement_form_before_btn') ?> :
			</p>

			<?php
			$simulatePaybox = true;
			if(ENVIRONMENT == 'production')
			{
				$simulatePaybox = false;
			}

			$simulatePaybox = true; // TMP

			if($simulatePaybox)
			{
			?>
				<a title="<?= $this->lang->line('paiement_form_button') ?>" class="btn btn-success" href="<?php echo base_url('call_autoresponse_collectif.php'); ?>"><?= $this->lang->line('paiement_form_button') ?></a>
			<?php
			}
			else
			{
				if(isset($_GET['error']) && $_GET['error'] != "")
				{
					// has error
					$currentPartenaire_email = getCurrentPartenaireEmail();
					?>
					<div class="alert alert-danger" role="alert">
				 		<p><strong><?= $this->lang->line('paiement_ko_title') ?> !</strong></p>
						<p><?= $this->lang->line('paiement_ko_subtitle') ?>.</p>
						<p><?= $this->lang->line('paiement_ko_retry') ?>.</p>
						<p><?= $this->lang->line('paiement_error_persist') ?> :<br /><a href="mailto:<?php echo $currentPartenaire_email; ?>"><?php echo $currentPartenaire_email; ?></a></p>
					</div>
					<?php
				}

				$serveurs = array(
					'tpeweb.paybox.com', //serveur primaire
					'tpeweb1.paybox.com'
				); //serveur secondaire
				$serveurOK = "";
				foreach ($serveurs as $serveur) 
				{
					$doc = new DOMDocument();
					$doc->loadHTMLFile('https://' . $serveur . '/load.html');
					$server_status = "";
					$element = $doc->getElementById('server_status');
					if ($element) {
						$server_status = $element->textContent;
					}
					if ($server_status == "OK") {
						//Le serveur est prêt et les services opérationnels
						$serveurOK = $serveur;
						break;
					}
					// else : La machine est disponible mais les services ne le sont pas.
				}
				if (!$serveurOK) {
					die("Erreur : Aucun serveur n'a été trouvé");
				}

				// vars
				$p=1; // = personne 1 (individuel)

				$paybox_tarif = $tarif_data['tarif_prime'];

				$preprodTest = PAYBOX_SANDBOX; // TODO: false in PRODUCTION - ONLY FOR TESTS
				// TODO: false in PRODUCTION - ONLY FORT TEST - ALLOW TO PUT CUSTOM AMOUNT 
				$prodTest = false;
				if($preprodTest) { $prodTest = false; }
				if($prodTest) { $paybox_tarif = 1.00; }

				if($preprodTest)
				{
					$paybox_server = "https://preprod-tpeweb.paybox.com/cgi/MYchoix_pagepaiement.cgi";
				}
				else
				{
					$paybox_server = "https://".$serveurOK."/cgi/MYchoix_pagepaiement.cgi";
				}

				$paybox_site = PAYBOX_SITE;
				$paybox_rang = PAYBOX_RANG;
				$paybox_identifiant = PAYBOX_ID;
				$keyTest = PAYBOX_KEY;

				$varPrime = ($paybox_tarif * 100); // TARIF PAYBOX EN CENTIMES
				$varEmail = $tarif_data['infos_assure']['assure_email_'.$p];
				$varPrivateCode = $tarif_data['PRIVATE_CODE'];
				$varDateTime = date("c");

				$urlRetour = base_url('call_autoresponse_collectif.php');

				// On crée la chaîne à hacher sans URLencodage
				$msg = "PBX_SITE=$paybox_site".
						"&PBX_RANG=$paybox_rang".
						"&PBX_IDENTIFIANT=$paybox_identifiant".
						"&PBX_TOTAL=$varPrime".
						"&PBX_DEVISE=978".
						"&PBX_CMD=$varPrivateCode".
						"&PBX_PORTEUR=$varEmail".
						"&PBX_RETOUR=Mt:M;Ref:R;Auto:A;Erreur:E".
						"&PBX_HASH=SHA512".
						"&PBX_TIME=$varDateTime".
						"&PBX_EFFECTUE=$urlRetour".
						"&PBX_REFUSE=$urlRetour".
						"&PBX_ANNULE=$urlRetour".
						"&PBX_ATTENTE=$urlRetour";

				if(false)
					echo('PHP '.phpversion().' with'.(function_exists('hash_hmac')?'':'out').' hash_hmac<br /><br />');
				
				// On calcule l’empreinte (à renseigner dans le paramètre PBX_HMAC) grâce à la fonction hash_hmac et la clé binaire
				// On envoie via la variable PBX_HASH l'algorithme de hachage qui a été utilisé (SHA512 dans ce cas)
				// Pour afficher la liste des algorithmes disponibles sur votre environnement, décommentez la ligne suivante
				$binKey = pack("H*", $keyTest);
				$hmac = strtoupper(hash_hmac('sha512', $msg, $binKey));
				
				// La chaîne sera envoyée en majuscules, d'où l'utilisation de strtoupper()
				// On crée le formulaire à envoyer à Paybox System
				// ATTENTION : l'ordre des champs est extrêmement important, il doit
				// correspondre exactement à l'ordre des champs dans la chaîne hachée

				//echo '<pre>';
				//	var_dump($msg);
				//	var_dump($hmac);
				//echo '</pre>';
				?>
					<form method="POST" action="<?php echo $paybox_server; ?>">
						<input type="hidden" name="PBX_SITE" value="<?php echo $paybox_site; ?>">
						<input type="hidden" name="PBX_RANG" value="<?php echo $paybox_rang; ?>">
						<input type="hidden" name="PBX_IDENTIFIANT" value="<?php echo $paybox_identifiant; ?>">
						<input type="hidden" name="PBX_TOTAL" value="<?php echo $varPrime; ?>">
						<input type="hidden" name="PBX_DEVISE" value="978">
						<input type="hidden" name="PBX_CMD" value="<?php echo $varPrivateCode; ?>">
						<input type="hidden" name="PBX_PORTEUR" value="<?php echo $varEmail; ?>">
						<input type="hidden" name="PBX_RETOUR" value="Mt:M;Ref:R;Auto:A;Erreur:E">
						<input type="hidden" name="PBX_HASH" value="SHA512">
						<input type="hidden" name="PBX_TIME" value="<?php echo $varDateTime; ?>">
						<input type="hidden" name="PBX_HMAC" value="<?php echo $hmac; ?>">
						<input type="hidden" name="PBX_EFFECTUE" value="<?php echo $urlRetour; ?>">
						<input type="hidden" name="PBX_REFUSE" value="<?php echo $urlRetour; ?>">
						<input type="hidden" name="PBX_ANNULE" value="<?php echo $urlRetour; ?>">
						<input type="hidden" name="PBX_ATTENTE" value="<?php echo $urlRetour; ?>">
						<input type="submit" class="btn btn-success" value="Procéder au paiement">
					</form>

				<?php
				// Conversion AdWords : Avant le paiment
				// Téléchargement du script
				echo '<script type="text/javascript">
				        <!--
				        var google_conversion_id = 1033276188;
				        var google_conversion_language = "fr";
				        var google_conversion_format = "3";
				        var google_conversion_color = "ffffff";
				        var google_conversion_label = "Zy2hCNyahQEQnJba7AM";
				        if ('.floatval($varPrime/100).') {
				          var google_conversion_value = '.floatval($varPrime/100).';
				        }
				        //-->
			        </script>
			        <script type="text/javascript" src="https://www.googleadservices.com/pagead/conversion.js"></script>
			        <noscript>
			       		<img height="1" width="1" border="0" src="https://www.googleadservices.com/pagead/conversion/1033276188/?value='.floatval($varPrime/100).'&amp;label=Zy2hCNyahQEQnJba7AM&amp;guid=ON&amp;script=0"/>
			        </noscript>';
			}
		endif;
		*/
		?>
		<?php
		/*
		<h2><?= $this->lang->line('paiement_form_title') ?></h2>

		<p><em><?= $this->lang->line('paiement_form_text') ?>.</em></p>

		<?php if(isset($_GET['token']) == "4763b20473acc2582d3d42abe1b69631"): ?>

			<p>
				<?= $this->lang->line('paiement_form_before_btn') ?> :
			</p>

			<?php
			$simulatePaybox = true;
			if(ENVIRONMENT == 'production')
			{
				$simulatePaybox = false;
			}

			$simulatePaybox = true; // TMP
			
			if($simulatePaybox)
			{
			?>
				<a title="<?= $this->lang->line('paiement_form_button') ?>" class="btn btn-success" href="<?php echo base_url('call_autoresponse_collectif.php'); ?>"><?= $this->lang->line('paiement_form_button') ?></a>
			<?php
			}
			else
			{
				if(isset($_GET['error']) && $_GET['error'] != "")
				{
					// has error
					$currentPartenaire_email = getCurrentPartenaireEmail();
					?>
					<div class="alert alert-danger" role="alert">
				 		<p><strong><?= $this->lang->line('paiement_ko_title') ?> !</strong></p>
						<p><?= $this->lang->line('paiement_ko_subtitle') ?>.</p>
						<p><?= $this->lang->line('paiement_ko_retry') ?>.</p>
						<p><?= $this->lang->line('paiement_error_persist') ?> :<br /><a href="mailto:<?php echo $currentPartenaire_email; ?>"><?php echo $currentPartenaire_email; ?></a></p>
					</div>
					<?php
				}

				$serveurs = array(
					'tpeweb.paybox.com', //serveur primaire
					'tpeweb1.paybox.com'
				); //serveur secondaire
				$serveurOK = "";
				foreach ($serveurs as $serveur) 
				{
					$doc = new DOMDocument();
					$doc->loadHTMLFile('https://' . $serveur . '/load.html');
					$server_status = "";
					$element = $doc->getElementById('server_status');
					if ($element) {
						$server_status = $element->textContent;
					}
					if ($server_status == "OK") {
						//Le serveur est prêt et les services opérationnels
						$serveurOK = $serveur;
						break;
					}
					// else : La machine est disponible mais les services ne le sont pas.
				}
				if (!$serveurOK) {
					die("Erreur : Aucun serveur n'a été trouvé");
				}

				// vars
				$p=1; // = personne 1 (individuel)

				$preprodTest = PAYBOX_SANDBOX; // TODO: false in PRODUCTION - ONLY FOR TESTS
				// TODO: false in PRODUCTION - ONLY FORT TEST - ALLOW TO PUT CUSTOM AMOUNT 
				$prodTest = false;
				if($preprodTest) { $prodTest = false; }
				if($prodTest) { $paybox_tarif = 1.00; }

				if($preprodTest)
				{
					$paybox_server = "https://preprod-tpeweb.paybox.com/cgi/MYchoix_pagepaiement.cgi";
				}
				else
				{
					$paybox_server = "https://".$serveurOK."/cgi/MYchoix_pagepaiement.cgi";
				}

				$paybox_site = PAYBOX_SITE;
				$paybox_rang = PAYBOX_RANG;
				$paybox_identifiant = PAYBOX_ID;
				$keyTest = PAYBOX_KEY;

				$urlRetour = base_url('call_autoresponse_collectif.php');

				$varPrime = ($nl_order_amount * 100);
				$varEmail = $tarif_data['infos_assure']['assure_email_'.$p];
				$varPrivateCode = $tarif_data['PRIVATE_CODE'];
				$varDateTime = date("c");

				// On crée la chaîne à hacher sans URLencodage
				$msg = "PBX_SITE=$paybox_site".
						"&PBX_RANG=$paybox_rang".
						"&PBX_IDENTIFIANT=$paybox_identifiant".
						"&PBX_TOTAL=$varPrime".
						"&PBX_DEVISE=978".
						"&PBX_CMD=$varPrivateCode".
						"&PBX_PORTEUR=$varEmail".
						"&PBX_RETOUR=Mt:M;Ref:R;Auto:A;Erreur:E".
						"&PBX_HASH=SHA512".
						"&PBX_TIME=$varDateTime".
						"&PBX_EFFECTUE=$urlRetour".
						"&PBX_REFUSE=$urlRetour".
						"&PBX_ANNULE=$urlRetour".
						"&PBX_ATTENTE=$urlRetour";
				
				if(false)
					echo('PHP '.phpversion().' with'.(function_exists('hash_hmac')?'':'out').' hash_hmac<br /><br />');
				
				// On calcule l’empreinte (à renseigner dans le paramètre PBX_HMAC) grâce à la fonction hash_hmac et la clé binaire
				// On envoie via la variable PBX_HASH l'algorithme de hachage qui a été utilisé (SHA512 dans ce cas)
				// Pour afficher la liste des algorithmes disponibles sur votre environnement, décommentez la ligne suivante
				// print_r(hash_algos());
				$binKey = pack("H*", $keyTest);
				$hmac = strtoupper(hash_hmac('sha512', $msg, $binKey));
				
				// La chaîne sera envoyée en majuscules, d'où l'utilisation de strtoupper()
				// On crée le formulaire à envoyer à Paybox System
				// ATTENTION : l'ordre des champs est extrêmement important, il doit
				// correspondre exactement à l'ordre des champs dans la chaîne hachée
				?>
				<form method="POST" action="https://tpeweb.paybox.com/cgi/MYchoix_pagepaiement.cgi">
					<input type="hidden" name="PBX_SITE" value="<?php echo $paybox_site; ?>">
					<input type="hidden" name="PBX_RANG" value="<?php echo $paybox_rang; ?>">
					<input type="hidden" name="PBX_IDENTIFIANT" value="<?php echo $paybox_identifiant; ?>">
					<input type="hidden" name="PBX_TOTAL" value="<?php echo $varPrime; ?>">
					<input type="hidden" name="PBX_DEVISE" value="978">
					<input type="hidden" name="PBX_CMD" value="<?php echo $varPrivateCode; ?>">
					<input type="hidden" name="PBX_PORTEUR" value="<?php echo $varEmail; ?>">
					<input type="hidden" name="PBX_RETOUR" value="Mt:M;Ref:R;Auto:A;Erreur:E">
					<input type="hidden" name="PBX_HASH" value="SHA512">
					<input type="hidden" name="PBX_TIME" value="<?php echo $varDateTime; ?>">
					<input type="hidden" name="PBX_HMAC" value="<?php echo $hmac; ?>">
					<input type="hidden" name="PBX_EFFECTUE" value="<?php echo $urlRetour; ?>">
					<input type="hidden" name="PBX_REFUSE" value="<?php echo $urlRetour; ?>">
					<input type="hidden" name="PBX_ANNULE" value="<?php echo $urlRetour; ?>">
					<input type="hidden" name="PBX_ATTENTE" value="<?php echo $urlRetour; ?>">
					<input type="submit" class="btn btn-success" value="Procéder au paiement">
				</form>

				<?php
				// Conversion AdWords : Avant le paiment
				// Téléchargement du script
				echo '<script type="text/javascript">
			        <!--
			        var google_conversion_id = 1033276188;
			        var google_conversion_language = "fr";
			        var google_conversion_format = "3";
			        var google_conversion_color = "ffffff";
			        var google_conversion_label = "Zy2hCNyahQEQnJba7AM";
			        if ('.floatval($varPrime/100).') {
			          var google_conversion_value = '.floatval($varPrime/100).';
			        }
			        //-->
			        </script>
			        <script type="text/javascript" src="https://www.googleadservices.com/pagead/conversion.js">
			        </script>
			        <noscript>
			        <img height="1" width="1" border="0" src="https://www.googleadservices.com/pagead/conversion/1033276188/?value='.floatval($varPrime/100).'&amp;label=Zy2hCNyahQEQnJba7AM&amp;guid=ON&amp;script=0"/>
			        </noscript>';
			}

		endif;
		*/
		?>
		<p id="paiement-infos-form">
			<br />
			<img width="160" height="auto" src="<?php echo base_url(); ?>assets/themes/default/img/paiement-secure.jpg" alt="Paiement">
		</p>
		<p><?= $this->lang->line('form_paiement_amount_total') ?> <strong><?= $nl_order_amount ?></strong> €</p>
		<?php
	endif;
	?>
</div>