jQuery.noConflict();
jQuery(document).ready(function ($) {

    var isMobile = $('body').data('ismobile');

	// click touch
    var isIOS = ((/iphone|ipad/gi).test(navigator.appVersion));
    var myDown = isIOS ? "touchstart" : "mousedown";
    var myUp = isIOS ? "touchend" : "mouseup";
    $.event.special.myDown = {
        setup: function () {
            var isIOS = ((/iphone|ipad/gi).test(navigator.appVersion));
            var myDown = isIOS ? "touchstart" : "mousedown";
            $(this).bind(myDown + ".myDownEvent", function (event) {
                event.type = "myDown";
                ($.event.dispatch || $.event.handle).call(this, event);
            });
        },
        teardown: function () {
            $(this).unbind(".myDownEvent");
        }
    };

    if($('#loader').size()>0)
    {
        var imgdir = window['base_url'] + "assets/themes/default/img/template/";
        var queue = new createjs.LoadQueue(true, imgdir);

        queue.on("complete", onPreloaderComplete);
        queue.on("progress", function(e) {
            var progressBar = $('.progress-bar');
            $('.percent').html(Math.floor(e.progress*100)+'<span>%</span>');
            var progressValue = Number((e.progress).toFixed(1));
            TweenLite.to(progressBar,.2,{css:{opacity:progressValue, width:parseInt(progressValue*100)+'%'}});
        });

        queue.loadManifest([
            {src: "nolimite-bg-06.jpg"},
            {src: "nolimite-bg-02.jpg"},
            {src: "nolimite-bg-03.jpg"},
            {src: "nolimite-ban1.jpg"},
            {src: "nolimite-ban3.jpg"},
            {src: "nolimite-ban4.jpg"},
            {src: "nolimite-ban5.jpg"},
            {src: "nolimite-ban6.jpg"},
        ]);

        function onPreloaderComplete(){
        $('#loader .percent,#loader .progress-bar').fadeOut(600, function(){});
            $('#loader').fadeOut(500, function(){
                $('#loader').remove();
                $(startSite);
            });
        }
    }
    else
    {
        $(startSite);
    }

    function startSite() {
        var tl = new TimelineLite({paused: true, onComplete: function(){
            $('#site').addClass('loaded');
        }});
        tl.add(TweenLite.to('#site',0.8,{opacity: 1}),.1);
        tl.play();
    }

    $(document).on(myDown, '#navbar-federations .nav-link', function(){
        var tab = $(this).attr('href').replace('#', '');
        var tabContent = $('#tabcontent-federations #'+tab);
        var id = 'masonry-'+tab.replace('type','');
        var container = $('#'+id);
        container.css('visibility', 'hidden');
        updateMasonry(container);
        setTimeout(function(){
            updateMasonry(container);
            container.css('visibility', 'visible');
        }, 500);
    });

    function updateMasonry(container) {
        $grid = container.isotope({
            itemSelector: '.grid-item',
            masonry: {
              columnWidth: 180,
              gutter: 10
            }
        });
        $grid.isotope('layout');
    }

    $(document).on(myDown, '#btn-responsive', function(){
        var mainNav = $('#site-navbar');
        var nav = $('#site-navbar .navbar-header');
        var menu = $('#main-navbar');

        if($(this).hasClass('closed')) {
            $(this).removeClass('closed');
            $(this).addClass('opened');
            menu.removeClass('closed');
            menu.addClass('opened');
            mainNav.addClass('opened');
            nav.addClass('opened');
            $('body').addClass('menuisopened');
        } else {
            $(this).removeClass('opened');
            $(this).addClass('closed');
            menu.removeClass('opened');
            menu.addClass('closed');
            mainNav.removeClass('opened');
            nav.removeClass('opened');
            $('body').removeClass('menuisopened');
        }
    });

    $(startMasonry);
    function startMasonry() {
        if($('.federations-masonry').size()>0){
            $('#tabcontent-federations .tab-pane.active .federations-masonry').each(function(){
                $(this).isotope({
                    itemSelector: '.grid-item',
                    masonry: {
                      columnWidth: 200,
                      gutter: 10
                    }
                });
            });
        }
    }

    /*$(document).on('change', '#table-list-assures .td_checkbox_assistance input[type="checkbox"]', function(){
        var id = $(this).parent().parent().data('id');
        if(!$(this).is(':checked'))
        {
            // 7 à 12 mois -> 1 an
            $('#table-list-assures #tarif_duree_'+id+' option:nth-last-child(2)').css('display', 'block');
            $('#table-list-assures #tarif_duree_'+id+' option:last-child').css('display', 'none');
            $('#table-list-assures #tarif_duree_'+id+'').val('');
        }
        else
        {
            // 1 an -> 7 à 12 mois
            $('#table-list-assures #tarif_duree_'+id+' option:nth-last-child(2)').css('display', 'none');
            $('#table-list-assures #tarif_duree_'+id+' option:last-child').css('display', 'block');
            $('#table-list-assures #tarif_duree_'+id+'').val('');
        }
    });*/

    function scrollToButtons(scroll)
    {
        var scrollTo;
        if(scroll != "1")
        {
            scrollTo = $('#'+scroll);
        }
        else
        {
            scrollTo = $('#steps-buttons-section');
        }

        if(scrollTo.size()>0)
        {
            $('html, body').animate({ scrollTop: scrollTo.offset().top-120 }, 500);
        }
    }

    $(document).on(myDown, '#navbar-tarif li a', function(){
        var etape = $(this).data('etape');
        if(etape !== undefined) {
            $('#form_tarif #etape').val(etape);
        }
    });

    $(document).on(myDown, '.tbl-selection tbody tr', function(){
        var parent = $(this).parent().parent().parent().find('.tbl-selection tr.selected');
        parent.removeClass('selected');
        $(this).addClass('selected');

        //var fieldName = $(this).parent().parent().parent().data('field');
        //var field = $('#'+fieldName);
        var value = $(this).data('id');
        if(value !== undefined && value != '') {
            $('#tarif_id').val(value);
        }
        if($(this).data('prime') !== undefined) {
            $('#tarif_prime').val($(this).data('prime'));
        }
        if($(this).data('duree') !== undefined) {
            $('#tarif_duree').val($(this).data('duree'));
        }
        if($(this).data('tauxindacc') !== undefined) {
            $('#tarif_tauxindacc').val($(this).data('tauxindacc'));
        }
        if($(this).data('option1') !== undefined) {
            $('#tarif_option1').val($(this).data('option1'));
        }
        if($(this).data('option1b') !== undefined) {
            $('#tarif_option1b').val($(this).data('option1b'));
        }
        if($(this).data('option2') !== undefined) {
            $('#tarif_option2').val($(this).data('option2'));
        }

        setTimeout(function(){
            scrollToButtons("1");
        }, 500);
    });

    $(document).on(myDown, '#table-list-assures .btn-edit-assure', function(){
        var table = $('#table-list-assures');
        var tr;
        if($(this).hasClass('btn-edit-assure-text'))
        {
            tr = $(this).parent().parent().parent();
        }
        else
        {
            tr = $(this).parent().parent();
        }
        var id = tr.data('id');
        table.find('tr.isediting').removeClass('isediting');
        tr.addClass('isediting');
    });

    $('.timepicker').timepicker({
        timeFormat: "HH:mm",
        timeOnlyTitle: 'Choisir heure',
        timeText: 'Heure',
        hourText: 'Changer',
        minuteText: 'Minutes',
        secondText: 'Secondes',
        currentText: 'Maintenant',
        closeText: 'Fermer'
    });

    $('.datepicker').datepicker({
        minDate: +1,
        showOn: "both",
        buttonImage: window['base_url'] + "assets/themes/default/img/calendar.gif",
        buttonImageOnly: true
    });

    $('.birthdatepicker').datepicker({
        yearRange: '-70:-18',
        //minDate: '-100y',
        //maxDate: '-18y',
        defaultDate: '01/01/' + (new Date().getFullYear()-18),
        dateFormat: 'dd/mm/yy',
        changeMonth: true,
        changeYear: true,
        showOn: "both",
        buttonImage: window['base_url'] + "assets/themes/default/img/calendar.gif",
        buttonImageOnly: true
    });

    $('.planeticketbuypicker').datepicker({
        minDate: '-5d',
        maxDate: '0',
        dateFormat: 'dd/mm/yy',
        changeMonth: true,
        changeYear: false,
        showOn: "both",
        buttonImage: window['base_url'] + "assets/themes/default/img/calendar.gif",
        buttonImageOnly: true
    });

    $('.travelpicker').datepicker({
        minDate: '+15d',
        dateFormat: 'dd/mm/yy',
        changeMonth: true,
        changeYear: true,
        showOn: "both",
        buttonImage: window['base_url'] + "assets/themes/default/img/calendar.gif",
        buttonImageOnly: true
    });

    $(document).find('.dateeffet-picker').each(function(){
        var t_mindate = $(this).data('mindate');
        $(this).datepicker({
            minDate: t_mindate,
            dateFormat: 'dd/mm/yy',
            changeMonth: true,
            changeYear: true,
            showOn: "both",
            buttonImage: window['base_url'] + "assets/themes/default/img/calendar.gif",
            buttonImageOnly: true
        });
    });

    $(document).on('change', '.dateeffet-picker.hasDatepicker, .timepicker.hasDatepicker', function(){
        var t_id = $(this).data('id');
        var t_field = $(document).find('input[name="assure_dateheure_effet_'+t_id+'"]');
        var t_value1 = $(document).find('input[name="assure_dateeffet_'+t_id+'"]').val();
        var t_value2 = $(document).find('input[name="assure_dateeffetheure_'+t_id+'"]').val();
        var t_value = t_value1 + " " + t_value2 + ":00";
        t_field.val(t_value);
    });

    $('.datepicker, .travelpicker, .planeticketbuypicker, .birthdatepicker').on(myDown, function(e) {
        $(this).attr("autocomplete", "off");  
    });

    $(document).on(myDown, '#table-list-assures .btn-valid-assure, #table-list-assures .btn-cancel-assure', function(){
        var id = $(this).data('id');
        var tr = $('#table-list-assures tr[data-id="'+id+'"]');
        var form = $('#form_tarif');

        if($(this).hasClass('btn-valid-assure')) {
            // check fields
            var isValid = true;
            $('#table-list-assures tbody tr[data-id="'+id+'"] :input:visible[required="required"]').each(function(){
                if(!this.validity.valid)
                {
                    $(this).parent().parent().addClass('has-error').addClass('has-feedback');
                    isValid = false;
                    console.log("non valide : " + id);
                    //return false;
                } else {
                    $(this).parent().parent().removeClass('has-error').removeClass('has-feedback');
                }
            });
            $('#table-list-assures tbody tr[data-id="'+id+'"] select[required="required"]').each(function(){
                if(!this.validity.valid)
                {
                    $(this).parent().parent().addClass('has-error').addClass('has-feedback');
                    isValid = false;
                    //return false;
                    console.log("non valide : " + id);
                } else {
                    $(this).parent().parent().removeClass('has-error').removeClass('has-feedback');
                }
            });

            if(isValid) 
            {
                
                if(parseInt(id) == 1)
                {
                    // if first one, duplicate some fields (date / time for ex.)
                    var m_datecopy = tr.find('.datepicker.input-duplicate').val();
                    var m_timecopy = tr.find('.timepicker.input-duplicate').val();

                    if(m_timecopy != '' && m_timecopy != '')
                    {
                        $('#table-list-assures tbody tr').each(function(){
                            if(parseInt($(this).data('id')) != parseInt(id))
                            {
                                var fieldDate = $(this).find('.datepicker.input-duplicate');
                                var fieldTime = $(this).find('.timepicker.input-duplicate');

                                if(fieldDate.hasClass('isDefaultValue') && fieldTime.hasClass('isDefaultValue'))
                                {
                                    $(this).find('#assure_typedateeffet_'+$(this).data('id')+'-0').removeClass('card-selected');
                                    $(this).find('#assure_typedateeffet_'+$(this).data('id')+'-1').addClass('card-selected');

                                    fieldDate.val(m_datecopy);
                                    fieldDate.removeClass('isDefaultValue');
                                    fieldTime.val(m_timecopy);
                                    fieldTime.removeClass('isDefaultValue');
                                }
                            }
                        });
                    }
                }

                var m_assure_nom = '';
                m_assure_nom = tr.find('.input-prenom').val() + ' ' + tr.find('.input-nom').val();

                tr.removeClass('isediting');
                tr.addClass('isok');

                tr.find('.txt-edit-name').html(m_assure_nom).removeClass('hidden');

                $('#form_infos_validation_'+id).val("1");

            } 
            else 
            {
                tr.removeClass('isok');
                tr.find('td.txt-edit-name').html('').addClass('hidden');

                if(isMobile)
                {
                    alert('Il faut compléter tous les champs obligatoires pour pouvoir valider cet inscrit.');
                }
            }

        } else if($(this).hasClass('btn-cancel-assure')) {
            tr.removeClass('isediting');
        }

        $(this).parent().focus();

        return false;
    });

    $(document).on(myDown, '.btn-etape-next', function(e){
        e.preventDefault();

        var etape = $(this).attr('href').replace('#etape', '');
        var form = document.getElementById('form_partenaire');
        var formBox = $('#form_partenaire');

        var currentEtape = etape-1;

        // validate each field for the current step
        var isValid = true;
        console.log("valid form :",isValid);
        $('#etape'+currentEtape+' input[required="required"], #etape'+currentEtape+' select[required="required"]').each(function(){
            if(!this.validity.valid)
            {
                //console.log("non valide");
                isValid = false;
            }
        });

        if(isValid)
        {
            //console.log("validation OK");
            
            var menuNav = $('#navbar-partenaire');
            var liActive = menuNav.find('a.nav-link.active');
            liActive.removeClass('active');

            var liNext = menuNav.find('a[data-etape="'+etape+'"]');
            liNext.addClass('active');

            var panelActive = $('.tab-pane.active');
            panelActive.removeClass('active');
            var panelNext = $('div#etape'+etape);
            panelNext.addClass('active');

            return false;
        }
    });

    $(document).on(myDown, '#button-form-paiement', function(){
        var button = $(this);
        setTimeout(function(){
            button.css('display', 'none');
            $(document).find('#paiement-infos-form').css('display', 'none');
        }, 1000);
    });

    $(document).on('change', '.card-dateeffet input', function(){
        var assure_id = $(this).attr('id').replace('assure_dateeffet_', '').replace('assure_dateeffetheure_', '');
        var assure_dateeffet = $(document).find('#assure_dateeffet_'+assure_id).val();
        var assure_heureeffet = $(document).find('#assure_dateeffetheure_'+assure_id).val();
        if(assure_dateeffet !== undefined && assure_dateeffet !== ""
            && assure_heureeffet !== undefined && assure_heureeffet !== "")
        {
            $(document).find('#assure_dateheure_effet_'+assure_id).val(assure_dateeffet + ' ' + assure_heureeffet + ':00');
        }
    });

});