<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
use Payline\PaylineSDK;

class Home extends CI_Controller {

	function __construct()
	{
		parent::__construct();

		$this->_init();
	}

	private function _init()
	{
		define('FPDF_FONTPATH',FCPATH . 'application/libraries/fpdf/');
		
		$this->lang->load('information', getCurrentLang());

		$this->output->set_template('default');

		$this->load->model('partenaires_model');
		
		// default
			$partenaire_id = 1; // DEFAULT PARTENAIRE = 1 = OPRA SA
			$partenaire_nom = "OPRA SA";
			$partenaire_courriel = "contact@no-limite.com";
			$partenaire_logo = base_url('assets/themes/default/img/logo-nolimite.png');
			$partenaire_parent = NULL;
			$partenaire_url = base_url();

		$partenaireSubDomain = getPartenaireSubDomain();

		if(ENVIRONMENT == 'production' && $partenaireSubDomain != ""):
			// check if exists
			$partenaireSearch = $this->partenaires_model->findWithSubdomain($partenaireSubDomain);
			//var_dump($partenaireSearch);
			//exit();
			if($partenaireSearch):
				$partenaire_id = $partenaireSearch;
				$partenaire_parent = 1; // has subdomain, default parent = 1 = OPRA SA
			else:
				// redirect to main url
				echo "ERROR : This subdomain / partner doesn't exist.";
				redirect(getMainSiteUrl());
				exit();
			endif;
		endif;
		// SET LOGO
		
		// partenaire infos
		$partenaire = $this->partenaires_model->find($partenaire_id);
			if($partenaire->NOM_PARTENAIRE)
			{
				$partenaire_nom = $partenaire->NOM_PARTENAIRE;
			}
			if($partenaire->COURRIEL_PARTENAIRE)
			{
				$partenaire_courriel = $partenaire->COURRIEL_PARTENAIRE;
			}
			if($partenaire->LOGO_PARTENAIRE)
			{
				$partenaire_logo = checkAndGetLogoPartenaire($partenaire->LOGO_PARTENAIRE);
			}
			if($partenaire->PARENT_PARTENAIRE)
			{
				$partenaire_parent = $partenaire->PARENT_PARTENAIRE;
			}
			if($partenaire->URL_PARTENAIRE)
			{
				$partenaire_url = $partenaire->URL_PARTENAIRE;
			}

			$partenaireData = array(
									"ID" => $partenaire_id,
									"NOM" => $partenaire_nom,
									"LOGO" => $partenaire_logo,
									"EMAIL" => $partenaire_courriel,
									"URL" => $partenaire_url,
									"PARENT" => $partenaire_parent
								);
			$this->session->set_userdata('currentPartenaire', $partenaireData);
	}

	public function index()
	{
		$data = [];
		//getLanguageFolder($lang);
		$this->load->view('default/front/index', $data);
	}

	public function get_country_phone_infos()
	{
		if(isset($_POST['country']) && $_POST['country'] != "")
		{
			header('Access-Control-Allow-Origin: *');
			header("Content-type: application/json");
			header("HTTP/1.1 200 OK");

			$result = new Stdclass();
			$result->indicator = "";
			$result->output = "";

			$country = $_POST['country'];

			$indicator = getCountryPhoneIndicator($country);
			$output = getCountryFlag($country);

			$result->indicator = $indicator;
			$result->output = $output;

			echo json_encode($result);
			exit();
		}
		else
		{
			redirect("");
		}
	}

	public function getback_from_paiement() {
		$redirect_url = '';

		$str_get = ""; $ref = "";
		if(isset($_GET['Ref']) && $_GET['Ref'] != "" && isset($_GET['level']) && $_GET['level'] == "6") 
		{
			$ref = $_GET['Ref'];

			if(isset($_GET['Erreur']) && $_GET['Erreur'] != "") {
				$error = "error=".$_GET['Erreur'];	
				$ref = $_GET['Ref'];

				// search REF in DB to get tarif type
				$this->load->model('souscripteurs_model');
				$souscription = $this->souscripteurs_model->findAllCertificatWithCrc($ref);

				if($souscription->TYPE_TARIF_SOUSCRIPTEUR != "") {
					$type_tarif = strtr($souscription->TYPE_TARIF_SOUSCRIPTEUR, array("0"=>$this->lang->line('page_slug_pricing_collective'), "1"=>$this->lang->line('page_slug_pricing_collective')));

					$redirect_url = $this->lang->line('page_slug_pricing').'/'.$type_tarif.'/'.$this->lang->line('pricing_slug_step').'5/?'.$error;
				}
			}
		}

		redirect($redirect_url);
	}

	public function call_autoresponse_collectif() {
		$debug = false;
		if($debug):
			echo "<pre>";
		endif;

		if(!$this->session->userdata('tarifData')) 
		{
			if($debug):
				var_dump("debug 0");
			endif;
			redirect($this->lang->line('page_slug_pricing'));
		}
		else
		{
			if($debug):
				var_dump("debug 1");
			endif;
			$paiement_code = null;
			$transaction_token = null;
			$transaction_version = null;
			$transaction_data = null;

			$tarifData = $this->session->userdata('tarifData');
			
			$simulatePaiement = false; // TODO : turn to false in prod!
			if(ENVIRONMENT == 'production')
			{
				$simulatePaiement = false;
			}
			
			// Mt:M;Ref:R;Auto:A;Erreur:E
			
			if($simulatePaiement):
				if($debug):
					var_dump("debug 2");
				endif;
				$transaction_id = date("YmdHis");
				$transaction_data = "test";
				$transaction_token = "test";
				$transaction_version = "test";
				$transaction_ref = date("Y-m-d-His");
				$paiement_code = "0000";
			else:
				if($debug):
					var_dump("debug 3");
				endif;
				//$transaction_id = date("ymdHis");
				$token = null;

				if(isset($_GET[NL_PAYLINE_TOKEN_VARGET]) && $_GET[NL_PAYLINE_TOKEN_VARGET] != ""):
					$token = $_GET[NL_PAYLINE_TOKEN_VARGET];
				endif;

				if($debug):
					var_dump("token : ".$token);
				endif;

				if(!is_null($token)):

					$array = array();

					// INITIALIZE PAYLINE
					$payline = new Payline\PaylineSDK(NL_PAYLINE_ID, NL_PAYLINE_KEY, "", "", "", "", NL_PAYLINE_ENV, "", null);
					$payline->usedBy(NL_PAYLINE_USEDBY);
					$array['version'] = NL_PAYLINE_VERSION;
					$transaction_version = $array['version'];
					$array['token'] = $token;

					$response = $payline->getWebPaymentDetails($array);
					if($debug):
						var_dump("PAYLINE RESPONSE : ", $response);
					endif;

					if(isset($response['transaction']['id'])):

						$transaction_id = $response['transaction']['id'];

						// payline datas to store
					    $array_payline = array(
											    "payline_ref" => $response['order']['ref'],
											    "payline_transaction_id" => $response['transaction']['id'],  
											    "payline_action" => $response['payment']['action'],
											    "payline_amount" => $response['payment']['amount'],
											    "payline_currency" => $response['payment']['currency'],
											    "payline_code" => $response['result']['code'],
											    "payline_token" => $array['token'],
											    "payline_version" => $array['version']
											);

					    if($debug):
							var_dump("PAYLINE DATAS TO DB :", $array_payline);
						endif;

						if(isset($array_payline['payline_code']) && $array_payline['payline_code'] == "00000"):
						   	//$response['payment']['contractNumber']
						   	//$response['wallet']['walletId']
						   	//$response['paymentRecordId'])
						   	$paiement_code = $array_payline['payline_code'];
						   	$transaction_token = $array['token'];
						  	$transaction_data = json_encode($array_payline);

							if($debug):
								var_dump("PAIEMENT_OK");
							endif;
						else: 
							var_dump($array_payline, $array_payline['result']);
							die("Paiement refusé : ");
							exit();
						endif;

						// Trace dans un fichier (au cas ou)
						$myFile = FCPATH . "/logs/trace_paiement_".date('Y').".log";
						$fh = fopen($myFile, 'a+');
						fwrite($fh, str_repeat("-",50)."\n");
						fwrite($fh, "Paiement recu le : ".date("d/m/Y").PHP_EOL);
						
						fwrite($fh, "      Id      -> ".$transaction_id.PHP_EOL);
						fwrite($fh, "      Ref     -> ".$response['order']['ref'].PHP_EOL);
						fwrite($fh, "      Token   -> ".$transaction_token.PHP_EOL);
						fwrite($fh, "      Montant -> ".$response['payment']['amount'].PHP_EOL);
						fwrite($fh, "      Code    -> ".$paiement_code.PHP_EOL);
						
						fclose($fh);

					endif;

				endif;
			endif;
			//}
			//else
			//{
				/* ************ */
				/* BEGIN PAYBOX */
				/* ************ */

				/*if(isset($_GET['Mt']) && isset($_GET['Ref']) && isset($_GET['Auto']) && isset($_GET['Erreur']))
				{
					$amount = $_GET['Mt'];
					$transaction_ref = $_GET['Ref'];
					$transaction_id = $_GET['Auto'];
					$code = $_GET['Erreur'];
				} 
				else if(!isset($_GET['Auto']) || empty($_GET['Auto'])) 
				{
					if(!$debug)
					{
						redirect($this->lang->line('page_slug_pricing').'/'.$tarifData['typeTarif'].'/@');
					}
					else
					{
						die("Paiement refusé : ".$code);
					}
				} 
				else 
				{
					if(!$debug)
					{
						redirect($this->lang->line('page_slug_pricing').'/'.$tarifData['typeTarif'].'/'.$this->lang->line('pricing_slug_step').'6');
					}
					else
					{
						die("Requête invalide");
					}
				};*/
				
				// Trace dans un fichier (au cas ou)
				/*$myFile = FCPATH . "/logs/trace_paiement_".date('Y').".log";
				$fh = fopen($myFile, 'a+');
				fwrite($fh, str_repeat("-",50)."\n");
				fwrite($fh, "Paiement recu le : ".date("d/m/Y").PHP_EOL);
				
				fwrite($fh, "      Id      -> ".$_GET['Auto'].PHP_EOL);
				fwrite($fh, "      Ref     -> ".$_GET['Ref'].PHP_EOL);
				fwrite($fh, "      Montant -> ".$_GET['Mt'].PHP_EOL);
				fwrite($fh, "      Code    -> ".$_GET['Erreur'].PHP_EOL);
				
				fclose($fh);*/
				
				/* ********** */
				/* END PAYBOX */
				/* ********** */
			//}

			if(is_null($paiement_code) || $paiement_code != "0000")
			{
				if(!$debug)
				{
					redirect($this->lang->line('page_slug_pricing').'/'.$tarifData['typeTarif'].'/'.$this->lang->line('pricing_slug_step').'6');
				}
				else
				{
					die("Paiement refusé : ".$code);
				}
			}
			else
			{
				$this->load->model('partenaires_model');
				$this->load->model('souscripteurs_model');
				$this->load->model('encaissement_model');

				// get customers
				$customers = $this->souscripteurs_model->findCustomers($tarifData['type_tarif'], $tarifData['ID_SOUSCRIPTEUR']);

				// infos sur le partenaire du souscripteur
				$id_partenaire = $customers[0]->ID_PARTENAIRE;

				if($debug)
				{
					var_dump("ID PARTENAIRE : ", $id_partenaire);
				}

				$partenaire = $this->partenaires_model->find($id_partenaire);
					$partenaire_id = $partenaire->ID_PARTENAIRE;
					$partenaire_nom = $partenaire->NOM_PARTENAIRE;
					$partenaire_email = $partenaire->COURRIEL_PARTENAIRE;
					$partenaire_commission = $partenaire->COM_PARTENAIRE;
					$partenaire_prime = $partenaire->PRIME_PARTENAIRE;
					$partenaire_parent = $partenaire->PARENT_PARTENAIRE;

				// taux partenaire parent de commission
				$partenaire_parent_commission = "";
				if($partenaire_parent != "")
				{
					$partenaireParent = $this->partenaires_model->find($partenaire_parent);
					$partenaire_parent_nom = $partenaireParent->NOM_PARTENAIRE;
					$partenaire_parent_commission = $partenaireParent->COM_AS_PARENT_PARTENAIRE;
				}

				$versionCalcul = 1; // permet de basculer entre le nouveau et l'ancien système

				// OK
				if($versionCalcul == 0)
				{
					$taux = getTaux();

					$TabGetTaux['A1 - 3 jours'] 	= 		$this->tarifs_model->getTauxHT('A', '1', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['A4 - 7 jours'] 	= 		$this->tarifs_model->getTauxHT( 'A', '2', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['A8 - 30 jours'] 	= 		$this->tarifs_model->getTauxHT( 'A', '3', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['A2 mois'] 			= 		$this->tarifs_model->getTauxHT( 'A', '42', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['A3 mois'] 			= 		$this->tarifs_model->getTauxHT( 'A', '43', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['A4 mois'] 			= 		$this->tarifs_model->getTauxHT( 'A', '44', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['A5 mois'] 			= 		$this->tarifs_model->getTauxHT( 'A', '45', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['A6 mois'] 			= 		$this->tarifs_model->getTauxHT( 'A', '46', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['A1 an'] 			= 		$this->tarifs_model->getTauxHT( 'A', '5', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);

					$TabGetTaux['B1 - 3 jours'] 	= 		$this->tarifs_model->getTauxHT( 'B', '1', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['B4 - 7 jours'] 	= 		$this->tarifs_model->getTauxHT( 'B', '2', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['B8 - 30 jours'] 	= 		$this->tarifs_model->getTauxHT( 'B', '3', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['B2 mois'] 			= 		$this->tarifs_model->getTauxHT( 'B', '42', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['B3 mois'] 			= 		$this->tarifs_model->getTauxHT( 'B', '43', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['B4 mois'] 			= 		$this->tarifs_model->getTauxHT( 'B', '44', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['B5 mois'] 			= 		$this->tarifs_model->getTauxHT( 'B', '45', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['B6 mois'] 			= 		$this->tarifs_model->getTauxHT( 'B', '46', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);
					$TabGetTaux['B1 an'] 			=		$this->tarifs_model->getTauxHT( 'B', '5', $customers[0]->ASSISTANCEMONDE_SOUSCRIPTEUR, $customers[0]->ANNULATION_VOYAGE_SOUSCRIPTEUR);

					$annee 							= 	getFraisFix('A');
					$semes 							=  	getFraisFix('S');
					$trimes 						=  	getFraisFix('T');
				}
				else if($versionCalcul == 1)
				{
					$this->load->model('taux_model');

					// taux assureur
					$tauxAssureur = $this->taux_model->getTaux('prime_assureur_principal');
					$tauxId1 = $this->taux_model->getTaux('commission_parent_role_1');
					if($partenaire->TYPE_PARTENAIRE == 1)
					{
						$tauxId1 = $this->taux_model->getTaux('commission_parent_role_3');
					}
					$tauxFilleuls = $this->taux_model->getTaux('commission_parent_role_2');
				}
				
				$update_errors = false;
				$newCertificatNumber = $this->souscripteurs_model->getLastCertificatNumber();
				if($newCertificatNumber == "" || $newCertificatNumber == 0 || $newCertificatNumber == null) { 
					$newCertificatNumber = 100614;
				}

				$array_privates_code = array();
				foreach($customers as $customer)
				{
					$array_privates_code[] = array(
												"nom" => $customer->PRENOM_SOUSCRIPTEUR.' '.$customer->NOM_SOUSCRIPTEUR,
												"email" => $customer->COURRIEL_SOUSCRIPTEUR,
												"code" => $customer->PRIVATE_CODE,
												"assistancemonde" => $customer->ASSISTANCEMONDE_SOUSCRIPTEUR
											);

					// numéro de certificat
					$newCertificatNumberFormatted = str_pad($newCertificatNumber, 8, '0', STR_PAD_LEFT);

					// update
					$updateCertificat = array(
												"CERTIFICAT_SOUSCRIPTEUR" => $newCertificatNumberFormatted,
												"DOSSIER_PAYE" => 1,
												"ID_PARTENAIRE" => $partenaire_id,
												"IDP_ORIGINE" => $partenaire_parent
											);
					$update = $this->souscripteurs_model->update($customer->ID_SOUSCRIPTEUR, $updateCertificat);

					if($debug){
						var_dump("Update certificat : ", $update);
					}

					if(!$update)
					{
						$update_errors = true;
						if($debug){
							var_dump("SQL ERROR UPDATE CERT");
						}
					}

					$newCertificatNumber++;
				}

				if(!$update_errors)
				{
					$PART_ASSUREUR = "";
					$PART_PARTENAIRE_PARENT = "";

					if($versionCalcul == 0)
					{
						// ANCIEN SYSTEME DE CALCUL
						// NE FONCTIONNE PAS DANS L'ETAT MAIS PEUT ETRE READAPTE

						/*$indice_taux = $customer->CATEGORIE_SOUSCRIPTEUR . $customer->PERIODE_SOUSCRIPTEUR;
						$pattern = '#([A|B][0-9])[^0-9]*([0-9]+ jours)#';
						if (preg_match($pattern, $indice_taux, $match))
						{
							$indice_taux = $match[1] . ' - ' . $match[2];
						}

						$TauxDuDossier_B = ($TabGetTaux[$indice_taux]/10000);
						$PrimeHT_C = $customer->CAPITAL_SOUSCRIPTEUR * $TauxDuDossier_B;
						$Commission_D = $PrimeHT_C * ($taux['comm']-1);
						$Honoraires_E = $PrimeHT_C * ($taux['honoraire']-1);
						$CoutDePolice_G = $taux['cp'];
						$Taxes_H = ($PrimeHT_C+$Commission_D+$CoutDePolice_G)*($taux['taxes']-1);
						$PrimeTTC_I = $PrimeHT_C + $Commission_D + $Honoraires_E + $CoutDePolice_G + $Taxes_H;
						$CALCUL_ENCAISSEMENT = "Capital (A) : ".$customer->CAPITAL_SOUSCRIPTEUR." - Taux HT (B) : ".$TauxDuDossier_B." - Prime HT (C) : ".$PrimeHT_C." - Commission (D) : ".$Commission_D." - Honoraires (E) : ".$Honoraires_E." - Coût de police (G) : ".$CoutDePolice_G." - Taxes (H) : ".$Taxes_H." - Prime TTC (I) : ".$PrimeTTC_I;
							
						// N
						$PART1 = $Commission_D + $Honoraires_E;

						if($IDP_ORIGINE <= 1 && $partenaire_id <= 1) { // CAS N
							echo "CAS:N";
							$PART2 = 0;
							$PART3 = 0;
						};
				
						if($IDP_ORIGINE <= 1 && $partenaire_id > 1) { // CAS N+1
							echo "CAS:N+1";
							$PART2 = ($PART1 * ($COM_PARTENAIRE/100)) + $PRIME_PARTENAIRE;
							$PART1 = $PART1-$PART2;
							$PART3 = 0;
						};
				
						if($IDP_ORIGINE > 1 AND $partenaire_id > $IDP_ORIGINE) { // CAS N+2
							echo "CAS:N+2";
							$PART2 = ($PART1 * ($COM_PARTENAIRE_ORIGINE/100)) + $PRIME_PARTENAIRE_ORIGINE;
							$PART3 = ($PART2 * ($COM_PARTENAIRE/100)) + $PRIME_PARTENAIRE;
							$PART1 = $PART1-$PART2;
							$PART2 = $PART2-$PART3;
						};

						if($debug){
							var_dump("PART1 N : ", $PART1);
							
						}*/
					}
					else if($versionCalcul == 1)
					{
						$insert_errors = false;

						$customersUpdated = $this->souscripteurs_model->findCustomers($tarifData['type_tarif'], $tarifData['ID_SOUSCRIPTEUR']);
						foreach($customersUpdated as $customer)
						{
							// NOUVEAU CALCUL

							$montant_encaissement = $customer->PRIME_SOUSCRIPTEUR;

							// part assureur
							// 50% sur le montant encaissé (par défaut)
							// prime utilisée pour les calculs suivants
							$MONTANT_PRIME = $montant_encaissement * ($tauxAssureur/100);
							$MONTANT_PRIME = number_format($MONTANT_PRIME, 2, '.', ' ');

							// COMMISSION POUR LE PARTENAIRE APPORTEUR D'AFFAIRES
							$PART_PARTENAIRE = $MONTANT_PRIME * ($partenaire_commission/100);
							$PART_PARTENAIRE = number_format($PART_PARTENAIRE, 2, '.', ' ');

							// PART POUR LE PARTENAIRE PARENT AFFILIE SI CELUI CI EST > 1 (<> OPRA SA)
							$PART_PARENT = 0;
							if($partenaire_parent != "" && $partenaire_parent > 1)
							{
								$PART_PARENT = $MONTANT_PRIME * ($partenaire_parent_commission/100);
								$PART_PARENT = number_format($PART_PARENT, 2, '.', ' ');
							}

							// recap calcul
							$CALCUL_ENCAISSEMENT = "";
							$CALCUL_ENCAISSEMENT .= "- Montant encaissement : ". $montant_encaissement;
							$CALCUL_ENCAISSEMENT .= "\n- Part assureur (".$partenaire_prime."%) : ". $MONTANT_PRIME; // = PART ORIGINE
							if($partenaire_parent != "" && $partenaire_parent > 1)
							{
								$CALCUL_ENCAISSEMENT .= "\n- Partenaire parent : ". $partenaire_parent_nom;
								$CALCUL_ENCAISSEMENT .= "\n- Part partenaire parent (".$partenaire_parent_commission."%) : ". $PART_PARENT; // 20% SI ID1 ou 5% SI ID>1 par défaut = PART PARTENAIRE
							}

							if($partenaire_id == 1) {
								$PART_PARTENAIRE = 0;
							} else {
								$CALCUL_ENCAISSEMENT .= "\n- Part apporteur (".$partenaire_commission."%) : ". $PART_PARTENAIRE;
							}

							if($debug){
								var_dump($CALCUL_ENCAISSEMENT);
							}

							// Mettre ici une inscription dans le journal des encaissements 
							// pour le(s) partenaire(s) & PLUS VALUE
							$dataJournalEncaissement = array(
															"ID_SOUSCRIPTEUR" => $customer->ID_SOUSCRIPTEUR,
															"ID_PARTENAIRE" => $partenaire_id,
															"DATE_ENCAISSEMENT" => date("Y-m-d H:i:s"),
															"AUTORISATION_TRANSACTION" => $transaction_id,
															"MONTANT_ENCAISSEMENT" => $montant_encaissement,
															"CALCUL_ENCAISSEMENT" => $CALCUL_ENCAISSEMENT,
															"CERTIFICAT_SOUSCRIPTEUR" => $newCertificatNumberFormatted,
															"PART_ASSUREUR" => $MONTANT_PRIME,
															"PART_APPORTEUR" => $PART_PARTENAIRE,
															"PART_PARENT" => $PART_PARENT,
															"VERSION_CALCUL" => $versionCalcul,
															"PAYLINE_TOKEN" => $transaction_token,
															"PAYLINE_VERSION" => $transaction_version,
															"PAYLINE_DATA" => $transaction_data
														);
							if($partenaire_parent != "")
							{
								$dataJournalEncaissement["IDP_ORIGINE"] = $partenaire_parent;
							}
							$insert = $this->encaissement_model->save($dataJournalEncaissement);

							if($insert == 0){
								$insert_errors = true;
								if($debug){
									var_dump("SQL ERROR ENCAISSEMENT", $insert, $dataJournalEncaissement);
								}
							} else {
								$updateIdEncaissement['TRANSACTION_ID'] = $insert;
								$updateIdEncaissement['BROUILLON_SOUSCRIPTION'] = 0;
								$updateIdEncaissement['BROUILLON_SESSION_SOUSCRIPTEUR'] = '';

								$updateCustomer = $this->souscripteurs_model->update($customer->ID_SOUSCRIPTEUR, $updateIdEncaissement);

								if($debug)
								{
									var_dump($updateCustomer);
								}
							}

							if($debug)
							{
								var_dump($insert_errors);
								var_dump("Journal encaissement sql : ", $insert);
							}

						}
					}

					// redirect if success
					if($insert_errors)
					{
						if($debug){
							var_dump("SQL ERROR INSERT ENCAISSEMENT");
						}
					}
					else
					{
						// SEND MAIL to client BBC partenaire
						foreach($array_privates_code as $customer_cert)
						{
							$customer_nom = $customer_cert['nom'];
							$customer_email = $customer_cert['email'];
							$customer_privatecode = $customer_cert['code'];
							$customer_assistancemonde = $customer_cert['assistancemonde'];

							$email = array(
										"type" => "certificat_paied",
										"to" => $customer_email,
										"bcc" => $partenaire_email,
										"PRIVATE_CODE" => $customer_privatecode,
										"LANG_SOUSCRIPTEUR" => getCurrentLang(),
											"nom" => $customer_nom,
											"assistancemonde" => $customer_assistancemonde
									);
							$mail = sendNewMail($email);
						}

						if(!$debug)
						{
							redirect($this->lang->line('page_slug_pricing').'/'.$tarifData['typeTarif'].'/'.$this->lang->line('pricing_slug_step').'6');
						}
						else
						{
							echo '<a href="'.base_url($this->lang->line('page_slug_pricing').'/'.$tarifData['typeTarif'].'/'.$this->lang->line('pricing_slug_step').'6').'">continuer</a>';
							var_dump("PAIEMENT SUCCES");
						}
					}
				}
			}
		}

		if($debug):
			echo "</pre>";
		endif;
	}

	public function phone_check($phone = null)
	{
		if(!is_null($phone)):
			// if only indicator : error
			$hasError = FALSE;
			$array = getIndicatorsArray();
			foreach($array as $row => $index)
			{
				if(strtr($phone, array("+" => "")) == $index)
				{
					$hasError = TRUE;
					break;
				}
			}

			if($hasError)
			{
				$this->form_validation->set_message('phone_check', $this->lang->line('error_phone_mandatory'));
				return FALSE;
			}
			else
			{
				return TRUE;
			}
		endif;
	}

	public function planeticket_date_check($date = null)
	{
		$debug = false;

		if(!is_null($date) && $date != ""):
			/* La date d’achat du billet doit être inférieure ou égale à 5 jours de la date du jour de souscription*/

			$date = getDateFormat($date);
			$date1 = new DateTime($date);  

			$date2 = new DateTime(date("Y-m-d"));
			$diff = $date1->diff($date2);

			if($debug):
				echo "<pre>";
				var_dump($date1, $date2);
				var_dump($diff->days);
				echo "<pre>";
			endif;

			if($date1 <= $date2 && $diff->days <= 5) {
			   return TRUE;
			} else {  
			    $this->form_validation->set_message('planeticket_date_check', $this->lang->line('form_error_option_plane_buy'));
			    return FALSE;
			}
		endif;
	}

	public function travel_date_check($date = null)
	{
		$debug = false;

		if(!is_null($date) && $date != ""):
			/*La date de départ doit être supérieure ou égale à 15 jours de la date du jour de souscription*/
			$date = getDateFormat($date);
			$date1 = new DateTime($date);  

			$date2 = new DateTime(date("Y-m-d"));
			$diff = $date1->diff($date2);

			if($debug):
				echo "<pre>";
				var_dump($date1, $date2);
				var_dump($diff->days);
				echo "<pre>";
			endif;

			if($date1 > $date2 && $diff->days >= 15) {
			   return TRUE;
			} else {  
			    $this->form_validation->set_message('travel_date_check', $this->lang->line('form_error_option_travel_date'));
			    return FALSE;
			}
		endif;
	}

	public function birthdate_check($date = null)
	{
		if(!is_null($date) && $date != ""):
			// check if 18 yo
			$date = getDateFormat($date);
			$bday = new DateTime($date);  
			$bday->add(new DateInterval("P18Y")); //adds time interval of 18 years to bday  
			//compare the added years to the current date  
			if($bday < new DateTime()){
			   return TRUE;
			}else{  
			    $this->form_validation->set_message('birthdate_check', $this->lang->line('error_birthdate_major'));
			    return FALSE;
			}
		endif;
	}

	public function dateeffet_check($date = null)
	{
		$debug_callback = false;
		if($_SERVER['REMOTE_ADDR'] == "128.78.125.179"):
			$debug_callback = false;
		endif;

		if(!is_null($date) && $date != ""):
			$date = getDateFormat($date)." ".date("H:i:s");
			$dateeffet = new DateTime($date); 
			$mindate = new DateTime(date("Y-m-d H:i:s", strtotime('+1day')));
			//compare the added years to the current date 

			if($debug_callback):
				echo "<pre>";
				var_dump($dateeffet);
				var_dump($mindate);
				var_dump($dateeffet >= $mindate);
				echo "</pre>";
			endif;

			if($dateeffet >= $mindate){
			   return TRUE;
			}else{  
			    $this->form_validation->set_message('dateeffet_check', $this->lang->line('error_date_effect'));
			    return FALSE;
			}
		endif;
	}

	public function dateheureeffet_check($date = null)
	{
		$debug_callback = false;
		if($_SERVER['REMOTE_ADDR'] == "128.78.125.179"):
			$debug_callback = false;
		endif;

		if(!is_null($date) && $date != ""):
			$time = mb_substr($date, 10, 5).':00';
			$date = getDateFormat(mb_substr($date, 0, 10));
			$dateeffet = new DateTime($date." ".$time); 
			$mindate = new DateTime(date("Y-m-d H:i:s", strtotime('+1day')));
			//compare the added years to the current date 

			if($debug_callback):
				echo "<pre>";
				var_dump($dateeffet);
				var_dump($mindate);
				var_dump($dateeffet >= $mindate);
				echo "</pre>";
				exit();
			endif;

			if($dateeffet >= $mindate){
			   return TRUE;
			}else{  
			    $this->form_validation->set_message('dateheureeffet_check', $this->lang->line('error_date_effect'));
			    return FALSE;
			}
		endif;
	}

	public function obtenir_un_tarif($typeTarif = '', $etape = '0') { //etape0
		$nbEtapes = 6;

		$this->load->model('assistancemonde_model'); // EDIT 2K17 : Assurance Monde

		$data = [];

		$data['label_rgpd'] = $this->lang->line('contact_rgpd');

		$data['nbEtapes'] = $nbEtapes;
		if($etape == '') { 
			$currentEtape = 0; 
		} else { 
			$currentEtape = $etape; 
			$currentEtape = strtr($etape, array($this->lang->line('pricing_slug_step') => ""));
			$currentEtape = (int)$currentEtape;
		}
		
		if(($currentEtape < 0 || $currentEtape > $nbEtapes) || ($typeTarif == '' && $currentEtape > 0)) {
			redirect($this->lang->line('page_slug_pricing'));
		}

		// main datas
			$data['currentEtape'] = $currentEtape;
			$data['formInfosEnd'] = $nbEtapes-1; // Form end (= etape 4)
			$data['typeTarif'] = $typeTarif;
			$data['dureeList'] = array(
										1 => $this->lang->line('form_pricing_list_1'),
										2 => $this->lang->line('form_pricing_list_2'),
										3 => $this->lang->line('form_pricing_list_3'),
										4 => $this->lang->line('form_pricing_list_4'),
										5 => $this->lang->line('form_pricing_list_5'),
										6 => $this->lang->line('form_pricing_list_6'),
										7 => $this->lang->line('form_pricing_list_7'),
										8 => $this->lang->line('form_pricing_list_8'),
										9 => $this->lang->line('form_pricing_list_9')
									);

		// get session to complete it
		if($this->session->userdata('tarifData')):
			$tarifData = $this->session->userdata('tarifData');
		else:
			// no session, create new one
			$tarifData = [];
			if($currentEtape > 1) {
				redirect($this->lang->line('page_slug_pricing'));
			} else {
				$this->session->set_userdata('tarifData', $tarifData);
			}
		endif;

		// ETAT DEVIS
		$data['etatDevis'] = false;
		if(isset($tarifData['DEVIS_SOUSCRIPTEUR']))
		{
			$data['etatDevis'] = $tarifData['DEVIS_SOUSCRIPTEUR'];
		}

		// check session validity
		if($currentEtape > 1)
		{
			if($currentEtape <= $data['formInfosEnd'])
			{
				if(!isset($tarifData['etape_'.($currentEtape-1).'_valid']) || !$tarifData['etape_'.($currentEtape-1).'_valid'])
				{
					redirect($this->lang->line('page_slug_pricing'));
				}
			} else if($currentEtape > $data['formInfosEnd'] && $currentEtape != $nbEtapes) {
				if(!isset($tarifData['etape_'.$data['formInfosEnd'].'_valid']) || !$tarifData['etape_'.$data['formInfosEnd'].'_valid'])
				{
					redirect($this->lang->line('page_slug_pricing'));
				}
			}
		}

		$tarifData['typeTarif'] = $typeTarif;

		if($currentEtape == $nbEtapes)
		{
			// dernière étape
			// vérifie si paiement OK
			$this->load->model('souscripteurs_model');

			if(!isset($tarifData['ID_SOUSCRIPTEUR']) || $tarifData['ID_SOUSCRIPTEUR'] == "" || !isset($tarifData['PRIVATE_CODE']) || $tarifData['PRIVATE_CODE'] == "")
			{
				// no session ID
				//var_dump("redirect 4");
				redirect($this->lang->line('page_slug_pricing'));
			}
			else
			{
				$certificats = $this->souscripteurs_model->findCustomers($tarifData['type_tarif'], $tarifData['ID_SOUSCRIPTEUR']);
				if(!$certificats)
				{
					// not found
					//var_dump("redirect 5");
					redirect($this->lang->line('page_slug_pricing'));
				}
				else
				{
					// certificats found , check  if paiement is ok
					$data['certificatsData'] = $certificats;
				}
			}

			// TODO
			// vide session (seulement si paiement OK)
			//$this->session->unset_userdata('tarifData');
			//$this->session->sess_destroy();
		}
		else
		{

			// check if the current etape has been validated (check the validity of the previous)
			if($currentEtape > 0 && $currentEtape < $data['formInfosEnd']) {
				$currentEtapeToCheck = (int)$currentEtape - 1;
				if(isset($tarifData['etape_'.$currentEtapeToCheck.'_valid']) && !$tarifData['etape_'.$currentEtapeToCheck.'_valid']) {
					redirect($this->lang->line('page_slug_pricing').'/');
				}
			}

			// Case if we go back and change the tarif type (individuel / collectif)
			if($this->input->post('type_tarif')) {
				$typeTarifNew = getLabelTarifType($this->input->post('type_tarif'));
				if($typeTarifNew != $typeTarif) {
					// empty session
					$tarifData = [];
					$this->session->set_userdata('tarifData', $tarifData);
					redirect($this->lang->line('page_slug_pricing').'/'.$typeTarifNew.'/'.$this->lang->line('pricing_slug_step').'1');
				}
			}

			// retrieve datas
				$data['inscritsCountA'] = "0";
				$data['inscritsCountB'] = "0";

				if($typeTarif == $this->lang->line('page_slug_pricing_collective')) 
				{
					$tarifData['type_tarif'] = "1";

					// categories Count
					if(isset($tarifData['collectif_personnes_identique']))
					{
						switch($tarifData['collectif_personnes_identique']) {
							case "0":

								// conditions similaires
								if($tarifData['categorie_sports'] == "A") {
									$data['inscritsCountA'] = $tarifData['personnes_nombre'];
									$data['inscritsCountB'] = "0";
								} else if($tarifData['categorie_sports'] == "B") {
									$data['inscritsCountA'] = "0";
									$data['inscritsCountB'] = $tarifData['personnes_nombre'];
								}

								// get tarif lists
								if((isset($tarifData['categorie_sports']) && $tarifData['categorie_sports'] != '') && 
									(isset($tarifData['tarif_duree']) != '' && $tarifData['tarif_duree'] != '')):
									$varDureeCalcul = getDureeDbTarif($tarifData['tarif_duree']);

									// load tarifs list
				

									$tarifListDb = $this->tarifs_model->get_tarifs_from_cat_v2($tarifData['categorie_sports']);
									$j=1;
									$tarifItem = [];
									foreach($tarifListDb as $tarifLine):
										if($varDureeCalcul == $tarifLine->duree_rang):
											$tarifItem = $tarifLine;
											break;
										endif;
										$j++;
									endforeach;
									$data['tarifsList'] = $tarifItem;
									$data['tarifsList_option1'] = $this->tarifs_model->get_tarifs_from_cat_v2("OPTION1");
									$data['tarifsList_option1b'] = $this->tarifs_model->get_tarifs_from_cat_v2("OPTION1B");
									$data['tarifsList_option2'] = $this->tarifs_model->get_tarifs_from_cat_v2("OPTION2");
								endif;

							break;

							case "1":

								$inscritsCountA = 0;
								$inscritsCountB = 0;

								// retrieve prime for each person & count categories
								for($p=1;$p<=$tarifData['personnes_nombre'];$p++):

									if($tarifData['categorie_sports_'.$p] == "A") {
										$inscritsCountA++; 
									} else if($tarifData['categorie_sports_'.$p] == "B") {
										$inscritsCountB++;
									}

									$varDureeCalcul = getDureeDbTarif($tarifData['tarif_duree_'.$p]);

									// load tarifs list
				
									$tarifListDb = $this->tarifs_model->get_tarifs_from_cat_v2($tarifData['categorie_sports_'.$p]);
									$j=1;
									$tarifItem = [];
									foreach($tarifListDb as $tarifLine):
										if($varDureeCalcul == $tarifLine->duree_rang):
											$tarifItem = $tarifLine;
											break;
										endif;
										$j++;
									endforeach;
									$data['tarifsList'][$p] = $tarifItem;
									$data['tarifsList_option1'][$p] = $this->tarifs_model->get_tarifs_from_cat_v2("OPTION1");
									$data['tarifsList_option1b'][$p] = $this->tarifs_model->get_tarifs_from_cat_v2("OPTION1B");
									$data['tarifsList_option2'][$p] = $this->tarifs_model->get_tarifs_from_cat_v2("OPTION2");
								endfor;

								$data['inscritsCountA'] = $inscritsCountA;
								$data['inscritsCountB'] = $inscritsCountB;

							break;
						}
						
					}

				}
				else if($typeTarif == $this->lang->line('page_slug_pricing_individual')) 
				{
					$tarifData['type_tarif'] = "0";

					if($typeTarif != '' && isset($tarifData['categorie_sports']) && $tarifData['categorie_sports'] != '')
					{
						// load tarifs list
						$data['tarifsList'] = $this->tarifs_model->get_tarifs_from_cat_v2($tarifData['categorie_sports']);
						$data['tarifsList_option1'] = $this->tarifs_model->get_tarifs_from_cat_v2("OPTION1");
						$data['tarifsList_option1b'] = $this->tarifs_model->get_tarifs_from_cat_v2("OPTION1B");
						$data['tarifsList_option2'] = $this->tarifs_model->get_tarifs_from_cat_v2("OPTION2");
					}
				}
			//

			if($_SERVER['REQUEST_METHOD'] == 'POST')
			{
				$etapeValidate = (int)$this->input->post('etape');

				// FORM step by step validation
				if($etapeValidate >= 0 && $etapeValidate <= $nbEtapes)
				{
					$etapeValidate = (int)$this->input->post('etape');
					if($etapeValidate == 0)
					{
						$this->form_validation->set_rules('type_tarif', 'Type de tarif', 'trim|required|numeric|xss_clean|strip_tags|greater_than_equal_to[0]|less_than_equal_to[1]');

						$tarifData['type_tarif'] = $this->input->post('type_tarif');

						$typeTarif = getLabelTarifType($tarifData['type_tarif']);
					}
					else
					{
						// rules for each etape
						if($typeTarif == $this->lang->line('page_slug_pricing_individual'))
						{
							// SOUSCRIPTION INDIVIDUELLE

							switch($etapeValidate){
								case 1:
									$this->form_validation->set_rules('capital_montant', $this->lang->line('form_insured_capital'), 'trim|required|numeric|xss_clean|strip_tags|greater_than_equal_to[10000]|less_than_equal_to[200000]');
									$this->form_validation->set_rules('categorie_sports', $this->lang->line('form_category'), 'trim|required|min_length[1]|max_length[1]|xss_clean|strip_tags');
									$this->form_validation->set_rules('assistance_monde', $this->lang->line('form_assistance'), 'trim|min_length[1]|max_length[1]|xss_clean|strip_tags');
									$this->form_validation->set_rules('assistance_monde_option', $this->lang->line('form_assistance').' option', 'trim|xss_clean|strip_tags');
									$this->form_validation->set_rules('annulation_voyage', $this->lang->line('form_annulation_voyage'), 'trim|min_length[1]|max_length[1]|xss_clean|strip_tags');

									$tarifData['capital_montant'] = $this->input->post('capital_montant');
									$tarifData['categorie_sports'] = $this->input->post('categorie_sports');
									$tarifData['assistance_monde'] = $this->input->post('assistance_monde');
									$tarifData['assistance_monde_option'] = $this->input->post('assistance_monde_option');

									$tarifData['annulation_voyage'] = $this->input->post('annulation_voyage');
									if($tarifData['annulation_voyage'] == "1"):
										$this->form_validation->set_rules('date_achat_billet_avion', $this->lang->line('form_annulation_field_buy'), 'trim|required|min_length[10]|max_length[10]|xss_clean|strip_tags|callback_planeticket_date_check');
										$this->form_validation->set_rules('date_depart_voyage', $this->lang->line('form_annulation_field_departure'), 'trim|required|min_length[10]|max_length[10]|xss_clean|strip_tags|callback_travel_date_check');

										$tarifData['date_achat_billet_avion'] = $this->input->post('date_achat_billet_avion');
										$tarifData['date_depart_voyage'] = $this->input->post('date_depart_voyage');
									else:
										$tarifData['date_achat_billet_avion'] = "";
										$tarifData['date_depart_voyage'] = "";
									endif;

									// reinit datas to recalcule if user goes back
									if(!isset($tarifData['is_quotation_step_1']) || !$tarifData['is_quotation_step_1']):
										$tarifData['tarif_id'] = "";
										$tarifData['tarif_prime'] = "";
										$tarifData['tarif_duree'] = "";
										$tarifData['tarif_tauxindacc'] = "";
										$tarifData['tarif_option1'] = "";
										$tarifData['tarif_option1b'] = "";
										$tarifData['tarif_option2'] = "";
									endif;

									if(isset($tarifData['is_quotation_step_1']) && $tarifData['is_quotation_step_1']):
										$tarifData['is_quotation_step_1'] = false;
									endif;

									// retour étape arrière, reset devis
									$tarifData['DEVIS_SOUSCRIPTEUR'] = false;
									$tarifData['BROUILLON_SOUSCRIPTION'] = 0;
									$tarifData['DEVIS_DATE_SOUSCRIPTEUR'] = "";
									$tarifData['DEVIS_NUMERO_SOUSCRIPTEUR'] = "";
									$tarifData['BROUILLON_SESSION_SOUSCRIPTEUR'] = "";

								break;

								case 2:

									$this->form_validation->set_rules('tarif_id', $this->lang->line('form_tarif'), 'trim|required|numeric|xss_clean|strip_tags');
									$this->form_validation->set_rules('tarif_duree', $this->lang->line('form_duration'), 'trim|required|xss_clean|strip_tags');
									$this->form_validation->set_rules('tarif_prime', $this->lang->line('form_premium'), 'trim|required|numeric|xss_clean|strip_tags');
									$this->form_validation->set_rules('tarif_tauxindacc', $this->lang->line('form_acc_ind_rate'), 'trim|required|numeric|xss_clean|strip_tags');
									$this->form_validation->set_rules('tarif_option1', $this->lang->line('form_prime_option1'), 'trim|required|numeric|xss_clean|strip_tags');
									$this->form_validation->set_rules('tarif_option1b', $this->lang->line('form_prime_option1b'), 'trim|required|numeric|xss_clean|strip_tags');
									$this->form_validation->set_rules('tarif_option2', $this->lang->line('form_prime_option2'), 'trim|required|numeric|xss_clean|strip_tags');

									$tarifData['tarif_id'] = $this->input->post('tarif_id');
									$tarifData['tarif_prime'] = $this->input->post('tarif_prime');
									$tarifData['tarif_duree'] = $this->input->post('tarif_duree');
									$tarifData['tarif_tauxindacc'] = $this->input->post('tarif_tauxindacc');
									$tarifData['tarif_option1'] = $this->input->post('tarif_option1');
									$tarifData['tarif_option1b'] = $this->input->post('tarif_option1b');
									$tarifData['tarif_option2'] = $this->input->post('tarif_option2');

									// retour étape arrière, reset devis
									$tarifData['DEVIS_SOUSCRIPTEUR'] = false;
									$tarifData['BROUILLON_SOUSCRIPTION'] = 0;
									$tarifData['DEVIS_DATE_SOUSCRIPTEUR'] = "";
									$tarifData['DEVIS_NUMERO_SOUSCRIPTEUR'] = "";
									$tarifData['BROUILLON_SESSION_SOUSCRIPTEUR'] = "";

									if(isset($tarifData['is_quotation_step_2']) && $tarifData['is_quotation_step_2']):
										$tarifData['is_quotation_step_2'] = false;
									endif;

								break;

								case 3:
									// form coordonnées
									$p=1;
									$this->form_validation->set_rules('assure_prenom_'.$p, $this->lang->line('form_firstname'), 'trim|required|min_length[1]|max_length[32]|xss_clean|strip_tags');
									$this->form_validation->set_rules('assure_nom_'.$p, $this->lang->line('form_lastname'), 'trim|min_length[1]|max_length[32]|xss_clean|strip_tags');
									$this->form_validation->set_rules('assure_naissance_'.$p, $this->lang->line('form_birthdate'), 'trim|required|min_length[10]|max_length[10]|xss_clean|strip_tags|callback_birthdate_check');
									
									$this->form_validation->set_rules('assure_adresse1_'.$p, $this->lang->line('form_address'), 'trim|required|min_length[1]|max_length[100]|xss_clean|strip_tags');
									$this->form_validation->set_rules('assure_adresse2_'.$p, $this->lang->line('form_address_2'), 'trim|min_length[1]|max_length[100]|xss_clean|strip_tags');
									$this->form_validation->set_rules('assure_codepostal_'.$p, $this->lang->line('form_zipcode'), 'trim|required|min_length[1]|max_length[10]|xss_clean|strip_tags');
									$this->form_validation->set_rules('assure_ville_'.$p, $this->lang->line('form_city'), 'trim|required|min_length[1]|max_length[50]|xss_clean|strip_tags');
									$this->form_validation->set_rules('assure_pays_'.$p, $this->lang->line('form_country'), 'trim|required|min_length[1]|max_length[100]|xss_clean|strip_tags');

									$this->form_validation->set_rules('assure_telephone_'.$p, $this->lang->line('form_phone'), 'trim|min_length[1]|max_length[20]|xss_clean|strip_tags');
									$this->form_validation->set_rules('assure_mobile_'.$p, $this->lang->line('form_mobile'), 'trim|required|min_length[1]|max_length[20]|xss_clean|strip_tags|callback_phone_check');
									$this->form_validation->set_rules('assure_email_'.$p, $this->lang->line('form_mail'), 'trim|required|valid_email|min_length[1]|max_length[100]|xss_clean|strip_tags');

									$this->form_validation->set_rules('assure_typedateeffet_'.$p, $this->lang->line('form_type_effect'), 'trim|numeric|required|greater_than_equal_to[0]|less_than_equal_to[1]|xss_clean|strip_tags');

									//if($this->input->post('assure_typedateeffet_'.$p) == "1") {
										$this->form_validation->set_rules('assure_dateeffet_'.$p, $this->lang->line('form_date_effect'), 'trim|required|min_length[10]|max_length[10]|xss_clean|strip_tags|callback_dateeffet_check');
										$this->form_validation->set_rules('assure_dateeffetheure_'.$p, $this->lang->line('form_hour_effect'), 'trim|required|min_length[5]|max_length[5]|xss_clean|strip_tags');
									//}
									if($_SERVER['REMOTE_ADDR'] == "128.78.125.179"):
										var_dump($this->input->post('assure_dateheure_effet_'.$p));
									endif;

									$this->form_validation->set_rules('assure_dateheure_effet_'.$p, $this->lang->line('form_date_effect'), 'trim|required|min_length[10]|xss_clean|strip_tags|callback_dateheureeffet_check');

									$this->form_validation->set_rules('assure_beneficiaire_'.$p, $this->lang->line('form_beneficiary'), 'trim|required|max_length[100]|xss_clean|strip_tags');
									$this->form_validation->set_rules('assure_sport_'.$p, $this->lang->line('form_sport'), 'trim|max_length[100]|xss_clean|strip_tags');

									$this->form_validation->set_rules('assure_conditions_'.$p, $this->lang->line('form_general_conditions'), 'trim|required|numeric|greater_than_equal_to[1]|less_than_equal_to[1]|xss_clean|strip_tags');

									$tarifData['infos_assure']['assure_nom_'.$p] = $this->input->post('assure_nom_'.$p);
									$tarifData['infos_assure']['assure_prenom_'.$p] = $this->input->post('assure_prenom_'.$p);
									$tarifData['infos_assure']['assure_naissance_'.$p] = $this->input->post('assure_naissance_'.$p);
									$tarifData['infos_assure']['assure_adresse1_'.$p] = $this->input->post('assure_adresse1_'.$p);
									$tarifData['infos_assure']['assure_adresse2_'.$p] = $this->input->post('assure_adresse2_'.$p);
									$tarifData['infos_assure']['assure_codepostal_'.$p] = $this->input->post('assure_codepostal_'.$p);
									$tarifData['infos_assure']['assure_ville_'.$p] = $this->input->post('assure_ville_'.$p);
									$tarifData['infos_assure']['assure_pays_'.$p] = $this->input->post('assure_pays_'.$p);

									$tarifData['infos_assure']['assure_telephone_'.$p] = $this->input->post('assure_telephone_'.$p);
									// remove if only indicator
									$indicator = getCountryPhoneIndicator($this->input->post('assure_pays_'.$p));
									if($tarifData['infos_assure']['assure_telephone_'.$p] == $indicator){
										$tarifData['infos_assure']['assure_telephone_'.$p] = "";
									}
									$tarifData['infos_assure']['assure_mobile_'.$p] = $this->input->post('assure_mobile_'.$p);
									$tarifData['infos_assure']['assure_email_'.$p] = $this->input->post('assure_email_'.$p);
									$tarifData['infos_assure']['assure_typedateeffet_'.$p] = $this->input->post('assure_typedateeffet_'.$p);
									$tarifData['infos_assure']['assure_dateeffet_'.$p] = $this->input->post('assure_dateeffet_'.$p);
									$tarifData['infos_assure']['assure_dateeffetheure_'.$p] = $this->input->post('assure_dateeffetheure_'.$p);

									$tarifData['infos_assure']['assure_dateheure_effet_'.$p] = $this->input->post('assure_dateheure_effet_'.$p);
									$tarifData['infos_assure']['assure_beneficiaire_'.$p] = $this->input->post('assure_beneficiaire_'.$p);
									$tarifData['infos_assure']['assure_sport_'.$p] = $this->input->post('assure_sport_'.$p);
									$tarifData['infos_assure']['assure_conditions_'.$p] = $this->input->post('assure_conditions_'.$p);

									// retour étape arrière, reset devis
									$tarifData['DEVIS_SOUSCRIPTEUR'] = false;
									$tarifData['BROUILLON_SOUSCRIPTION'] = 0;
									$tarifData['DEVIS_DATE_SOUSCRIPTEUR'] = "";
									$tarifData['DEVIS_NUMERO_SOUSCRIPTEUR'] = "";
									$tarifData['BROUILLON_SESSION_SOUSCRIPTEUR'] = "";

									if(isset($tarifData['is_quotation_step_3']) && $tarifData['is_quotation_step_3']):
										$tarifData['is_quotation_step_3'] = false;
									endif;

								break;

								case 4:
									$this->form_validation->set_rules('assure_recap', 'Récapitulatif', 'trim|required|numeric|greater_than_equal_to[1]|less_than_equal_to[1]|xss_clean|strip_tags');

									if(isset($tarifData['is_quotation_step_4']) && $tarifData['is_quotation_step_4']):
										$tarifData['is_quotation_step_4'] = false;
									endif;
								break;

							}

						} else if($typeTarif == $this->lang->line('page_slug_pricing_collective')) {
							// SOUSCRIPTION COLLECTIF

							switch($etapeValidate){
								case 1:
									$this->form_validation->set_rules('personnes_nombre', 'Nombre de personnes à assurer', 'trim|required|numeric|xss_clean|strip_tags|greater_than_equal_to[2]|less_than_equal_to[30]');
									$this->form_validation->set_rules('collectif_personnes_identique', 'Infos identiques pour chaque personnes', 'trim|required|numeric|greater_than_equal_to[0]|less_than_equal_to[1]|xss_clean|strip_tags');

									$tarifData['personnes_nombre'] = $this->input->post('personnes_nombre');
									$tarifData['collectif_personnes_identique'] = $this->input->post('collectif_personnes_identique');

									if(!isset($tarifData['is_quotation_step_1']) || !$tarifData['is_quotation_step_1']):
										// reset to re-save if user goes back
										$tarifData['tarif_duree'] = "";
										$tarifData['tarif_id'] = "";
										$tarifData['tarif_prime'] = "";
										$tarifData['tarif_tauxindacc'] = "";
										$tarifData['tarif_option1'] = "";
										$tarifData['tarif_option1b'] = "";
										$tarifData['tarif_option2'] = "";
										$tarifData['capital_montant'] = "";
										$tarifData['categorie_sports'] = "";
										$tarifData['assistance_monde'] = "";
										$tarifData['assistance_monde_option'] = "";
									endif;

									if(isset($tarifData['is_quotation_step_1']) && $tarifData['is_quotation_step_1']):
										$tarifData['is_quotation_step_1'] = false;
									endif;

									if(isset($tarifData['personnes_nombre']) && isset($tarifData['collectif_personnes_identique']) && $tarifData['collectif_personnes_identique'] == "1") 
									{
										// conditions au cas par cas
										for($p=1;$p<=$tarifData['personnes_nombre'];$p++)
										{
											$tarifData['tarif_duree_'.$p] = "";
											$tarifData['tarif_id_'.$p] = "";
											$tarifData['tarif_prime_'.$p] = "";
											$tarifData['tarif_tauxindacc_'.$p] = "";
											$tarifData['tarif_option1_'.$p] = "";
											$tarifData['tarif_option1b_'.$p] = "";
											$tarifData['tarif_option2_'.$p] = "";
											$tarifData['capital_montant_'.$p] = "";
											$tarifData['categorie_sports_'.$p] = "";
											$tarifData['assistance_monde_'.$p] = "";
											$tarifData['assistance_monde_option_'.$p] = "";
											$tarifData['annulation_voyage_'.$p] = "";
											$tarifData['date_achat_billet_avion_'.$p] = "";
											$tarifData['date_depart_voyage_'.$p] = "";
										}
									}

									// retour étape arrière, reset devis
									$tarifData['DEVIS_SOUSCRIPTEUR'] = false;
									$tarifData['BROUILLON_SOUSCRIPTION'] = 0;
									$tarifData['DEVIS_DATE_SOUSCRIPTEUR'] = "";
									$tarifData['DEVIS_NUMERO_SOUSCRIPTEUR'] = "";
									$tarifData['BROUILLON_SESSION_SOUSCRIPTEUR'] = "";

								break;

								case 2:

									$this->form_validation->set_rules('assistance_monde', $this->lang->line('form_assistance'), 'trim|min_length[1]|max_length[1]|xss_clean|strip_tags');
									$tarifData['assistance_monde'] = $this->input->post('assistance_monde');

									$this->form_validation->set_rules('assistance_monde_option', $this->lang->line('form_assistance').' option', 'trim|xss_clean|strip_tags');
									$tarifData['assistance_monde_option'] = $this->input->post('assistance_monde_option');

									$tarifData['annulation_voyage'] = $this->input->post('annulation_voyage');

									if($tarifData['annulation_voyage'] == "1"):
										$this->form_validation->set_rules('date_achat_billet_avion', $this->lang->line('form_annulation_field_buy'), 'trim|required|min_length[10]|max_length[10]|xss_clean|strip_tags|callback_planeticket_date_check');
										$this->form_validation->set_rules('date_depart_voyage', $this->lang->line('form_annulation_field_departure'), 'trim|required|min_length[10]|max_length[10]|xss_clean|strip_tags|callback_travel_date_check');
										$tarifData['date_achat_billet_avion'] = $this->input->post('date_achat_billet_avion');
										$tarifData['date_depart_voyage'] = $this->input->post('date_depart_voyage');
									else:
										$tarifData['date_achat_billet_avion'] = "";
										$tarifData['date_depart_voyage'] = "";
									endif;
									//

									if($tarifData['collectif_personnes_identique'] == "0")
									{
										// identique
										
										$this->form_validation->set_rules('capital_montant', $this->lang->line('form_insured_capital'), 'trim|required|numeric|xss_clean|strip_tags|greater_than_equal_to[10000]|less_than_equal_to[200000]');
										$this->form_validation->set_rules('categorie_sports', $this->lang->line('form_category'), 'trim|required|min_length[1]|max_length[1]|xss_clean|strip_tags');
										$this->form_validation->set_rules('tarif_duree', $this->lang->line('form_contrat_duration'), 'trim|required|xss_clean|strip_tags');

										// conditions similaires
										$tarifData['capital_montant'] = $this->input->post('capital_montant');
										$tarifData['categorie_sports'] = $this->input->post('categorie_sports');
										$tarifData['tarif_duree'] = $this->input->post('tarif_duree');

										if(!isset($tarifData['is_quotation_step_2']) || !$tarifData['is_quotation_step_2']):
											// reset if go back at this etape
											$tarifData['tarif_id'] = "";
											$tarifData['tarif_prime'] = "";
											$tarifData['tarif_tauxindacc'] = "";
											$tarifData['tarif_option1'] = "";
											$tarifData['tarif_option1b'] = "";
											$tarifData['tarif_option2'] = "";
										endif;
									} 
									else if($tarifData['collectif_personnes_identique'] == "1") 
									{
										// conditions au cas par cas
										$hasAssistance = 0; 
										$hasAnnulationVoyage = 0;
										for($p=1;$p<=$tarifData['personnes_nombre'];$p++)
										{
											$this->form_validation->set_rules('capital_montant_'.$p, $this->lang->line('form_insured_capital').' '.$this->lang->line('form_registered').' '.$p, 'trim|required|numeric|xss_clean|strip_tags|greater_than_equal_to[10000]|less_than_equal_to[200000]');
											$this->form_validation->set_rules('categorie_sports_'.$p, $this->lang->line('form_category').' '.$this->lang->line('form_registered').' '.$p, 'trim|required|min_length[1]|max_length[1]|xss_clean|strip_tags');
											$this->form_validation->set_rules('tarif_duree_'.$p, $this->lang->line('form_contrat_duration').' '.$this->lang->line('form_registered').' '.$p, 'trim|required|xss_clean|strip_tags');
											//$this->form_validation->set_rules('assistance_monde_'.$p, $this->lang->line('form_assistance').' '.$this->lang->line('form_registered').' '.$p, 'trim|min_length[1]|max_length[1]|xss_clean|strip_tags');
											$this->form_validation->set_rules('assistance_monde_option', 'Assistance monde option', 'trim|xss_clean|strip_tags');
											$this->form_validation->set_rules('annulation_voyage_'.$p, $this->lang->line('form_annulation_voyage').' '.$this->lang->line('form_registered').' '.$p, 'trim|min_length[1]|max_length[1]|xss_clean|strip_tags');

											if($tarifData['annulation_voyage_'.$p] == "1"):
												$this->form_validation->set_rules('date_achat_billet_avion_'.$p, $this->lang->line('form_annulation_field_buy').' '.$this->lang->line('form_registered').' '.$p, 'trim|required|min_length[10]|max_length[10]|xss_clean|strip_tags|callback_planeticket_date_check');
												$this->form_validation->set_rules('date_depart_voyage_'.$p, $this->lang->line('form_annulation_field_departure').' '.$this->lang->line('form_registered').' '.$p, 'trim|required|min_length[10]|max_length[10]|xss_clean|strip_tags|callback_travel_date_check');
											endif;

											// conditions similaires
											$tarifData['capital_montant_'.$p] = $this->input->post('capital_montant_'.$p);
											$tarifData['categorie_sports_'.$p] = $this->input->post('categorie_sports_'.$p);
											$tarifData['tarif_duree_'.$p] = $this->input->post('tarif_duree_'.$p);
											$tarifData['assistance_monde_option_'.$p] = $this->input->post('assistance_monde_option_'.$p);
											if(intval($tarifData['assistance_monde_option_'.$p]) != 2):
												$tarifData['assistance_monde_'.$p] = 1;
											else:
												$tarifData['assistance_monde_'.$p] = 0;
											endif;
											$tarifData['annulation_voyage_'.$p] = $this->input->post('annulation_voyage_'.$p);

											if(intval($tarifData['annulation_voyage_'.$p]) == 1):
												$tarifData['date_achat_billet_avion_'.$p] = $this->input->post('date_achat_billet_avion_'.$p);
												$tarifData['date_depart_voyage_'.$p] = $this->input->post('date_depart_voyage_'.$p);
											else:
												$tarifData['date_achat_billet_avion_'.$p] = "";
												$tarifData['date_depart_voyage_'.$p] = "";
											endif;

											if(!isset($tarifData['is_quotation_step_2']) || !$tarifData['is_quotation_step_2']):
												// reset if go back at this etape
												$tarifData['tarif_id_'.$p] = "";
												$tarifData['tarif_prime_'.$p] = "";
												$tarifData['tarif_tauxindacc_'.$p] = "";
												$tarifData['tarif_option1_'.$p] = "";
												$tarifData['tarif_option1b_'.$p] = "";
												$tarifData['tarif_option2_'.$p] = "";
											endif;

											if($tarifData['tarif_option1_'.$p] != "" || $tarifData['tarif_option1b_'.$p] != "")
											{
												$hasAssistance = 1;
											}
											if($tarifData['annulation_voyage_'.$p] == 1)
											{
												$hasAnnulationVoyage = 1;
											}

										}
										$tarifData['assistance_monde'] = $hasAssistance;
										$tarifData['annulation_voyage'] = $hasAnnulationVoyage;
									}

									if(isset($tarifData['is_quotation_step_2']) && $tarifData['is_quotation_step_2']):
										$tarifData['is_quotation_step_2'] = false;
									endif;

									// retour étape arrière, reset devis
									$tarifData['DEVIS_SOUSCRIPTEUR'] = false;
									$tarifData['BROUILLON_SOUSCRIPTION'] = 0;
									$tarifData['DEVIS_DATE_SOUSCRIPTEUR'] = "";
									$tarifData['DEVIS_NUMERO_SOUSCRIPTEUR'] = "";
									$tarifData['BROUILLON_SESSION_SOUSCRIPTEUR'] = "";

								break;

								case 3:

									if($tarifData['collectif_personnes_identique'] == "0")
									{
										// conditions similaires
										$this->form_validation->set_rules('tarif_id', $this->lang->line('form_price'), 'trim|required|numeric|xss_clean|strip_tags');
										$this->form_validation->set_rules('tarif_prime', $this->lang->line('form_premium'), 'trim|required|numeric|xss_clean|strip_tags');
										$this->form_validation->set_rules('tarif_tauxindacc', $this->lang->line('form_acc_ind_rate'), 'trim|required|numeric|xss_clean|strip_tags');
										$this->form_validation->set_rules('tarif_option1', $this->lang->line('form_prime_option1'), 'trim|required|numeric|xss_clean|strip_tags');
										$this->form_validation->set_rules('tarif_option1b', $this->lang->line('form_prime_option1b'), 'trim|required|numeric|xss_clean|strip_tags');
										$this->form_validation->set_rules('tarif_option2', $this->lang->line('form_prime_option2'), 'trim|required|numeric|xss_clean|strip_tags');

										$tarifData['tarif_id'] = $this->input->post('tarif_id');
										$tarifData['tarif_prime'] = $this->input->post('tarif_prime');
										$tarifData['tarif_tauxindacc'] = $this->input->post('tarif_tauxindacc');
										$tarifData['tarif_option1'] = $this->input->post('tarif_option1');
										$tarifData['tarif_option1b'] = $this->input->post('tarif_option1b');
										$tarifData['tarif_option2'] = $this->input->post('tarif_option2');
									} 
									else if($tarifData['collectif_personnes_identique'] == "1") 
									{
										for($p=1;$p<=$tarifData['personnes_nombre'];$p++)
										{
											// conditions au cas par cas
											$this->form_validation->set_rules('tarif_id_'.$p, $this->lang->line('form_price').' '.$this->lang->line('form_registered').' '.$p, 'trim|required|numeric|xss_clean|strip_tags');
											$this->form_validation->set_rules('tarif_prime_'.$p, $this->lang->line('form_premium').' '.$this->lang->line('form_registered').' '.$p, 'trim|required|numeric|xss_clean|strip_tags');
											$this->form_validation->set_rules('tarif_tauxindacc_'.$p, $this->lang->line('form_acc_ind_rate').' '.$this->lang->line('form_registered').' '.$p, 'trim|required|numeric|xss_clean|strip_tags');
											$this->form_validation->set_rules('tarif_option1_'.$p, $this->lang->line('form_prime_option1').' '.$this->lang->line('form_registered').' '.$p, 'trim|required|numeric|xss_clean|strip_tags');
											$this->form_validation->set_rules('tarif_option1b_'.$p, $this->lang->line('form_prime_option1b').' '.$this->lang->line('form_registered').' '.$p, 'trim|required|numeric|xss_clean|strip_tags');
											$this->form_validation->set_rules('tarif_option2_'.$p, $this->lang->line('form_prime_option2').' '.$this->lang->line('form_registered').' '.$p, 'trim|required|numeric|xss_clean|strip_tags');

											$tarifData['tarif_id_'.$p] = $this->input->post('tarif_id_'.$p);
											$tarifData['tarif_prime_'.$p] = $this->input->post('tarif_prime_'.$p);
											$tarifData['tarif_tauxindacc_'.$p] = $this->input->post('tarif_tauxindacc_'.$p);
											$tarifData['tarif_option1_'.$p] = $this->input->post('tarif_option1_'.$p);
											$tarifData['tarif_option1b_'.$p] = $this->input->post('tarif_option1b_'.$p);
											$tarifData['tarif_option2_'.$p] = $this->input->post('tarif_option2_'.$p);
										}
									}

									// totaux
									$this->form_validation->set_rules('assure_tarif_total', $this->lang->line('form_premium_total'), 'trim|required|numeric|xss_clean|strip_tags');
									$this->form_validation->set_rules('assure_A_total', $this->lang->line('form_nb_registered_cat').' A', 'trim|required|numeric|xss_clean|strip_tags');
									$this->form_validation->set_rules('assure_B_total', $this->lang->line('form_nb_registered_cat').' B', 'trim|required|numeric|xss_clean|strip_tags');

									$tarifData['cumulPrimes'] = $this->input->post('assure_tarif_total');
									$tarifData['inscritsCountA'] = $this->input->post('assure_A_total');
									$tarifData['inscritsCountB'] = $this->input->post('assure_B_total');

									// cgv
									$this->form_validation->set_rules('assure_conditions', $this->lang->line('form_general_conditions'), 'trim|required|numeric|greater_than_equal_to[1]|less_than_equal_to[1]|xss_clean|strip_tags');

									$tarifData['infos_assure']['assure_conditions'] = $this->input->post('assure_conditions');

									// infos assurés
									// form coordonnées
									for($p=1;$p<=intval($tarifData['personnes_nombre']);$p++)
									{
										$this->form_validation->set_rules('form_infos_validation_'.$p, $this->lang->line('form_registered').' '.$p.' infos', 'trim|required|numeric|greater_than_equal_to[0]|less_than_equal_to[1]|xss_clean|strip_tags');

										$this->form_validation->set_rules('assure_prenom_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_firstname'), 'trim|required|min_length[1]|max_length[32]|xss_clean|strip_tags');
										$this->form_validation->set_rules('assure_nom_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_lastname'), 'trim|min_length[1]|max_length[32]|xss_clean|strip_tags');
										$this->form_validation->set_rules('assure_naissance_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_birthdate'), 'trim|required|min_length[10]|max_length[10]|xss_clean|strip_tags|callback_birthdate_check');
										
										$this->form_validation->set_rules('assure_adresse1_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_address'), 'trim|required|min_length[1]|max_length[100]|xss_clean|strip_tags');
										$this->form_validation->set_rules('assure_adresse2_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_address_2'), 'trim|min_length[1]|max_length[100]|xss_clean|strip_tags');
										$this->form_validation->set_rules('assure_codepostal_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_zipcode'), 'trim|required|min_length[1]|max_length[10]|xss_clean|strip_tags');
										$this->form_validation->set_rules('assure_ville_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_city'), 'trim|required|min_length[1]|max_length[50]|xss_clean|strip_tags');
										$this->form_validation->set_rules('assure_pays_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_country'), 'trim|required|min_length[1]|max_length[100]|xss_clean|strip_tags');

										$this->form_validation->set_rules('assure_telephone_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_phone'), 'trim|min_length[1]|max_length[20]|xss_clean|strip_tags');
										$this->form_validation->set_rules('assure_mobile_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_mobile'), 'trim|required|min_length[1]|max_length[20]|xss_clean|strip_tags|callback_phone_check');
										$this->form_validation->set_rules('assure_email_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_mail_short'), 'trim|required|valid_email|min_length[1]|max_length[100]|xss_clean|strip_tags');

										$this->form_validation->set_rules('assure_typedateeffet_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_type_effect'), 'trim|numeric|required|greater_than_equal_to[0]|less_than_equal_to[1]|xss_clean|strip_tags');

										//if($this->input->post('assure_typedateeffet_'.$p) == "1") {
											$this->form_validation->set_rules('assure_dateeffet_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_date_effect'), 'trim|required|min_length[10]|max_length[10]|xss_clean|strip_tags|callback_dateeffet_check');
											$this->form_validation->set_rules('assure_dateeffetheure_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_hour_effect'), 'trim|required|min_length[5]|max_length[5]|xss_clean|strip_tags');
										//}

										$this->form_validation->set_rules('assure_dateheure_effet_'.$p, $this->lang->line('form_mobile'), 'trim|required|min_length[10]|xss_clean|strip_tags|callback_dateheureeffet_check');

										$this->form_validation->set_rules('assure_beneficiaire_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_beneficiary'), 'trim|required|max_length[100]|xss_clean|strip_tags');
										$this->form_validation->set_rules('assure_sport_'.$p, $this->lang->line('form_registered').' '.$p.' - '.$this->lang->line('form_sport'), 'trim|max_length[100]|xss_clean|strip_tags');

										$tarifData['infos_assure']['form_infos_validation_'.$p] = $this->input->post('form_infos_validation_'.$p);

										$tarifData['infos_assure']['assure_nom_'.$p] = $this->input->post('assure_nom_'.$p);
										$tarifData['infos_assure']['assure_prenom_'.$p] = $this->input->post('assure_prenom_'.$p);
										$tarifData['infos_assure']['assure_naissance_'.$p] = $this->input->post('assure_naissance_'.$p);
										$tarifData['infos_assure']['assure_adresse1_'.$p] = $this->input->post('assure_adresse1_'.$p);
										$tarifData['infos_assure']['assure_adresse2_'.$p] = $this->input->post('assure_adresse2_'.$p);
										$tarifData['infos_assure']['assure_codepostal_'.$p] = $this->input->post('assure_codepostal_'.$p);
										$tarifData['infos_assure']['assure_ville_'.$p] = $this->input->post('assure_ville_'.$p);
										$tarifData['infos_assure']['assure_pays_'.$p] = $this->input->post('assure_pays_'.$p);

										$tarifData['infos_assure']['assure_telephone_'.$p] = $this->input->post('assure_telephone_'.$p);
										// remove if only indicator
										$indicator = getCountryPhoneIndicator($this->input->post('assure_pays_'.$p));
										if($tarifData['infos_assure']['assure_telephone_'.$p] == $indicator){
											$tarifData['infos_assure']['assure_telephone_'.$p] = "";
										}
										$tarifData['infos_assure']['assure_mobile_'.$p] = $this->input->post('assure_mobile_'.$p);
										$tarifData['infos_assure']['assure_email_'.$p] = $this->input->post('assure_email_'.$p);
										$tarifData['infos_assure']['assure_typedateeffet_'.$p] = $this->input->post('assure_typedateeffet_'.$p);
										$tarifData['infos_assure']['assure_dateeffet_'.$p] = $this->input->post('assure_dateeffet_'.$p);
										$tarifData['infos_assure']['assure_dateeffetheure_'.$p] = $this->input->post('assure_dateeffetheure_'.$p);
										$tarifData['infos_assure']['assure_dateheure_effet_'.$p] = $this->input->post('assure_dateheure_effet_'.$p);
										$tarifData['infos_assure']['assure_beneficiaire_'.$p] = $this->input->post('assure_beneficiaire_'.$p);
										$tarifData['infos_assure']['assure_sport_'.$p] = $this->input->post('assure_sport_'.$p);
									}

									// retour étape arrière, reset devis
									$tarifData['DEVIS_SOUSCRIPTEUR'] = false;
									$tarifData['BROUILLON_SOUSCRIPTION'] = 0;
									$tarifData['DEVIS_DATE_SOUSCRIPTEUR'] = "";
									$tarifData['DEVIS_NUMERO_SOUSCRIPTEUR'] = "";
									$tarifData['BROUILLON_SESSION_SOUSCRIPTEUR'] = "";

									if(isset($tarifData['is_quotation_step_3']) && $tarifData['is_quotation_step_3']):
										$tarifData['is_quotation_step_3'] = false;
									endif;

								break;

								case 4:
									$this->form_validation->set_rules('assure_recap', $this->lang->line('form_recap'), 'trim|required|numeric|greater_than_equal_to[1]|less_than_equal_to[1]|xss_clean|strip_tags');

									if(isset($tarifData['is_quotation_step_4']) && $tarifData['is_quotation_step_4']):
										$tarifData['is_quotation_step_4'] = false;
									endif;
								break;

							}
						}
					}

					$stepIsOK = false;
					$tarifData['etape_'.$etapeValidate.'_valid'] = false;
					if(!$this->form_validation->run() == FALSE)
					{
						$stepIsOK = true;
					
						if($stepIsOK && $etapeValidate < $data['formInfosEnd']) {
							$nextEtape = $etapeValidate+1;

							$tarifData['etape_'.$etapeValidate.'_valid'] = true;

							if($nextEtape == $data['formInfosEnd']) 
							{
								// horodatage rgpd
								// TO DEBUG
								//$this->horodatage_model->insert($data['label_rgpd'], $tarifData['infos_assure']['assure_prenom_0']." ".$tarifData['infos_assure']['assure_nom_0'], $tarifData['infos_assure']['assure_email_0'], $tarifData['infos_assure']['assure_telephone_0']);

								// SQL
								// si ID existant, le visiteur est revenu en arrière
								// supprime donc les précédentes insertons
								$this->load->model('souscripteurs_model');

								if(isset($tarifData['ID_SOUSCRIPTEUR']) && $tarifData['ID_SOUSCRIPTEUR'] != "")
								{
									//var_dump("deleting", $tarifData['ID_SOUSCRIPTEUR']);
									$sql = $this->souscripteurs_model->delete($tarifData['type_tarif'], $tarifData['ID_SOUSCRIPTEUR']);
								}

								// insert/update les souscripteurs
								$sql = $this->souscripteurs_model->insert($tarifData);
								if (substr($sql, 0, 1) == "0") {
									var_dump("sql erros");
								} else if (substr($sql, 0, 1) == "1") {
									$idSouscripteur = substr($sql, 1);
									$tarifData['ID_SOUSCRIPTEUR'] = $idSouscripteur;

									$getSouscripteur = $this->souscripteurs_model->findCustomers($tarifData['type_tarif'], $idSouscripteur);
									$tarifData['PRIVATE_CODE'] = $getSouscripteur[0]->PRIVATE_CODE;
								}
							}

							// save in session
							$this->session->set_userdata('tarifData', $tarifData);

							$redirect_url = $this->lang->line('page_slug_pricing').'/'.$typeTarif.'/'.$this->lang->line('pricing_slug_step').''.$nextEtape;
							redirect($redirect_url);
						}
					}
				}
			}
		}

		$data['tarif_data'] = $tarifData;
		// re-save session to keep it
		$this->session->set_userdata('tarifData', $tarifData);

		$this->load->view('default/front/obtenir-un-tarif', $data);
	}

	public function devenir_partenaire($partnerCategory = '')
	{
		$debug = false;
		$data = [];
		$pageView = "";

		$allowed_types = array($this->lang->line('page_slug_associations'), $this->lang->line('page_slug_brokers'));
		if($partnerCategory == "" || !in_array($partnerCategory, $allowed_types))
		{
			redirect("");
		}
		else
		{
			$data['requestSuccess'] = false;
			$data['partnerCategory'] = $partnerCategory;

			$this->load->model('partenaires_model');
			//$data['fonctionsList'] = $this->partenaires_model->getListFonctionsPartenaires();
			//$data['activitesList'] = $this->partenaires_model->getListActivitesPartenaires();

			$partnerType = 0;
			switch($partnerCategory)
			{
				case $this->lang->line('page_slug_associations'):
					$partnerType = 1;

					$pageView = "associations-clubs-sportifs";

					$data['fonctionsList'] = array($this->lang->line('form_type_president'));
					$data['activitesList'] = array($this->lang->line('form_type_association'), $this->lang->line('form_type_club'), $this->lang->line('form_type_group'), $this->lang->line('form_type_federation'));
					$data['fjList'] = array($this->lang->line('form_type_association'), $this->lang->line('form_type_group'));

				break;

				case $this->lang->line('page_slug_brokers'):
					$partnerType = 0;

					$pageView = "courtiers-agents-assurances";

					$data['fonctionsList'] = array($this->lang->line('form_type_manager'));
					$data['activitesList'] = array($this->lang->line('form_type_insurance_agent'), $this->lang->line('form_type_insurance_broker'));
					$data['fjList'] = array($this->lang->line('form_type_personal_name'), $this->lang->line('form_type_status_sarl'), $this->lang->line('form_type_status_sa'), $this->lang->line('form_type_status_sas'));

				break;
			}
			$data['partnerType'] = $partnerType;
			$data['label_rgpd'] = $this->lang->line('contact_rgpd');

			$config = array(
						'upload_path' => FCPATH . 'uploads/',
						'allowed_types' => 'jpeg|jpg',
						'overwrite' => FALSE,
						'max_size' => '10000',
						'max_width' => '500',
						'max_height' => '100'
					);
			$this->load->library('upload', $config);

			if($_SERVER['REQUEST_METHOD'] == 'POST')
			{
				if($this->input->post('submit'))
				{
					$this->form_validation->set_rules('partenaire_nom', $this->lang->line('form_name_of_partner'), 'trim|required|min_length[1]|max_length[32]|xss_clean|strip_tags');
					$this->form_validation->set_rules('partenaire_activite', $this->lang->line('form_partner_activity'), 'trim|min_length[1]|max_length[32]|xss_clean|strip_tags');
					$this->form_validation->set_rules('partenaire_fj', $this->lang->line('form_legalstatus'), 'trim|min_length[1]|max_length[50]|xss_clean|strip_tags');

					if($partnerType == 0)
					{
						//$this->form_validation->set_rules('partenaire_isprof', 'Vous êtes un professionnel de l\'assurance', 'trim|numeric|xss_clean|strip_tags|greater_than_equal_to[0]|less_than_equal_to[1]');

						$this->form_validation->set_rules('partenaire_capital', $this->lang->line('form_capital'), 'trim|required|numeric|min_length[1]|xss_clean|strip_tags');
						$this->form_validation->set_rules('partenaire_villerc', $this->lang->line('form_cityrc'), 'trim|min_length[1]|max_length[100]|xss_clean|strip_tags');
						$this->form_validation->set_rules('partenaire_nrc', $this->lang->line('form_nrc'), 'trim|required|min_length[1]|xss_clean|strip_tags');
					}

					$this->form_validation->set_rules('contact_nom', $this->lang->line('form_contact_lastname'), 'trim|required|min_length[1]|max_length[32]|xss_clean|strip_tags');
					$this->form_validation->set_rules('contact_prenom', $this->lang->line('form_contact_firstname'), 'trim|required|min_length[1]|max_length[32]|xss_clean|strip_tags');
					$this->form_validation->set_rules('contact_fonction', $this->lang->line('form_contact_role'), 'trim|min_length[1]|max_length[32]|xss_clean|strip_tags');
					
					$this->form_validation->set_rules('adresse1', $this->lang->line('form_address'), 'trim|required|min_length[1]|max_length[100]|xss_clean|strip_tags');
					$this->form_validation->set_rules('adresse2', $this->lang->line('form_address_2'), 'trim|min_length[1]|max_length[100]|xss_clean|strip_tags');
					$this->form_validation->set_rules('codepostal', $this->lang->line('form_zipcode'), 'trim|required|numeric|min_length[1]|max_length[10]|xss_clean|strip_tags');
					$this->form_validation->set_rules('ville', $this->lang->line('form_city'), 'trim|required|min_length[1]|max_length[50]|xss_clean|strip_tags');
					$this->form_validation->set_rules('pays', $this->lang->line('form_country'), 'trim|min_length[1]|max_length[100]|xss_clean|strip_tags');

					$this->form_validation->set_rules('telephone', $this->lang->line('form_phone'), 'trim|required|numeric|min_length[1]|max_length[20]|xss_clean|strip_tags');
					$this->form_validation->set_rules('fax', $this->lang->line('form_fax'), 'trim|numeric|min_length[1]|max_length[20]|xss_clean|strip_tags');
					$this->form_validation->set_rules('email', $this->lang->line('form_mail_short'), 'trim|required|valid_email|max_length[100]|xss_clean|strip_tags');
					$this->form_validation->set_rules('email_confirm', $this->lang->line('form_mail_confrm'), 'trim|required|valid_email|max_length[100]|xss_clean|strip_tags');

					//$this->form_validation->set_rules('logo', 'Logo', 'trim|required|min_length[1]|max_length[255]|xss_clean|strip_tags');
					
					if(!$this->form_validation->run() == FALSE)
					{					
						if($this->input->post('logo') != "" && $this->input->post('logo_new') == "1" && !$this->upload->do_upload('logo_upload'))
						{
							$data['requestSuccess'] = false;
							$requestMsg = $this->upload->display_errors();
						}
						else
						{

							// Captcha V3
							$userIp = $this->input->ip_address();
					        $secret = $this->config->item('google_secret');
					        $captcha_is_ok = true;
					        $captcha = $this->input->post('g-recaptcha-response');
							if (!$captcha):
							    //Do something with error
							    $captcha_is_ok = false;
							else:
							    $response = file_get_contents(
							        "https://www.google.com/recaptcha/api/siteverify?secret=" . $secret . "&response=" . $captcha . "&remoteip=" . $userIp
							    );
							    // use json_decode to extract json response
							    $response = json_decode($response);

							    if ($response->success === false):
							        //Do something with error
							        $captcha_is_ok = false;
							    endif;
							endif;
							//... The Captcha is valid you can continue with the rest of your code
							//... Add code to filter access using $response . score
							if ($response->success==true && $response->score <= 0.5):
							    //Do something to denied access
							    $captcha_is_ok = false;
							endif;
							// end captcha V3

							/*
							// captcha V2
							$recaptchaResponse = trim($this->input->post('g-recaptcha-response'));
							$userIp=$this->input->ip_address();
					        $secret = $this->config->item('google_secret');
					        $url="https://www.google.com/recaptcha/api/siteverify?secret=".$secret."&response=".$recaptchaResponse."&remoteip=".$userIp;
					        $ch = curl_init(); 
					        curl_setopt($ch, CURLOPT_URL, $url); 
					        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
					        $output = curl_exec($ch); 
					        curl_close($ch);      
					        $status= json_decode($output, true);
					        */

					        if( !$captcha_is_ok ):
					            
					        	$data['requestSuccess'] = false;
								$requestMsg = $this->lang->line('form_error_captcha');
								$data['requestMsg'] = $requestMsg;

					        else:

								if($this->input->post('logo') != "") {
									if($this->input->post('logo_new') == "1")
									{
										$uploadData = array('upload_data' => $this->upload->data());
										$partenaire['LOGO_PARTENAIRE'] = $uploadData['upload_data']['file_name'];
									}
									else
									{
										$partenaire['LOGO_PARTENAIRE'] = $this->input->post('logo');
									}
								}

								if($this->input->post('email') != $this->input->post('email_confirm'))
								{
									$data['requestSuccess'] = false;
									$requestMsg = $this->lang->line('error_emails_not_matching').'.';
								}
								else
								{
									$this->load->model('users_model');

									$partenaire_login = trim(strtolower($this->input->post('email')));
									$partenaire_password_clear = password_generator(8);
									$partenaire_password = $this->users_model->setPassword($partenaire_password_clear);
									$partenaire_sousdomaine = toAscii($this->input->post('partenaire_nom'), array(), '');

									$this->load->model('taux_model');
									$partenaire_commission = $this->taux_model->getTaux('commission_parent_role_1');
									$partenaire_parent_commission = $this->taux_model->getTaux('commission_parent_role_2');

									// insert
									$partenaire = array(
										"TYPE_PARTENAIRE" => $partnerType,
										"NOM_PARTENAIRE" => mb_strtoupper($this->input->post('partenaire_nom')),
										"CONTACT_PARTENAIRE" => mb_strtoupper($this->input->post('contact_nom')),
										"CONTACT_PRENOM_PARTENAIRE" => mb_strtoupper($this->input->post('contact_prenom')),
										"FONCTION_PARTENAIRE" => mb_strtoupper($this->input->post('contact_fonction')),
										"ADRESSE1_PARTENAIRE" => mb_strtoupper($this->input->post('adresse1')),
										"ADRESSE2_PARTENAIRE" => mb_strtoupper($this->input->post('adresse2')),
										"CP_PARTENAIRE" => $this->input->post('codepostal'),
										"VILLE_PARTENAIRE" => mb_strtoupper($this->input->post('ville')),
										"PAYS_PARTENAIRE" => $this->input->post('pays'),
										"TEL_PARTENAIRE" => $this->input->post('telephone'),
										"FAX_PARTENAIRE" => $this->input->post('fax'),
										"COURRIEL_PARTENAIRE" => mb_strtolower($this->input->post('email')),
										"ACTIVITE_PARTENAIRE" => mb_strtoupper($this->input->post('partenaire_activite')),
										"ROLE_PARTENAIRE" => 2,
										"ETAT_PARTENAIRE" => 0,
										"ACTIF_PARTENAIRE" => 1,
										"DATE_INSCRIPTION_PARTENAIRE" => date("Y-m-d"),
										//"LOGO_PARTENAIRE" => $this->input->post('logo'),
										"LOGIN_PARTENAIRE" => $partenaire_login,
										"PASSWORD_PARTENAIRE" => $partenaire_password,
										"PASSWORD_CLEAR_PARTENAIRE" => $partenaire_password_clear,
										"SOUSDOMAINE_PARTENAIRE" => $partenaire_sousdomaine,
										"FJ_PARTENAIRE" => mb_strtoupper($this->input->post('partenaire_fj')),
										"CAPITAL_PARTENAIRE" => $this->input->post('partenaire_capital'),
										"NRC_PARTENAIRE" => mb_strtoupper($this->input->post('partenaire_nrc')),
										"VILLERC_PARTENAIRE" => mb_strtoupper($this->input->post('partenaire_villerc')),
										"COM_PARTENAIRE" => $partenaire_commission,
										"COM_AS_PARENT_PARTENAIRE" => $partenaire_parent_commission
									);

									if($partnerType == 0)
									{
										// Courtiers
										$partenaire["ISPROF_PARTENAIRE"] = 1;
										//$partenaire["ISPROF_PARTENAIRE"] = $this->input->post('partenaire_isprof');
									}
									else
									{
										// associations
										$partenaire["ISPROF_PARTENAIRE"] = 0;
									}

									// check if partenaire
									// if registration on subdomain
									// récupère email partenaire parent courant
									$parentPartenaireId = 1;
									$partenaire_parent_email = getMainPartenaireEmail(); // par défaut nolimite
									$currentPartenaire = $this->session->userdata('currentPartenaire');
									if($currentPartenaire && isset($currentPartenaire['ID']) && $currentPartenaire['ID'] != "")
									{
										$partenaire_parent_email = $currentPartenaire['EMAIL'];
										$parentPartenaireId = $currentPartenaire['ID'];
									}
									$partenaire['PARENT_PARTENAIRE'] = $parentPartenaireId;

									$requestMsg = "";
									$sql = $this->partenaires_model->insert($partenaire);
									if(substr($sql, 0, 1) != 0) {
										$data['requestSuccess'] = true;

										// horodatage rgpd
										$this->horodatage_model->insert($data['label_rgpd'], $this->input->post('contact_prenom')." ".$this->input->post('contact_nom')." (".$this->input->post('partenaire_nom').")", $this->input->post('email'), $this->input->post('telephone'));

										// generate contrat pdf
										$contrat_file = $this->_contratPdf($sql);
										if(substr($contrat_file, 0, 1) == "0")
										{
											if($debug)
											{
												var_dump("error generating contrat pdf");
											}
										}
										else
										{
											$contrat_file = getContratFile($contrat_file);
											// EMAIL : NOUVEAU PARTENAIRE
											$email = array(
														"type" => "new_partner_client",
														"to" => $this->input->post('email'),
														"bcc" => $partenaire_parent_email,
															"partenaire-nom" => $this->input->post('partenaire_nom'),
															"partenaire-login" => $partenaire_login,
															"partenaire-password" => $partenaire_password_clear,
															"partenaire-sousdomaine" => $partenaire_sousdomaine,
															"file" => $contrat_file
													);
											$mail = sendNewMail($email);

											// supprime le fichier contrat
											unlink($contrat_file);
											if($debug)
											{
												var_dump("FILE DELETED", $contrat_file);
											}
										}
										
									} else {
										$requestMsg = $this->lang->line('error_demand').".<br />".substr($sql, 1);
									}
								}

							endif;
						}

						$data['requestMsg'] = $requestMsg;
					}
				}
			}

			// VIEW
			if($data['requestSuccess']) {
				$registration = array('success' => true);
				$this->session->set_userdata('registration', $registration);
				redirect($this->lang->line('page_slug_become_partner_ok'));
			} else {
				$this->load->view('default/front/'.$pageView, $data);
			}

		}
	}

	public function devenir_partenaire_inscription_reussie(){
		$session = $this->session->userdata('registration');
		if(isset($session['success']) && $session['success'])
		{
			$this->load->view('default/front/devenir-partenaire-success');

			$registration = array('success' => false);
			$this->session->set_userdata('registration', $registration);
			$session = $this->session->userdata('registration');

		} else {
			redirect($this->lang->line('page_slug_become_partner'));
		}
	}

	public function annuaire_des_federations(){
		$this->load->model('federations_model');

		$data['federations_types'] = $this->federations_model->get_types();
		$data['federations_list'] = $this->federations_model->get_all();

		$this->load->view('default/front/annuaire-des-federations', $data);
	}

	public function assistance(){
		$data = [];
		$this->load->view('default/front/assistance_'.getCurrentLang(), $data);
	}

	public function en_savoir_plus(){
		$data = [];
		if(stripos($_SERVER['REQUEST_URI'], "en-savoir-plus") !== false || stripos($_SERVER['REQUEST_URI'], "learn-more") !== false):
			redirect(base_url($this->lang->line('page_slug_learn_more')));
		else:
			$this->load->view('default/front/en-savoir-plus', $data);
		endif;
	}

	public function politique_de_confidentialite(){
		$data = [];
		$this->load->view('default/front/politique-de-confidentialite', $data);
	}

	public function nous_contacter(){
		$data = [];

		$data['requestSuccess'] = false;

		$data['label_rgpd'] = $this->lang->line('contact_rgpd');

		$data['coordonneesPhone1'] = '+33 (0) 4 86 51 05 06';
		$data['coordonneesPhone2'] = '+33 (0) 4 86 51 05 06';
		$data['coordonneesEmail'] = 'contact@no-limite.com';
		$data['coordonneesName'] = 'NO-LIMITE (OPRA SARL)';
		$data['coordonneesAdresse'] = '900 CHEMIN DE L\'AUMONE VIEILLE<br />L\'ANGEVINIERE BAT B2<br />13400 AUBAGNE<br />FRANCE';

		$subdomain = getPartenaireSubDomain();
		if($subdomain != "")
		{
			// partner
			$partnerId = $this->partenaires_model->findWithSubdomain($subdomain);
			$partner = $this->partenaires_model->find($partnerId);

			// is subdomain
			$data['coordonneesPhone1'] = formatPhoneNumber($partner->TEL_PARTENAIRE);
			$data['coordonneesPhone2'] = formatPhoneNumber($partner->TEL_PARTENAIRE);
			$data['coordonneesEmail'] = $partner->COURRIEL_PARTENAIRE;
			$data['coordonneesName'] = $partner->NOM_PARTENAIRE;
				$tmp_adresse = $partner->ADRESSE1_PARTENAIRE.'<br />';
				if($partner->ADRESSE2_PARTENAIRE != '')
				{
					$tmp_adresse .= $partner->ADRESSE2_PARTENAIRE;
				}
				$tmp_adresse .= $partner->CP_PARTENAIRE.' '.$partner->VILLE_PARTENAIRE.'<br />';
				$tmp_adresse .= $partner->PAYS_PARTENAIRE;
			$data['coordonneesAdresse'] = $tmp_adresse;
		}

		if($this->input->post('submit'))
		{
			$this->form_validation->set_rules('nom', $this->lang->line('form_lastname'), 'trim|required|min_length[1]|max_length[32]|xss_clean|strip_tags');
			$this->form_validation->set_rules('email', $this->lang->line('form_email_short'), 'trim|required|valid_email|max_length[100]|xss_clean|strip_tags');
			$this->form_validation->set_rules('telephone', $this->lang->line('form_phone'), 'trim|required|min_length[1]|max_length[20]|xss_clean|strip_tags');
			$this->form_validation->set_rules('sujet', $this->lang->line('form_subject'), 'trim|required|min_length[1]|max_length[100]|xss_clean|strip_tags');
			$this->form_validation->set_rules('message', $this->lang->line('form_message'), 'trim|required|min_length[1]|max_length[500]|xss_clean|strip_tags');

			if(!$this->form_validation->run() == FALSE)
			{
				// envoie du message
				$nom = $this->input->post('nom');
				$email = $this->input->post('email');
				$telephone = $this->input->post('telephone');
				$sujet = $this->input->post('sujet');
				$message = $this->input->post('message');

				// Captcha V3
				$userIp = $this->input->ip_address();
		        $secret = $this->config->item('google_secret');
		        $captcha_is_ok = true;
		        $captcha = $this->input->post('g-recaptcha-response');
				if (!$captcha):
				    //Do something with error
				    $captcha_is_ok = false;
				else:
				    $response = file_get_contents(
				        "https://www.google.com/recaptcha/api/siteverify?secret=" . $secret . "&response=" . $captcha . "&remoteip=" . $userIp
				    );
				    // use json_decode to extract json response
				    $response = json_decode($response);

				    if ($response->success === false):
				        //Do something with error
				        $captcha_is_ok = false;
				    endif;
				endif;
				//... The Captcha is valid you can continue with the rest of your code
				//... Add code to filter access using $response . score
				if ($response->success==true && $response->score <= 0.5):
				    //Do something to denied access
				    $captcha_is_ok = false;
				endif;
				// end captcha V3

				/*
				captcha V2
				$recaptchaResponse = trim($this->input->post('g-recaptcha-response'));
		        $url="https://www.google.com/recaptcha/api/siteverify?secret=".$secret."&response=".$recaptchaResponse."&remoteip=".$userIp;
		        $ch = curl_init(); 
		        curl_setopt($ch, CURLOPT_URL, $url); 
		        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
		        $output = curl_exec($ch); 
		        curl_close($ch);      
		        $status= json_decode($output, true);
		        */

		        if( !$captcha_is_ok ):
		            
		        	$data['requestSuccess'] = false;
					$requestMsg = $this->lang->line('form_error_captcha');
					$data['requestMsg'] = $requestMsg;

		        else:

					//TODO send mail
					$mail = true;

					$requestMsg = "";
					$data['requestSuccess'] = false;
					if($mail){
						$data['requestSuccess'] = true;
					} else {
						$requestMsg = $this->lang->line('error_email_sending');
					}
					$data['requestMsg'] = $requestMsg;

					// VIEW
					if($data['requestSuccess']) 
					{
						// horodatage rgpd
						$this->horodatage_model->insert($data['label_rgpd'], $this->input->post('nom'), $this->input->post('email'), $this->input->post('telephone'));

						// mail to client
						$email = array(
									"type" => "contact_new_message_client",
									"to" => $email,
										"nom" => $this->input->post('nom')
								);
						$mail = sendNewMail($email);

						// mail to main client
						$email = array(
									"type" => "contact_new_message",
									"to" => getMainPartenaireEmail(),
										"contact-nom" => $this->input->post('nom'),
										"contact-email" => $this->input->post('email'),
										"contact-tel" => $this->input->post('telephone'),
										"contact-sujet" => $this->input->post('sujet'),
										"contact-message" => $this->input->post('message')
								);
						$mail = sendNewMail($email);

						$contact = array('success' => true);
						$this->session->set_userdata('contact', $contact);
						redirect($this->lang->line('page_slug_contact_msg_sent'));
					}

				endif;
			}

		}

		$this->load->view('default/front/nous-contacter', $data);
	}

	public function assursport(){
		$data = [];

		$this->load->view('default/front/assursport/en-savoir-plus', $data);
	}

	public function assurance_emprunteur(){
		$data = [];

		$this->load->view('default/front/assurance-emprunteur', $data);
	}

	public function sport_extreme_liste($sport = ""){
		$data = [];

		$data['sportIndex'] = "";
		$data['sportFolder'] = "";
		$data['sportImage'] = "";
		$data['sportList'] = null;
		$data['sportTitle'] = "";
		$template = 'sport-extreme-liste';
		if($sport != ""):
			// check if valid sport
			$is_valid = false;
			for($i=1;$i<=9;$i++):
				if($this->lang->line('page_slug_sport_list_'.$i) == $sport):
					$is_valid = true;
					break;
				endif;
			endfor;
			if($is_valid):
				$data['sportIndex'] = $i;
				$data['sportFolder'] = APPPATH . 'views/default/front/sport-extreme-liste/'.getCurrentLang().'/sport-'.$i.'/';
				$sportImage = getSportImage($i);
				if($sportImage != ""):
					$data['sportImage'] = base_url('assets/themes/default/img/sports/'.$sportImage);
				endif;
				$data['sportList'] = getSportList($i);
				$data['sportTitle'] = $this->lang->line('page_content_borower_list_'.$i);
				$template = 'sport-extreme-liste/'.getCurrentLang().'/sport';
			else:
				redirect('sport-extreme-liste');
			endif;
		endif;

		$this->load->view('default/front/'.$template, $data);
	}

	public function ipid(){
		$data = [];

		$this->output->set_template('ipid');


		$this->load->view('default/front/ipid-'.$this->session->userdata('site_lang'), $data);
	}

	public function nous_contacter_message_envoye(){
		$session = $this->session->userdata('contact');
		if(isset($session['success']) && $session['success'])
		{
			$this->load->view('default/front/nous-contacter-success');

			$contact = array('success' => false);
			$this->session->set_userdata('contact', $contact);

			$session = $this->session->userdata('contact');
		} else {
			redirect($this->lang->line('page_slug_contact'));
		}
	}

	public function certificat($crc = "", $language = "")
	{
		$debug = false;

		if(!isset($language) || $language == ""):
			$language = "french";
		endif;
		$this->lang->load('information', $language);

		if($crc == "")
		{
			redirect('');
		}
		else
		{
			$this->load->model('souscripteurs_model');

			// search certificat with privade code
			$certificat = $this->souscripteurs_model->findCertificatWithCrc($crc);
			if(!isset($certificat->ID_SOUSCRIPTEUR))
			{
				if($debug)
				{
					var_dump("DEBUG *1"."crc not found");
				}
				else
				{
					redirect('');
				}
			}
			else
			{
				if($certificat->ANNULATION_SOUSCRIPTEUR == 1):
					redirect('');
				else:
					$filename_short = $certificat->CERTIFICAT_SOUSCRIPTEUR."_".substr($crc, 0, 5).".pdf";
					$filename = FCPATH . "certificats/".$filename_short;

					if($debug)
					{
						var_dump("DEBUG *2"."file : ", $filename);
					}

					if(!file_exists($filename) || 1) {

						//texte
						$certif = "<b>".$this->lang->line('form_certificat_1')."".$certificat->CERTIFICAT_SOUSCRIPTEUR;
						$certif .= " - ".$this->lang->line('form_certificat_2')." : ".$certificat->NOM_PARTENAIRE."</b>";
						$titre = $this->lang->line('form_certificat_3');
						$date = date("d/m/Y", strtotime($certificat->DATE_SOUSCRIPTION));
						$date_base = $certificat->DATE_SOUSCRIPTION;
						$sport = getCategorieSportText($certificat->CATEGORIE_SOUSCRIPTEUR, 'pdf');
						$BIRTHDAY_SOUSCRIPTEUR = date("d/m/Y", strtotime($certificat->BIRTHDAY_SOUSCRIPTEUR));
						$DATE_EFFET_SOUSCRIPTEUR = date("d/m/Y", strtotime($certificat->DATE_EFFET_SOUSCRIPTEUR));

						$datev2_time = NOLIMITE_V2_UPDATE_DATE;
						$current_time = strtotime($certificat->DATE_SOUSCRIPTION);
						if($current_time >= $datev2_time):
							$current_periode = $this->lang->line('form_pricing_list_'.$certificat->PERIODE_SOUSCRIPTEUR.'');
						else:
							$current_periode = $certificat->PERIODE_SOUSCRIPTEUR;
						endif;

						$assMondeTxt = ""; 
						$assMondeBr = "<br />";
						if($certificat->ASSISTANCEMONDE_SOUSCRIPTEUR == 1):
							if($certificat->ASSISTANCEMONDE_OPTION_SOUSCRIPTEUR == 0): // 1
								$assMondeTxt = "<b>".$this->lang->line('form_certificat_22')." :</b> ".$this->lang->line('form_certificat_24')."<br />";
							elseif($certificat->ASSISTANCEMONDE_OPTION_SOUSCRIPTEUR == 1): // 1b
								$assMondeTxt = "<b>".$this->lang->line('form_certificat_22')." BIS :</b> ".$this->lang->line('form_certificat_25')."<br />";
							endif;
			          		$assMondeBr = "";
			      		endif;

			      		if($certificat->ANNULATION_VOYAGE_SOUSCRIPTEUR == 1):
			          		$annulationVoyageTxt = "<b>".$this->lang->line('form_certificat_23')." :</b> ".$this->lang->line('form_certificat_26')."";
			      		endif;

						/*if($certificat->PERIODE_SOUSCRIPTEUR == "1 an") {
							$closeP = " et à faire prélever par le gestionnaire Plus Value SAS la prime annuelle sur le compte bancaire suivant l'autorisation de prélèvement complétée à cet effet";
							$reglement = "Je joins au présent document un règlement par carte bancaire de $certificat->PRIME_SOUSCRIPTEUR € correspondant au premier versement de ma cotisation.<br />";
						} else {*/
							$closeP = "";
							$reglement = "".$this->lang->line('form_certificat_19')." ".$certificat->PRIME_SOUSCRIPTEUR." ".$this->lang->line('form_certificat_19b')."<br />";
						//};

						$date_effet = $DATE_EFFET_SOUSCRIPTEUR." ".$certificat->HEURE_EFFET_SOUSCRIPTEUR;
						if($certificat->TYPE_EFFET_SOUSCRIPTEUR == "0")
						{
							//$date_effet .= " (Immédiate après le paiement effectif de la prime en ligne dont la date et l'heure sont portés sur le reçu de paiement délivré par le site et qui font foi).";
						}

						$date_exp = getCertificatDateExp($certificat->DATE_EFFET_SOUSCRIPTEUR, $certificat->PERIODE_SOUSCRIPTEUR, 'v2');

						if($debug)
						{
							var_dump("DEBUG *3".$date_effet);
							var_dump("DEBUG *4".$date_exp);
						}

						$sport_category_text = $this->lang->line('form_certificat_16');
						if(mb_strtoupper($certificat->CATEGORIE_SOUSCRIPTEUR) == "B"):
							$sport_category_text = $this->lang->line('form_certificat_16b');
						endif;

						$message = "<br /><br />".$certif." <br />"
						          ."".$this->lang->line('form_certificat_4')." : $certificat->NOM_SOUSCRIPTEUR $certificat->PRENOM_SOUSCRIPTEUR<br />"
						          ."".$this->lang->line('form_certificat_5')." : $BIRTHDAY_SOUSCRIPTEUR<br />"
						          ."".$this->lang->line('form_certificat_6')." : $certificat->ADRESSE1_SOUSCRIPTEUR $certificat->ADRESSE2_SOUSCRIPTEUR<br />"
						          ."".$this->lang->line('form_certificat_7')." : $certificat->CP_SOUSCRIPTEUR $certificat->VILLE_SOUSCRIPTEUR<br /><br />"
						          ."<b>".$this->lang->line('form_certificat_8')."</b><br />"
						          ."".$this->lang->line('form_certificat_9')." :<br />"

									."<b>".$this->lang->line('form_certificat_10')." :</b> ".$this->lang->line('form_certificat_11')."<br />"
									."<b>".$this->lang->line('form_certificat_12')." :</b> ".$this->lang->line('form_certificat_13')."<br />"

								  ."".$this->lang->line('form_certificat_14')."<br />"
						          ."<b>".$this->lang->line('form_certificat_15')."</b><br />"
						          ."".$sport_category_text." : $sport<br />"
						          .$assMondeBr.""
						          ."<br /><b>".$this->lang->line('form_certificat_17')." :</b><br />"
						          ."".$this->lang->line('form_certificat_18')."<br />"
						          .$assMondeTxt.$annulationVoyageTxt.""
						          ."<br /><br />"
						          ."<b>".$this->lang->line('form_certificat_20')."</b><br />"
						          ."".$this->lang->line('form_certificat_21')." : ".$certificat->CAPITAL_SOUSCRIPTEUR." €.<br />"
						          ."".$this->lang->line('form_certificat_37')." : ".$certificat->BENEFICIAIRE_SOUSCRIPTEUR.".<br />"
						          ."<b>".$this->lang->line('form_certificat_38')." :</b><br />"
						          ."".$this->lang->line('form_certificat_39')." ".$date_effet." ".$this->lang->line('form_certificat_40')." ".$date_exp." ".$certificat->HEURE_EFFET_SOUSCRIPTEUR." (".$this->lang->line('form_certificat_41')." : ".$current_periode.").<br />"
						          ."<br /><b>".$this->lang->line('form_certificat_27')."</b><br />"
						          ."".$this->lang->line('form_certificat_28')." :<br />"
						          ."        -    ".$this->lang->line('form_certificat_29').",<br />"
						          ."        -    ".$this->lang->line('form_certificat_30').",<br />"
						          ."        -    ".$this->lang->line('form_certificat_31').",<br />"
						          ."        -    ".$this->lang->line('form_certificat_32').".<br />"
						          ."".$this->lang->line('form_certificat_33')." $closeP.<br />"
						          .$reglement
						          ."".$this->lang->line('form_certificat_34')."<b>".$this->lang->line('form_certificat_35')."</b><br /><br />"
						          ."<b>".$this->lang->line('form_certificat_36')." ".date("d", strtotime($date_base))." ".getMonthLabel(date("m", strtotime($date_base)))." ".date("Y", strtotime($date_base))."<br />".$this->lang->line('form_certificat_42')." :</b><br /><br />";

						$message_footer = array("Groupe Special Lines pour le compte de GROUPAMA Rhônes-Alpes Auvergne",
												"Entreprise régie par le code des assurances",
												"50 Rue de Saint-Cyr 69251 LYON CEDEX 09",
						       					"Siret : 779 838 366 000 28",
						       					"Office de Placement des Risques d'Assurance SARL au capital de 9 000.00 €",
						       					"900 CHEMIN DE L'AUMONE VIEILLE L'ANGEVINIERE BAT B2 13400 AUBAGNE",
						       					"RCS Salon de Provence 498 729 656 - Inscription ORIAS N° 09 049 322 www.orias.fr",
						       					"Garanties financières et assurances responsabilité civile professionnelle",
						       					"conforme aux articles L 530.1 et L 530.2 du Code des Assurances");

						// start pdf
							$this->load->library('fpdf');
							$this->load->library('html2pdf');

							$pdf = new Html2pdf();
							$pdf->AddPage();

							if($debug)
							{
								var_dump("DEBUG *ERR1");
							}

							$pdf->SetMargins(5, 5);
							$pdf->SetFont('Helvetica','B',11);

							// logo
							$size_logo = 0;
							if($certificat->LOGO_PARTENAIRE == "" || $certificat->LOGO_PARTENAIRE == "logo-nolimite.jpg")
							{
								$size_logo = 1;
								$logo_name = "logo-nolimite-".$language.".jpg";
							}
							else
							{
								$logo_name = $certificat->LOGO_PARTENAIRE;
							}

							$EntetePartenaireFileName = checkAndGetLogoPartenaire($logo_name);
							if($EntetePartenaireFileName != "") {
								if($logo_name != '')
								{
									$img = FCPATH . 'uploads/'.$logo_name;
									if($debug)
									{
										var_dump("DEBUG ERR*2".$logo_name);
									}
									if($size_logo == 1):
										$pdf->Cell(0, 0, $pdf->Image($img, $pdf->GetX()+0, $pdf->GetY()-5, 120, 10), 0, 1, 'C');
									else:
										$pdf->Cell(0, 0, $pdf->Image($img, $pdf->GetX()+0, $pdf->GetY()-5, 33.78), 0, 1, 'C');
									endif;
								}
							}

							if($debug)
							{
								var_dump("DEBUG *ERR3");
							}

							// titre
							$titre = iconv("UTF-8", "CP1252", $titre);
							$pdf->setTextColor(255,255,255);
							$pdf->setFillColor(142,194,230); 
							$pdf->Cell(0, 5, "", 0, 1, 'C');
							$pdf->Cell(0, 5, $titre, 0, 0, 'C', true);
							$pdf->setTextColor(0,0,0);

							// contenu
							$pdf->SetFont('Helvetica','',8);
							$message = iconv("UTF-8", "CP1252", $message);
							$parsed = "";
							$pdf->WriteHTML($message,$parsed );
							$pdf->Multicell(0,0, $parsed );

							// signature
							$img = FCPATH .'assets/themes/default/img/signature.jpg';
							$pdf->Cell(0, 0, $pdf->Image($img, $pdf->GetX()+70, $pdf->GetY()-20, 33.78), 0, 1, 'C');

							// footer
							$pdf->SetFont('Helvetica','B',6);
							$i=0;
							foreach($message_footer as $bas)
							{
								if($i==0){$h=3;}else{$h=2;}

								$text = iconv("UTF-8", "CP1252", $bas);
								$pdf->Cell(0, $h, $text, 0, 1, 'C');

								$pdf->SetFont('Helvetica','',6);

								$i++;
							}

							$pdf->Output($filename,'F');
						// End pdf

						/*$EntetePartenaireFileName = checkAndGetLogoPartenaire($certificat->LOGO_PARTENAIRE);
						if($EntetePartenaireFileName != "") {
							//$img = imagecreatefromjpeg($EntetePartenaireFileName);
							$pdf->addJpegFromFile(FCPATH . 'uploads/'.$certificat->LOGO_PARTENAIRE, $pdf->ez['leftMargin'], $pdf->y-$pdf->ez['topMargin'], 495);
							if($debug){
								var_dump("logo:", $certificat->LOGO_PARTENAIRE);
							}
							// TODO : adjuste image size
						};
						$pdf->addJpegFromFile(FCPATH .'assets/themes/default/img/signature.jpg',210,$pdf->y+70,75);*/

						if($debug)
						{	
							var_dump("DEBUG *5".$filename_short);
						}

						// file created, open it
						redirect("certificats/".$filename_short);
					} else {
						redirect("certificats/".$filename_short);
					}
				endif;

			}
			
		}
	}

	public function reprendre_souscription($crc = '')
	{
		$debug = false;

		$language = ($language != "") ? $language : "french";
        $this->session->set_userdata('site_lang', $language);
	    if($language != ""):
	        $this->lang->load('information', $language);
	    endif;

		if($crc == '') 
		{
			redirect($this->lang->line('page_slug_pricing'));
		}
		else
		{
			$this->load->model('souscripteurs_model');
			$findSouscription = $this->souscripteurs_model->findBrouillonWithCode($crc);

			if(!$findSouscription) 
			{
				if($debug)
				{
					var_dump("DEBUG *2 ERROR REDIRECT");
				}
				else
				{
					redirect($this->lang->line('page_slug_pricing'));
				}
			}
			else
			{
				// re-build session // TO DO : better
				$tarifData = array();
				$tarifData = json_decode($findSouscription->BROUILLON_SESSION_SOUSCRIPTEUR, true);

				if($debug)
				{
					var_dump("DEBUG 3.1*".$findSouscription->BROUILLON_SESSION_SOUSCRIPTEUR);
					var_dump("DEBUG 3.2*".$tarifData);
				}

				if($tarifData['type_tarif'] == "0")
				{
					$redirect = $this->lang->line('page_slug_pricing_individual');
				}
				else
				{
					$redirect = $this->lang->line('page_slug_pricing_collective');
				}

				if($debug)
				{
					var_dump("DEBUG 4* ".$redirect);
				}
				else
				{
					// found, load data and go to first step, to get data verifications step by step 
					// reinit each steps
					for($i=1;$i<5;$i++):
						$tarifData['etape_'.$i.'_valid'] = false;
						$tarifData['is_quotation_step_'.$i] = true;
					endfor;
					$this->session->set_userdata('tarifData', $tarifData);

					redirect($this->lang->line('page_slug_pricing').'/'.$redirect.'/'.$this->lang->line('pricing_slug_step').'1');
				}
			}
		}

	}

	public function telecharger_devis($crc = '', $language = "french")
	{
		$debug = false;

		$language = ($language != "") ? $language : "french";
        $this->session->set_userdata('site_lang', $language);
	    if($language != ""):
	        $this->lang->load('information', $language);
	    endif;

		if(IS_DEBUG_IP)
		{
			$debug = false;
		}

		if($crc == '') 
		{
			if($debug)
			{
				var_dump("DEBUG *1 ERROR REDIRECT");
			}
			else
			{
				redirect($this->lang->line('page_slug_pricing'));
			}
		}
		else
		{
			$this->load->model('souscripteurs_model');
			$certificat = $this->souscripteurs_model->findDevisWithCode($crc);

			if(!$certificat) 
			{
				if($debug)
				{
					echo '<pre>';
					var_dump("DEBUG *2 ERROR REDIRECT");
					echo '</pre>';
				}
				else
				{
					redirect($this->lang->line('page_slug_pricing'));
				}
			}
			else
			{
				$filename_short = "devis_NOLIMITE_".date("Ymd", strtotime($certificat->DEVIS_DATE_SOUSCRIPTEUR))."_".substr($crc, 0, 5).".pdf";
				$filename = FCPATH . "devis/".$filename_short;

				if($debug)
				{
					echo '<pre>';
						var_dump("DEBUG *2"."file : ", $filename);
					echo '</pre>';
				}

				if(!file_exists($filename) || 1 || $debug) {

					$array_pdf_content = array();

					$isCollectif = false;
					$isCollectifIdentique = false;
					$nbPersonnes = 1;
					$nbPagesToGenerate = 1;

					$arrayCertificats = array();
					$arrayCertificats[] = $certificat;

					if($certificat->TYPE_TARIF_SOUSCRIPTEUR == "1")
					{
						$isCollectif = true;
						$arrayCertificats = $this->souscripteurs_model->findDevisWithCodeCollectif($certificat->COLLECTIF_ID_SOUSCRIPTEUR);

						if($debug)
						{
							echo '<pre>';
							var_dump("check collectif", $certificat->COLLECTIF_IDENTIQUE_SOUSCRIPTEUR);
							echo '</pre>';
						}

						if($isCollectif)
						{
							$nbPersonnes = $certificat->NB_PERSONNES_SOUSCRIPTEUR;

							if($debug)
							{
								echo '<pre>';
								var_dump("nb personnes", $certificat->NB_PERSONNES_SOUSCRIPTEUR);
								echo '</pre>';
							}
						}

						$checkCat = ''; $checkCapital = ''; $checkDuree = ''; $checkAssistance = '';
						$isCollectifIdentique = true;

						for($x=0;$x<$nbPersonnes;$x++)
						{
							$tmpCurrentCertificat = $arrayCertificats[$x];

							if($x > 0)
							{
								if($checkCat != $tmpCurrentCertificat->CATEGORIE_SOUSCRIPTEUR)
								{
									$isCollectifIdentique = false;
									break;
								} 
								else if($checkCapital != $tmpCurrentCertificat->CAPITAL_SOUSCRIPTEUR)
								{
									$isCollectifIdentique = false;
									break;
								}
								else if($checkDuree != $tmpCurrentCertificat->PERIODE_SOUSCRIPTEUR)
								{
									$isCollectifIdentique = false;
									break;
								}
								else if($checkAssistance != $tmpCurrentCertificat->ASSISTANCEMONDE_SOUSCRIPTEUR)
								{
									$isCollectifIdentique = false;
									break;
								}
							}

							$checkCat = $tmpCurrentCertificat->CATEGORIE_SOUSCRIPTEUR;
							$checkCapital = $tmpCurrentCertificat->CAPITAL_SOUSCRIPTEUR;
							$checkDuree = $tmpCurrentCertificat->PERIODE_SOUSCRIPTEUR;
							$checkAssistance = $tmpCurrentCertificat->ASSISTANCEMONDE_SOUSCRIPTEUR;
						}

						if($isCollectifIdentique)
						{
							$arrayCertificats[] = $certificat;
						}

						// collectif
						if($certificat->COLLECTIF_IDENTIQUE_SOUSCRIPTEUR == "1")
						{
							// conditions identiques : 1 devis global
							$isCollectifIdentique = true;
						}
						else
						{
							// conditions différentes : 1 devis / personne
						}
					}

					// GLOBAL DATAS
						$date_base = $certificat->DEVIS_DATE_SOUSCRIPTEUR;
						$date = date("d/m/Y", strtotime($certificat->DEVIS_DATE_SOUSCRIPTEUR));

						// footer
						$message_footer = array("Groupe Special Lines pour le compte de GROUPAMA Rhônes-Alpes Auvergne",
												"Entreprise régie par le code des assurances",
												"50 Rue de Saint-Cyr 69251 LYON CEDEX 09",
						       					"Siret : 779 838 366 000 28",
						       					"Office de Placement des Risques d'Assurance SARL au capital de 9 000.00 €",
						       					"900 CHEMIN DE L'AUMONE VIEILLE L'ANGEVINIERE BAT B2 13400 AUBAGNE",
						       					"RCS Salon de Provence 498 729 656 - Inscription ORIAS N° 09 049 322 www.orias.fr",
						       					"Garanties financières et assurances responsabilité civile professionnelle",
						       					"conforme aux articles L 530.1 et L 530.2 du Code des Assurances");
						
						if($certificat->ID_PARTENAIRE == "1")
						{
							/*
							$coords_a = '<strong><em>Nous contacter :</em></strong>';
							$coords_b = '<strong>'.$certificat->NOM_PARTENAIRE.'</strong>';
							$coords_c = '<strong>'.getPhoneFormatSpaces($certificat->TEL_PARTENAIRE).'</strong>';
							$coords_d = '<strong>'.getPhoneFormatSpaces($certificat->COURRIEL_PARTENAIRE).'</strong>';
							$coords_e = '';
							*/
							$coords_a = '<strong>NO-LIMITE :</strong>';
							$coords_b = '<strong>+33 4 86 51 05 06</strong>';
							$coords_c = '';
							$coords_d = '';
							$coords_e = '';
						}
						else
						{
							$coords_a = mb_strtoupper($certificat->NOM_PARTENAIRE);
							$coords_b = mb_strtoupper($certificat->ADRESSE1_PARTENAIRE);
							if($certificat->ADRESSE2_PARTENAIRE != '')
							{
								$coords_b .= ' '.mb_strtoupper($certificat->ADRESSE2_PARTENAIRE);
							}
							$coords_c = mb_strtoupper($certificat->CP_PARTENAIRE).' '.mb_strtoupper($certificat->VILLE_PARTENAIRE);
							$coords_d = getUrlFromSubDomain($certificat->SOUSDOMAINE_PARTENAIRE);
							$coords_e = 'Tél. : '.getPhoneFormatSpaces($certificat->TEL_PARTENAIRE);
						}
						

					//

					if($isCollectif && !$isCollectifIdentique)
					{
						$nbPagesToGenerate = $nbPersonnes;

						$titre_devis = "";
						$titre_date = "";
						$message = "";
						$tableau_titre = "";
						$tableau_ligne_top = "";
						$tableau_ligne_bottom = "";
						$tableau_tarif_titre = "";
						$tableau_legende = "";
						$tableau_tarif_texte = "";

						$tarifTotalTtc = 0;
						for($p=0;$p<$nbPagesToGenerate;$p++)
						{
							$currentCertificat = $arrayCertificats[$p];
							$tarifTotalTtc += floatval($currentCertificat->PRIME_SOUSCRIPTEUR);
						}
						$tarifTotalTtc = number_format($tarifTotalTtc, 2, ',', ' ');

						$certif = "<br /><br /><br />         <em><strong>".$this->lang->line('quotation_line_1')."</strong></em><br />";

						$message = "          ".$nbPersonnes." ".$this->lang->line('quotation_line_2')."<br /><br />";
						//$message .= "          <br /><br /><strong><u>Proposition d'assurance du ".getDateText($certificat->DEVIS_DATE_SOUSCRIPTEUR)." :</u></strong><br /><br />";

						// tableau titre
						//$tableau_titre = "Assurés                                Tarif TTC en €";

						// tableau ligne
						$tableau_ligne_top = "                                       ".$nbPersonnes;
						$tableau_ligne_top .= "                                                     ";
						$tableau_ligne_top .= $tarifTotalTtc;

						// tableau message
						$tableau_legende = "<br /><br /><em>".$this->lang->line('quotation_line_11').".<br />".$this->lang->line('quotation_line_4').".</em><br /><br /><br /><br />";

						$tableau_tarif_texte = "          <strong>".$this->lang->line('quotation_line_5').".<br />";
						$tableau_tarif_texte .= "          ".$this->lang->line('quotation_line_6').".</strong>";
						$tableau_tarif_texte .= "<br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br />";

						// ADD FIRST PAGE RECAP
						$array_pdf_content[] = array(
													"isrecappage" => true,
													"certif" => $certif,
													"titre_devis" => $titre_devis,
													"titre_date" => $titre_date,
													"message" => $message,
													//"tableau_titre" => $tableau_titre,
													"tableau_ligne_top" => $tableau_ligne_top,
													"tableau_ligne_bottom" => $tableau_ligne_bottom,
													"tableau_tarif_titre" => $tableau_tarif_titre,
													"tableau_tarif_prix" => $tableau_tarif_prix,
													"tableau_legende" => $tableau_legende,
													"tableau_tarif_texte" => $tableau_tarif_texte,
													"message_footer" => $message_footer
												);
					}

					for($p=0;$p<$nbPagesToGenerate;$p++)
					{
						$currentCertificat = $arrayCertificats[$p];

						if($debug)
						{
							echo '<pre>';
								var_dump("DEBUG *3".$date_effet);
								var_dump("DEBUG *4".$date_exp);
								var_dump("DEBUG *5 -> Is collectif".$isCollectif);
								var_dump("DEBUG *6 -> Is collectif identique".$isCollectifIdentique);
							echo '</pre>';
						}

						// infos devis
						$numero_devis = date("m", strtotime($currentCertificat->DEVIS_DATE_SOUSCRIPTEUR)).sprintf("%04d", $currentCertificat->DEVIS_NUMERO_SOUSCRIPTEUR).date("y", strtotime($currentCertificat->DEVIS_DATE_SOUSCRIPTEUR));
						$titre_devis = $this->lang->line('quotation_line_14')." ".$numero_devis;
						$titre_date = $this->lang->line('quotation_line_15')." ".$date;

						// intro
						$message_options = getOptionsLabelQuotation($currentCertificat);

						$txtPrixPersonne = '';
						if($isCollectif && $isCollectifIdentique)
						{
							$txtPrixPersonne = ' / '.$this->lang->line('quotation_line_13');

							if($debug)
							{
								echo '<pre>';
									var_dump("NB. PERSONNES:".$nbPersonnes);
								echo '</pre>';
							}

							$certif = "<br /><br /><br />        <strong>".$this->lang->line('quotation_line_1')."</strong><br />";

							$message = "          ".$nbPersonnes." ".$this->lang->line('quotation_line_12')."<br /><br />";
							/*$message .= "          <strong>".$this->lang->line('form_lastname')." :</strong> $currentCertificat->NOM_SOUSCRIPTEUR<br />";
							$message .= "          <strong>".$this->lang->line('form_firstname')." :</strong> $currentCertificat->PRENOM_SOUSCRIPTEUR<br />";*/
							$message .= "          <strong>".$this->lang->line('form_people_listing')." : </strong>";
							for($px=0;$px<$nbPersonnes;$px++):
								$tmp_currentCertificat = $arrayCertificats[$px];
								if($px>0):
									$message .= ", ";
								endif;
								$message .= $currentCertificat->NOM_SOUSCRIPTEUR." ".$currentCertificat->PRENOM_SOUSCRIPTEUR;
							endfor;
							$message .= "<br />";

							$message .= "          <strong>".$this->lang->line('form_phone')." :</strong> $currentCertificat->TEL_SOUSCRIPTEUR<br />";
							$message .= "          <strong>".$this->lang->line('form_mobile')." :</strong> $currentCertificat->GSM_SOUSCRIPTEUR<br />";
							$message .= "          <strong>".$this->lang->line('form_mail')." :</strong> $currentCertificat->COURRIEL_SOUSCRIPTEUR<br /><br />";

							if($debug)
							{
								echo '<pre>';
								var_dump($message);
								echo '</pre>';
							}
						}
						else
						{
							$certif = "<br /><br /><br />         ";
							//$certif .= "<strong>".$this->lang->line('quotation_line_11')."</strong><br />";

							$adresse2 = "";
							if($currentCertificat->ADRESSE2_SOUSCRIPTEUR != "" && $currentCertificat->ADRESSE2_SOUSCRIPTEUR != " ")
							{
								$adresse2 = "<br />          ".$currentCertificat->ADRESSE2_SOUSCRIPTEUR;
							}
							$BIRTHDAY_SOUSCRIPTEUR = date("d/m/Y", strtotime($currentCertificat->BIRTHDAY_SOUSCRIPTEUR));

							// infos assuré
							$message = "          <strong>".$this->lang->line('form_lastname')." :</strong> $currentCertificat->NOM_SOUSCRIPTEUR<br />"
							          ."          <strong>".$this->lang->line('form_firstname')." :</strong> $currentCertificat->PRENOM_SOUSCRIPTEUR<br />"
							          ."          <strong>".$this->lang->line('form_birthdate')." :</strong> $BIRTHDAY_SOUSCRIPTEUR<br />"
							          ."          <strong>".$this->lang->line('form_address')." :</strong><br />"
							          ."          $currentCertificat->ADRESSE1_SOUSCRIPTEUR".$adresse2."<br />"
							          ."          $currentCertificat->CP_SOUSCRIPTEUR $currentCertificat->VILLE_SOUSCRIPTEUR $currentCertificat->PAYS_SOUSCRIPTEUR<br />"
							          ."          <strong>".$this->lang->line('form_phone')." :</strong> $currentCertificat->TEL_SOUSCRIPTEUR<br />"
							          ."          <strong>".$this->lang->line('form_mobile')." :</strong> $currentCertificat->GSM_SOUSCRIPTEUR<br />"
							          ."          <strong>".$this->lang->line('form_mail')." :</strong> $currentCertificat->COURRIEL_SOUSCRIPTEUR<br />"
							          ."          <strong>".$this->lang->line('quotation_line_0')." :</strong> $currentCertificat->BENEFICIAIRE_SOUSCRIPTEUR<br />";
						}

						$message .= "          <strong>".$this->lang->line('form_category_chosen')." : ".mb_strtoupper($currentCertificat->CATEGORIE_SOUSCRIPTEUR)."</strong><br />"
							          ."          <strong>".$this->lang->line('form_duration')." : ".$this->lang->line('form_pricing_list_'.$currentCertificat->PERIODE_SOUSCRIPTEUR)."</strong><br /><br />"
							          ."          <strong>".$this->lang->line('quotation_listing_title')." :</strong><br /><br />"
							          ."          <strong>".$this->lang->line('form_capital_short')." : ".number_format($currentCertificat->CAPITAL_SOUSCRIPTEUR, 2, ',', ' ')." €</strong><br />";


						if($message_options != ""):
							$message .= "".$message_options;
						endif;

						// TABLEAU GARANTIES
							// tableau titre
							//$tableau_titre = "Tableau des garanties Individuelle Accident – Sport de CATEGORIE ".mb_strtoupper($currentCertificat->CATEGORIE_SOUSCRIPTEUR);

							// tableau ligne
							$tableau_ligne_top = "  ".$this->lang->line('quotation_line_10');
							$tableau_ligne_top .= "                 ";
							$tableau_ligne_top .= "".$this->lang->line('quotation_line_9')." ".number_format($currentCertificat->CAPITAL_SOUSCRIPTEUR, 2, ',', ' ')." €";

							//$tableau_ligne_bottom = "  Indemnité forfaitaire";
							$tableau_ligne_bottom .= "                                          ";
							$tableau_ligne_bottom .= "(".$this->lang->line('quotation_line_8').")";

							// tableau message
							$tableau_legende = "<em>".$this->lang->line('quotation_line_3').".<br />".$this->lang->line('quotation_line_4').".</em><br /><br />";
							
							// tarif
							$tableau_tarif_titre = "";
							$tableau_tarif_titre .= "        <u><strong>".$this->lang->line('quotation_line_7')."</strong></u><br /><br />";
							
							$tableau_tarif_prix = "        <strong>".number_format($currentCertificat->PRIME_SOUSCRIPTEUR, 2, ',', ' ')." € TTC".$txtPrixPersonne."</strong><br />";
							// / an
							$tableau_tarif_texte = "          ".$this->lang->line('quotation_line_5').".<br />";
							$tableau_tarif_texte .= "          ".$this->lang->line('quotation_line_6').".";
							$tableau_tarif_texte .= "<br /><br />";

						// FIN TABLEAU

						if($isCollectif && $isCollectifIdentique)
						{
							$tableau_tarif_texte .= "<br /><br /><br /><br />";
						}

						$array_pdf_content[] = array(
													"certif" => $certif,
													"titre_devis" => $titre_devis,
													"titre_date" => $titre_date,
													"message" => $message,
													//"tableau_titre" => $tableau_titre,
													"tableau_ligne_top" => $tableau_ligne_top,
													"tableau_ligne_bottom" => $tableau_ligne_bottom,
													"tableau_tarif_titre" => $tableau_tarif_titre,
													"tableau_tarif_prix" => $tableau_tarif_prix,
													"tableau_legende" => $tableau_legende,
													"tableau_tarif_texte" => $tableau_tarif_texte,
													"message_footer" => $message_footer
												);
					}

					// start pdf
						$this->load->library('fpdf');
						$this->load->library('html2pdf');
						$pdf = new Html2pdf();
						$pdf->SetMargins(10, 15);
						$pdf->SetFont('Helvetica','B',12);

						foreach($array_pdf_content as $pdfPage)
						{
							$isrecappage = false;
							if(isset($pdfPage['isrecappage'])) { $isrecappage = true; }

							$certif = $pdfPage['certif'];
							$titre_devis = $pdfPage['titre_devis'];
							$titre_date = $pdfPage['titre_date'];
							$message = $pdfPage['message'];
							//$tableau_titre = $pdfPage['tableau_titre'];
							$tableau_ligne_top = $pdfPage['tableau_ligne_top'];
							$tableau_ligne_bottom = $pdfPage['tableau_ligne_bottom'];
							$tableau_tarif_titre = $pdfPage['tableau_tarif_titre'];
							$tableau_tarif_prix = $pdfPage['tableau_tarif_prix'];
							$tableau_legende = $pdfPage['tableau_legende'];
							$tableau_tarif_texte = $pdfPage['tableau_tarif_texte'];
							$message_footer = $pdfPage['message_footer'];

							$pdf->AddPage();
							$pdf->SetMargins(10, 15);
							$pdf->SetFont('Helvetica','B',12);

							if($debug)
							{
								echo '<pre>';
									var_dump("DEBUG *STEP1");
								echo '</pre>';
							}
							
							// logo
							if($currentCertificat->LOGO_PARTENAIRE == "")
							{
								$logo_name = "logo-nolimite.jpg";
							}
							else
							{
								$logo_name = $currentCertificat->LOGO_PARTENAIRE;
							}
							$EntetePartenaireFileName = checkAndGetLogoPartenaire($logo_name);
							if($EntetePartenaireFileName != "") {
								if($logo_name != '')
								{
									$img = FCPATH . 'uploads/'.$logo_name;
									if($debug)
									{
										echo '<pre>';
											var_dump("DEBUG LOGO*2".$logo_name);
										echo '</pre>';
									}
									$pdf->Cell(0, 0, $pdf->Image($img, $pdf->GetX()+0, $pdf->GetY()-5, 77.78), 0, 1, 'C');
								}
							}

							if($debug)
							{
								echo '<pre>';
									var_dump("DEBUG *STEP3");
								echo '</pre>';
							}

							// Top space
							/*if($titre_devis != '')
							{
								$header_space = "<br /><br /><br />";
								$pdf->SetFont('Helvetica','',12);
								$header_space = iconv("UTF-8", "CP1252", $header_space);
								$parsed = "";
								$pdf->WriteHTML($header_space,$parsed );
								$pdf->Multicell(0,0, $parsed );
							}*/

							if($coords_a != '')
							{
								// COORDONNEES
									// nom
									$message_part = '                                                                                  <strong>'.$coords_a.'</strong>';
									$pdf->SetFont('Helvetica','',12);
									$message_part = iconv("UTF-8", "CP1252", $message_part);
									$parsed = "";
									$pdf->WriteHTML($message_part,$parsed );
									$pdf->Multicell(0,0, $parsed );

									// coordonnées
									$message_part = '<br />                                                                                  '.$coords_b;
									$message_part .= '<br />                                                                                  '.$coords_c;
									$message_part .= '<br />                                                                                  '.$coords_d;
									if($coords_e != '')
									{
										$message_part .= '<br />                                                                                  '.$coords_e;
									}
									$message_part .= '<br />';

									$pdf->SetFont('Helvetica','',12);
									$message_part = iconv("UTF-8", "CP1252", $message_part);
									$parsed = "";
									$pdf->WriteHTML($message_part,$parsed );
									$pdf->Multicell(0,0, $parsed );
								// FIN COORDONNEES
							}

							if($titre_devis != '')
							{
								// devis space
								$titre_devis_space = "";
								$pdf->SetFont('Helvetica','B',12);
								$titre_devis_space = iconv("UTF-8", "CP1252", $titre_devis_space);
								$pdf->setTextColor(0,0,0);
								$pdf->setFillColor(240, 240, 240); 
								$pdf->Cell(0, 5, "", 0, 1, 'R');
								$pdf->Cell(0, 5, $titre_devis_space, 0, 0, 'R', true);

								// n° devis
								$pdf->SetFont('Helvetica','B',20);
								$titre_devis = iconv("UTF-8", "CP1252", $titre_devis);
								$pdf->setTextColor(0,0,0);
								$pdf->setFillColor(240, 240, 240); 
								$pdf->Cell(0, 5, "", 0, 1, 'R');
								$pdf->Cell(0, 5, $titre_devis, 0, 0, 'R', true);

								// devis space
								$titre_devis_space = "";
								$pdf->SetFont('Helvetica','B',12);
								$titre_devis_space = iconv("UTF-8", "CP1252", $titre_devis_space);
								$pdf->setTextColor(0,0,0);
								$pdf->setFillColor(240, 240, 240); 
								$pdf->Cell(0, 5, "", 0, 1, 'R');
								$pdf->Cell(0, 5, $titre_devis_space, 0, 0, 'R', true);

								// date devis
								$pdf->SetFont('Helvetica','',20);
								$titre_date = iconv("UTF-8", "CP1252", $titre_date);
								$pdf->setTextColor(0,0,0);
								$pdf->setFillColor(240, 240, 240); 
								$pdf->Cell(0, 5, "", 0, 1, 'R');
								$pdf->Cell(0, 5, $titre_date, 0, 0, 'R', true);

								// devis space
								$titre_devis_space = "";
								$pdf->SetFont('Helvetica','B',12);
								$titre_devis_space = iconv("UTF-8", "CP1252", $titre_devis_space);
								$pdf->setTextColor(0,0,0);
								$pdf->setFillColor(240, 240, 240); 
								$pdf->Cell(0, 5, "", 0, 1, 'R');
								$pdf->Cell(0, 5, $titre_devis_space, 0, 0, 'R', true);

								// FIN TITRE
							}
							// certif
							$pdf->SetFont('Helvetica','',14);
							$certif = iconv("UTF-8", "CP1252", $certif);
							$parsed = "";
							$pdf->WriteHTML($certif,$parsed );
							$pdf->Multicell(0,0, $parsed );
 
							// contenu
							$pdf->SetFont('Helvetica','',12);
							$message = iconv("UTF-8", "CP1252", $message);
							$parsed = "";
							$pdf->WriteHTML($message,$parsed );
							$pdf->Multicell(0,0, $parsed );

							// titre tableau espace haut
							/*$tableau_titre_space = "";
							$pdf->SetFont('Helvetica','B',15);
							$tableau_titre_space = iconv("UTF-8", "CP1252", $$tableau_titre_space);
							$pdf->setTextColor(255,255,255);
							$pdf->setFillColor(156,186,94); 
							$pdf->Cell(0, 5, "", 0, 1, 'C');
							$pdf->Cell(0, 5, $tableau_titre_space, 0, 0, 'C', true);
							$pdf->setTextColor(0,0,0);

							// titre tableau
							$pdf->SetFont('Helvetica','B',15);
							$tableau_titre = iconv("UTF-8", "CP1252", $tableau_titre);
							$pdf->setTextColor(255,255,255);
							$pdf->setFillColor(156,186,94); 
							$pdf->Cell(0, 5, "", 0, 1, 'C');
							$pdf->Cell(0, 5, $tableau_titre, 0, 0, 'C', true);
							$pdf->setTextColor(0,0,0);

							// titre tableau espace bas
							$tableau_titre_space = "";
							$pdf->SetFont('Helvetica','B',15);
							$tableau_titre_space = iconv("UTF-8", "CP1252", $$tableau_titre_space);
							$pdf->setTextColor(255,255,255);
							$pdf->setFillColor(156,186,94); 
							$pdf->Cell(0, 5, "", 0, 1, 'C');
							$pdf->Cell(0, 5, $tableau_titre_space, 0, 0, 'C', true);
							$pdf->setTextColor(0,0,0);*/

							// tableau ligne espace haut
							$tableau_titre_space = "";
							$pdf->SetFont('Helvetica','B',15);
							$tableau_titre_space = iconv("UTF-8", "CP1252", $$tableau_titre_space);
							$pdf->setTextColor(255,255,255);
							$pdf->setFillColor(255,255,255); 
							$pdf->Cell(0, 5, "", 0, 1, 'C');
							$pdf->Cell(0, 5, $tableau_titre_space, 0, 0, 'C', true);
							$pdf->setTextColor(0,0,0);

							// tableau ligne
							$pdf->SetFont('Helvetica','B',13);
							$tableau_ligne_top = iconv("UTF-8", "CP1252", $tableau_ligne_top);
							$pdf->setTextColor(0,0,0);
							$pdf->setFillColor(255,255,255); 
							$pdf->Cell(0, 5, "", 0, 1, 'L');
							$pdf->Cell(0, 5, $tableau_ligne_top, 0, 0, 'L', true);
							$pdf->setTextColor(0,0,0);

							// tableau ligne infos
							$pdf->SetFont('Helvetica','I',8);
							$tableau_ligne_bottom = iconv("UTF-8", "CP1252", $tableau_ligne_bottom);
							$pdf->setTextColor(0,0,0);
							$pdf->setFillColor(255,255,255); 
							$pdf->Cell(0, 5, "", 0, 1, 'L');
							$pdf->Cell(0, 5, $tableau_ligne_bottom, 0, 0, 'R', true);
							$pdf->setTextColor(0,0,0);

							if(!$isrecappage)
							{
								// tableau ligne espace bas
								$tableau_titre_space = "";
								$pdf->SetFont('Helvetica','B',14);
								$tableau_titre_space = iconv("UTF-8", "CP1252", $$tableau_titre_space);
								$pdf->setTextColor(255,255,255);
								$pdf->setFillColor(255,255,255); 
								$pdf->Cell(0, 5, "", 0, 1, 'C');
								$pdf->Cell(0, 5, $tableau_titre_space, 0, 0, 'C', true);
								$pdf->setTextColor(0,0,0);
							}

							// tableau légende
							$pdf->SetFont('Helvetica','',10);
							$tableau_legende = iconv("UTF-8", "CP1252", $tableau_legende);
							$parsed = "";
							$pdf->WriteHTML($tableau_legende,$parsed );
							$pdf->Multicell(0,0, $parsed );

							// tarif titre
							$pdf->SetFont('Helvetica','',14);
							$tableau_tarif_titre = iconv("UTF-8", "CP1252", $tableau_tarif_titre);
							$parsed = "";
							$pdf->WriteHTML($tableau_tarif_titre,$parsed );
							$pdf->Multicell(0,0, $parsed );

							// tarif prix
							$pdf->SetFont('Helvetica','',14);
							$tableau_tarif_prix = iconv("UTF-8", "CP1252", $tableau_tarif_prix);
							$parsed = "";
							$pdf->WriteHTML($tableau_tarif_prix,$parsed );
							$pdf->Multicell(0,0, $parsed );

							// tarif texte
							$pdf->SetFont('Helvetica','',11);
							$tableau_tarif_texte = iconv("UTF-8", "CP1252", $tableau_tarif_texte);
							$parsed = "";
							$pdf->WriteHTML($tableau_tarif_texte,$parsed );
							$pdf->Multicell(0,0, $parsed );

							// footer
							$pdf->SetFont('Helvetica','B',6);
							$i=0;
							foreach($message_footer as $bas)
							{
								if($i==0){$h=3;}else{$h=2;}

								$text = iconv("UTF-8", "CP1252", $bas);
								$pdf->Cell(0, $h, $text, 0, 1, 'C');

								$pdf->SetFont('Helvetica','',6);

								$i++;
							}
						}

						$pdf->Output($filename,'F');
						
					// End pdf

					/*$EntetePartenaireFileName = checkAndGetLogoPartenaire($currentCertificat->LOGO_PARTENAIRE);
					if($EntetePartenaireFileName != "") {
						//$img = imagecreatefromjpeg($EntetePartenaireFileName);
						$pdf->addJpegFromFile(FCPATH . 'uploads/'.$currentCertificat->LOGO_PARTENAIRE, $pdf->ez['leftMargin'], $pdf->y-$pdf->ez['topMargin'], 495);
						if($debug){
							var_dump("logo:", $currentCertificat->LOGO_PARTENAIRE);
						}
						// TODO : adjuste image size
					};
					$pdf->addJpegFromFile(FCPATH .'assets/themes/default/img/signature.jpg',210,$pdf->y+70,75);*/

					if($debug)
					{
						echo '<pre>';
						var_dump("DEBUG *5".$filename_short);
						echo '</pre>';
					}
					else
					{
						// file created, open it
						redirect("devis/".$filename_short);
					}
					
				} else {
					redirect("devis/".$filename_short);
				}
			}
		}
	}

	public function devis()
	{
		$debug = false;

		if(IS_DEBUG_IP)
		{
			$debug = false;
		}

		if(!$this->session->userdata('tarifData')) 
		{
			redirect($this->lang->line('page_slug_pricing'));
		}
		else
		{
			$tarifData = $this->session->userdata('tarifData');

			$this->load->model('souscripteurs_model');

			if($debug)
			{
				var_dump("DEBUG*1");
			}

			if(!isset($tarifData['DEVIS_SOUSCRIPTEUR']) || !$tarifData['DEVIS_SOUSCRIPTEUR'] 
				|| !$this->souscripteurs_model->find($tarifData['ID_SOUSCRIPTEUR'])) 
				// check if devis/session already exists
			{
				$tarifData['DEVIS_SOUSCRIPTEUR'] = false;

				// insert souscripteurs as brouillon
				$tarifData['BROUILLON_SOUSCRIPTION'] = 1;
				$tarifData['DEVIS_DATE_SOUSCRIPTEUR'] = date("Y-m-d H:i:s");
				$tarifData['DEVIS_NUMERO_SOUSCRIPTEUR'] = $this->souscripteurs_model->getLastDevisNumber();
				$tarifData['BROUILLON_SESSION_SOUSCRIPTEUR'] = json_encode($tarifData);

				$sql = $this->souscripteurs_model->insert($tarifData, 1);

				if($debug)
				{
					var_dump("DEBUG*2");
				}

				if (substr($sql, 0, 1) == "0") {
					var_dump("sql erros");

					$tarifData['DEVIS_SOUSCRIPTEUR'] = false;
					$tarifData['BROUILLON_SOUSCRIPTION'] = 0;
					$tarifData['DEVIS_DATE_SOUSCRIPTEUR'] = "";
					$tarifData['DEVIS_NUMERO_SOUSCRIPTEUR'] = "";
					$tarifData['BROUILLON_SESSION_SOUSCRIPTEUR'] = "";

				} else if (substr($sql, 0, 1) == "1") {

					if($debug)
					{
						var_dump("DEBUG*3");
					}

					$idSouscripteur = substr($sql, 1);
					$tarifData['ID_SOUSCRIPTEUR'] = $idSouscripteur;

					// store in session that devis was saved
					$tarifData['DEVIS_SOUSCRIPTEUR'] = true; 
					$tarifData['BROUILLON_SOUSCRIPTION'] = 1;
				}

				// save in session
				$this->session->set_userdata('tarifData', $tarifData);
			}

			// SEND EMAIL WITH DEVIS
			if(isset($tarifData['ID_SOUSCRIPTEUR']) && $tarifData['ID_SOUSCRIPTEUR'] != "")
			{
				$getSouscripteur = $this->souscripteurs_model->findCustomers($tarifData['type_tarif'], $tarifData['ID_SOUSCRIPTEUR']);
				if($getSouscripteur)
				{
					$tarifData['PRIVATE_CODE'] = $getSouscripteur[0]->PRIVATE_CODE;

					//$devis_file = getDevisFile($devis_file);
					//$devis_file = "";
					$devis_email = "";
					if(isset($tarifData['infos_assure']['assure_email_1']) && $tarifData['infos_assure']['assure_email_1'] != "")
					{
						$devis_email = $tarifData['infos_assure']['assure_email_1'];
					}
					if($devis_email == "")
					{
						$devis_email = $getSouscripteur[0]->COURRIEL_SOUSCRIPTEUR;
					}
					$devis_privatecode = $tarifData['PRIVATE_CODE'];

					if($debug)
					{
						var_dump("DEBUG*4", $devis_email, $devis_privatecode);
					}

					// EMAIL : NOUVEAU DEVIS
					$email = array(
								"type" => "new_devis",
								"to" => $devis_email,
								"bcc" => "contact@no-limite.com",
									"nom" => $getSouscripteur[0]->PRENOM_SOUSCRIPTEUR.' '.$getSouscripteur[0]->NOM_SOUSCRIPTEUR,
									"DEVIS_PRIVATE_CODE" => $devis_privatecode
							);
					$mail = sendNewMail($email);
				}
			}
			
			if($tarifData['type_tarif'] == "0")
			{
				$redirect = $this->lang->line('page_slug_pricing_individual');
			}
			else
			{
				$redirect = $this->lang->line('page_slug_pricing_collective');
			}

			if($debug)
			{
				var_dump("DEBUG*REDIRECT", $tarifData['DEVIS_SOUSCRIPTEUR'], $tarifData['ID_SOUSCRIPTEUR']);
			}
			else
			{
				redirect($this->lang->line('page_slug_pricing').'/'.$redirect.'/'.$this->lang->line('pricing_slug_step').'4/');
			}
		}
	}

	private function _contratPdf($partenaire_id = "")
	{
		$debug = false;
		$result = "0";

		if(!isset($language) || $language == ""):
			$language = "french";
		endif;
		$this->lang->load('information', $language);

		if($partenaire_id == "")
		{
			if($debug)
			{
				$result = "0partenaire not found";
			}
			else
			{
				//redirect('');
			}
		}
		else
		{
			$this->load->model('partenaires_model');

			// search partenaire with id
			$partenaire = $this->partenaires_model->find($partenaire_id);
			if(!isset($partenaire->ID_PARTENAIRE) || $partenaire->ROLE_PARTENAIRE != 2)
			{
				if($debug)
				{
					$result = "0partenaire not found";
				}
				else
				{
					//redirect('');
				}
			}
			else
			{
				$contrat_numero = getPartenaireNumeroContrat($partenaire);
				$filename_short = "contrat-".$contrat_numero.".pdf";
				$filename = FCPATH . "contrats/".$filename_short;
				if($debug)
				{
					//var_dump("file : ", $filename);
				}

				if(!file_exists($filename) || 1 || $debug) {

					// infos partenaire
					$partenaire_nom = $partenaire->NOM_PARTENAIRE;
					$partenaire_contact = $partenaire->CONTACT_PRENOM_PARTENAIRE.' '.$partenaire->CONTACT_PARTENAIRE;
					$partenaire_sousdomaine = $partenaire->SOUSDOMAINE_PARTENAIRE;
					$partenaire_sousdomaine = '<u>'.getFullDomain($partenaire_sousdomaine).'</u>';
					$partenaire_login = $partenaire->LOGIN_PARTENAIRE;
					$partenaire_password = $partenaire->PASSWORD_CLEAR_PARTENAIRE;
					$partenaire_fj = $partenaire->FJ_PARTENAIRE;

					$partenaire_capital = "";
					$partenaire_villerc = "";
					$partenaire_nrc = "";
					if($partenaire->TYPE_PARTENAIRE == 0)
					{
						$partenaire_capital = $partenaire->CAPITAL_PARTENAIRE;
						$partenaire_villerc = $partenaire->VILLERC_PARTENAIRE;
						$partenaire_nrc = $partenaire->NRC_PARTENAIRE;
					}

					if($debug)
					{
						var_dump($partenaire_nom);
						var_dump($partenaire_contact);
						var_dump($partenaire_sousdomaine);
						var_dump($partenaire_login);
						var_dump($partenaire_password);
						var_dump($partenaire_fj);
						var_dump($partenaire_capital);
						var_dump($partenaire_villerc);
						var_dump($partenaire_nrc);
					}

					$nolimite_intranet = "<u>www.no-limite.com/intranet/</u>";

					// on récupère les taux en place par défaut
					$partenaire_commission = $partenaire->COM_PARTENAIRE;
					$partenaire_parent_commission = $partenaire->COM_AS_PARENT_PARTENAIRE;

					$soustitre = "";
					$titre = "";

					include_once 'protocole_'.$language.'.inc.php';

					if($debug)
					{
						var_dump($message);
					}

					$this->load->library('fpdf');
					$this->load->library('html2pdf');

					$pdf = new Html2pdf();
					$pdf->AddPage();

					if($partenaire->TYPE_PARTENAIRE == 0)
					{
						if($isprof)
						{
							$pdf->SetMargins(20, 20);
						}
						else
						{
							$pdf->SetMargins(10, 10);
						}
					}
					else
					{
						$pdf->SetMargins(20, 20);
					}

					$pdf->SetFont('Helvetica','B',14);
					// titre avec sous titre
					if($soustitre != "")
					{
						$header_title = array($titre, $soustitre);
						foreach($header_title as $title)
						{
							$text = iconv("UTF-8", "CP1252", $title);
							$pdf->Cell(0, 5, $text, 0, 1, 'C');
							$pdf->SetFont('Helvetica','B',12);
						}
					}
					else
					{
						// titre
						$titre = iconv("UTF-8", "CP1252", $titre);
						$pdf->Cell(0, 20, $titre, 0, 0, 'C');
					}

					// contenu
					$pdf->SetFont('Helvetica','',9);
					$message = iconv("UTF-8", "CP1252", $message);
					$parsed = "";
					$pdf->WriteHTML($message,$parsed );
					$pdf->Multicell(0,0, $parsed );

					// signatures
					$message_footer_left = iconv("UTF-8", "CP1252", $message_footer_left);
					$message_footer_right = iconv("UTF-8", "CP1252", $message_footer_right);
						// gauche
						$y=$pdf->GetY();
						$parsed = "";
						$pdf->MultiCell(90,5,$message_footer_left);
						// droite
						$pdf->SetXY(110,$y);
						$pdf->MultiCell(90,5,$message_footer_right);

					// footer
					if($partenaire->TYPE_PARTENAIRE == 0)
					{
						$message_footer = iconv("UTF-8", "CP1252", $message_footer);
						$parsed = "";
						$pdf->WriteHTML($message_footer,$parsed );
						$pdf->Multicell(0,0, $parsed );
					}
					
					$pdf->Output($filename,'F');

					// file created, open it
					$result = $filename_short;
					//redirect("contrats/".$filename_short);

				} else {
					$result = $filename_short;
					//redirect("contrats/".$filename_short);
				}

			}
			
		}

		return $result;
	}

	public function telecharger_contrat($id_partenaire, $language = "french")
	{
		$language = ($language != "") ? $language : "french";
        $this->session->set_userdata('site_lang', $language);
	    if($language != ""):
	        $this->lang->load('information', $language);
	    endif;

		$user = $this->session->userdata('user');
		if(!$user)
		{
			redirect('/');
		}
		else
		{
			$isSuperAdmin = checkIfSuperAdmin($user);

			$debug = false;
			if($id_partenaire == '' || !$isSuperAdmin)
			{
				//redirect('/');
			}
			else
			{
				// sécurité : vide dossier
				array_map('unlink', glob(BASEPATH.'../contrats/*'));

				// generate contrat pdf
				$search = $this->partenaires_model->find($id_partenaire);

				if($search !== null)
				{
					$contrat_file = $this->_contratPdf($id_partenaire);
					redirect('contrats/'.$contrat_file);
					//unlink(BASEPATH.'../contrats/'.$contrat_file);
				}
			}
		}
	}
}
