<?php
Class souscripteurs_model extends CI_Model
{
	var $table_souscripteurs = "souscripteurs";
	var $table_partenaires = "partenaires";
	var $table_encaissements = "journal_encaissements";

	function __construct(){
		parent::__construct();
	}

	public function findAllCertificatWithCrc($crc)
	{
		$this->db->select('s.*, p.ID_PARTENAIRE, p.COURRIEL_PARTENAIRE, p.NOM_PARTENAIRE, p.PRIME_PARTENAIRE, p.COM_PARTENAIRE, p.TEL_PARTENAIRE, p.LOGO_PARTENAIRE');
		$this->db->from($this->table_souscripteurs.' as s');
		$this->db->join($this->table_partenaires.' as p', 'p.ID_PARTENAIRE = s.ID_PARTENAIRE', 'left');
	    $this->db->where('PRIVATE_CODE = "'.$crc.'"', NULL, FALSE); 
		$this->db->where('PRIVATE_CODE IS NOT NULL', NULL, FALSE);
		$this->db->where('PRIVATE_CODE <> ""', NULL, FALSE);
		$this->db->where('BROUILLON_SOUSCRIPTION = 0', NULL, FALSE);
		$this->db->where('ANNULATION_SOUSCRIPTEUR = 0', NULL, FALSE);

	    $query = $this->db->get();

		if ($query->num_rows() > 0)
		{
			$row = $query->row(); 
   			return $row;
		}

		return null;
	}

	public function findCertificatWithCrc($crc)
	{
		$this->db->select('s.*, p.ID_PARTENAIRE, p.COURRIEL_PARTENAIRE, p.NOM_PARTENAIRE, p.PRIME_PARTENAIRE, p.COM_PARTENAIRE, p.TEL_PARTENAIRE, p.LOGO_PARTENAIRE');
		$this->db->from($this->table_souscripteurs.' as s');
		$this->db->join($this->table_partenaires.' as p', 'p.ID_PARTENAIRE = s.ID_PARTENAIRE', 'left');
	    $this->db->where('PRIVATE_CODE = "'.$crc.'"', NULL, FALSE); 
		$this->db->where('PRIVATE_CODE IS NOT NULL', NULL, FALSE);
		$this->db->where('PRIVATE_CODE <> ""', NULL, FALSE);
		$this->db->where('DOSSIER_PAYE', 1);
		$this->db->where('TRANSACTION_ID IS NOT NULL', NULL, FALSE); 
		$this->db->where('TRANSACTION_ID <> ""', NULL, FALSE);
		$this->db->where('DATE_SOUSCRIPTION IS NOT NULL', NULL, FALSE); 
		$this->db->where('DATE_SOUSCRIPTION <> ""', NULL, FALSE);
		$this->db->where('DATE_SOUSCRIPTION <> "0000-00-00 00:00:00"', NULL, FALSE);
		$this->db->where('BROUILLON_SOUSCRIPTION = 0', NULL, FALSE);
		$this->db->where('ANNULATION_SOUSCRIPTEUR = 0', NULL, FALSE);

	    $query = $this->db->get();

		if ($query->num_rows() > 0)
		{
			$row = $query->row(); 
   			return $row;
		}

		return null;
	}

	public function find($id)
	{
		$datas = $this->db->get_where($this->table_souscripteurs, array("ID_SOUSCRIPTEUR" => $id))->result();

		return $datas;
	}

	public function getLastCertificatNumber() {
		$this->db->select_max('CERTIFICAT_SOUSCRIPTEUR');
		$this->db->from($this->table_souscripteurs);
	    $this->db->where('CERTIFICAT_SOUSCRIPTEUR <> ""', NULL, FALSE);
		$this->db->where('CERTIFICAT_SOUSCRIPTEUR IS NOT NULL', NULL, FALSE);
		$this->db->where('BROUILLON_SOUSCRIPTION = 0', NULL, FALSE);
		$this->db->order_by('CERTIFICAT_SOUSCRIPTEUR','DESC');

	    $query = $this->db->get();

		if ($query->num_rows() >= 1)
		{
			$row = $query->row(); 
   			return (int)$row->CERTIFICAT_SOUSCRIPTEUR+1;
		} else {
			return 0;
		}
	}

	public function getLastDevisNumber() {
		$this->db->select_max('DEVIS_NUMERO_SOUSCRIPTEUR');
		$this->db->from($this->table_souscripteurs);
	    $this->db->where('DEVIS_NUMERO_SOUSCRIPTEUR <> ""', NULL, FALSE);
		$this->db->where('DEVIS_NUMERO_SOUSCRIPTEUR IS NOT NULL', NULL, FALSE);
		$this->db->order_by('DEVIS_NUMERO_SOUSCRIPTEUR','DESC');

	    $query = $this->db->get();

		if ($query->num_rows() >= 1)
		{
			$row = $query->row(); 
   			return (int)$row->DEVIS_NUMERO_SOUSCRIPTEUR+1;
		} else {
			return 1;
		}
	}

	public function findDevisWithCode($pcode)
	{
		$this->db->select('s.*, (SELECT COUNT(*) FROM '.$this->db->dbprefix($this->table_souscripteurs).' as d2 WHERE d2.TYPE_TARIF_SOUSCRIPTEUR = 1 AND s.COLLECTIF_ID_SOUSCRIPTEUR = d2.COLLECTIF_ID_SOUSCRIPTEUR) as NB_PERSONNES_SOUSCRIPTEUR, p.NOM_PARTENAIRE,
							p.ADRESSE1_PARTENAIRE,
							p.ADRESSE2_PARTENAIRE,
							p.CP_PARTENAIRE,
							p.VILLE_PARTENAIRE,
							p.SOUSDOMAINE_PARTENAIRE,
							p.TEL_PARTENAIRE,
							p.COURRIEL_PARTENAIRE');
		$this->db->from($this->table_souscripteurs.' as s');
		$this->db->join($this->table_partenaires.' as p', 'p.ID_PARTENAIRE = s.ID_PARTENAIRE', 'left');
		$this->db->where('DEVIS_DATE_SOUSCRIPTEUR <> ""', NULL, FALSE);
		$this->db->where('DEVIS_DATE_SOUSCRIPTEUR IS NOT NULL', NULL, FALSE);
		$this->db->where('DEVIS_NUMERO_SOUSCRIPTEUR > 0', NULL, FALSE);
		$this->db->where('PRIVATE_CODE = "'.$pcode.'"', NULL, FALSE);
		$this->db->order_by('1','ASC');

		$query = $this->db->get();

		if ($query->num_rows() >= 1)
		{
			$row = $query->row(); 
   			return $row;
		} else {
			return 0;
		}
	}

	public function findDevisWithCodeCollectif($idcollectif)
	{
		$this->db->select('s.*, (SELECT COUNT(*) FROM '.$this->db->dbprefix($this->table_souscripteurs).' as d2 WHERE d2.TYPE_TARIF_SOUSCRIPTEUR = 1 AND s.COLLECTIF_ID_SOUSCRIPTEUR = d2.COLLECTIF_ID_SOUSCRIPTEUR) as NB_PERSONNES_SOUSCRIPTEUR');
		$this->db->from($this->table_souscripteurs.' as s');
		$this->db->where('DEVIS_DATE_SOUSCRIPTEUR <> ""', NULL, FALSE);
		$this->db->where('DEVIS_DATE_SOUSCRIPTEUR IS NOT NULL', NULL, FALSE);
		$this->db->where('DEVIS_NUMERO_SOUSCRIPTEUR > 0', NULL, FALSE);
		$this->db->where('COLLECTIF_ID_SOUSCRIPTEUR = "'.$idcollectif.'"', NULL, FALSE);
		$this->db->order_by('ID_SOUSCRIPTEUR','ASC');

		$result = $this->db->get()->result();

		return $result;
	}

	public function findBrouillonWithCode($pcode)
	{
		$this->db->select('s.*, (SELECT COUNT(*) FROM '.$this->db->dbprefix($this->table_souscripteurs).' as d2 WHERE d2.TYPE_TARIF_SOUSCRIPTEUR = 1 AND s.COLLECTIF_ID_SOUSCRIPTEUR = d2.COLLECTIF_ID_SOUSCRIPTEUR) as NB_PERSONNES_SOUSCRIPTEUR');
		$this->db->from($this->table_souscripteurs.' as s');
		$this->db->where('BROUILLON_SOUSCRIPTION = 1', NULL, FALSE);
		$this->db->where('PRIVATE_CODE = "'.$pcode.'"', NULL, FALSE);
		$this->db->order_by('1','ASC');

		$query = $this->db->get();

		if ($query->num_rows() >= 1)
		{
			$row = $query->row(); 
   			return $row;
		} else {
			return 0;
		}
	}

	public function findCustomers($typeTarif, $id)
	{
		$this->db->select('s.*, p.PARENT_PARTENAIRE, p.ID_PARTENAIRE, p.COURRIEL_PARTENAIRE, p.NOM_PARTENAIRE, p.PRIME_PARTENAIRE, p.COM_PARTENAIRE');
		$this->db->from($this->table_souscripteurs.' as s');
		$this->db->join($this->table_partenaires.' as p', 'p.ID_PARTENAIRE = s.ID_PARTENAIRE', 'left');
		//$this->db->where('BROUILLON_SOUSCRIPTION = 0', NULL, FALSE);

		if($typeTarif == "0") 
		{
			$this->db->where(array("ID_SOUSCRIPTEUR" => $id));
		}
		else if($typeTarif == "1") 
		{
			$this->db->where(array("COLLECTIF_ID_SOUSCRIPTEUR" => $id));
		}
		$this->db->order_by('1','ASC');
		$result = $this->db->get()->result();

		return $result;
	}

	public function nb() {
		$datas = 0;

		$user = $this->session->userdata('user');
		if($user)
		{
			// get all partners affiliated to connected user
			$ID_PARTENAIRE = $user['ID_PARTENAIRE'];
			$ID_PARENT_PARTENAIRE = $user['PARENT_PARTENAIRE'];
			$isSuperAdmin = checkIfSuperAdmin($user);

			$this->db->select('s.ID_SOUSCRIPTEUR');
			$this->db->from($this->table_souscripteurs.' as s');
			$this->db->join($this->table_partenaires.' as p', 'p.ID_PARTENAIRE = s.ID_PARTENAIRE', 'left');
			if(!$isSuperAdmin) {
				$this->db->where('(s.ID_PARTENAIRE = '.$ID_PARTENAIRE.' OR s.IDP_ORIGINE = '.$ID_PARTENAIRE.')', NULL, FALSE);
			}
			$this->db->where('s.CERTIFICAT_SOUSCRIPTEUR IS NOT NULL', NULL, FALSE);
			$this->db->where('s.CERTIFICAT_SOUSCRIPTEUR <> ""', NULL, FALSE); 
			$this->db->where('s.TRANSACTION_ID IS NOT NULL', NULL, FALSE);
			$this->db->where('s.TRANSACTION_ID <> ""', NULL, FALSE);
			$this->db->where('s.DATE_SOUSCRIPTION IS NOT NULL', NULL, FALSE); 
			$this->db->where('s.DATE_SOUSCRIPTION <> ""', NULL, FALSE);
			$this->db->where('s.DATE_SOUSCRIPTION <> "0000-00-00 00:00:00"', NULL, FALSE);
			$this->db->where('s.DOSSIER_PAYE = 1', NULL, FALSE);
			$this->db->where('s.BROUILLON_SOUSCRIPTION = 0', NULL, FALSE);
			$this->db->where('s.ANNULATION_SOUSCRIPTEUR = 0', NULL, FALSE);

			$this->db->group_by('s.ID_SOUSCRIPTEUR');

			$datas = $this->db->count_all_results();
		}

        return $datas;
	}

	public function get_months() {
		$datas = null;

		$user = $this->session->userdata('user');
		if($user)
		{
			// get all partners affiliated to connected user
			$ID_PARTENAIRE = $user['ID_PARTENAIRE'];
			//$ID_PARENT_PARTENAIRE = $user['PARENT_PARTENAIRE'];
			$isSuperAdmin = checkIfSuperAdmin($user);
			$where = '';
			if(!$isSuperAdmin){
				$where = ' AND (s.ID_PARTENAIRE = '.$ID_PARTENAIRE.' OR s.IDP_ORIGINE = '.$ID_PARTENAIRE.') ';
			}

			$sql = 'SELECT t1.month, COUNT(*) as nb
					FROM
					(
						SELECT DATE_FORMAT(s.DATE_SOUSCRIPTION, "%Y-%m") as `month` 
						FROM `'.$this->db->dbprefix($this->table_souscripteurs).'` as `s` 
						LEFT JOIN `'.$this->db->dbprefix($this->table_partenaires).'` as `p` ON `p`.`ID_PARTENAIRE` = `s`.`ID_PARTENAIRE` 
						LEFT JOIN `'.$this->db->dbprefix($this->table_encaissements).'` as `v` ON `s`.`TRANSACTION_ID` = `v`.`ID_ENCAISSEMENT` 
						WHERE s.CERTIFICAT_SOUSCRIPTEUR IS NOT NULL'.$where.'
						AND s.CERTIFICAT_SOUSCRIPTEUR <> "" 
						AND s.TRANSACTION_ID IS NOT NULL 
						AND s.TRANSACTION_ID <> "" 
						AND DATE_SOUSCRIPTION IS NOT NULL 
						AND DATE_SOUSCRIPTION <> "" 
						AND DATE_SOUSCRIPTION <> "0000-00-00 00:00:00"
						AND ANNULATION_SOUSCRIPTEUR = 0
						AND BROUILLON_SOUSCRIPTION = 0
						AND DOSSIER_PAYE = 1 
						GROUP BY `s`.`ID_SOUSCRIPTEUR` 
					) as t1
					GROUP BY 1
					ORDER BY 1 DESC';

			$datas = $this->db->query($sql)->result();


			/*$this->db->select('DATE_FORMAT(s.DATE_SOUSCRIPTION,"%Y-%m") as `month`, COUNT(s.ID_SOUSCRIPTEUR) as `nb`', FALSE);
			$this->db->from($this->table_souscripteurs.' as s');
			$this->db->join($this->table_partenaires.' as p', 'p.ID_PARTENAIRE = s.ID_PARTENAIRE', 'left');
			$this->db->join($this->table_encaissements.' as v', 's.TRANSACTION_ID = v.ID_ENCAISSEMENT', 'left');
			$this->db->where('(s.ID_PARTENAIRE = '.$ID_PARTENAIRE.' OR s.IDP_ORIGINE = '.$ID_PARTENAIRE.')', NULL, FALSE);
			$this->db->where('s.CERTIFICAT_SOUSCRIPTEUR IS NOT NULL', NULL, FALSE);
			$this->db->where('s.CERTIFICAT_SOUSCRIPTEUR <> ""', NULL, FALSE); 
			$this->db->where('s.TRANSACTION_ID IS NOT NULL', NULL, FALSE);
			$this->db->where('s.TRANSACTION_ID <> ""', NULL, FALSE);
			$this->db->where('DATE_SOUSCRIPTION IS NOT NULL', NULL, FALSE); 
			$this->db->where('DATE_SOUSCRIPTION <> ""', NULL, FALSE);
			$this->db->where('DOSSIER_PAYE = 1', NULL, FALSE);
			$this->db->where('DATE_SOUSCRIPTION <> "0000-00-00 00:00:00"', NULL, FALSE); 
			$this->db->order_by('1','DESC');
			$this->db->group_by('s.ID_SOUSCRIPTEUR');
			$this->db->group_by('1');

			$datas = $this->db->get()->result();*/

			//echo $this->db->last_query(); ;
		}

		return $datas;
	}

	public function get_all($id = ''){
		$datas = null;

		$user = $this->session->userdata('user');
		if($user)
		{
			// get all partners affiliated to connected user
			$ID_PARTENAIRE = $user['ID_PARTENAIRE'];
			$ID_PARENT_PARTENAIRE = $user['PARENT_PARTENAIRE'];
			$isSuperAdmin = checkIfSuperAdmin($user);

			$this->db->select('s.ID_SOUSCRIPTEUR,
							ANNULATION_SOUSCRIPTEUR,
							ANNULATION_VOYAGE_SOUSCRIPTEUR,
							ANNULATION_VOYAGE_DATE_ACHAT_SOUSCRIPTEUR,
							ANNULATION_VOYAGE_DATE_DEPART_SOUSCRIPTEUR,
							ANNULATION_COMMENTAIRE_SOUSCRIPTEUR,
							ANNULATION_DATE_SOUSCRIPTEUR,
							DATE_SOUSCRIPTION,
							DATEHEURE_SOUSCRIPTION,
							HEURE_EFFET_SOUSCRIPTEUR,
							p.ID_PARTENAIRE,
							s.IDP_ORIGINE,
							NOM_SOUSCRIPTEUR, PRENOM_SOUSCRIPTEUR,
							UCASE(ADRESSE1_SOUSCRIPTEUR) as ADRESSE1_SOUSCRIPTEUR, 
							UCASE(ADRESSE2_SOUSCRIPTEUR) as ADRESSE2_SOUSCRIPTEUR,
							CP_SOUSCRIPTEUR, 
							UCASE(VILLE_SOUSCRIPTEUR) as VILLE_SOUSCRIPTEUR, 
							UCASE(PAYS_SOUSCRIPTEUR) as PAYS_SOUSCRIPTEUR,
							TEL_SOUSCRIPTEUR, GSM_SOUSCRIPTEUR, COURRIEL_SOUSCRIPTEUR,
							DATE_EFFET_SOUSCRIPTEUR,
							TYPE_EFFET_SOUSCRIPTEUR,
							v.AUTORISATION_TRANSACTION as TRANSACTION_ID,
							PRIME_SOUSCRIPTEUR,
							s.CERTIFICAT_SOUSCRIPTEUR,
							p.NOM_PARTENAIRE,
							p.ADRESSE1_PARTENAIRE,
							p.ADRESSE2_PARTENAIRE,
							p.CP_PARTENAIRE,
							p.VILLE_PARTENAIRE,
							p.SOUSDOMAINE_PARTENAIRE,
							p.TEL_PARTENAIRE,
							p.COURRIEL_PARTENAIRE,
							p.COM_PARTENAIRE,
							(SELECT COM_AS_PARENT_PARTENAIRE FROM '.$this->db->dbprefix($this->table_partenaires).' WHERE ID_PARTENAIRE = s.IDP_ORIGINE) AS COM_AFFILIE,
							TAUXINDACC_SOUSCRIPTEUR,
							CAPITAL_SOUSCRIPTEUR,
							PERIODE_SOUSCRIPTEUR,
							CATEGORIE_SOUSCRIPTEUR,
							COLLECTIF_IDENTIQUE_SOUSCRIPTEUR,
							ASSISTANCEMONDE_SOUSCRIPTEUR,
							ASSISTANCEMONDE_OPTION_SOUSCRIPTEUR,
							TAUXASSMONDE_SOUSCRIPTEUR,
							TAUXASSMONDEB_SOUSCRIPTEUR,
							TAUXANNVOYAGE_SOUSCRIPTEUR,
							BENEFICIAIRE_SOUSCRIPTEUR,
							BIRTHDAY_SOUSCRIPTEUR,
							s.DOSSIER_PAYE,
							CALCUL_ENCAISSEMENT,
							PRIVATE_CODE,
							DEVIS_DATE_SOUSCRIPTEUR,
							DEVIS_NUMERO_SOUSCRIPTEUR,
							v.VERSION_CALCUL,
							v.PART_ID1, v.PART_ORIGINE, v.PART_PARTENAIRE,
							v.PART_ASSUREUR, v.PART_APPORTEUR, v.PART_PARENT,
							p2.NOM_PARTENAIRE as NOM_PARENT_PARTENAIRE,
							p2.ID_PARTENAIRE as ID_PARENT_PARTENAIRE,
							p2.COURRIEL_PARTENAIRE as COURRIEL_PARENT_PARTENAIRE,
							(SELECT COUNT(*) FROM '.$this->db->dbprefix($this->table_souscripteurs).' as d2 WHERE d2.TYPE_TARIF_SOUSCRIPTEUR = 1 AND s.COLLECTIF_ID_SOUSCRIPTEUR = d2.COLLECTIF_ID_SOUSCRIPTEUR) as NB_PERSONNES_SOUSCRIPTEUR,
							ANNULATION_VOYAGE_SOUSCRIPTEUR,
							SPORTPRATIQUE_SOUSCRIPTEUR,
							LANG_SOUSCRIPTEUR
							');
			$this->db->from($this->table_souscripteurs.' as s');
			$this->db->join($this->table_partenaires.' as p', 'p.ID_PARTENAIRE = s.ID_PARTENAIRE', 'left');
			$this->db->join($this->table_partenaires.' as p2', 'p.PARENT_PARTENAIRE = p2.ID_PARTENAIRE', 'left outer');
			$this->db->join($this->table_encaissements.' as v', 's.TRANSACTION_ID = v.ID_ENCAISSEMENT', 'left');
			if(!$isSuperAdmin) {
				$this->db->where('(s.ID_PARTENAIRE = '.$ID_PARTENAIRE.' OR s.IDP_ORIGINE = '.$ID_PARTENAIRE.')', NULL, FALSE);
			}
			$this->db->where('s.CERTIFICAT_SOUSCRIPTEUR IS NOT NULL', NULL, FALSE);
			$this->db->where('s.CERTIFICAT_SOUSCRIPTEUR <> ""', NULL, FALSE); 
			$this->db->where('s.TRANSACTION_ID IS NOT NULL', NULL, FALSE);
			$this->db->where('s.TRANSACTION_ID <> ""', NULL, FALSE);
			$this->db->where('DATE_SOUSCRIPTION IS NOT NULL', NULL, FALSE); 
			$this->db->where('DATE_SOUSCRIPTION <> ""', NULL, FALSE);
			$this->db->where('DOSSIER_PAYE = 1', NULL, FALSE);
			$this->db->where('BROUILLON_SOUSCRIPTION = 0', NULL, FALSE);
			$this->db->where('DATE_SOUSCRIPTION <> "0000-00-00 00:00:00"', NULL, FALSE); 
			if($id != "")
			{
				$this->db->where('s.ID_SOUSCRIPTEUR = '.$id.'', NULL, FALSE);
			}
			$this->db->group_by('s.ID_SOUSCRIPTEUR');
			$this->db->order_by('DATE_SOUSCRIPTION','ASC');
			
			$datas = $this->db->get()->result();

		}

		return $datas;
	}

	public function getBirthday($date) {
		$str = substr($date, -4);
		$str .= '-'.substr($date, 3, 2);
		$str .= '-'.substr($date, 0, 2);

		return $str;
	}

	public function insert($datas, $isBrouillon = 0) {

		$result = "0";

		if($datas['type_tarif'] == "0")
		{
			$nbPersonnes = 1;
		}
		else if($datas['type_tarif'] == "1") 
		{
			$nbPersonnes = $datas['personnes_nombre'];
		}

		$varIdCollectif = md5($_SERVER['REMOTE_ADDR'] . time());

		for($p=1;$p<=$nbPersonnes;$p++)
		{
			$souscripteur = [];
			
			if($datas['type_tarif'] == "0" || ($datas['type_tarif'] == "1" && isset($datas['collectif_personnes_identique']) && $datas['collectif_personnes_identique'] == "0"))
			{
				// individuel, ou collectif idem
				$capital = $datas['capital_montant'];
				$cat = $datas['categorie_sports'];

				$assistanceMonde = $datas['assistance_monde'];
				$assistanceMondeOption = $datas['assistance_monde_option'];

				// 2K19
				$annulationVoyage = $datas['annulation_voyage'];
				$annulationVoyageDateAchatBilletAvion = getDateFormat($datas['date_achat_billet_avion']);
				$annulationVoyageDateDepartVoyage = getDateFormat($datas['date_depart_voyage']);

				$duree = $datas['tarif_duree'];
				$prime = $datas['tarif_prime'];
				$tauxIndAcc = $datas['tarif_tauxindacc'];
				$taux_option1 = $datas['tarif_option1'];
				$taux_option1b = $datas['tarif_option1b'];
				$taux_option2 = $datas['tarif_option2'];
			} 
			else if($datas['type_tarif'] == "1" && isset($datas['collectif_personnes_identique']) && $datas['collectif_personnes_identique'] == "1") 
			{
				// collectif
				// cas par cas
				$capital = $datas['capital_montant_'.$p];
				$cat = $datas['categorie_sports_'.$p];

				$assistanceMonde = $datas['assistance_monde_'.$p];
				$assistanceMondeOption = $datas['assistance_monde_option_'.$p];
				$annulationVoyage = $datas['annulation_voyage_'.$p];

				$annulationVoyageDateAchatBilletAvion = getDateFormat($datas['date_achat_billet_avion_'.$p]);
				$annulationVoyageDateDepartVoyage = getDateFormat($datas['date_depart_voyage_'.$p]);

				$duree = $datas['tarif_duree_'.$p];
				$prime = $datas['tarif_prime_'.$p];
				$tauxIndAcc = $datas['tarif_tauxindacc_'.$p];
				$taux_option1 = $datas['tarif_option1_'.$p];
				$taux_option1b = $datas['tarif_option1b_'.$p];
				$taux_option2 = $datas['tarif_option2_'.$p];
			}
			if($assistanceMonde == "") { $assistanceMonde = 0; }
			if($annulationVoyage == "") { $annulationVoyage = 0; }

			$souscripteur['DATEHEURE_SOUSCRIPTION'] = date("Y-m-d H:i:s");
			$souscripteur['DATE_SOUSCRIPTION'] = date("Y-m-d H:i:s");

			$currentPartenaireId = 1;
			$currentPartenaireParent = NULL;
			$currentPartenaire = $this->session->userdata('currentPartenaire');
			if($currentPartenaire)
			{
				$currentPartenaireId = $currentPartenaire['ID'];
				$currentPartenaireParent = $currentPartenaire['PARENT'];
			}

			$souscripteur['ID_PARTENAIRE'] = $currentPartenaireId;
			$souscripteur['IDP_ORIGINE'] = $currentPartenaireParent;
			$souscripteur['TYPE_TARIF_SOUSCRIPTEUR'] = $datas['type_tarif'];

			$souscripteur['NOM_SOUSCRIPTEUR'] = mb_strtoupper($datas['infos_assure']['assure_nom_'.$p]);
			$souscripteur['PRENOM_SOUSCRIPTEUR'] = mb_strtoupper($datas['infos_assure']['assure_prenom_'.$p]);
			$souscripteur['ADRESSE1_SOUSCRIPTEUR'] = mb_strtoupper($datas['infos_assure']['assure_adresse1_'.$p]);
			$souscripteur['ADRESSE2_SOUSCRIPTEUR'] = mb_strtoupper($datas['infos_assure']['assure_adresse2_'.$p]);
			$souscripteur['CP_SOUSCRIPTEUR'] = $datas['infos_assure']['assure_codepostal_'.$p];
			$souscripteur['VILLE_SOUSCRIPTEUR'] = mb_strtoupper($datas['infos_assure']['assure_ville_'.$p]);
			$souscripteur['PAYS_SOUSCRIPTEUR'] = $datas['infos_assure']['assure_pays_'.$p];
			$souscripteur['COURRIEL_SOUSCRIPTEUR'] = mb_strtolower($datas['infos_assure']['assure_email_'.$p]);
			$souscripteur['TEL_SOUSCRIPTEUR'] = $datas['infos_assure']['assure_telephone_'.$p];
			$souscripteur['GSM_SOUSCRIPTEUR'] = $datas['infos_assure']['assure_mobile_'.$p];
			$souscripteur['BIRTHDAY_SOUSCRIPTEUR'] = getDateFormat($datas['infos_assure']['assure_naissance_'.$p]);
			if($datas['infos_assure']['assure_typedateeffet_'.$p] == "0")
			{
				$dateEffet = date("Y-m-d");
				$heureEffet = date("H").":00";
			} 
			else 
			{
				$dateEffet = getDateFormat($datas['infos_assure']['assure_dateeffet_'.$p]);
				$heureEffet = $datas['infos_assure']['assure_dateeffetheure_'.$p];
			}
			$souscripteur['TYPE_EFFET_SOUSCRIPTEUR'] = $datas['infos_assure']['assure_typedateeffet_'.$p];
			$souscripteur['DATE_EFFET_SOUSCRIPTEUR'] = $dateEffet;
			$souscripteur['HEURE_EFFET_SOUSCRIPTEUR'] = $heureEffet;
			$souscripteur['TAUXINDACC_SOUSCRIPTEUR'] = $tauxIndAcc;
			$souscripteur['CAPITAL_SOUSCRIPTEUR'] = $capital;
			$souscripteur['CATEGORIE_SOUSCRIPTEUR'] = $cat;

			$val_collectif_personnes_identique = 0;
			if(isset($datas['collectif_personnes_identique']) && $datas['collectif_personnes_identique'] != "")
			{
				$val_collectif_personnes_identique = strtr($datas['collectif_personnes_identique'], array("0" => "1", "1" => "0"));
			}

			$souscripteur['COLLECTIF_IDENTIQUE_SOUSCRIPTEUR'] = $val_collectif_personnes_identique;
			$souscripteur['ASSISTANCEMONDE_SOUSCRIPTEUR'] = $assistanceMonde;
			$souscripteur['ASSISTANCEMONDE_OPTION_SOUSCRIPTEUR'] = $assistanceMondeOption;
			
			$souscripteur['TAUXASSMONDE_SOUSCRIPTEUR'] = $taux_option1;
			$souscripteur['TAUXASSMONDEB_SOUSCRIPTEUR'] = $taux_option1b;
			$souscripteur['TAUXANNVOYAGE_SOUSCRIPTEUR'] = $taux_option2;

			// 2K19
			$souscripteur['ANNULATION_VOYAGE_SOUSCRIPTEUR'] = $annulationVoyage;
			$souscripteur['ANNULATION_VOYAGE_DATE_ACHAT_SOUSCRIPTEUR'] = $annulationVoyageDateAchatBilletAvion;
			$souscripteur['ANNULATION_VOYAGE_DATE_DEPART_SOUSCRIPTEUR'] = $annulationVoyageDateDepartVoyage;

			$souscripteur['PERIODE_SOUSCRIPTEUR'] = $duree;
			$souscripteur['PRIME_SOUSCRIPTEUR'] = $prime;
			$souscripteur['BENEFICIAIRE_SOUSCRIPTEUR'] = $datas['infos_assure']['assure_beneficiaire_'.$p];
			$souscripteur['SPORTPRATIQUE_SOUSCRIPTEUR'] = $datas['infos_assure']['assure_sport_'.$p];
			$souscripteur['PRIVATE_CODE'] = password_generator(32);

			$souscripteur['DOSSIER_PAYE'] = 0;

			// BROUILLON & DEVIS
			$val_brouillon = 0;
			if($datas['BROUILLON_SOUSCRIPTION'] != "")
			{
				$val_brouillon = $datas['BROUILLON_SOUSCRIPTION'];
			}
			$souscripteur['BROUILLON_SOUSCRIPTION'] = $val_brouillon;
			if(isset($datas['DEVIS_DATE_SOUSCRIPTEUR']) && $datas['DEVIS_DATE_SOUSCRIPTEUR'] != "")
			{
				$souscripteur['DEVIS_DATE_SOUSCRIPTEUR'] = $datas['DEVIS_DATE_SOUSCRIPTEUR'];
			}
			if(isset($datas['DEVIS_NUMERO_SOUSCRIPTEUR']) && $datas['DEVIS_NUMERO_SOUSCRIPTEUR'] != "")
			{
				$souscripteur['DEVIS_NUMERO_SOUSCRIPTEUR'] = $datas['DEVIS_NUMERO_SOUSCRIPTEUR'];
			}
			if(isset($datas['BROUILLON_SESSION_SOUSCRIPTEUR']) && $datas['BROUILLON_SESSION_SOUSCRIPTEUR'] != "")
			{
				$souscripteur['BROUILLON_SESSION_SOUSCRIPTEUR'] = $datas['BROUILLON_SESSION_SOUSCRIPTEUR'];
			}

			/*$souscripteur['TRANSACTION_ID'] = "";
			$souscripteur['CERTIFICAT_SOUSCRIPTEUR'] = "";
			$souscripteur['PRIVATE_CODE'] = "";
			$souscripteur['IWN_DEPARTEMENT'] = "";
			$souscripteur['IWN_PARTENAIRE'] = "";*/
			if ($datas['type_tarif'] == "1") {
				$souscripteur['COLLECTIF_ID_SOUSCRIPTEUR'] = $varIdCollectif;
			}

			$souscripteur['LANG_SOUSCRIPTEUR'] = getCurrentLang();
			
			//var_dump($souscripteur);

			$sql = $this->save($souscripteur);
			if(!$sql)
			{
				$result = "0Erreur lors de l'insertion en base de données";
			} 
			else 
			{
				$id_insert = $sql;
				if ($datas['type_tarif'] == "1")
				{
					$id_insert = $varIdCollectif;
				}
				$result = "1".$id_insert;
			}

		}

		return $result;
	}

	public function save($datas)
	{
		$result = $this->db->insert($this->table_souscripteurs, $datas);
		if($result)
		{
			$insert_id = $this->db->insert_id();

			return $insert_id;
		}
		else
		{
			return FALSE;
		}
	}

	public function delete($typeTarif, $id)
	{
		$result = true;

		$search = $this->find($id);
		if($search)
		{
			$search = false;
			
			if($typeTarif == "0") {
				$result = $this->db->delete($this->table_souscripteurs, array("ID_SOUSCRIPTEUR" => $id));
			} else if($type_tarif == "1") {
				$result = $this->db->delete($this->table_souscripteurs, array("COLLECTIF_ID_SOUSCRIPTEUR" => $id));
			}
		}
		
		return $result;
	}

	public function update($id, $souscripteur)
	{
		$sql = "0";

		if($id > 0){
			$where = array('ID_SOUSCRIPTEUR' => $id);
			$result = $this->db->update($this->table_souscripteurs, $souscripteur, $where);
			if($result) {
				$sql = "1";
			} else {
				$sql = "0sql error";
			}
		}

		return $sql;
	}

}