jQuery(document).on('click', "#saveSettingsBtn", function(event) {
	event.preventDefault();
	
	var settings = generalFunctions.getFormInputValues(jQuery('#settings'));
	//console.log(values); exit();
	
	jQuery.ajax({
		type: 'POST',
		url: './listeners/save_settings.php',
		data: settings,
		success: function(msg) {
			if(msg!='') alert(msg);
			else window.location.reload();
		}
	});
});
	
/*
Save Locked Content
*/
jQuery(document).on('click', "#locked_content_save_btn", function(event) {
	event.preventDefault();
	
	var locked_content = $('#locked_content').val();
	var redirect_url = $('#redirect_url').val();
	var bg_image_url = $('#bg_image_url').val();
	
	//var locked_content = CKEDITOR.instances['locked_content'].getData();
	var settings = {"locked_content":locked_content, "redirect_url":redirect_url, "bg_image_url":bg_image_url}
	
	jQuery.ajax({
		type: 'POST',
		url: './listeners/save_settings.php',
		data: settings,
		success: function(msg) {
			window.location.reload();
		}
	});
});

/*
Send Message Dialog
*/
jQuery(document).on('click', "#send_message_fb_dialog", function(event) {
	event.preventDefault();	
	var link = $(this).attr('data-link');
	var fb_id = $(this).attr('data-fb-id');
	var demo_mode = $(this).attr('data-demo-mode');
	
	if(demo_mode==1) {
		alert('Not available in demo mode');
	}
	else {
		socialFunctions.fbDialogSendMessage(fb_id, link, function(response) {
			//console.log('response: '+response);
		});
	}
});

jQuery(document).on('click', ".fb_shares_modal", function(event) {
	event.preventDefault();
	var fb_id = $(this).attr('data-fb-id');
	
	$('#fb-shares-modal .modal-body').html('Loading...');
	$('#fb-shares-modal').modal();
	
	jQuery.ajax({
		type: 'POST',
		url: './views/fb_shares.php',
		data: 'fb_id='+fb_id,
		success: function(msg) {
			$('#fb-shares-modal .modal-body').html(msg);
		}
	});
});

jQuery(document).on('click', ".social_visits_modal", function(event) {
	event.preventDefault();
	var fb_id = $(this).attr('data-fb-id');
	
	$('#social-visits-modal .modal-body').html('Loading...');
	$('#social-visits-modal').modal();
	
	jQuery.ajax({
		type: 'POST',
		url: './views/social_visits.php',
		data: 'fb_id='+fb_id,
		success: function(msg) {
			$('#social-visits-modal .modal-body').html(msg);
		}
	});
});

/*
User details
*/
jQuery(document).on('click', ".fb_user_details_modal", function(event) {
	event.preventDefault();
	var id = $(this).attr('data-id');
	
	$('#user-details-modal .modal-body').html('Loading...');
	$('#user-details-modal').modal();
	
	jQuery.ajax({
		type: 'POST',
		url: './views/fb_user_details.php',
		data: 'id='+id,
		success: function(msg) {
			$('#user-details-modal .modal-body').html(msg);
		}
	});
});

/*
Send notifications
*/
jQuery(document).on('click', "#display_send_notification_modal", function(event) {
	event.preventDefault();
	
	var fb_ids = '';
	jQuery('#send-notification-modal #users').html('');	
	jQuery.each(jQuery("input[name='fb_accounts_selection[]']:checked"), function() {
		fb_ids += (fb_ids?',':'') + jQuery(this).attr('id');
		jQuery('#send-notification-modal #users').append('<img src="https://graph.facebook.com/'+jQuery(this).attr('id')+'/picture" style="width:25px; margin-right:5px;">');
	});
	
	if(fb_ids=='') {
		alert('No users selected');
	}
	else {
		$('#send-notification-modal #fb_ids').val(fb_ids);
		$('#send-notification-modal').modal();
	}
});

jQuery(document).on('shown.bs.modal', "#send-notification-modal", function(event) {
	$('#send-notification-modal #message').focus();
});

jQuery(document).on('click', "#send_notification_btn", function(event) {
	event.preventDefault();	
	
	var fb_ids = $('#send-notification-modal #fb_ids').val();
	var message = $('#send-notification-modal #message').val();
	
	if(message=='') {
		alert('Message required');
	}
	else {
		$('#send-notification-modal #message').attr('disabled', 'disabled');
		$('#send_notification_btn').attr('disabled', 'disabled');
		
		jQuery.ajax({
			type: 'POST',
			url: './listeners/fb_send_notification.php',
			data: 'fb_ids='+fb_ids+'&message='+message,
			success: function(msg) {
				alert(msg);
				window.location.reload();
			}
		});
	}	
});

/*
Send emails
*/
jQuery(document).on('click', "#display_send_email_modal", function(event) {
	event.preventDefault();
	
	var fb_ids = '';
	jQuery('#send-email-modal #users').html('');	
	jQuery.each(jQuery("input[name='fb_accounts_selection[]']:checked"), function() {
		fb_ids += (fb_ids?',':'') + jQuery(this).attr('id');
		jQuery('#send-email-modal #users').append('<img src="https://graph.facebook.com/'+jQuery(this).attr('id')+'/picture" style="width:25px; margin-right:5px;">');
	});
	
	if(fb_ids=='') {
		alert('No users selected');
	}
	else {
		$('#send-email-modal #fb_ids').val(fb_ids);
		$('#send-email-modal').modal();
	}
});

jQuery(document).on('shown.bs.modal', "#send-email-modal", function(event) {
	$('#send-email-modal #subject').focus();
});

jQuery(document).on('click', "#send_email_btn", function(event) {
	event.preventDefault();	
	
	var fb_ids = $('#send-email-modal #fb_ids').val();
	var subject = $('#send-email-modal #subject').val();
	var message = $('#send-email-modal #message').val();
	
	if(subject=='' || message=='') {
		alert('Subject and message both required');
	}
	else {
		$('#send-email-modal #subject').attr('disabled', 'disabled');
		$('#send-email-modal #message').attr('disabled', 'disabled');
		$('#send_email_btn').attr('disabled', 'disabled');
		
		jQuery.ajax({
			type: 'POST',
			url: './listeners/fb_send_email.php',
			data: 'fb_ids='+fb_ids+'&subject='+subject+'&message='+message,
			success: function(msg) {
				alert(msg);
				window.location.reload();
			}
		});
	}	
});

/*
Delete Facebook user
*/
jQuery(document).on('click', ".delete_fb_user_btn", function(event) {
	event.preventDefault();
	
	if (confirm("Are you sure you want to delete this user?")) {
		var id = jQuery(this).attr('id');
		var fb_id = jQuery(this).attr('data-fb-id');
		
		jQuery.ajax({
			type: 'POST',
			url: './listeners/fb_delete_user.php',
			data: 'id='+id+'&fb_id='+fb_id,
			success: function(msg) {
				window.location.reload();
			}
		});
	}
});

/*
General functions
*/
jQuery(document).on('click', "#check_all_btn", function(event) {
	jQuery(this).parents('.checkboxes').find(':checkbox').prop('checked', this.checked);
});
