<?php
// @codingStandardsIgnoreFile

class Stripe_Event extends Stripe_ApiResource
{
  /**
   * @param string $id The ID of the event to retrieve.
   * @param string|null $apiKey
   *
   * @return Stripe_Event
   */
  public static function retrieve($id, $apiKey=null)
  {
    $class = get_class();
    return self::_scopedRetrieve($class, $id, $apiKey);
  }

  /**
   * @param array|null $params
   * @param string|null $apiKey
   *
   * @return array An array of Stripe_Events.
   */
  public static function all($params=null, $apiKey=null)
  {
    $class = get_class();
    return self::_scopedAll($class, $params, $apiKey);
  }
}
